<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Accounts
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Accounts\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Serialize;


class MessagingGeopermissionsList extends ListResource
    {
    /**
     * Construct the MessagingGeopermissionsList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Messaging/GeoPermissions';
    }

    /**
     * Fetch the MessagingGeopermissionsInstance
     *
     * @param array|Options $options Optional Arguments
     * @return MessagingGeopermissionsInstance Fetched MessagingGeopermissionsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): MessagingGeopermissionsInstance
    {

        $options = new Values($options);

        $params = Values::of([
            'CountryCode' =>
                $options['countryCode'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        $payload = $this->version->fetch('GET', $this->uri, $params, [], $headers);

        return new MessagingGeopermissionsInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Update the MessagingGeopermissionsInstance
     *
     * @param array[] $permissions A list of objects where each object represents the Geo Permission to be updated. Each object contains the following fields: `country_code`, unique code for each country of Geo Permission; `type`, permission type of the Geo Permission i.e. country; `enabled`, configure true for enabling the Geo Permission, false for disabling the Geo Permission.
     * @return MessagingGeopermissionsInstance Updated MessagingGeopermissionsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $permissions): MessagingGeopermissionsInstance
    {

        $data = Values::of([
            'Permissions' =>
                Serialize::map($permissions,function ($e) { return Serialize::jsonObject($e); }),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        $payload = $this->version->update('PATCH', $this->uri, [], $data, $headers);

        return new MessagingGeopermissionsInstance(
            $this->version,
            $payload
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Accounts.V1.MessagingGeopermissionsList]';
    }
}
