<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Knowledge
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Knowledge\V1;

use Twilio\Values;
abstract class KnowledgeModels
{
    /**
     * @property string $description The description of the policy.
     * @property string $id The Policy ID.
     * @property string $name The name of the policy.
     * @property array $policyDetails
     * @property string $type The description of the policy.
    */
    public static function createKnowledgeV1ServiceCreatePolicyRequest(array $payload = []): KnowledgeV1ServiceCreatePolicyRequest
    {
        return new KnowledgeV1ServiceCreatePolicyRequest($payload);
    }

    /**
     * @property string $description The description of the knowledge source.
     * @property array $knowledgeSourceDetails The details of the knowledge source based on the type.
     * @property string $name The name of the tool.
     * @property KnowledgeV1ServiceCreatePolicyRequest $policy
     * @property string $type The type of the knowledge source.
     * @property string $embeddingModel The embedding model to be used for the knowledge source. It's required for 'Database' type but disallowed for other types.
    */
    public static function createKnowledgeV1ServiceCreateKnowledgeRequest(array $payload = []): KnowledgeV1ServiceCreateKnowledgeRequest
    {
        return new KnowledgeV1ServiceCreateKnowledgeRequest($payload);
    }

    /**
     * @property string $description The description of the knowledge source.
     * @property array $knowledgeSourceDetails The details of the knowledge source based on the type.
     * @property string $name The name of the knowledge source.
     * @property KnowledgeV1ServiceCreatePolicyRequest $policy
     * @property string $type The description of the knowledge source.
     * @property string $embeddingModel The embedding model to be used for the knowledge source. It's only applicable to 'Database' type.
    */
    public static function createKnowledgeV1ServiceUpdateKnowledgeRequest(array $payload = []): KnowledgeV1ServiceUpdateKnowledgeRequest
    {
        return new KnowledgeV1ServiceUpdateKnowledgeRequest($payload);
    }

}

class KnowledgeV1ServiceCreatePolicyRequest implements \JsonSerializable
{
    /**
     * @property string $description The description of the policy.
     * @property string $id The Policy ID.
     * @property string $name The name of the policy.
     * @property array $policyDetails
     * @property string $type The description of the policy.
    */
        protected $description;
        protected $id;
        protected $name;
        protected $policyDetails;
        protected $type;
    public function __construct(array $payload = []) {
        $this->description = Values::array_get($payload, 'description');
        $this->id = Values::array_get($payload, 'id');
        $this->name = Values::array_get($payload, 'name');
        $this->policyDetails = Values::array_get($payload, 'policy_details');
        $this->type = Values::array_get($payload, 'type');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'policy_details' => $this->policyDetails
        ];
        if (isset($this->description)) {
            $jsonString['description'] = $this->description;
        }
        if (isset($this->id)) {
            $jsonString['id'] = $this->id;
        }
        if (isset($this->name)) {
            $jsonString['name'] = $this->name;
        }
        if (isset($this->type)) {
            $jsonString['type'] = $this->type;
        }
        return $jsonString;
    }
}

class KnowledgeV1ServiceCreateKnowledgeRequest implements \JsonSerializable
{
    /**
     * @property string $description The description of the knowledge source.
     * @property array $knowledgeSourceDetails The details of the knowledge source based on the type.
     * @property string $name The name of the tool.
     * @property KnowledgeV1ServiceCreatePolicyRequest $policy
     * @property string $type The type of the knowledge source.
     * @property string $embeddingModel The embedding model to be used for the knowledge source. It's required for 'Database' type but disallowed for other types.
    */
        protected $description;
        protected $knowledgeSourceDetails;
        protected $name;
        protected $policy;
        protected $type;
        protected $embeddingModel;
    public function __construct(array $payload = []) {
        $this->description = Values::array_get($payload, 'description');
        $this->knowledgeSourceDetails = Values::array_get($payload, 'knowledge_source_details');
        $this->name = Values::array_get($payload, 'name');
        $this->policy = Values::array_get($payload, 'policy');
        $this->type = Values::array_get($payload, 'type');
        $this->embeddingModel = Values::array_get($payload, 'embedding_model');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
            'name' => $this->name,
            'type' => $this->type
        ];
        if (isset($this->description)) {
            $jsonString['description'] = $this->description;
        }
        if (isset($this->knowledgeSourceDetails)) {
            $jsonString['knowledge_source_details'] = $this->knowledgeSourceDetails;
        }
        if (isset($this->policy)) {
            $jsonString['policy'] = $this->policy;
        }
        if (isset($this->embeddingModel)) {
            $jsonString['embedding_model'] = $this->embeddingModel;
        }
        return $jsonString;
    }
}

class KnowledgeV1ServiceUpdateKnowledgeRequest implements \JsonSerializable
{
    /**
     * @property string $description The description of the knowledge source.
     * @property array $knowledgeSourceDetails The details of the knowledge source based on the type.
     * @property string $name The name of the knowledge source.
     * @property KnowledgeV1ServiceCreatePolicyRequest $policy
     * @property string $type The description of the knowledge source.
     * @property string $embeddingModel The embedding model to be used for the knowledge source. It's only applicable to 'Database' type.
    */
        protected $description;
        protected $knowledgeSourceDetails;
        protected $name;
        protected $policy;
        protected $type;
        protected $embeddingModel;
    public function __construct(array $payload = []) {
        $this->description = Values::array_get($payload, 'description');
        $this->knowledgeSourceDetails = Values::array_get($payload, 'knowledge_source_details');
        $this->name = Values::array_get($payload, 'name');
        $this->policy = Values::array_get($payload, 'policy');
        $this->type = Values::array_get($payload, 'type');
        $this->embeddingModel = Values::array_get($payload, 'embedding_model');
    }

    public function toArray(): array
    {
        return $this->jsonSerialize();
    }

    public function jsonSerialize(): array
    {
        $jsonString = [
        ];
        if (isset($this->description)) {
            $jsonString['description'] = $this->description;
        }
        if (isset($this->knowledgeSourceDetails)) {
            $jsonString['knowledge_source_details'] = $this->knowledgeSourceDetails;
        }
        if (isset($this->name)) {
            $jsonString['name'] = $this->name;
        }
        if (isset($this->policy)) {
            $jsonString['policy'] = $this->policy;
        }
        if (isset($this->type)) {
            $jsonString['type'] = $this->type;
        }
        if (isset($this->embeddingModel)) {
            $jsonString['embedding_model'] = $this->embeddingModel;
        }
        return $jsonString;
    }
}

