<?php
/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 */

$aConfig = array(
    /**
     * Main Section.
     */
    'title' => 'Market',
    'version_from' => '12.0.4',
    'version_to' => '13.0.0',
    'vendor' => 'BoonEx',

    'compatible_with' => array(
        '13.0.0-A1'
    ),

    /**
     * 'home_dir' and 'home_uri' - should be unique. Don't use spaces in 'home_uri' and the other special chars.
     */
    'home_dir' => 'boonex/market/updates/update_12.0.4_13.0.0/',
    'home_uri' => 'market_update_1204_1300',

    'module_dir' => 'boonex/market/',
    'module_uri' => 'market',

    'db_prefix' => 'bx_market_',
    'class_prefix' => 'BxMarket',

    /**
     * Installation/Uninstallation Section.
     */
    'install' => array(
        'execute_sql' => 1,
        'update_files' => 1,
        'update_languages' => 1,
        'clear_db_cache' => 1,
    ),

    /**
     * Category for language keys.
     */
    'language_category' => 'Market',

    /**
     * Files Section
     */
    'delete_files' => array(
        'template/unit.html',
        'template/unit_full.html',
        'template/unit_full_private.html',
        'template/unit_gallery_private.html',
        'template/unit_live_search.html',
        'template/unit_meta_item.html',
        'template/unit_private.html',
    ),
);
