<?php
/**
 * NICategory
 *
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Payroll UK
 *
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Models\PayrollUk;

use \ArrayAccess;
use \XeroAPI\XeroPHP\PayrollUkObjectSerializer;
use \XeroAPI\XeroPHP\StringUtil;
use ReturnTypeWillChange;

/**
 * NICategory Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class NICategory implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'NICategory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'start_date' => '\DateTime',
        'ni_category' => '\XeroAPI\XeroPHP\Models\PayrollUk\NICategoryLetter',
        'ni_category_id' => 'float',
        'date_first_employed_as_civilian' => '\DateTime',
        'workplace_postcode' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'start_date' => 'date',
        'ni_category' => null,
        'ni_category_id' => null,
        'date_first_employed_as_civilian' => 'date',
        'workplace_postcode' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'start_date' => 'startDate',
        'ni_category' => 'niCategory',
        'ni_category_id' => 'niCategoryID',
        'date_first_employed_as_civilian' => 'dateFirstEmployedAsCivilian',
        'workplace_postcode' => 'workplacePostcode'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'start_date' => 'setStartDate',
        'ni_category' => 'setNiCategory',
        'ni_category_id' => 'setNiCategoryId',
        'date_first_employed_as_civilian' => 'setDateFirstEmployedAsCivilian',
        'workplace_postcode' => 'setWorkplacePostcode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'start_date' => 'getStartDate',
        'ni_category' => 'getNiCategory',
        'ni_category_id' => 'getNiCategoryId',
        'date_first_employed_as_civilian' => 'getDateFirstEmployedAsCivilian',
        'workplace_postcode' => 'getWorkplacePostcode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['start_date'] = isset($data['start_date']) ? $data['start_date'] : null;
        $this->container['ni_category'] = isset($data['ni_category']) ? $data['ni_category'] : null;
        $this->container['ni_category_id'] = isset($data['ni_category_id']) ? $data['ni_category_id'] : null;
        $this->container['date_first_employed_as_civilian'] = isset($data['date_first_employed_as_civilian']) ? $data['date_first_employed_as_civilian'] : null;
        $this->container['workplace_postcode'] = isset($data['workplace_postcode']) ? $data['workplace_postcode'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['ni_category'] === null) {
            $invalidProperties[] = "'ni_category' can't be null";
        }
        if ($this->container['workplace_postcode'] === null) {
            $invalidProperties[] = "'workplace_postcode' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets start_date
     *
     * @return \DateTime|null
     */
    public function getStartDate()
    {
        return $this->container['start_date'];
    }

    /**
     * Sets start_date
     *
     * @param \DateTime|null $start_date The start date of the NI category (YYYY-MM-DD)
     *
     * @return $this
     */
    public function setStartDate($start_date)
    {

        $this->container['start_date'] = $start_date;

        return $this;
    }



    /**
     * Gets ni_category
     *
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\NICategoryLetter
     */
    public function getNiCategory()
    {
        return $this->container['ni_category'];
    }

    /**
     * Sets ni_category
     *
     * @param \XeroAPI\XeroPHP\Models\PayrollUk\NICategoryLetter $ni_category ni_category
     *
     * @return $this
     */
    public function setNiCategory($ni_category)
    {

        $this->container['ni_category'] = $ni_category;

        return $this;
    }



    /**
     * Gets ni_category_id
     *
     * @return float|null
     */
    public function getNiCategoryId()
    {
        return $this->container['ni_category_id'];
    }

    /**
     * Sets ni_category_id
     *
     * @param float|null $ni_category_id Xero unique identifier for the NI category
     *
     * @return $this
     */
    public function setNiCategoryId($ni_category_id)
    {

        $this->container['ni_category_id'] = $ni_category_id;

        return $this;
    }



    /**
     * Gets date_first_employed_as_civilian
     *
     * @return \DateTime|null
     */
    public function getDateFirstEmployedAsCivilian()
    {
        return $this->container['date_first_employed_as_civilian'];
    }

    /**
     * Sets date_first_employed_as_civilian
     *
     * @param \DateTime|null $date_first_employed_as_civilian The date in which the employee was first employed as a civilian (YYYY-MM-DD)
     *
     * @return $this
     */
    public function setDateFirstEmployedAsCivilian($date_first_employed_as_civilian)
    {

        $this->container['date_first_employed_as_civilian'] = $date_first_employed_as_civilian;

        return $this;
    }



    /**
     * Gets workplace_postcode
     *
     * @return string
     */
    public function getWorkplacePostcode()
    {
        return $this->container['workplace_postcode'];
    }

    /**
     * Sets workplace_postcode
     *
     * @param string $workplace_postcode The workplace postcode
     *
     * @return $this
     */
    public function setWorkplacePostcode($workplace_postcode)
    {

        $this->container['workplace_postcode'] = $workplace_postcode;

        return $this;
    }


    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            PayrollUkObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


