<?php
/**
 * Contact
 *
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Models\Accounting;

use \ArrayAccess;
use \XeroAPI\XeroPHP\AccountingObjectSerializer;
use \XeroAPI\XeroPHP\StringUtil;
use ReturnTypeWillChange;

/**
 * Contact Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Contact implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Contact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'contact_id' => 'string',
        'merged_to_contact_id' => 'string',
        'contact_number' => 'string',
        'account_number' => 'string',
        'contact_status' => 'string',
        'name' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'company_number' => 'string',
        'email_address' => 'string',
        'contact_persons' => '\XeroAPI\XeroPHP\Models\Accounting\ContactPerson[]',
        'bank_account_details' => 'string',
        'tax_number' => 'string',
        'accounts_receivable_tax_type' => 'string',
        'accounts_payable_tax_type' => 'string',
        'addresses' => '\XeroAPI\XeroPHP\Models\Accounting\Address[]',
        'phones' => '\XeroAPI\XeroPHP\Models\Accounting\Phone[]',
        'is_supplier' => 'bool',
        'is_customer' => 'bool',
        'sales_default_line_amount_type' => 'string',
        'purchases_default_line_amount_type' => 'string',
        'default_currency' => '\XeroAPI\XeroPHP\Models\Accounting\CurrencyCode',
        'xero_network_key' => 'string',
        'sales_default_account_code' => 'string',
        'purchases_default_account_code' => 'string',
        'sales_tracking_categories' => '\XeroAPI\XeroPHP\Models\Accounting\SalesTrackingCategory[]',
        'purchases_tracking_categories' => '\XeroAPI\XeroPHP\Models\Accounting\SalesTrackingCategory[]',
        'tracking_category_name' => 'string',
        'tracking_category_option' => 'string',
        'payment_terms' => '\XeroAPI\XeroPHP\Models\Accounting\PaymentTerm',
        'updated_date_utc' => 'string',
        'contact_groups' => '\XeroAPI\XeroPHP\Models\Accounting\ContactGroup[]',
        'website' => 'string',
        'branding_theme' => '\XeroAPI\XeroPHP\Models\Accounting\BrandingTheme',
        'batch_payments' => '\XeroAPI\XeroPHP\Models\Accounting\BatchPaymentDetails',
        'discount' => 'double',
        'balances' => '\XeroAPI\XeroPHP\Models\Accounting\Balances',
        'attachments' => '\XeroAPI\XeroPHP\Models\Accounting\Attachment[]',
        'has_attachments' => 'bool',
        'validation_errors' => '\XeroAPI\XeroPHP\Models\Accounting\ValidationError[]',
        'has_validation_errors' => 'bool',
        'status_attribute_string' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'contact_id' => 'uuid',
        'merged_to_contact_id' => 'uuid',
        'contact_number' => null,
        'account_number' => null,
        'contact_status' => null,
        'name' => null,
        'first_name' => null,
        'last_name' => null,
        'company_number' => null,
        'email_address' => null,
        'contact_persons' => null,
        'bank_account_details' => null,
        'tax_number' => null,
        'accounts_receivable_tax_type' => null,
        'accounts_payable_tax_type' => null,
        'addresses' => null,
        'phones' => null,
        'is_supplier' => null,
        'is_customer' => null,
        'sales_default_line_amount_type' => null,
        'purchases_default_line_amount_type' => null,
        'default_currency' => null,
        'xero_network_key' => null,
        'sales_default_account_code' => null,
        'purchases_default_account_code' => null,
        'sales_tracking_categories' => null,
        'purchases_tracking_categories' => null,
        'tracking_category_name' => null,
        'tracking_category_option' => null,
        'payment_terms' => null,
        'updated_date_utc' => null,
        'contact_groups' => null,
        'website' => null,
        'branding_theme' => null,
        'batch_payments' => null,
        'discount' => 'double',
        'balances' => null,
        'attachments' => null,
        'has_attachments' => null,
        'validation_errors' => null,
        'has_validation_errors' => null,
        'status_attribute_string' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'contact_id' => 'ContactID',
        'merged_to_contact_id' => 'MergedToContactID',
        'contact_number' => 'ContactNumber',
        'account_number' => 'AccountNumber',
        'contact_status' => 'ContactStatus',
        'name' => 'Name',
        'first_name' => 'FirstName',
        'last_name' => 'LastName',
        'company_number' => 'CompanyNumber',
        'email_address' => 'EmailAddress',
        'contact_persons' => 'ContactPersons',
        'bank_account_details' => 'BankAccountDetails',
        'tax_number' => 'TaxNumber',
        'accounts_receivable_tax_type' => 'AccountsReceivableTaxType',
        'accounts_payable_tax_type' => 'AccountsPayableTaxType',
        'addresses' => 'Addresses',
        'phones' => 'Phones',
        'is_supplier' => 'IsSupplier',
        'is_customer' => 'IsCustomer',
        'sales_default_line_amount_type' => 'SalesDefaultLineAmountType',
        'purchases_default_line_amount_type' => 'PurchasesDefaultLineAmountType',
        'default_currency' => 'DefaultCurrency',
        'xero_network_key' => 'XeroNetworkKey',
        'sales_default_account_code' => 'SalesDefaultAccountCode',
        'purchases_default_account_code' => 'PurchasesDefaultAccountCode',
        'sales_tracking_categories' => 'SalesTrackingCategories',
        'purchases_tracking_categories' => 'PurchasesTrackingCategories',
        'tracking_category_name' => 'TrackingCategoryName',
        'tracking_category_option' => 'TrackingCategoryOption',
        'payment_terms' => 'PaymentTerms',
        'updated_date_utc' => 'UpdatedDateUTC',
        'contact_groups' => 'ContactGroups',
        'website' => 'Website',
        'branding_theme' => 'BrandingTheme',
        'batch_payments' => 'BatchPayments',
        'discount' => 'Discount',
        'balances' => 'Balances',
        'attachments' => 'Attachments',
        'has_attachments' => 'HasAttachments',
        'validation_errors' => 'ValidationErrors',
        'has_validation_errors' => 'HasValidationErrors',
        'status_attribute_string' => 'StatusAttributeString'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'contact_id' => 'setContactId',
        'merged_to_contact_id' => 'setMergedToContactId',
        'contact_number' => 'setContactNumber',
        'account_number' => 'setAccountNumber',
        'contact_status' => 'setContactStatus',
        'name' => 'setName',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'company_number' => 'setCompanyNumber',
        'email_address' => 'setEmailAddress',
        'contact_persons' => 'setContactPersons',
        'bank_account_details' => 'setBankAccountDetails',
        'tax_number' => 'setTaxNumber',
        'accounts_receivable_tax_type' => 'setAccountsReceivableTaxType',
        'accounts_payable_tax_type' => 'setAccountsPayableTaxType',
        'addresses' => 'setAddresses',
        'phones' => 'setPhones',
        'is_supplier' => 'setIsSupplier',
        'is_customer' => 'setIsCustomer',
        'sales_default_line_amount_type' => 'setSalesDefaultLineAmountType',
        'purchases_default_line_amount_type' => 'setPurchasesDefaultLineAmountType',
        'default_currency' => 'setDefaultCurrency',
        'xero_network_key' => 'setXeroNetworkKey',
        'sales_default_account_code' => 'setSalesDefaultAccountCode',
        'purchases_default_account_code' => 'setPurchasesDefaultAccountCode',
        'sales_tracking_categories' => 'setSalesTrackingCategories',
        'purchases_tracking_categories' => 'setPurchasesTrackingCategories',
        'tracking_category_name' => 'setTrackingCategoryName',
        'tracking_category_option' => 'setTrackingCategoryOption',
        'payment_terms' => 'setPaymentTerms',
        'updated_date_utc' => 'setUpdatedDateUtc',
        'contact_groups' => 'setContactGroups',
        'website' => 'setWebsite',
        'branding_theme' => 'setBrandingTheme',
        'batch_payments' => 'setBatchPayments',
        'discount' => 'setDiscount',
        'balances' => 'setBalances',
        'attachments' => 'setAttachments',
        'has_attachments' => 'setHasAttachments',
        'validation_errors' => 'setValidationErrors',
        'has_validation_errors' => 'setHasValidationErrors',
        'status_attribute_string' => 'setStatusAttributeString'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'contact_id' => 'getContactId',
        'merged_to_contact_id' => 'getMergedToContactId',
        'contact_number' => 'getContactNumber',
        'account_number' => 'getAccountNumber',
        'contact_status' => 'getContactStatus',
        'name' => 'getName',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'company_number' => 'getCompanyNumber',
        'email_address' => 'getEmailAddress',
        'contact_persons' => 'getContactPersons',
        'bank_account_details' => 'getBankAccountDetails',
        'tax_number' => 'getTaxNumber',
        'accounts_receivable_tax_type' => 'getAccountsReceivableTaxType',
        'accounts_payable_tax_type' => 'getAccountsPayableTaxType',
        'addresses' => 'getAddresses',
        'phones' => 'getPhones',
        'is_supplier' => 'getIsSupplier',
        'is_customer' => 'getIsCustomer',
        'sales_default_line_amount_type' => 'getSalesDefaultLineAmountType',
        'purchases_default_line_amount_type' => 'getPurchasesDefaultLineAmountType',
        'default_currency' => 'getDefaultCurrency',
        'xero_network_key' => 'getXeroNetworkKey',
        'sales_default_account_code' => 'getSalesDefaultAccountCode',
        'purchases_default_account_code' => 'getPurchasesDefaultAccountCode',
        'sales_tracking_categories' => 'getSalesTrackingCategories',
        'purchases_tracking_categories' => 'getPurchasesTrackingCategories',
        'tracking_category_name' => 'getTrackingCategoryName',
        'tracking_category_option' => 'getTrackingCategoryOption',
        'payment_terms' => 'getPaymentTerms',
        'updated_date_utc' => 'getUpdatedDateUtc',
        'contact_groups' => 'getContactGroups',
        'website' => 'getWebsite',
        'branding_theme' => 'getBrandingTheme',
        'batch_payments' => 'getBatchPayments',
        'discount' => 'getDiscount',
        'balances' => 'getBalances',
        'attachments' => 'getAttachments',
        'has_attachments' => 'getHasAttachments',
        'validation_errors' => 'getValidationErrors',
        'has_validation_errors' => 'getHasValidationErrors',
        'status_attribute_string' => 'getStatusAttributeString'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const CONTACT_STATUS_ACTIVE = 'ACTIVE';
    const CONTACT_STATUS_ARCHIVED = 'ARCHIVED';
    const CONTACT_STATUS_GDPRREQUEST = 'GDPRREQUEST';
    const SALES_DEFAULT_LINE_AMOUNT_TYPE_INCLUSIVE = 'INCLUSIVE';
    const SALES_DEFAULT_LINE_AMOUNT_TYPE_EXCLUSIVE = 'EXCLUSIVE';
    const SALES_DEFAULT_LINE_AMOUNT_TYPE_NONE = 'NONE';
    const PURCHASES_DEFAULT_LINE_AMOUNT_TYPE_INCLUSIVE = 'INCLUSIVE';
    const PURCHASES_DEFAULT_LINE_AMOUNT_TYPE_EXCLUSIVE = 'EXCLUSIVE';
    const PURCHASES_DEFAULT_LINE_AMOUNT_TYPE_NONE = 'NONE';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getContactStatusAllowableValues()
    {
        return [
            self::CONTACT_STATUS_ACTIVE,
            self::CONTACT_STATUS_ARCHIVED,
            self::CONTACT_STATUS_GDPRREQUEST,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSalesDefaultLineAmountTypeAllowableValues()
    {
        return [
            self::SALES_DEFAULT_LINE_AMOUNT_TYPE_INCLUSIVE,
            self::SALES_DEFAULT_LINE_AMOUNT_TYPE_EXCLUSIVE,
            self::SALES_DEFAULT_LINE_AMOUNT_TYPE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPurchasesDefaultLineAmountTypeAllowableValues()
    {
        return [
            self::PURCHASES_DEFAULT_LINE_AMOUNT_TYPE_INCLUSIVE,
            self::PURCHASES_DEFAULT_LINE_AMOUNT_TYPE_EXCLUSIVE,
            self::PURCHASES_DEFAULT_LINE_AMOUNT_TYPE_NONE,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['contact_id'] = isset($data['contact_id']) ? $data['contact_id'] : null;
        $this->container['merged_to_contact_id'] = isset($data['merged_to_contact_id']) ? $data['merged_to_contact_id'] : null;
        $this->container['contact_number'] = isset($data['contact_number']) ? $data['contact_number'] : null;
        $this->container['account_number'] = isset($data['account_number']) ? $data['account_number'] : null;
        $this->container['contact_status'] = isset($data['contact_status']) ? $data['contact_status'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['first_name'] = isset($data['first_name']) ? $data['first_name'] : null;
        $this->container['last_name'] = isset($data['last_name']) ? $data['last_name'] : null;
        $this->container['company_number'] = isset($data['company_number']) ? $data['company_number'] : null;
        $this->container['email_address'] = isset($data['email_address']) ? $data['email_address'] : null;
        $this->container['contact_persons'] = isset($data['contact_persons']) ? $data['contact_persons'] : null;
        $this->container['bank_account_details'] = isset($data['bank_account_details']) ? $data['bank_account_details'] : null;
        $this->container['tax_number'] = isset($data['tax_number']) ? $data['tax_number'] : null;
        $this->container['accounts_receivable_tax_type'] = isset($data['accounts_receivable_tax_type']) ? $data['accounts_receivable_tax_type'] : null;
        $this->container['accounts_payable_tax_type'] = isset($data['accounts_payable_tax_type']) ? $data['accounts_payable_tax_type'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['phones'] = isset($data['phones']) ? $data['phones'] : null;
        $this->container['is_supplier'] = isset($data['is_supplier']) ? $data['is_supplier'] : null;
        $this->container['is_customer'] = isset($data['is_customer']) ? $data['is_customer'] : null;
        $this->container['sales_default_line_amount_type'] = isset($data['sales_default_line_amount_type']) ? $data['sales_default_line_amount_type'] : null;
        $this->container['purchases_default_line_amount_type'] = isset($data['purchases_default_line_amount_type']) ? $data['purchases_default_line_amount_type'] : null;
        $this->container['default_currency'] = isset($data['default_currency']) ? $data['default_currency'] : null;
        $this->container['xero_network_key'] = isset($data['xero_network_key']) ? $data['xero_network_key'] : null;
        $this->container['sales_default_account_code'] = isset($data['sales_default_account_code']) ? $data['sales_default_account_code'] : null;
        $this->container['purchases_default_account_code'] = isset($data['purchases_default_account_code']) ? $data['purchases_default_account_code'] : null;
        $this->container['sales_tracking_categories'] = isset($data['sales_tracking_categories']) ? $data['sales_tracking_categories'] : null;
        $this->container['purchases_tracking_categories'] = isset($data['purchases_tracking_categories']) ? $data['purchases_tracking_categories'] : null;
        $this->container['tracking_category_name'] = isset($data['tracking_category_name']) ? $data['tracking_category_name'] : null;
        $this->container['tracking_category_option'] = isset($data['tracking_category_option']) ? $data['tracking_category_option'] : null;
        $this->container['payment_terms'] = isset($data['payment_terms']) ? $data['payment_terms'] : null;
        $this->container['updated_date_utc'] = isset($data['updated_date_utc']) ? $data['updated_date_utc'] : null;
        $this->container['contact_groups'] = isset($data['contact_groups']) ? $data['contact_groups'] : null;
        $this->container['website'] = isset($data['website']) ? $data['website'] : null;
        $this->container['branding_theme'] = isset($data['branding_theme']) ? $data['branding_theme'] : null;
        $this->container['batch_payments'] = isset($data['batch_payments']) ? $data['batch_payments'] : null;
        $this->container['discount'] = isset($data['discount']) ? $data['discount'] : null;
        $this->container['balances'] = isset($data['balances']) ? $data['balances'] : null;
        $this->container['attachments'] = isset($data['attachments']) ? $data['attachments'] : null;
        $this->container['has_attachments'] = isset($data['has_attachments']) ? $data['has_attachments'] : false;
        $this->container['validation_errors'] = isset($data['validation_errors']) ? $data['validation_errors'] : null;
        $this->container['has_validation_errors'] = isset($data['has_validation_errors']) ? $data['has_validation_errors'] : false;
        $this->container['status_attribute_string'] = isset($data['status_attribute_string']) ? $data['status_attribute_string'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['contact_number']) && (mb_strlen($this->container['contact_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'contact_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['account_number']) && (mb_strlen($this->container['account_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'account_number', the character length must be smaller than or equal to 50.";
        }

        $allowedValues = $this->getContactStatusAllowableValues();
        if (!is_null($this->container['contact_status']) && !in_array($this->container['contact_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'contact_status', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['name']) && (mb_strlen($this->container['name']) > 255)) {
            $invalidProperties[] = "invalid value for 'name', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['first_name']) && (mb_strlen($this->container['first_name']) > 255)) {
            $invalidProperties[] = "invalid value for 'first_name', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['last_name']) && (mb_strlen($this->container['last_name']) > 255)) {
            $invalidProperties[] = "invalid value for 'last_name', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['company_number']) && (mb_strlen($this->container['company_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'company_number', the character length must be smaller than or equal to 50.";
        }

        if (!is_null($this->container['email_address']) && (mb_strlen($this->container['email_address']) > 255)) {
            $invalidProperties[] = "invalid value for 'email_address', the character length must be smaller than or equal to 255.";
        }

        if (!is_null($this->container['tax_number']) && (mb_strlen($this->container['tax_number']) > 50)) {
            $invalidProperties[] = "invalid value for 'tax_number', the character length must be smaller than or equal to 50.";
        }

        $allowedValues = $this->getSalesDefaultLineAmountTypeAllowableValues();
        if (!is_null($this->container['sales_default_line_amount_type']) && !in_array($this->container['sales_default_line_amount_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'sales_default_line_amount_type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPurchasesDefaultLineAmountTypeAllowableValues();
        if (!is_null($this->container['purchases_default_line_amount_type']) && !in_array($this->container['purchases_default_line_amount_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'purchases_default_line_amount_type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets contact_id
     *
     * @return string|null
     */
    public function getContactId()
    {
        return $this->container['contact_id'];
    }

    /**
     * Sets contact_id
     *
     * @param string|null $contact_id Xero identifier
     *
     * @return $this
     */
    public function setContactId($contact_id)
    {

        $this->container['contact_id'] = $contact_id;

        return $this;
    }



    /**
     * Gets merged_to_contact_id
     *
     * @return string|null
     */
    public function getMergedToContactId()
    {
        return $this->container['merged_to_contact_id'];
    }

    /**
     * Sets merged_to_contact_id
     *
     * @param string|null $merged_to_contact_id ID for the destination of a merged contact. Only returned when using paging or when fetching a contact by ContactId or ContactNumber.
     *
     * @return $this
     */
    public function setMergedToContactId($merged_to_contact_id)
    {

        $this->container['merged_to_contact_id'] = $merged_to_contact_id;

        return $this;
    }



    /**
     * Gets contact_number
     *
     * @return string|null
     */
    public function getContactNumber()
    {
        return $this->container['contact_number'];
    }

    /**
     * Sets contact_number
     *
     * @param string|null $contact_number This can be updated via the API only i.e. This field is read only on the Xero contact screen, used to identify contacts in external systems (max length = 50). If the Contact Number is used, this is displayed as Contact Code in the Contacts UI in Xero.
     *
     * @return $this
     */
    public function setContactNumber($contact_number)
    {
        if (!is_null($contact_number) && (mb_strlen($contact_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $contact_number when calling Contact., must be smaller than or equal to 50.');
        }


        $this->container['contact_number'] = $contact_number;

        return $this;
    }



    /**
     * Gets account_number
     *
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->container['account_number'];
    }

    /**
     * Sets account_number
     *
     * @param string|null $account_number A user defined account number. This can be updated via the API and the Xero UI (max length = 50)
     *
     * @return $this
     */
    public function setAccountNumber($account_number)
    {
        if (!is_null($account_number) && (mb_strlen($account_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $account_number when calling Contact., must be smaller than or equal to 50.');
        }


        $this->container['account_number'] = $account_number;

        return $this;
    }



    /**
     * Gets contact_status
     *
     * @return string|null
     */
    public function getContactStatus()
    {
        return $this->container['contact_status'];
    }

    /**
     * Sets contact_status
     *
     * @param string|null $contact_status Current status of a contact – see contact status types
     *
     * @return $this
     */
    public function setContactStatus($contact_status)
    {
        $allowedValues = $this->getContactStatusAllowableValues();
        if (!is_null($contact_status) && !in_array($contact_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'contact_status', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }

        $this->container['contact_status'] = $contact_status;

        return $this;
    }



    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Full name of contact/organisation (max length = 255)
     *
     * @return $this
     */
    public function setName($name)
    {
        if (!is_null($name) && (mb_strlen($name) > 255)) {
            throw new \InvalidArgumentException('invalid length for $name when calling Contact., must be smaller than or equal to 255.');
        }


        $this->container['name'] = $name;

        return $this;
    }



    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name First name of contact person (max length = 255)
     *
     * @return $this
     */
    public function setFirstName($first_name)
    {
        if (!is_null($first_name) && (mb_strlen($first_name) > 255)) {
            throw new \InvalidArgumentException('invalid length for $first_name when calling Contact., must be smaller than or equal to 255.');
        }


        $this->container['first_name'] = $first_name;

        return $this;
    }



    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name Last name of contact person (max length = 255)
     *
     * @return $this
     */
    public function setLastName($last_name)
    {
        if (!is_null($last_name) && (mb_strlen($last_name) > 255)) {
            throw new \InvalidArgumentException('invalid length for $last_name when calling Contact., must be smaller than or equal to 255.');
        }


        $this->container['last_name'] = $last_name;

        return $this;
    }



    /**
     * Gets company_number
     *
     * @return string|null
     */
    public function getCompanyNumber()
    {
        return $this->container['company_number'];
    }

    /**
     * Sets company_number
     *
     * @param string|null $company_number Company registration number (max length = 50)
     *
     * @return $this
     */
    public function setCompanyNumber($company_number)
    {
        if (!is_null($company_number) && (mb_strlen($company_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $company_number when calling Contact., must be smaller than or equal to 50.');
        }


        $this->container['company_number'] = $company_number;

        return $this;
    }



    /**
     * Gets email_address
     *
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->container['email_address'];
    }

    /**
     * Sets email_address
     *
     * @param string|null $email_address Email address of contact person (umlauts not supported) (max length  = 255)
     *
     * @return $this
     */
    public function setEmailAddress($email_address)
    {
        if (!is_null($email_address) && (mb_strlen($email_address) > 255)) {
            throw new \InvalidArgumentException('invalid length for $email_address when calling Contact., must be smaller than or equal to 255.');
        }


        $this->container['email_address'] = $email_address;

        return $this;
    }



    /**
     * Gets contact_persons
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\ContactPerson[]|null
     */
    public function getContactPersons()
    {
        return $this->container['contact_persons'];
    }

    /**
     * Sets contact_persons
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\ContactPerson[]|null $contact_persons See contact persons
     *
     * @return $this
     */
    public function setContactPersons($contact_persons)
    {

        $this->container['contact_persons'] = $contact_persons;

        return $this;
    }



    /**
     * Gets bank_account_details
     *
     * @return string|null
     */
    public function getBankAccountDetails()
    {
        return $this->container['bank_account_details'];
    }

    /**
     * Sets bank_account_details
     *
     * @param string|null $bank_account_details Bank account number of contact
     *
     * @return $this
     */
    public function setBankAccountDetails($bank_account_details)
    {

        $this->container['bank_account_details'] = $bank_account_details;

        return $this;
    }



    /**
     * Gets tax_number
     *
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->container['tax_number'];
    }

    /**
     * Sets tax_number
     *
     * @param string|null $tax_number Tax number of contact – this is also known as the ABN (Australia), GST Number (New Zealand), VAT Number (UK) or Tax ID Number (US and global) in the Xero UI depending on which regionalized version of Xero you are using (max length = 50)
     *
     * @return $this
     */
    public function setTaxNumber($tax_number)
    {
        if (!is_null($tax_number) && (mb_strlen($tax_number) > 50)) {
            throw new \InvalidArgumentException('invalid length for $tax_number when calling Contact., must be smaller than or equal to 50.');
        }


        $this->container['tax_number'] = $tax_number;

        return $this;
    }



    /**
     * Gets accounts_receivable_tax_type
     *
     * @return string|null
     */
    public function getAccountsReceivableTaxType()
    {
        return $this->container['accounts_receivable_tax_type'];
    }

    /**
     * Sets accounts_receivable_tax_type
     *
     * @param string|null $accounts_receivable_tax_type The tax type from TaxRates
     *
     * @return $this
     */
    public function setAccountsReceivableTaxType($accounts_receivable_tax_type)
    {

        $this->container['accounts_receivable_tax_type'] = $accounts_receivable_tax_type;

        return $this;
    }



    /**
     * Gets accounts_payable_tax_type
     *
     * @return string|null
     */
    public function getAccountsPayableTaxType()
    {
        return $this->container['accounts_payable_tax_type'];
    }

    /**
     * Sets accounts_payable_tax_type
     *
     * @param string|null $accounts_payable_tax_type The tax type from TaxRates
     *
     * @return $this
     */
    public function setAccountsPayableTaxType($accounts_payable_tax_type)
    {

        $this->container['accounts_payable_tax_type'] = $accounts_payable_tax_type;

        return $this;
    }



    /**
     * Gets addresses
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Address[]|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Address[]|null $addresses Store certain address types for a contact – see address types
     *
     * @return $this
     */
    public function setAddresses($addresses)
    {

        $this->container['addresses'] = $addresses;

        return $this;
    }



    /**
     * Gets phones
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Phone[]|null
     */
    public function getPhones()
    {
        return $this->container['phones'];
    }

    /**
     * Sets phones
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Phone[]|null $phones Store certain phone types for a contact – see phone types
     *
     * @return $this
     */
    public function setPhones($phones)
    {

        $this->container['phones'] = $phones;

        return $this;
    }



    /**
     * Gets is_supplier
     *
     * @return bool|null
     */
    public function getIsSupplier()
    {
        return $this->container['is_supplier'];
    }

    /**
     * Sets is_supplier
     *
     * @param bool|null $is_supplier true or false – Boolean that describes if a contact that has any AP  invoices entered against them. Cannot be set via PUT or POST – it is automatically set when an accounts payable invoice is generated against this contact.
     *
     * @return $this
     */
    public function setIsSupplier($is_supplier)
    {

        $this->container['is_supplier'] = $is_supplier;

        return $this;
    }



    /**
     * Gets is_customer
     *
     * @return bool|null
     */
    public function getIsCustomer()
    {
        return $this->container['is_customer'];
    }

    /**
     * Sets is_customer
     *
     * @param bool|null $is_customer true or false – Boolean that describes if a contact has any AR invoices entered against them. Cannot be set via PUT or POST – it is automatically set when an accounts receivable invoice is generated against this contact.
     *
     * @return $this
     */
    public function setIsCustomer($is_customer)
    {

        $this->container['is_customer'] = $is_customer;

        return $this;
    }



    /**
     * Gets sales_default_line_amount_type
     *
     * @return string|null
     */
    public function getSalesDefaultLineAmountType()
    {
        return $this->container['sales_default_line_amount_type'];
    }

    /**
     * Sets sales_default_line_amount_type
     *
     * @param string|null $sales_default_line_amount_type The default sales line amount type for a contact. Only available when summaryOnly parameter or paging is used, or when fetch by ContactId or ContactNumber.
     *
     * @return $this
     */
    public function setSalesDefaultLineAmountType($sales_default_line_amount_type)
    {
        $allowedValues = $this->getSalesDefaultLineAmountTypeAllowableValues();
        if (!is_null($sales_default_line_amount_type) && !in_array($sales_default_line_amount_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'sales_default_line_amount_type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }

        $this->container['sales_default_line_amount_type'] = $sales_default_line_amount_type;

        return $this;
    }



    /**
     * Gets purchases_default_line_amount_type
     *
     * @return string|null
     */
    public function getPurchasesDefaultLineAmountType()
    {
        return $this->container['purchases_default_line_amount_type'];
    }

    /**
     * Sets purchases_default_line_amount_type
     *
     * @param string|null $purchases_default_line_amount_type The default purchases line amount type for a contact Only available when summaryOnly parameter or paging is used, or when fetch by ContactId or ContactNumber.
     *
     * @return $this
     */
    public function setPurchasesDefaultLineAmountType($purchases_default_line_amount_type)
    {
        $allowedValues = $this->getPurchasesDefaultLineAmountTypeAllowableValues();
        if (!is_null($purchases_default_line_amount_type) && !in_array($purchases_default_line_amount_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'purchases_default_line_amount_type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }

        $this->container['purchases_default_line_amount_type'] = $purchases_default_line_amount_type;

        return $this;
    }



    /**
     * Gets default_currency
     *
     * @return string|null
     */
    public function getDefaultCurrency()
    {
        return $this->container['default_currency'];
    }

    /**
     * Sets default_currency
     *
     * @param string|null $default_currency default_currency
     *
     * @return $this
     */
    public function setDefaultCurrency($default_currency)
    {

        $this->container['default_currency'] = $default_currency;

        return $this;
    }



    /**
     * Gets xero_network_key
     *
     * @return string|null
     */
    public function getXeroNetworkKey()
    {
        return $this->container['xero_network_key'];
    }

    /**
     * Sets xero_network_key
     *
     * @param string|null $xero_network_key Store XeroNetworkKey for contacts.
     *
     * @return $this
     */
    public function setXeroNetworkKey($xero_network_key)
    {

        $this->container['xero_network_key'] = $xero_network_key;

        return $this;
    }



    /**
     * Gets sales_default_account_code
     *
     * @return string|null
     */
    public function getSalesDefaultAccountCode()
    {
        return $this->container['sales_default_account_code'];
    }

    /**
     * Sets sales_default_account_code
     *
     * @param string|null $sales_default_account_code The default sales account code for contacts
     *
     * @return $this
     */
    public function setSalesDefaultAccountCode($sales_default_account_code)
    {

        $this->container['sales_default_account_code'] = $sales_default_account_code;

        return $this;
    }



    /**
     * Gets purchases_default_account_code
     *
     * @return string|null
     */
    public function getPurchasesDefaultAccountCode()
    {
        return $this->container['purchases_default_account_code'];
    }

    /**
     * Sets purchases_default_account_code
     *
     * @param string|null $purchases_default_account_code The default purchases account code for contacts
     *
     * @return $this
     */
    public function setPurchasesDefaultAccountCode($purchases_default_account_code)
    {

        $this->container['purchases_default_account_code'] = $purchases_default_account_code;

        return $this;
    }



    /**
     * Gets sales_tracking_categories
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\SalesTrackingCategory[]|null
     */
    public function getSalesTrackingCategories()
    {
        return $this->container['sales_tracking_categories'];
    }

    /**
     * Sets sales_tracking_categories
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\SalesTrackingCategory[]|null $sales_tracking_categories The default sales tracking categories for contacts
     *
     * @return $this
     */
    public function setSalesTrackingCategories($sales_tracking_categories)
    {

        $this->container['sales_tracking_categories'] = $sales_tracking_categories;

        return $this;
    }



    /**
     * Gets purchases_tracking_categories
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\SalesTrackingCategory[]|null
     */
    public function getPurchasesTrackingCategories()
    {
        return $this->container['purchases_tracking_categories'];
    }

    /**
     * Sets purchases_tracking_categories
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\SalesTrackingCategory[]|null $purchases_tracking_categories The default purchases tracking categories for contacts
     *
     * @return $this
     */
    public function setPurchasesTrackingCategories($purchases_tracking_categories)
    {

        $this->container['purchases_tracking_categories'] = $purchases_tracking_categories;

        return $this;
    }



    /**
     * Gets tracking_category_name
     *
     * @return string|null
     */
    public function getTrackingCategoryName()
    {
        return $this->container['tracking_category_name'];
    }

    /**
     * Sets tracking_category_name
     *
     * @param string|null $tracking_category_name The name of the Tracking Category assigned to the contact under SalesTrackingCategories and PurchasesTrackingCategories
     *
     * @return $this
     */
    public function setTrackingCategoryName($tracking_category_name)
    {

        $this->container['tracking_category_name'] = $tracking_category_name;

        return $this;
    }



    /**
     * Gets tracking_category_option
     *
     * @return string|null
     */
    public function getTrackingCategoryOption()
    {
        return $this->container['tracking_category_option'];
    }

    /**
     * Sets tracking_category_option
     *
     * @param string|null $tracking_category_option The name of the Tracking Option assigned to the contact under SalesTrackingCategories and PurchasesTrackingCategories
     *
     * @return $this
     */
    public function setTrackingCategoryOption($tracking_category_option)
    {

        $this->container['tracking_category_option'] = $tracking_category_option;

        return $this;
    }



    /**
     * Gets payment_terms
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\PaymentTerm|null
     */
    public function getPaymentTerms()
    {
        return $this->container['payment_terms'];
    }

    /**
     * Sets payment_terms
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\PaymentTerm|null $payment_terms payment_terms
     *
     * @return $this
     */
    public function setPaymentTerms($payment_terms)
    {

        $this->container['payment_terms'] = $payment_terms;

        return $this;
    }



    /**
     * Gets updated_date_utc
     *
     * @return string|null
     */
    public function getUpdatedDateUtc()
    {
        return $this->container['updated_date_utc'];
    }
    public function getUpdatedDateUtcAsDate()
    {
      if ($this->getUpdatedDateUtc() != null) {
        return StringUtil::convertStringToDateTime($this->getUpdatedDateUtc());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets updated_date_utc
     *
     * @param string|null $updated_date_utc UTC timestamp of last update to contact
     *
     * @return $this
     */
    public function setUpdatedDateUtc($updated_date_utc)
    {

        $this->container['updated_date_utc'] = $updated_date_utc;

        return $this;
    }


    /**
     * Gets contact_groups
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\ContactGroup[]|null
     */
    public function getContactGroups()
    {
        return $this->container['contact_groups'];
    }

    /**
     * Sets contact_groups
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\ContactGroup[]|null $contact_groups Displays which contact groups a contact is included in
     *
     * @return $this
     */
    public function setContactGroups($contact_groups)
    {

        $this->container['contact_groups'] = $contact_groups;

        return $this;
    }



    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website Website address for contact (read only)
     *
     * @return $this
     */
    public function setWebsite($website)
    {

        $this->container['website'] = $website;

        return $this;
    }


    /**
     * Gets branding_theme
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\BrandingTheme|null
     */
    public function getBrandingTheme()
    {
        return $this->container['branding_theme'];
    }

    /**
     * Sets branding_theme
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\BrandingTheme|null $branding_theme branding_theme
     *
     * @return $this
     */
    public function setBrandingTheme($branding_theme)
    {

        $this->container['branding_theme'] = $branding_theme;

        return $this;
    }



    /**
     * Gets batch_payments
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\BatchPaymentDetails|null
     */
    public function getBatchPayments()
    {
        return $this->container['batch_payments'];
    }

    /**
     * Sets batch_payments
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\BatchPaymentDetails|null $batch_payments batch_payments
     *
     * @return $this
     */
    public function setBatchPayments($batch_payments)
    {

        $this->container['batch_payments'] = $batch_payments;

        return $this;
    }



    /**
     * Gets discount
     *
     * @return double|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param double|null $discount The default discount rate for the contact (read only)
     *
     * @return $this
     */
    public function setDiscount($discount)
    {

        $this->container['discount'] = $discount;

        return $this;
    }


    /**
     * Gets balances
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Balances|null
     */
    public function getBalances()
    {
        return $this->container['balances'];
    }

    /**
     * Sets balances
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Balances|null $balances balances
     *
     * @return $this
     */
    public function setBalances($balances)
    {

        $this->container['balances'] = $balances;

        return $this;
    }



    /**
     * Gets attachments
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Attachment[]|null $attachments Displays array of attachments from the API
     *
     * @return $this
     */
    public function setAttachments($attachments)
    {

        $this->container['attachments'] = $attachments;

        return $this;
    }



    /**
     * Gets has_attachments
     *
     * @return bool|null
     */
    public function getHasAttachments()
    {
        return $this->container['has_attachments'];
    }

    /**
     * Sets has_attachments
     *
     * @param bool|null $has_attachments A boolean to indicate if a contact has an attachment
     *
     * @return $this
     */
    public function setHasAttachments($has_attachments)
    {

        $this->container['has_attachments'] = $has_attachments;

        return $this;
    }



    /**
     * Gets validation_errors
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\ValidationError[]|null
     */
    public function getValidationErrors()
    {
        return $this->container['validation_errors'];
    }

    /**
     * Sets validation_errors
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\ValidationError[]|null $validation_errors Displays validation errors returned from the API
     *
     * @return $this
     */
    public function setValidationErrors($validation_errors)
    {

        $this->container['validation_errors'] = $validation_errors;

        return $this;
    }



    /**
     * Gets has_validation_errors
     *
     * @return bool|null
     */
    public function getHasValidationErrors()
    {
        return $this->container['has_validation_errors'];
    }

    /**
     * Sets has_validation_errors
     *
     * @param bool|null $has_validation_errors A boolean to indicate if a contact has an validation errors
     *
     * @return $this
     */
    public function setHasValidationErrors($has_validation_errors)
    {

        $this->container['has_validation_errors'] = $has_validation_errors;

        return $this;
    }



    /**
     * Gets status_attribute_string
     *
     * @return string|null
     */
    public function getStatusAttributeString()
    {
        return $this->container['status_attribute_string'];
    }

    /**
     * Sets status_attribute_string
     *
     * @param string|null $status_attribute_string Status of object
     *
     * @return $this
     */
    public function setStatusAttributeString($status_attribute_string)
    {

        $this->container['status_attribute_string'] = $status_attribute_string;

        return $this;
    }


    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            AccountingObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


