<?php
/**
 * AppStoreApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP AppStore
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero AppStore API
 *
 * These endpoints are for Xero Partners to interact with the App Store Billing platform
 *
 * OpenAPI spec version: 9.0.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\AppStoreObjectSerializer;

/**
 * AppStoreApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AppStoreApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getSubscription
     * Retrieves a subscription for a given subscriptionId
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\AppStore\Subscription|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails
     */
    public function getSubscription($subscription_id)
    {
        list($response) = $this->getSubscriptionWithHttpInfo($subscription_id);
        return $response;
    }
    /**
     * Operation getSubscriptionWithHttpInfo
     * Retrieves a subscription for a given subscriptionId
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\AppStore\Subscription|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriptionWithHttpInfo($subscription_id)
    {
        $request = $this->getSubscriptionRequest($subscription_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\Subscription' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\Subscription', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\AppStore\Subscription';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AppStoreObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\Subscription',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSubscriptionAsync
     * Retrieves a subscription for a given subscriptionId
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionAsync($subscription_id)
    {
        return $this->getSubscriptionAsyncWithHttpInfo($subscription_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSubscriptionAsyncWithHttpInfo
     * Retrieves a subscription for a given subscriptionId
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSubscriptionAsyncWithHttpInfo($subscription_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\AppStore\Subscription';
        $request = $this->getSubscriptionRequest($subscription_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSubscription'
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSubscriptionRequest($subscription_id)
    {
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling getSubscription'
            );
        }
        $resourcePath = '/subscriptions/{subscriptionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriptionId' . '}',
                AppStoreObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AppStoreObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostAppStore() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getUsageRecords
     * Gets all usage records related to the subscription
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails
     */
    public function getUsageRecords($subscription_id)
    {
        list($response) = $this->getUsageRecordsWithHttpInfo($subscription_id);
        return $response;
    }
    /**
     * Operation getUsageRecordsWithHttpInfo
     * Gets all usage records related to the subscription
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function getUsageRecordsWithHttpInfo($subscription_id)
    {
        $request = $this->getUsageRecordsRequest($subscription_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AppStoreObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getUsageRecordsAsync
     * Gets all usage records related to the subscription
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getUsageRecordsAsync($subscription_id)
    {
        return $this->getUsageRecordsAsyncWithHttpInfo($subscription_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getUsageRecordsAsyncWithHttpInfo
     * Gets all usage records related to the subscription
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getUsageRecordsAsyncWithHttpInfo($subscription_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\AppStore\UsageRecordsList';
        $request = $this->getUsageRecordsRequest($subscription_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getUsageRecords'
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getUsageRecordsRequest($subscription_id)
    {
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling getUsageRecords'
            );
        }
        $resourcePath = '/subscriptions/{subscriptionId}/usage-records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriptionId' . '}',
                AppStoreObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AppStoreObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostAppStore() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation postUsageRecords
     * Send metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\CreateUsageRecord $create_usage_record Contains the quantity for the usage record to create (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\AppStore\UsageRecord|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails
     */
    public function postUsageRecords($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key = null)
    {
        list($response) = $this->postUsageRecordsWithHttpInfo($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key);
        return $response;
    }
    /**
     * Operation postUsageRecordsWithHttpInfo
     * Send metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\CreateUsageRecord $create_usage_record Contains the quantity for the usage record to create (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\AppStore\UsageRecord|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function postUsageRecordsWithHttpInfo($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key = null)
    {
        $request = $this->postUsageRecordsRequest($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\UsageRecord' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AppStoreObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation postUsageRecordsAsync
     * Send metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\CreateUsageRecord $create_usage_record Contains the quantity for the usage record to create (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function postUsageRecordsAsync($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key = null)
    {
        return $this->postUsageRecordsAsyncWithHttpInfo($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation postUsageRecordsAsyncWithHttpInfo
     * Send metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\CreateUsageRecord $create_usage_record Contains the quantity for the usage record to create (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function postUsageRecordsAsyncWithHttpInfo($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord';
        $request = $this->postUsageRecordsRequest($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'postUsageRecords'
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\CreateUsageRecord $create_usage_record Contains the quantity for the usage record to create (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function postUsageRecordsRequest($subscription_id, $subscription_item_id, $create_usage_record, $idempotency_key = null)
    {
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling postUsageRecords'
            );
        }
        // verify the required parameter 'subscription_item_id' is set
        if ($subscription_item_id === null || (is_array($subscription_item_id) && count($subscription_item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_item_id when calling postUsageRecords'
            );
        }
        // verify the required parameter 'create_usage_record' is set
        if ($create_usage_record === null || (is_array($create_usage_record) && count($create_usage_record) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_usage_record when calling postUsageRecords'
            );
        }
        $resourcePath = '/subscriptions/{subscriptionId}/items/{subscriptionItemId}/usage-records';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = AppStoreObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriptionId' . '}',
                AppStoreObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriptionItemId' . '}',
                AppStoreObjectSerializer::toPathValue($subscription_item_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($create_usage_record)) {
            $_tempBody = $create_usage_record;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AppStoreObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostAppStore() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putUsageRecords
     * Update and existing metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  string $usage_record_id The unique identifier of the usage record (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\UpdateUsageRecord $update_usage_record Contains the quantity for the usage record to update (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\AppStore\UsageRecord|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails
     */
    public function putUsageRecords($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key = null)
    {
        list($response) = $this->putUsageRecordsWithHttpInfo($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key);
        return $response;
    }
    /**
     * Operation putUsageRecordsWithHttpInfo
     * Update and existing metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  string $usage_record_id The unique identifier of the usage record (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\UpdateUsageRecord $update_usage_record Contains the quantity for the usage record to update (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\AppStore\UsageRecord|\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails, HTTP status code, HTTP response headers (array of strings)
     */
    public function putUsageRecordsWithHttpInfo($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key = null)
    {
        $request = $this->putUsageRecordsRequest($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\UsageRecord' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 404:
                    if ('\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                AppStoreObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = AppStoreObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\AppStore\ProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation putUsageRecordsAsync
     * Update and existing metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  string $usage_record_id The unique identifier of the usage record (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\UpdateUsageRecord $update_usage_record Contains the quantity for the usage record to update (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putUsageRecordsAsync($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key = null)
    {
        return $this->putUsageRecordsAsyncWithHttpInfo($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation putUsageRecordsAsyncWithHttpInfo
     * Update and existing metered usage belonging to this subscription and subscription item
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  string $usage_record_id The unique identifier of the usage record (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\UpdateUsageRecord $update_usage_record Contains the quantity for the usage record to update (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function putUsageRecordsAsyncWithHttpInfo($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\AppStore\UsageRecord';
        $request = $this->putUsageRecordsRequest($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        AppStoreObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putUsageRecords'
     * @param  string $subscription_id Unique identifier for Subscription object (required)
     * @param  string $subscription_item_id The unique identifier of the subscriptionItem (required)
     * @param  string $usage_record_id The unique identifier of the usage record (required)
     * @param  \XeroAPI\XeroPHP\Models\AppStore\UpdateUsageRecord $update_usage_record Contains the quantity for the usage record to update (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function putUsageRecordsRequest($subscription_id, $subscription_item_id, $usage_record_id, $update_usage_record, $idempotency_key = null)
    {
        // verify the required parameter 'subscription_id' is set
        if ($subscription_id === null || (is_array($subscription_id) && count($subscription_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_id when calling putUsageRecords'
            );
        }
        // verify the required parameter 'subscription_item_id' is set
        if ($subscription_item_id === null || (is_array($subscription_item_id) && count($subscription_item_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_item_id when calling putUsageRecords'
            );
        }
        // verify the required parameter 'usage_record_id' is set
        if ($usage_record_id === null || (is_array($usage_record_id) && count($usage_record_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $usage_record_id when calling putUsageRecords'
            );
        }
        // verify the required parameter 'update_usage_record' is set
        if ($update_usage_record === null || (is_array($update_usage_record) && count($update_usage_record) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_usage_record when calling putUsageRecords'
            );
        }
        $resourcePath = '/subscriptions/{subscriptionId}/items/{subscriptionItemId}/usage-records/{usageRecordId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = AppStoreObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($subscription_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriptionId' . '}',
                AppStoreObjectSerializer::toPathValue($subscription_id),
                $resourcePath
            );
        }
        // path params
        if ($subscription_item_id !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriptionItemId' . '}',
                AppStoreObjectSerializer::toPathValue($subscription_item_id),
                $resourcePath
            );
        }
        // path params
        if ($usage_record_id !== null) {
            $resourcePath = str_replace(
                '{' . 'usageRecordId' . '}',
                AppStoreObjectSerializer::toPathValue($usage_record_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($update_usage_record)) {
            $_tempBody = $update_usage_record;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(AppStoreObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostAppStore() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
