<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Messaging;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Messaging\V2\ChannelsSenderList;
use Twilio\Rest\Messaging\V2\DomainCertsList;
use Twilio\Rest\Messaging\V2\TypingIndicatorList;
use Twilio\Version;

/**
 * @property ChannelsSenderList $channelsSenders
 * @property DomainCertsList $domainCerts
 * @property TypingIndicatorList $typingIndicator
 * @method \Twilio\Rest\Messaging\V2\ChannelsSenderContext channelsSenders(string $sid)
 */
class V2 extends Version
{
    protected $_channelsSenders;
    protected $_domainCerts;
    protected $_typingIndicator;

    /**
     * Construct the V2 version of Messaging
     *
     * @param Domain $domain Domain that contains the version
     */
    public function __construct(Domain $domain)
    {
        parent::__construct($domain);
        $this->version = 'v2';
    }

    protected function getChannelsSenders(): ChannelsSenderList
    {
        if (!$this->_channelsSenders) {
            $this->_channelsSenders = new ChannelsSenderList($this);
        }
        return $this->_channelsSenders;
    }

    protected function getDomainCerts(): DomainCertsList
    {
        if (!$this->_domainCerts) {
            $this->_domainCerts = new DomainCertsList($this);
        }
        return $this->_domainCerts;
    }

    protected function getTypingIndicator(): TypingIndicatorList
    {
        if (!$this->_typingIndicator) {
            $this->_typingIndicator = new TypingIndicatorList($this);
        }
        return $this->_typingIndicator;
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     * @return \Twilio\ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get(string $name)
    {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext
    {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Messaging.V2]';
    }
}
