/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 *
 * @defgroup    MediaManager MediaManager
 * @ingroup     UnaModules
 */

/**
 * Media Changer js class
 */

function BxMediaChanger(oOptions) {
	this._sActionUrl = oOptions.sActionUrl;
	this._iContentId = oOptions.iContentId;
	this._sFieldName = oOptions.sFieldName;
	this._sModule = oOptions.sModule;
	this._sObjName = oOptions.sObjName;
	this._sStorage = oOptions.sStorage;
	this._sUploader = oOptions.sUploader;
	this._sTranscoder = oOptions.sTranscoder;
	this._sSelector = '.' + oOptions.sSelector;
	this._bIsBackground = oOptions.bIsBackground;
	this._sImageUrl = oOptions.sImageUrl;
	this._sUniqId = oOptions.sUniqId;
	this._sImageType = oOptions.sImageType;
	
	this._bIsInline = (this._sImageType == 'cover' ? true : false);
	this._bIsCaption = (this._sImageType == 'avatar' ? false : true);
	this._aCaptions = oOptions.aCaptions;
    var $this = this;
	$(document).ready(function () {
        window[$this._sObjName].init(); 
    });
}

BxMediaChanger.prototype.init = function () {
	var $this = this;
	var $obj = window[this._sObjName];
	$($this._sSelector).each(function () {
		$(this).find(".bx-media-editable-cnt").remove();
		$('<div class="bx-media-editable-cnt"></div>').insertAfter($(this).find(">:first-child"));
		//$(this).find("A").removeAttr('onclick');
		
		var $cnt = $(this).find('.bx-media-editable-cnt');
		//  add upload button
		$cnt.append('<input type="file" class="bx-media-editable-file" accept=".png, .jpg, .jpeg, .gif" hidden/><a href="javascript:" class="bx-media-editable-btn bx-media-editable-btn-add bx-btn bx-btn-small" title="' + $this._aCaptions['allowed_files'] + '"><i class="sys-icon upload"></i>' + ($this._bIsCaption ? '<u>' + $this._aCaptions['upload'] + '</u>' : '') + '</a>');
		
        $(this).find('.bx-media-editable-btn-add').on('click', function(event) {
            $($this._sSelector).find(".bx-media-editable-file").trigger('click');    
        });
        
        $(this).find('.bx-media-editable-file').change(function (){
            $this.uploadFile($($this._sSelector).find(".bx-media-editable-file").prop('files')[0], false);
        });

		//  add edit button
		if ($this._sImageUrl != ''){
			$cnt.append('<a href="javascript:" class="bx-media-editable-btn bx-media-editable-btn-edit bx-btn bx-btn-small"><i class="sys-icon pencil-alt"></i>' + ($this._bIsCaption ? '<u>' + $this._aCaptions['edit'] + '</u>' : '') + '</a>');
			$(this).find('.bx-media-editable-btn-edit').on('click', function(event) {
				event.stopPropagation();
				$this.addEditor('open')
			});
		}
		
		//  add tweak button
		if ($this._sImageUrl != '' && $this._bIsInline){
			$cnt.append('<a href="javascript:" class="bx-media-editable-btn bx-media-editable-btn-tweak bx-btn bx-btn-small"><i class="sys-icon cog"></i>' + ($this._bIsCaption ? '<u>' + $this._aCaptions['tweak'] + '</u>' : '') + '</a>');
			$(this).find('.bx-media-editable-btn-tweak').on('click', function(event) {
				event.stopPropagation();
				$this.addEditor('inline')
			});
		}
		
		if ($this._bIsCaption){
			$cnt.css('top', '20px').css('width', 'auto').css('justify-content', 'flex-end');
		}
		else{
			$cnt.css('right', 'calc(50% - ' + $cnt.width()/2 + 'px)');
		}
	});
}

BxMediaChanger.prototype.addEditor = function (sMode) {
	var $this = this;
	import(sUrlRoot + '/modules/boonex/media/plugins/pintura/pintura.js').then(({
		getEditorDefaults,
		overlayEditor,
		appendEditor,
		openEditor
	}) => {
		var oConfig = Object.assign(getEditorDefaults(), {src: $this._sImageUrl})	
		var oEditor; 
		if (sMode == 'open')
			oEditor = openEditor(oConfig); 
		else
			oEditor = overlayEditor($this._sSelector, oConfig);
		oEditor.on('process', (res) => {
			$this.uploadFile(res.dest, oEditor, (sMode == 'open'? false : true))
		});
	});
}

BxMediaChanger.prototype.uploadFile = function (oFile, oEditor, bDestroy) {

    var $this = this;
    var $src = $($this._sSelector).find('.bx-media-editable-src');
    
	if (oFile.type.indexOf('image') == -1){
        $src.parent().addClass('bx-media-editable-src-updating');
        $src.parent().attr('data-content', $this._aCaptions['allowed_files']);
        var oAnim = setInterval(function(){
            $src.parent().toggleClass("bx-media-editable-src-updating2");
        }, 500);
         setTimeout(function(){
            $src.parent().removeClass('bx-media-editable-src-updating');
        }, 3000);
        
        return;
    }

	$src.parent().addClass('bx-media-editable-src-updating');

	$src.parent().attr('data-content', $this._aCaptions['please_wait']);
        
	var oAnim = setInterval(function(){
    	$src.parent().toggleClass("bx-media-editable-src-updating2");
 	}, 500);
    
	const formData = new FormData();
    formData.append('file', oFile, oFile.name);
	formData.append('f', oFile, oFile.name);
	formData.append('uo', $this._sUploader);
	formData.append('so', $this._sStorage);
	formData.append('uid', $this._sUniqId);
	formData.append('m', '');
	formData.append('c', $this._iContentId);
	formData.append('p', '0');
	formData.append('a', 'upload');

	const request = new XMLHttpRequest();
	request.open('POST', sUrlRoot + 'storage_uploader.php');
	request.onload = function(res) {
		if (request.status >= 200 && request.status < 300) {
			
			// restore ghosts
			var sUrl = sUrlRoot + 'storage_uploader.php?uo=' + $this._sUploader + '&so=' + $this._sStorage + '&uid=' + $this._sUniqId + '&img_trans=' + $this._sTranscoder + '&a=restore_ghosts&f=json&c=' + $this._iContentId + '&_t=' + (new Date());

			$.getJSON(sUrl, function (aData) {
                if ('object' === typeof(aData) && 'object' === typeof(aData.g)) {
                    if('object' === typeof(aData.g) && 'object' === typeof(aData.o)) 
                        aData = aData.g;
					$.each(aData, function(iFileId, oVars) {
						$this._sImageUrl = oVars.file_url;
                        if ($this._bIsBackground){
							$src.css("backgroundImage", 'url(' + oVars.file_icon + ")");
                            $($this._sSelector).closest('.bx-media-editable').removeClass('h-32').removeClass('lg:h-32').addClass('h-64').addClass('lg:h-80');
                        }
						else{
							$src.attr("src", oVars.file_icon);
                            $src.show();
                            $($this._sSelector).find('.bx-media-editable-src-placeholder').hide();
						}
						
						$src.parent().removeClass('bx-media-editable-src-updating');
						clearInterval(oAnim);
						var sOnclick = $src.parent().attr('onclick');
						if (sOnclick){
							var sOldUrl = sOnclick.substring(
								sOnclick.lastIndexOf("dolPopupImage(") , 
								sOnclick.lastIndexOf("$(this).parent()")
							);
							if (sOldUrl != ''){
								sOnclick= sOnclick.replace(sOldUrl, "dolPopupImage('" + $this._sImageUrl + "', ");
								$src.parent().attr('onclick', sOnclick);
							}
						}
						
						if ($this._bIsInline && oEditor && bDestroy){
							oEditor.destroy()
						}
						var sUrl = $this._sActionUrl + 'UpdateContent/' + $this._sModule + '/' + $this._sFieldName + '/' + $this._iContentId + '/' + oVars.file_id +'/';
						$.getJSON(sUrl, function (aData2) {	});
						window[$this._sObjName].init(); 
					})

				}
				else{
                    $($this._sSelector).find('.bx-media-editable-src-placeholder').hide();
                }
			});

		}
		else {
			error('error');
		}
	};
	request.send(formData);
}