<?php defined('BX_DOL') or die('hack attempt');
/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 *
 * @defgroup    UnaCore UNA Core
 * @{
 */

/**
 * Database queries for embed objects.
 * @see BxDolEmbed
 */
class BxDolEmbedQuery extends BxDolFactoryObjectQuery
{
    protected $_sTableData;

    static public function getObject($sObject)
    {
        return parent::getObjectFromTable($sObject, 'sys_objects_embeds', true);
    }

    static public function getObjects ()
    {
        return parent::getObjectsFromTable('sys_objects_embeds');
    }

    public function setParams($aParams)
    {
        $this->_sTableData = $aParams['table_data'] ?? '';
    }

    public function getLocal ($sUrl, $sTheme)
    {
        return $this->getOne("SELECT `data` FROM `" . $this->_sTableData . "` WHERE `url` = :url AND  `theme` = :theme", [
            'url' => $sUrl, 
            'theme' => $sTheme
        ]);
    }

    public function getLocalUnprocessed ()
    {
        return $this->getAll("SELECT * FROM `" . $this->_sTableData . "` WHERE `data` = ''");
    }

    public function insertLocal ($sUrl, $sTheme, $sData = '')
    {
        return (int)$this->query("INSERT INTO `" . $this->_sTableData . "` (`url`, `theme`, `data`, `added`) VALUES (:url, :theme, :data, :added)", [
            'url' => $sUrl,
            'theme' => $sTheme,
            'data' => $sData,
            'added' => time(),
        ]) > 0 ? $this->lastId() : false;
    }

    public function updateLocal($aParamsSet, $aParamsWhere)
    {
        if(empty($aParamsSet) || empty($aParamsWhere))
            return false;

        return $this->query("UPDATE `{$this->_sTableData}` SET " . $this->arrayToSQL($aParamsSet) . " WHERE " . $this->arrayToSQL($aParamsWhere, " AND "));
    }
}

/** @} */
