<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Marketplace
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Marketplace\V1\InstalledAddOn;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class InstalledAddOnUsageList extends ListResource
    {
    /**
     * Construct the InstalledAddOnUsageList
     *
     * @param Version $version Version that contains the resource
     * @param string $installedAddOnSid Customer Installation SID to report usage on.
     */
    public function __construct(
        Version $version,
        string $installedAddOnSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'installedAddOnSid' =>
            $installedAddOnSid,
        
        ];

        $this->uri = '/InstalledAddOns/' . \rawurlencode($installedAddOnSid)
        .'/Usage';
    }

    /**
     * Helper function for Create
     *
     * @param MarketplaceV1InstalledAddOnInstalledAddOnUsage $marketplaceV1InstalledAddOnInstalledAddOnUsage
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(MarketplaceV1InstalledAddOnInstalledAddOnUsage $marketplaceV1InstalledAddOnInstalledAddOnUsage): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $marketplaceV1InstalledAddOnInstalledAddOnUsage->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the InstalledAddOnUsageInstance
     *
     * @param MarketplaceV1InstalledAddOnInstalledAddOnUsage $marketplaceV1InstalledAddOnInstalledAddOnUsage
     * @return InstalledAddOnUsageInstance Created InstalledAddOnUsageInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(MarketplaceV1InstalledAddOnInstalledAddOnUsage $marketplaceV1InstalledAddOnInstalledAddOnUsage): InstalledAddOnUsageInstance
    {
        $response = $this->_create( $marketplaceV1InstalledAddOnInstalledAddOnUsage);
        return new InstalledAddOnUsageInstance(
            $this->version,
            $response->getContent(),
            $this->solution['installedAddOnSid']
        );
        
    }

    /**
     * Create the InstalledAddOnUsageInstance with Metadata
     *
     * @param MarketplaceV1InstalledAddOnInstalledAddOnUsage $marketplaceV1InstalledAddOnInstalledAddOnUsage
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(MarketplaceV1InstalledAddOnInstalledAddOnUsage $marketplaceV1InstalledAddOnInstalledAddOnUsage): ResourceMetadata
    {
        $response = $this->_create( $marketplaceV1InstalledAddOnInstalledAddOnUsage);
        $resource = new InstalledAddOnUsageInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['installedAddOnSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Marketplace.V1.InstalledAddOnUsageList]';
    }
}
