<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Serverless
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Serverless\V1\Service\Environment;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class DeploymentContext extends InstanceContext
    {
    /**
     * Initialize the DeploymentContext
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The SID of the Service to create the Deployment resource under.
     * @param string $environmentSid The SID of the Environment for the Deployment.
     * @param string $sid The SID that identifies the Deployment resource to fetch.
     */
    public function __construct(
        Version $version,
        $serviceSid,
        $environmentSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        'environmentSid' =>
            $environmentSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Environments/' . \rawurlencode($environmentSid)
        .'/Deployments/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the DeploymentInstance
     *
     * @return DeploymentInstance Fetched DeploymentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): DeploymentInstance
    {
        $response = $this->_fetch();
        return new DeploymentInstance(
            $this->version,
            $response->getContent(),
            $this->solution['serviceSid'],
            $this->solution['environmentSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Fetch the DeploymentInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new DeploymentInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['serviceSid'],
                        $this->solution['environmentSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Serverless.V1.DeploymentContext ' . \implode(' ', $context) . ']';
    }
}
