<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Supersim
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Supersim\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class FleetContext extends InstanceContext
    {
    /**
     * Initialize the FleetContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The SID of the Fleet resource to fetch.
     */
    public function __construct(
        Version $version,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'sid' =>
            $sid,
        ];

        $this->uri = '/Fleets/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the FleetInstance
     *
     * @return FleetInstance Fetched FleetInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): FleetInstance
    {
        $response = $this->_fetch();
        return new FleetInstance(
            $this->version,
            $response->getContent(),
            $this->solution['sid']
        );
        
    }

    /**
     * Fetch the FleetInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new FleetInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'UniqueName' =>
                $options['uniqueName'],
            'NetworkAccessProfile' =>
                $options['networkAccessProfile'],
            'IpCommandsUrl' =>
                $options['ipCommandsUrl'],
            'IpCommandsMethod' =>
                $options['ipCommandsMethod'],
            'SmsCommandsUrl' =>
                $options['smsCommandsUrl'],
            'SmsCommandsMethod' =>
                $options['smsCommandsMethod'],
            'DataLimit' =>
                $options['dataLimit'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the FleetInstance
     *
     * @param array|Options $options Optional Arguments
     * @return FleetInstance Updated FleetInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): FleetInstance
    {
        $response = $this->_update($options);
        return new FleetInstance(
            $this->version,
            $response->getContent(),
            $this->solution['sid']
        );
        
    }

    /**
     * Update the FleetInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new FleetInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Supersim.V1.FleetContext ' . \implode(' ', $context) . ']';
    }
}
