<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class ApproveChallengeList extends ListResource
    {
    /**
     * Construct the ApproveChallengeList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The unique SID identifier of the Service.
     */
    public function __construct(
        Version $version,
        string $serviceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Passkeys/ApproveChallenge';
    }

    /**
     * Helper function for Update
     *
     * @param ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $approvePasskeysChallengeRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the ApproveChallengeInstance
     *
     * @param ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest
     * @return ApproveChallengeInstance Updated ApproveChallengeInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest): ApproveChallengeInstance
    {
        $response = $this->_update( $approvePasskeysChallengeRequest);
        return new ApproveChallengeInstance(
            $this->version,
            $response->getContent(),
            $this->solution['serviceSid']
        );
        
    }

    /**
     * Update the ApproveChallengeInstance with Metadata
     *
     * @param ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(ApprovePasskeysChallengeRequest $approvePasskeysChallengeRequest): ResourceMetadata
    {
        $response = $this->_update( $approvePasskeysChallengeRequest);
        $resource = new ApproveChallengeInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['serviceSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Verify.V2.ApproveChallengeList]';
    }
}
