<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class NewFactorList extends ListResource
    {
    /**
     * Construct the NewFactorList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The unique SID identifier of the Service.
     */
    public function __construct(
        Version $version,
        string $serviceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Passkeys/Factors';
    }

    /**
     * Helper function for Create
     *
     * @param CreateNewPasskeysFactorRequest $createNewPasskeysFactorRequest
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(CreateNewPasskeysFactorRequest $createNewPasskeysFactorRequest): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $createNewPasskeysFactorRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the NewFactorInstance
     *
     * @param CreateNewPasskeysFactorRequest $createNewPasskeysFactorRequest
     * @return NewFactorInstance Created NewFactorInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(CreateNewPasskeysFactorRequest $createNewPasskeysFactorRequest): NewFactorInstance
    {
        $response = $this->_create( $createNewPasskeysFactorRequest);
        return new NewFactorInstance(
            $this->version,
            $response->getContent(),
            $this->solution['serviceSid']
        );
        
    }

    /**
     * Create the NewFactorInstance with Metadata
     *
     * @param CreateNewPasskeysFactorRequest $createNewPasskeysFactorRequest
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(CreateNewPasskeysFactorRequest $createNewPasskeysFactorRequest): ResourceMetadata
    {
        $response = $this->_create( $createNewPasskeysFactorRequest);
        $resource = new NewFactorInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['serviceSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Verify.V2.NewFactorList]';
    }
}
