<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Video
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Video\V1\Room;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class TranscriptionsContext extends InstanceContext
    {
    /**
     * Initialize the TranscriptionsContext
     *
     * @param Version $version Version that contains the resource
     * @param string $roomSid The SID of the room new transcriptions resource to be created.
     * @param string $ttid The Twilio type id of the transcriptions resource to fetch.
     */
    public function __construct(
        Version $version,
        $roomSid,
        $ttid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'roomSid' =>
            $roomSid,
        'ttid' =>
            $ttid,
        ];

        $this->uri = '/Rooms/' . \rawurlencode($roomSid)
        .'/Transcriptions/' . \rawurlencode($ttid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the TranscriptionsInstance
     *
     * @return TranscriptionsInstance Fetched TranscriptionsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): TranscriptionsInstance
    {
        $response = $this->_fetch();
        return new TranscriptionsInstance(
            $this->version,
            $response->getContent(),
            $this->solution['roomSid'],
            $this->solution['ttid']
        );
        
    }

    /**
     * Fetch the TranscriptionsInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new TranscriptionsInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['roomSid'],
                        $this->solution['ttid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'Status' =>
                $options['status'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the TranscriptionsInstance
     *
     * @param array|Options $options Optional Arguments
     * @return TranscriptionsInstance Updated TranscriptionsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): TranscriptionsInstance
    {
        $response = $this->_update($options);
        return new TranscriptionsInstance(
            $this->version,
            $response->getContent(),
            $this->solution['roomSid'],
            $this->solution['ttid']
        );
        
    }

    /**
     * Update the TranscriptionsInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new TranscriptionsInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['roomSid'],
                        $this->solution['ttid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Video.V1.TranscriptionsContext ' . \implode(' ', $context) . ']';
    }
}
