
-- SETTINGS

SET @iTypeOrder = (SELECT MAX(`order`) FROM `sys_options_types` WHERE `group` = 'modules');
INSERT INTO `sys_options_types`(`group`, `name`, `caption`, `icon`, `order`) VALUES 
('modules', 'bx_stream', '_bx_stream', 'bx_stream@modules/boonex/stream/|std-icon.svg', IF(ISNULL(@iTypeOrder), 1, @iTypeOrder + 1));
SET @iTypeId = LAST_INSERT_ID();

INSERT INTO `sys_options_categories` (`type_id`, `name`, `caption`, `order`)
VALUES (@iTypeId, 'bx_stream_streaming', '_bx_stream_options_cat_streaming', 1);
SET @iCategId = LAST_INSERT_ID();

INSERT INTO `sys_options` (`name`, `value`, `category_id`, `caption`, `type`, `check`, `check_error`, `extra`, `order`) VALUES

('bx_stream_engine', 'OvenMediaEngine', @iCategId, '_bx_stream_option_engine', 'select', '', '', 'OvenMediaEngine,NGINX', 10),

('bx_stream_server_host', '', @iCategId, '_bx_stream_option_server_host', 'digit', '', '', '', 20),
('bx_stream_app', '', @iCategId, '_bx_stream_option_app', 'digit', '', '', '', 22),
('bx_stream_sources_pattern', '', @iCategId, '_bx_stream_option_sources_pattern', 'text', '', '', '', 24),
('bx_stream_dash_enabled', '', @iCategId, '_bx_stream_option_dash_enabled', 'checkbox', '', '', '', 26),
('bx_stream_hls_enabled', '', @iCategId, '_bx_stream_option_hls_enabled', 'checkbox', '', '', '', 28),
('bx_stream_recordings_url', '', @iCategId, '_bx_stream_option_recordings_url', 'digit', '', '', '', 30),
('bx_stream_aspect_ratio', '', @iCategId, '_bx_stream_option_aspect_ratio', 'digit', '', '', '', 40);

INSERT INTO `sys_options_categories` (`type_id`, `name`, `caption`, `order`)
VALUES (@iTypeId, 'bx_stream_engine_ome', '_bx_stream_options_cat_engine_ome', 2);
SET @iCategId = LAST_INSERT_ID();

INSERT INTO `sys_options` (`name`, `value`, `category_id`, `caption`, `type`, `check`, `check_error`, `extra`, `order`) VALUES

('bx_stream_server_ome_api_key', '', @iCategId, '_bx_stream_option_ome_api_key', 'digit', '', '', '', 10),
('bx_stream_server_ome_api_protocol', 'http', @iCategId, '_bx_stream_option_ome_api_protocol', 'select', '', '', 'http,https', 12),
('bx_stream_server_ome_api_port', '8081', @iCategId, '_bx_stream_option_ome_api_port', 'digit', '', '', '', 14),
('bx_stream_server_ome_policy_secret', '', @iCategId, '_bx_stream_option_ome_policy_secret', 'digit', '', '', '', 20),
('bx_stream_server_ome_recordings_source', '', @iCategId, '_bx_stream_option_ome_recordings_source', 'digit', '', '', '', 30);

INSERT INTO `sys_options_categories` (`type_id`, `name`, `caption`, `order`)
VALUES (@iTypeId, 'bx_stream_engine_nginx', '_bx_stream_options_cat_engine_nginx', 3);
SET @iCategId = LAST_INSERT_ID();

INSERT INTO `sys_options` (`name`, `value`, `category_id`, `caption`, `type`, `check`, `check_error`, `extra`, `order`) VALUES
('bx_stream_server_nginx_stats_url', 'https://{host}/stat', @iCategId, '_bx_stream_option_nginx_stats_url', 'digit', '', '', '', 10),
('bx_stream_server_nginx_auth', 'on', @iCategId, '_bx_stream_option_nginx_auth', 'checkbox', '', '', '', 12),
('bx_stream_server_nginx_recording_base_path', '', @iCategId, '_bx_stream_option_nginx_recording_base_path', 'digit', '', '', '', 20);

INSERT INTO `sys_options_categories` (`type_id`, `name`, `caption`, `order`)
VALUES (@iTypeId, 'bx_stream_general', '_bx_stream_options_cat_general', 4);
SET @iCategId = LAST_INSERT_ID();

INSERT INTO `sys_options` (`name`, `value`, `category_id`, `caption`, `type`, `check`, `check_error`, `extra`, `order`) VALUES
('bx_stream_enable_auto_approve', 'on', @iCategId, '_bx_stream_option_enable_auto_approve', 'checkbox', '', '', '', 100),
('bx_stream_summary_chars', '700', @iCategId, '_bx_stream_option_summary_chars', 'digit', '', '', '', 110),
('bx_stream_plain_summary_chars', '240', @iCategId, '_bx_stream_option_plain_summary_chars', 'digit', '', '', '', 120),
('bx_stream_per_page_browse', '12', @iCategId, '_bx_stream_option_per_page_browse', 'digit', '', '', '', 130),
('bx_stream_per_page_profile', '6', @iCategId, '_bx_stream_option_per_page_profile', 'digit', '', '', '', 140),
('bx_stream_per_page_browse_showcase', '32', @iCategId, '_sys_option_per_page_browse_showcase', 'digit', '', '', '', 150),
('bx_stream_rss_num', '10', @iCategId, '_bx_stream_option_rss_num', 'digit', '', '', '', 20),
('bx_stream_auto_activation_for_categories', 'on', @iCategId, '_bx_stream_option_auto_activation_for_categories', 'checkbox', '', '', '', 160),
('bx_stream_always_accessible', '', @iCategId, '_bx_stream_option_always_accessible', 'checkbox', '', '', '', 170),
('bx_stream_mute', '', @iCategId, '_bx_stream_option_mute', 'checkbox', '', '', '', 180),
('bx_stream_mute_embed', '', @iCategId, '_bx_stream_option_mute_embed', 'checkbox', '', '', '', 182);

-- PAGE: create entry

INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_create_entry', '_bx_stream_page_title_sys_create_entry', '_bx_stream_page_title_create_entry', 'bx_stream', 5, 2147483647, 1, 'create-stream', 'page.php?i=create-stream', '', '', '', 0, 1, 0, 'BxStrmPageBrowse', 'modules/boonex/stream/classes/BxStrmPageBrowse.php');

INSERT INTO `sys_pages_blocks` (`object`, `cell_id`, `module`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES
('bx_stream_create_entry', 1, 'bx_stream', '_bx_stream_page_block_title_create_entry', 11, 2147483647, 'service', 'a:2:{s:6:"module";s:9:"bx_stream";s:6:"method";s:13:"entity_create";}', 0, 1, 1);


-- PAGE: edit entry

INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_edit_entry', '_bx_stream_page_title_sys_edit_entry', '_bx_stream_page_title_edit_entry', 'bx_stream', 5, 2147483647, 1, 'edit-stream', '', '', '', '', 0, 1, 0, 'BxStrmPageEntry', 'modules/boonex/stream/classes/BxStrmPageEntry.php');

INSERT INTO `sys_pages_blocks` (`object`, `cell_id`, `module`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES
('bx_stream_edit_entry', 1, 'bx_stream', '_bx_stream_page_block_title_edit_entry', 11, 2147483647, 'service', 'a:2:{s:6:"module";s:9:"bx_stream";s:6:"method";s:11:"entity_edit";}', 0, 0, 0);


-- PAGE: delete entry

INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_delete_entry', '_bx_stream_page_title_sys_delete_entry', '_bx_stream_page_title_delete_entry', 'bx_stream', 5, 2147483647, 1, 'delete-stream', '', '', '', '', 0, 1, 0, 'BxStrmPageEntry', 'modules/boonex/stream/classes/BxStrmPageEntry.php');

INSERT INTO `sys_pages_blocks` (`object`, `cell_id`, `module`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES
('bx_stream_delete_entry', 1, 'bx_stream', '_bx_stream_page_block_title_delete_entry', 11, 2147483647, 'service', 'a:2:{s:6:"module";s:9:"bx_stream";s:6:"method";s:13:"entity_delete";}', 0, 0, 0);


-- PAGE: view entry

INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_view_entry', '_bx_stream_page_title_sys_view_entry', '_bx_stream_page_title_view_entry', 'bx_stream', 12, 2147483647, 1, 'view-stream', '', '', '', '', 0, 1, 0, 'BxStrmPageEntry', 'modules/boonex/stream/classes/BxStrmPageEntry.php');

INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title_system`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `active`, `order`) VALUES 
('bx_stream_view_entry', 1, 'bx_stream', '', '_bx_stream_page_block_title_viewers', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:14:\"stream_viewers\";}', 0, 0, 1, 1),
('bx_stream_view_entry', 1, 'bx_stream', '', '_bx_stream_page_block_title_player', 3, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:13:\"stream_player\";}', 0, 0, 1, 2),
('bx_stream_view_entry', 2, 'bx_stream', '', '_bx_stream_page_block_title_entry_text', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:17:\"entity_text_block\";}', 0, 0, 1, 2),
('bx_stream_view_entry', 3, 'bx_stream', '_bx_stream_page_block_title_sys_entry_context', '_bx_stream_page_block_title_entry_context', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:14:\"entity_context\";}', 0, 0, 1, 1),
('bx_stream_view_entry', 3, 'bx_stream', '', '_bx_stream_page_block_title_entry_info', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:11:\"entity_info\";}', 0, 0, 1, 2),
('bx_stream_view_entry', 3, 'bx_stream', '', '_bx_stream_page_block_title_entry_author', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:13:\"entity_author\";}', 0, 0, 1, 3),
('bx_stream_view_entry', 3, 'bx_stream', '', '_bx_stream_page_block_title_entry_rtmp_settings', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:20:\"stream_rtmp_settings\";}', 0, 0, 1, 4),
('bx_stream_view_entry', 3, 'bx_stream', '', '_bx_stream_page_block_title_entry_recordings', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:17:\"stream_recordings\";}', 0, 0, 1, 5),
('bx_stream_view_entry', 3, 'bx_stream', '', '_bx_stream_page_block_title_entry_location', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:15:\"entity_location\";}', 0, 0, 0, 0),
('bx_stream_view_entry', 2, 'bx_stream', '', '_bx_stream_page_block_title_entry_all_actions', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:18:\"entity_all_actions\";}', 0, 0, 1, 3),
('bx_stream_view_entry', 4, 'bx_stream', '', '_bx_stream_page_block_title_entry_actions', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:14:\"entity_actions\";}', 0, 0, 0, 0),
('bx_stream_view_entry', 4, 'bx_stream', '', '_bx_stream_page_block_title_entry_social_sharing', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:21:\"entity_social_sharing\";}', 0, 0, 0, 0),
('bx_stream_view_entry', 2, 'bx_stream', '', '_bx_stream_page_block_title_entry_comments', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:15:\"entity_comments\";}', 0, 0, 1, 6),
('bx_stream_view_entry', 3, 'bx_stream', '', '_bx_stream_page_block_title_entry_location', 3, 2147483647, 'service', 'a:4:{s:6:\"module\";s:6:\"system\";s:6:\"method\";s:13:\"locations_map\";s:6:\"params\";a:2:{i:0;s:9:\"bx_stream\";i:1;s:4:\"{id}\";}s:5:\"class\";s:20:\"TemplServiceMetatags\";}', 0, 0, 1, 3),
('bx_stream_view_entry', 2, 'bx_stream', '', '_bx_stream_page_block_title_entry_reports', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:14:\"entity_reports\";}', 0, 0, 1, 6);


-- PAGE: broadcast

INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_broadcast', '', '_bx_stream_page_title_broadcast', 'bx_stream', 5, 2147483647, 1, 'broadcast-stream', '', '', '', '', 0, 1, 0, 'BxStrmPageEntry', 'modules/boonex/stream/classes/BxStrmPageEntry.php');

INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title_system`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `active`, `order`) VALUES 
('bx_stream_broadcast', 1, 'bx_stream', '', '_bx_stream_page_block_title_viewers', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:14:\"stream_viewers\";}', 0, 0, 1, 1),
('bx_stream_broadcast', 1, 'bx_stream', '', '_bx_stream_page_block_title_broadcast', 13, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:16:\"stream_broadcast\";}', 0, 0, 1, 2);

-- PAGE: view entry comments

INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_view_entry_comments', '_bx_stream_page_title_sys_view_entry_comments', '_bx_stream_page_title_view_entry_comments', 'bx_stream', 5, 2147483647, 1, 'view-stream-comments', '', '', '', '', 0, 1, 0, 'BxStrmPageEntry', 'modules/boonex/stream/classes/BxStrmPageEntry.php');

INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title_system`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES 
('bx_stream_view_entry_comments', 1, 'bx_stream', '_bx_stream_page_block_title_entry_comments', '_bx_stream_page_block_title_entry_comments_link', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:15:\"entity_comments\";}', 0, 0, 1);


-- PAGE: module manage own
INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_manage', '_bx_stream_page_title_sys_manage', '_bx_stream_page_title_manage', 'bx_stream', 5, 2147483647, 1, 'streams-manage', 'page.php?i=streams-manage', '', '', '', 0, 1, 0, 'BxStrmPageBrowse', 'modules/boonex/stream/classes/BxStrmPageBrowse.php');

INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title_system`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES 
('bx_stream_manage', 1, 'bx_stream', '_bx_stream_page_block_title_system_manage', '_bx_stream_page_block_title_manage', 11, 2147483647, 'service', 'a:2:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:12:\"manage_tools\";}}', 0, 1, 0);

-- PAGE: module manage all
INSERT INTO `sys_objects_page`(`object`, `title_system`, `title`, `module`, `layout_id`, `visible_for_levels`, `visible_for_levels_editable`, `uri`, `url`, `meta_description`, `meta_keywords`, `meta_robots`, `cache_lifetime`, `cache_editable`, `deletable`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_administration', '_bx_stream_page_title_sys_manage_administration', '_bx_stream_page_title_manage', 'bx_stream', 5, 192, 1, 'streams-administration', 'page.php?i=streams-administration', '', '', '', 0, 1, 0, 'BxStrmPageBrowse', 'modules/boonex/stream/classes/BxStrmPageBrowse.php');

INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title_system`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES 
('bx_stream_administration', 1, 'bx_stream', '_bx_stream_page_block_title_system_manage_administration', '_bx_stream_page_block_title_manage', 11, 192, 'service', 'a:3:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:12:\"manage_tools\";s:6:\"params\";a:1:{i:0;s:14:\"administration\";}}', 0, 1, 0);

-- PAGE: add block to homepage

SET @iBlockOrder = (SELECT `order` FROM `sys_pages_blocks` WHERE `object` = 'sys_home' AND `cell_id` = 1 ORDER BY `order` DESC LIMIT 1);
INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `active`, `order`) VALUES 
('sys_home', 1, 'bx_stream', '_bx_stream_page_block_title_recent_entries', 11, 2147483647, 'service', 'a:3:{s:6:"module";s:9:"bx_stream";s:6:"method";s:13:"browse_public";s:6:"params";a:2:{i:0;b:0;i:1;b:0;}}', 1, 0, 0, IFNULL(@iBlockOrder, 0) + 1);

-- PAGES: add page block to profiles modules (trigger* page objects are processed separately upon modules enable/disable)
SET @iPBCellProfile = 3;
SET @iPBCellGroup = 3;
INSERT INTO `sys_pages_blocks` (`object`, `cell_id`, `module`, `title_system`, `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `active`, `order`) VALUES
('trigger_page_profile_view_entry', @iPBCellProfile, 'bx_stream', '_bx_stream_page_block_title_sys_my_entries', '_bx_stream_page_block_title_my_entries', 11, 2147483647, 'service', 'a:3:{s:6:"module";s:9:"bx_stream";s:6:"method";s:13:"browse_author";s:6:"params";a:2:{i:0;s:12:"{profile_id}";i:1;a:2:{s:8:"per_page";s:26:"bx_stream_per_page_profile";s:13:"empty_message";b:0;}}}', 0, 0, 0, 0),
('trigger_page_group_view_entry', @iPBCellGroup, 'bx_stream', '_bx_stream_page_block_title_sys_entries_in_context', '_bx_stream_page_block_title_entries_in_context', 11, 2147483647, 'service', 'a:3:{s:6:"module";s:9:"bx_stream";s:6:"method";s:14:"browse_context";s:6:"params";a:2:{s:10:"profile_id";s:12:"{profile_id}";i:0;a:1:{s:13:"empty_message";b:0;}}}', 0, 0, 0, 0);


-- PAGE: service blocks

SET @iBlockOrder = (SELECT `order` FROM `sys_pages_blocks` WHERE `object` = '' AND `cell_id` = 0 ORDER BY `order` DESC LIMIT 1);
INSERT INTO `sys_pages_blocks`(`object`, `cell_id`, `module`, `title_system` , `title`, `designbox_id`, `visible_for_levels`, `type`, `content`, `deletable`, `copyable`, `order`) VALUES 
('', 0, 'bx_stream', '', '_bx_stream_page_block_title_recent_entries', 11, 2147483647, 'service', 'a:3:{s:6:\"module\";s:9:\"bx_stream\";s:6:\"method\";s:13:\"browse_public\";s:6:\"params\";a:3:{s:9:\"unit_view\";s:7:\"gallery\";s:13:\"empty_message\";b:1;s:13:\"ajax_paginate\";b:0;}}', 0, 1, IFNULL(@iBlockOrder, 0) + 1);

-- MENU: add to "add content" menu

SET @iAddMenuOrder = (SELECT `order` FROM `sys_menu_items` WHERE `set_name` = 'sys_add_content_links' AND `active` = 1 ORDER BY `order` DESC LIMIT 1);
INSERT INTO `sys_menu_items` (`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `submenu_object`, `visible_for_levels`, `active`, `copyable`, `order`) VALUES 
('sys_add_content_links', 'bx_stream', 'create-stream', '_bx_stream_menu_item_title_system_create_entry', '_bx_stream_menu_item_title_create_entry', 'page.php?i=create-stream', '', '', 'rss', '', 2147483647, 1, 1, IFNULL(@iAddMenuOrder, 0) + 1);

-- MENU: actions menu for view entry 

INSERT INTO `sys_objects_menu`(`object`, `title`, `set_name`, `module`, `template_id`, `deletable`, `active`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_view', '_bx_stream_menu_title_view_entry', 'bx_stream_view', 'bx_stream', 9, 0, 1, 'BxStrmMenuView', 'modules/boonex/stream/classes/BxStrmMenuView.php');

INSERT INTO `sys_menu_sets`(`set_name`, `module`, `title`, `deletable`) VALUES 
('bx_stream_view', 'bx_stream', '_bx_stream_menu_set_title_view_entry', 0);

INSERT INTO `sys_menu_items`(`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `submenu_object`, `visible_for_levels`, `active`, `copyable`, `order`) VALUES 
('bx_stream_view', 'bx_stream', 'edit-stream', '_bx_stream_menu_item_title_system_edit_entry', '_bx_stream_menu_item_title_edit_entry', 'page.php?i=edit-stream&id={content_id}', '', '', 'pencil-alt', '', 2147483647, 1, 0, 1),
('bx_stream_view', 'bx_stream', 'delete-stream', '_bx_stream_menu_item_title_system_delete_entry', '_bx_stream_menu_item_title_delete_entry', 'page.php?i=delete-stream&id={content_id}', '', '', 'remove', '', 2147483647, 1, 0, 2),
('bx_stream_view', 'bx_stream', 'approve', '_sys_menu_item_title_system_va_approve', '_sys_menu_item_title_va_approve', 'javascript:void(0)', 'javascript:bx_approve(this, ''{module_uri}'', {content_id});', '', 'check', '', 2147483647, 1, 0, 3);


-- MENU: all actions menu for view entry 

INSERT INTO `sys_objects_menu`(`object`, `title`, `set_name`, `module`, `template_id`, `deletable`, `active`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_view_actions', '_sys_menu_title_view_actions', 'bx_stream_view_actions', 'bx_stream', 15, 0, 1, 'BxStrmMenuViewActions', 'modules/boonex/stream/classes/BxStrmMenuViewActions.php');

INSERT INTO `sys_menu_sets`(`set_name`, `module`, `title`, `deletable`) VALUES 
('bx_stream_view_actions', 'bx_stream', '_sys_menu_set_title_view_actions', 0);

INSERT INTO `sys_menu_items`(`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `addon`, `submenu_object`, `submenu_popup`, `visible_for_levels`, `visibility_custom`, `active`, `copyable`, `order`) VALUES 
('bx_stream_view_actions', 'bx_stream', 'edit-stream', '_bx_stream_menu_item_title_system_edit_entry', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 10),
('bx_stream_view_actions', 'bx_stream', 'delete-stream', '_bx_stream_menu_item_title_system_delete_entry', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 20),
('bx_stream_view_actions', 'bx_stream', 'approve', '_sys_menu_item_title_system_va_approve', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 30),
('bx_stream_view_actions', 'bx_stream', 'set-badges', '_sys_menu_item_title_system_set_badges', '_sys_menu_item_title_set_badges', 'javascript:void(0)', 'bx_menu_popup(''sys_set_badges'', window, {}, {module: ''bx_stream'', content_id: {content_id}});', '', 'check-circle', '', '', 0, 2147483647, 'a:2:{s:6:"module";s:9:"bx_stream";s:6:"method";s:19:"is_badges_avaliable";}', 1, 0, 40),
('bx_stream_view_actions', 'bx_stream', 'comment', '_sys_menu_item_title_system_va_comment', '', '', '', '', '', '', '', 0, 2147483647, '', 0, 0, 200),
('bx_stream_view_actions', 'bx_stream', 'view', '_sys_menu_item_title_system_va_view', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 210),
('bx_stream_view_actions', 'bx_stream', 'vote', '_sys_menu_item_title_system_va_vote', '', '', '', '', '', '', '', 0, 2147483647, '', 0, 0, 220),
('bx_stream_view_actions', 'bx_stream', 'reaction', '_sys_menu_item_title_system_va_reaction', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 225),
('bx_stream_view_actions', 'bx_stream', 'score', '_sys_menu_item_title_system_va_score', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 230),
('bx_stream_view_actions', 'bx_stream', 'feature', '_sys_menu_item_title_system_va_feature', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 250),
('bx_stream_view_actions', 'bx_stream', 'repost', '_sys_menu_item_title_system_va_repost', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 260),
('bx_stream_view_actions', 'bx_stream', 'report', '_sys_menu_item_title_system_va_report', '', '', '', '', '', '', '', 0, 2147483647, '', 1, 0, 270),
('bx_stream_view_actions', 'bx_stream', 'notes', '_sys_menu_item_title_system_va_notes', '_sys_menu_item_title_va_notes', 'javascript:void(0)', 'javascript:bx_get_notes(this,  ''{module_uri}'', {content_id});', '', 'exclamation-triangle', '', '', 0, 2147483647, '', 1, 0, 280),
('bx_stream_view_actions', 'bx_stream', 'audit', '_sys_menu_item_title_system_va_audit', '_sys_menu_item_title_va_audit', 'page.php?i=dashboard-audit&module=bx_stream&content_id={content_id}', '', '', 'history', '', '', 0, 192, '', 1, 0, 290),
('bx_stream_view_actions', 'bx_stream', 'social-sharing', '_sys_menu_item_title_system_social_sharing', '_sys_menu_item_title_social_sharing', 'javascript:void(0)', 'oBxDolPage.share(this, \'{url_encoded}\')', '', 'share', '', '', 0, 2147483647, '', 1, 0, 300),
('bx_stream_view_actions', 'bx_stream', 'more-auto', '_sys_menu_item_title_system_va_more_auto', '_sys_menu_item_title_va_more_auto', 'javascript:void(0)', '', '', 'ellipsis-v', '', '', 0, 2147483647, '', 1, 0, 9999);


-- MENU: custom menu for snippet meta info
INSERT INTO `sys_objects_menu`(`object`, `title`, `set_name`, `module`, `template_id`, `deletable`, `active`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_snippet_meta', '_sys_menu_title_snippet_meta', 'bx_stream_snippet_meta', 'bx_stream', 15, 0, 1, 'BxStrmMenuSnippetMeta', 'modules/boonex/stream/classes/BxStrmMenuSnippetMeta.php');

INSERT INTO `sys_menu_sets`(`set_name`, `module`, `title`, `deletable`) VALUES 
('bx_stream_snippet_meta', 'bx_stream', '_sys_menu_set_title_snippet_meta', 0);

INSERT INTO `sys_menu_items`(`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `submenu_object`, `visible_for_levels`, `active`, `copyable`, `editable`, `order`) VALUES 
('bx_stream_snippet_meta', 'bx_stream', 'date', '_sys_menu_item_title_system_sm_date', '_sys_menu_item_title_sm_date', '', '', '', '', '', 2147483647, 1, 0, 1, 1),
('bx_stream_snippet_meta', 'bx_stream', 'author', '_sys_menu_item_title_system_sm_author', '_sys_menu_item_title_sm_author', '', '', '', '', '', 2147483647, 1, 0, 1, 2),
('bx_stream_snippet_meta', 'bx_stream', 'category', '_sys_menu_item_title_system_sm_category', '_sys_menu_item_title_sm_category', '', '', '', '', '', 2147483647, 0, 0, 1, 3),
('bx_stream_snippet_meta', 'bx_stream', 'tags', '_sys_menu_item_title_system_sm_tags', '_sys_menu_item_title_sm_tags', '', '', '', '', '', 2147483647, 0, 0, 1, 4),
('bx_stream_snippet_meta', 'bx_stream', 'views', '_sys_menu_item_title_system_sm_views', '_sys_menu_item_title_sm_views', '', '', '', '', '', 2147483647, 0, 0, 1, 5),
('bx_stream_snippet_meta', 'bx_stream', 'comments', '_sys_menu_item_title_system_sm_comments', '_sys_menu_item_title_sm_comments', '', '', '', '', '', 2147483647, 0, 0, 1, 6);

-- MENU: profile stats
SET @iNotifMenuOrder = (SELECT IFNULL(MAX(`order`), 0) FROM `sys_menu_items` WHERE `set_name` = 'sys_profile_stats' AND `active` = 1 LIMIT 1);
INSERT INTO `sys_menu_items` (`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `addon`, `submenu_object`, `visible_for_levels`, `active`, `copyable`, `order`) VALUES
('sys_profile_stats', 'bx_stream', 'profile-stats-manage-streams', '_bx_stream_menu_item_title_system_manage_my_stream', '_bx_stream_menu_item_title_manage_my_stream', 'page.php?i=streams-manage', '', '_self', 'rss', 'a:2:{s:6:"module";s:9:"bx_stream";s:6:"method";s:41:"get_menu_addon_manage_tools_profile_stats";}', '', 2147483646, 1, 0, @iNotifMenuOrder + 1);

-- MENU: manage tools submenu
INSERT INTO `sys_objects_menu`(`object`, `title`, `set_name`, `module`, `template_id`, `deletable`, `active`, `override_class_name`, `override_class_file`) VALUES 
('bx_stream_menu_manage_tools', '_bx_stream_menu_title_manage_tools', 'bx_stream_menu_manage_tools', 'bx_stream', 6, 0, 1, 'BxStrmMenuManageTools', 'modules/boonex/stream/classes/BxStrmMenuManageTools.php');

INSERT INTO `sys_menu_sets`(`set_name`, `module`, `title`, `deletable`) VALUES 
('bx_stream_menu_manage_tools', 'bx_stream', '_bx_stream_menu_set_title_manage_tools', 0);

--INSERT INTO `sys_menu_items`(`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `submenu_object`, `visible_for_levels`, `active`, `copyable`, `order`) VALUES 
--('bx_stream_menu_manage_tools', 'bx_stream', 'delete-with-content', '_bx_stream_menu_item_title_system_delete_with_content', '_bx_stream_menu_item_title_delete_with_content', 'javascript:void(0)', 'javascript:{js_object}.onClickDeleteWithContent({content_id});', '_self', 'far trash-alt', '', 128, 1, 0, 0);

-- MENU: dashboard manage tools
SET @iManageMenuOrder = (SELECT IFNULL(MAX(`order`), 0) FROM `sys_menu_items` WHERE `set_name`='sys_account_dashboard_manage_tools' LIMIT 1);
INSERT INTO `sys_menu_items`(`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `addon`, `submenu_object`, `visible_for_levels`, `active`, `copyable`, `order`) VALUES 
('sys_account_dashboard_manage_tools', 'bx_stream', 'streams-administration', '_bx_stream_menu_item_title_system_admt_stream', '_bx_stream_menu_item_title_admt_stream', 'page.php?i=streams-administration', '', '_self', 'rss', 'a:2:{s:6:"module";s:8:"bx_stream";s:6:"method";s:27:"get_menu_addon_manage_tools";}', '', 192, 1, 0, @iManageMenuOrder + 1);


-- PRIVACY 

INSERT INTO `sys_objects_privacy` (`object`, `module`, `action`, `title`, `default_group`, `table`, `table_field_id`, `table_field_author`, `override_class_name`, `override_class_file`) VALUES
('bx_stream_allow_view_to', 'bx_stream', 'view', '_bx_stream_form_entry_input_allow_view_to', '3', 'bx_stream_streams', 'id', 'author', '', '');

-- ACL

INSERT INTO `sys_acl_actions` (`Module`, `Name`, `AdditionalParamName`, `Title`, `Desc`, `Countable`, `DisabledForLevels`) VALUES
('bx_stream', 'create entry', NULL, '_bx_stream_acl_action_create_entry', '', 1, 3);
SET @iIdActionEntryCreate = LAST_INSERT_ID();

INSERT INTO `sys_acl_actions` (`Module`, `Name`, `AdditionalParamName`, `Title`, `Desc`, `Countable`, `DisabledForLevels`) VALUES
('bx_stream', 'record', NULL, '_bx_stream_acl_action_record', '', 1, 3);
SET @iIdActionRecord = LAST_INSERT_ID();

INSERT INTO `sys_acl_actions` (`Module`, `Name`, `AdditionalParamName`, `Title`, `Desc`, `Countable`, `DisabledForLevels`) VALUES
('bx_stream', 'delete entry', NULL, '_bx_stream_acl_action_delete_entry', '', 1, 3);
SET @iIdActionEntryDelete = LAST_INSERT_ID();

INSERT INTO `sys_acl_actions` (`Module`, `Name`, `AdditionalParamName`, `Title`, `Desc`, `Countable`, `DisabledForLevels`) VALUES
('bx_stream', 'view entry', NULL, '_bx_stream_acl_action_view_entry', '', 1, 0);
SET @iIdActionEntryView = LAST_INSERT_ID();

INSERT INTO `sys_acl_actions` (`Module`, `Name`, `AdditionalParamName`, `Title`, `Desc`, `Countable`, `DisabledForLevels`) VALUES
('bx_stream', 'edit any entry', NULL, '_bx_stream_acl_action_edit_any_entry', '', 1, 3);
SET @iIdActionEntryEditAny = LAST_INSERT_ID();

INSERT INTO `sys_acl_actions` (`Module`, `Name`, `AdditionalParamName`, `Title`, `Desc`, `Countable`, `DisabledForLevels`) VALUES
('bx_stream', 'delete any entry', NULL, '_bx_stream_acl_action_delete_any_entry', '', 1, 3);
SET @iIdActionEntryDeleteAny = LAST_INSERT_ID();

SET @iUnauthenticated = 1;
SET @iAccount = 2;
SET @iStandard = 3;
SET @iUnconfirmed = 4;
SET @iPending = 5;
SET @iSuspended = 6;
SET @iModerator = 7;
SET @iAdministrator = 8;
SET @iPremium = 9;

INSERT INTO `sys_acl_matrix` (`IDLevel`, `IDAction`) VALUES

-- entry create
(@iModerator, @iIdActionEntryCreate),
(@iAdministrator, @iIdActionEntryCreate),
(@iPremium, @iIdActionEntryCreate),

-- entry delete
(@iModerator, @iIdActionEntryDelete),
(@iAdministrator, @iIdActionEntryDelete),
(@iPremium, @iIdActionEntryDelete),

-- entry view
(@iUnauthenticated, @iIdActionEntryView),
(@iAccount, @iIdActionEntryView),
(@iStandard, @iIdActionEntryView),
(@iUnconfirmed, @iIdActionEntryView),
(@iPending, @iIdActionEntryView),
(@iModerator, @iIdActionEntryView),
(@iAdministrator, @iIdActionEntryView),
(@iPremium, @iIdActionEntryView),

-- edit any entry
(@iModerator, @iIdActionEntryEditAny),
(@iAdministrator, @iIdActionEntryEditAny),

-- delete any entry
(@iAdministrator, @iIdActionEntryDeleteAny);

-- METATAGS
INSERT INTO `sys_objects_metatags` (`object`, `module`, `table_keywords`, `table_locations`, `table_mentions`, `override_class_name`, `override_class_file`) VALUES
('bx_stream', 'bx_stream', 'bx_stream_meta_keywords', 'bx_stream_meta_locations', 'bx_stream_meta_mentions', '', '');

-- CATEGORY
INSERT INTO `sys_objects_category` (`object`, `module`, `search_object`, `form_object`, `list_name`, `table`, `field`, `join`, `where`, `override_class_name`, `override_class_file`) VALUES
('bx_stream_cats', 'bx_stream', '', 'bx_stream', 'bx_stream_cats', 'bx_stream_streams', 'cat', 'INNER JOIN `sys_profiles` ON (`sys_profiles`.`id` = ABS(`bx_stream_streams`.`author`))', 'AND `sys_profiles`.`status` = ''active''', '', '');

-- STATS
SET @iMaxOrderStats = (SELECT IFNULL(MAX(`order`), 0) FROM `sys_statistics`);
INSERT INTO `sys_statistics` (`module`, `name`, `title`, `link`, `icon`, `query`, `order`) VALUES 
('bx_stream', 'bx_stream', '_bx_stream', 'page.php?i=streams-home', 'rss', 'SELECT COUNT(*) FROM `bx_stream_streams` WHERE 1 AND `status` = ''active'' AND `status_admin` = ''active''', @iMaxOrderStats + 1);

-- CHARTS
SET @iMaxOrderCharts = (SELECT IFNULL(MAX(`order`), 0) FROM `sys_objects_chart`);
INSERT INTO `sys_objects_chart` (`object`, `title`, `table`, `field_date_ts`, `field_date_dt`, `field_status`, `query`, `active`, `order`, `class_name`, `class_file`) VALUES
('bx_stream_growth', '_bx_stream_chart_growth', 'bx_stream_streams', 'added', '', 'status,status_admin', '', 1, @iMaxOrderCharts + 1, 'BxDolChartGrowth', ''),
('bx_stream_growth_speed', '_bx_stream_chart_growth_speed', 'bx_stream_streams', 'added', '', 'status,status_admin', '', 1, @iMaxOrderCharts + 2, 'BxDolChartGrowthSpeed', '');

-- GRIDS: moderation tools
INSERT INTO `sys_objects_grid` (`object`, `source_type`, `source`, `table`, `field_id`, `field_order`, `field_active`, `paginate_url`, `paginate_per_page`, `paginate_simple`, `paginate_get_start`, `paginate_get_per_page`, `filter_fields`, `filter_fields_translatable`, `filter_mode`, `sorting_fields`, `sorting_fields_translatable`, `visible_for_levels`, `override_class_name`, `override_class_file`) VALUES
('bx_stream_administration', 'Sql', 'SELECT * FROM `bx_stream_streams` WHERE 1 ', 'bx_stream_streams', 'id', 'added', 'status_admin', '', 20, NULL, 'start', '', 'title,text', '', 'like', 'reports', '', 192, 'BxStrmGridAdministration', 'modules/boonex/stream/classes/BxStrmGridAdministration.php'),
('bx_stream_common', 'Sql', 'SELECT * FROM `bx_stream_streams` WHERE 1 ', 'bx_stream_streams', 'id', 'added', 'status', '', 20, NULL, 'start', '', 'title,text', '', 'like', '', '', 2147483647, 'BxStrmGridCommon', 'modules/boonex/stream/classes/BxStrmGridCommon.php');

INSERT INTO `sys_grid_fields` (`object`, `name`, `title`, `width`, `translatable`, `chars_limit`, `params`, `order`) VALUES
('bx_stream_administration', 'checkbox', '_sys_select', '2%', 0, '', '', 1),
('bx_stream_administration', 'switcher', '_bx_stream_grid_column_title_adm_active', '8%', 0, '', '', 2),
('bx_stream_administration', 'reports', '_sys_txt_reports_title', '5%', 0, '', '', 3),
('bx_stream_administration', 'title', '_bx_stream_grid_column_title_adm_title', '25%', 0, '25', '', 4),
('bx_stream_administration', 'added', '_bx_stream_grid_column_title_adm_added', '20%', 1, '25', '', 5),
('bx_stream_administration', 'author', '_bx_stream_grid_column_title_adm_author', '20%', 0, '25', '', 6),
('bx_stream_administration', 'actions', '', '20%', 0, '', '', 7),

('bx_stream_common', 'checkbox', '_sys_select', '2%', 0, '', '', 1),
('bx_stream_common', 'switcher', '_bx_stream_grid_column_title_adm_active', '8%', 0, '', '', 2),
('bx_stream_common', 'title', '_bx_stream_grid_column_title_adm_title', '40%', 0, '35', '', 3),
('bx_stream_common', 'added', '_bx_stream_grid_column_title_adm_added', '15%', 1, '25', '', 4),
('bx_stream_common', 'status_admin', '_bx_stream_grid_column_title_adm_status_admin', '15%', 0, '16', '', 5),
('bx_stream_common', 'actions', '', '20%', 0, '', '', 6);


INSERT INTO `sys_grid_actions` (`object`, `type`, `name`, `title`, `icon`, `icon_only`, `confirm`, `order`) VALUES
('bx_stream_administration', 'bulk', 'delete', '_bx_stream_grid_action_title_adm_delete', '', 0, 1, 1),
('bx_stream_administration', 'bulk', 'clear_reports', '_bx_stream_grid_action_title_adm_clear_reports', '', 0, 1, 1),
('bx_stream_administration', 'single', 'edit', '_bx_stream_grid_action_title_adm_edit', 'pencil-alt', 1, 0, 1),
('bx_stream_administration', 'single', 'delete', '_bx_stream_grid_action_title_adm_delete', 'remove', 1, 1, 2),
('bx_stream_administration', 'single', 'settings', '_bx_stream_grid_action_title_adm_more_actions', 'cog', 1, 0, 3),
('bx_stream_administration', 'single', 'audit_content', '_bx_stream_grid_action_title_adm_audit_content', 'search', 1, 0, 4),
('bx_stream_administration', 'single', 'clear_reports', '_bx_stream_grid_action_title_adm_clear_reports', 'eraser', 1, 0, 5),

('bx_stream_common', 'bulk', 'delete', '_bx_stream_grid_action_title_adm_delete', '', 0, 1, 1),
('bx_stream_common', 'single', 'edit', '_bx_stream_grid_action_title_adm_edit', 'pencil-alt', 1, 0, 1),
('bx_stream_common', 'single', 'delete', '_bx_stream_grid_action_title_adm_delete', 'remove', 1, 1, 2),
('bx_stream_common', 'single', 'settings', '_bx_stream_grid_action_title_adm_more_actions', 'cog', 1, 0, 3);

-- GRIDS: recordings
INSERT INTO `sys_objects_grid` (`object`, `source_type`, `source`, `table`, `field_id`, `field_order`, `field_active`, `paginate_url`, `paginate_per_page`, `paginate_simple`, `paginate_get_start`, `paginate_get_per_page`, `filter_fields`, `filter_fields_translatable`, `filter_mode`, `sorting_fields`, `sorting_fields_translatable`, `visible_for_levels`, `show_total_count`, `override_class_name`, `override_class_file`) VALUES
('bx_stream_recordings', 'Sql', 'SELECT `bx_stream_recordings`.* FROM `bx_stream_recordings` INNER JOIN `sys_storage_ghosts` USING (`id`) WHERE `sys_storage_ghosts`.`object` = "bx_stream_recordings"', 'bx_stream_recordings', 'id', 'added', '', '', 16, NULL, 'start', '', '', '', 'auto', 'size,added', '', 2147483647, 0, 'BxStrmGridRecordings', 'modules/boonex/stream/classes/BxStrmGridRecordings.php');

INSERT INTO `sys_grid_fields` (`object`, `name`, `title`, `width`, `translatable`, `chars_limit`, `params`, `order`) VALUES
('bx_stream_recordings', 'size', '_bx_stream_field_size', '20%', 0, 0, '', 1),
('bx_stream_recordings', 'added', '_bx_stream_field_added', '20%', 0, 0, '', 2),
('bx_stream_recordings', 'actions', '_sys_actions', '60%', 0, 0, '', 3);

INSERT INTO `sys_grid_actions` (`object`, `type`, `name`, `title`, `icon`, `icon_only`, `confirm`, `order`) VALUES
('bx_stream_recordings', 'single', 'download', '_bx_stream_grid_action_download', 'download', 1, 0, 1),
('bx_stream_recordings', 'single', 'publish', '_bx_stream_grid_action_publish', 'upload', 1, 1, 2),
('bx_stream_recordings', 'single', 'delete', '_Delete', 'remove',  1, 1, 3);

-- UPLOADERS

INSERT INTO `sys_objects_uploader` (`object`, `active`, `override_class_name`, `override_class_file`) VALUES
('bx_stream_html5', 1, 'BxStrmUploaderHTML5', 'modules/boonex/stream/classes/BxStrmUploaderHTML5.php');

-- ALERTS

INSERT INTO `sys_alerts_handlers` (`name`, `class`, `file`, `service_call`) VALUES 
('bx_stream', 'BxStrmAlertsResponse', 'modules/boonex/stream/classes/BxStrmAlertsResponse.php', '');
SET @iHandler := LAST_INSERT_ID();

INSERT INTO `sys_alerts` (`unit`, `action`, `handler_id`) VALUES
('system', 'save_setting', @iHandler),
('profile', 'delete', @iHandler);

-- CRON

INSERT INTO `sys_cron_jobs` (`name`, `time`, `class`, `file`, `service_call`) VALUES
('bx_stream_recordings', '* * * * *', 'BxStrmCronRecordings', 'modules/boonex/stream/classes/BxStrmCronRecordings.php', '');
