<?php
/**
 * PayrollNzApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP PayrollNz
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Payroll NZ
 *
 * This is the Xero Payroll API for orgs in the NZ region.
 *
 * OpenAPI spec version: 9.0.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\PayrollNzObjectSerializer;

/**
 * PayrollNzApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PayrollNzApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation approveTimesheet
     * Approves a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function approveTimesheet($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        list($response) = $this->approveTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key);
        return $response;
    }
    /**
     * Operation approveTimesheetWithHttpInfo
     * Approves a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function approveTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        $request = $this->approveTimesheetRequest($xero_tenant_id, $timesheet_id, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation approveTimesheetAsync
     * Approves a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function approveTimesheetAsync($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        return $this->approveTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation approveTimesheetAsyncWithHttpInfo
     * Approves a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function approveTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
        $request = $this->approveTimesheetRequest($xero_tenant_id, $timesheet_id, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'approveTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function approveTimesheetRequest($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling approveTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling approveTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Approve';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDeduction
     * Creates a new deduction for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Deduction $deduction deduction (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createDeduction($xero_tenant_id, $deduction, $idempotency_key = null)
    {
        list($response) = $this->createDeductionWithHttpInfo($xero_tenant_id, $deduction, $idempotency_key);
        return $response;
    }
    /**
     * Operation createDeductionWithHttpInfo
     * Creates a new deduction for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Deduction $deduction (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDeductionWithHttpInfo($xero_tenant_id, $deduction, $idempotency_key = null)
    {
        $request = $this->createDeductionRequest($xero_tenant_id, $deduction, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createDeductionAsync
     * Creates a new deduction for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Deduction $deduction (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDeductionAsync($xero_tenant_id, $deduction, $idempotency_key = null)
    {
        return $this->createDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createDeductionAsyncWithHttpInfo
     * Creates a new deduction for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Deduction $deduction (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject';
        $request = $this->createDeductionRequest($xero_tenant_id, $deduction, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDeduction'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Deduction $deduction (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createDeductionRequest($xero_tenant_id, $deduction, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createDeduction'
            );
        }
        // verify the required parameter 'deduction' is set
        if ($deduction === null || (is_array($deduction) && count($deduction) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deduction when calling createDeduction'
            );
        }
        $resourcePath = '/Deductions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($deduction)) {
            $_tempBody = $deduction;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEarningsRate
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRate $earnings_rate earnings_rate (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEarningsRate($xero_tenant_id, $earnings_rate, $idempotency_key = null)
    {
        list($response) = $this->createEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEarningsRateWithHttpInfo
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRate $earnings_rate (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate, $idempotency_key = null)
    {
        $request = $this->createEarningsRateRequest($xero_tenant_id, $earnings_rate, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEarningsRateAsync
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRate $earnings_rate (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEarningsRateAsync($xero_tenant_id, $earnings_rate, $idempotency_key = null)
    {
        return $this->createEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEarningsRateAsyncWithHttpInfo
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRate $earnings_rate (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject';
        $request = $this->createEarningsRateRequest($xero_tenant_id, $earnings_rate, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEarningsRate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRate $earnings_rate (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEarningsRateRequest($xero_tenant_id, $earnings_rate, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEarningsRate'
            );
        }
        // verify the required parameter 'earnings_rate' is set
        if ($earnings_rate === null || (is_array($earnings_rate) && count($earnings_rate) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_rate when calling createEarningsRate'
            );
        }
        $resourcePath = '/EarningsRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_rate)) {
            $_tempBody = $earnings_rate;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployee
     * Creates an employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployee($xero_tenant_id, $employee, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeWithHttpInfo($xero_tenant_id, $employee, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeWithHttpInfo
     * Creates an employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeWithHttpInfo($xero_tenant_id, $employee, $idempotency_key = null)
    {
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeAsync
     * Creates an employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeAsync($xero_tenant_id, $employee, $idempotency_key = null)
    {
        return $this->createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeAsyncWithHttpInfo
     * Creates an employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject';
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeRequest($xero_tenant_id, $employee, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployee'
            );
        }
        // verify the required parameter 'employee' is set
        if ($employee === null || (is_array($employee) && count($employee) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee when calling createEmployee'
            );
        }
        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeEarningsTemplate
     * Creates earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeEarningsTemplateWithHttpInfo
     * Creates earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        $request = $this->createEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeEarningsTemplateAsync
     * Creates earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        return $this->createEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeEarningsTemplateAsyncWithHttpInfo
     * Creates earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject';
        $request = $this->createEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'earnings_template' is set
        if ($earnings_template === null || (is_array($earnings_template) && count($earnings_template) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_template when calling createEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates/Earnings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_template)) {
            $_tempBody = $earnings_template;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeLeave
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeLeave($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeLeaveWithHttpInfo
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key = null)
    {
        $request = $this->createEmployeeLeaveRequest($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeLeaveAsync
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeLeaveAsync($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key = null)
    {
        return $this->createEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeLeaveAsyncWithHttpInfo
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
        $request = $this->createEmployeeLeaveRequest($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeLeaveRequest($xero_tenant_id, $employee_id, $employee_leave, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_leave' is set
        if ($employee_leave === null || (is_array($employee_leave) && count($employee_leave) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave when calling createEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave)) {
            $_tempBody = $employee_leave;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeLeaveSetup
     * Creates a leave set-up for a specific employee. This is required before viewing, configuring and requesting leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetup $employee_leave_setup employee_leave_setup (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeLeaveSetup($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeLeaveSetupWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeLeaveSetupWithHttpInfo
     * Creates a leave set-up for a specific employee. This is required before viewing, configuring and requesting leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetup $employee_leave_setup (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeLeaveSetupWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key = null)
    {
        $request = $this->createEmployeeLeaveSetupRequest($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeLeaveSetupAsync
     * Creates a leave set-up for a specific employee. This is required before viewing, configuring and requesting leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetup $employee_leave_setup (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeLeaveSetupAsync($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key = null)
    {
        return $this->createEmployeeLeaveSetupAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeLeaveSetupAsyncWithHttpInfo
     * Creates a leave set-up for a specific employee. This is required before viewing, configuring and requesting leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetup $employee_leave_setup (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeLeaveSetupAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetupObject';
        $request = $this->createEmployeeLeaveSetupRequest($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeLeaveSetup'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveSetup $employee_leave_setup (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeLeaveSetupRequest($xero_tenant_id, $employee_id, $employee_leave_setup, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeLeaveSetup'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeLeaveSetup'
            );
        }
        // verify the required parameter 'employee_leave_setup' is set
        if ($employee_leave_setup === null || (is_array($employee_leave_setup) && count($employee_leave_setup) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave_setup when calling createEmployeeLeaveSetup'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveSetup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave_setup)) {
            $_tempBody = $employee_leave_setup;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeLeaveType
     * Creates leave type records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveType $employee_leave_type employee_leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeLeaveType($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeLeaveTypeWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeLeaveTypeWithHttpInfo
     * Creates leave type records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveType $employee_leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeLeaveTypeWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key = null)
    {
        $request = $this->createEmployeeLeaveTypeRequest($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeLeaveTypeAsync
     * Creates leave type records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveType $employee_leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeLeaveTypeAsync($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key = null)
    {
        return $this->createEmployeeLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeLeaveTypeAsyncWithHttpInfo
     * Creates leave type records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveType $employee_leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypeObject';
        $request = $this->createEmployeeLeaveTypeRequest($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeLeaveType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveType $employee_leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeLeaveTypeRequest($xero_tenant_id, $employee_id, $employee_leave_type, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeLeaveType'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeLeaveType'
            );
        }
        // verify the required parameter 'employee_leave_type' is set
        if ($employee_leave_type === null || (is_array($employee_leave_type) && count($employee_leave_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave_type when calling createEmployeeLeaveType'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave_type)) {
            $_tempBody = $employee_leave_type;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeOpeningBalances
     * Creates opening balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalance[] $employee_opening_balance employee_opening_balance (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeOpeningBalances($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeOpeningBalancesWithHttpInfo
     * Creates opening balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalance[] $employee_opening_balance (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key = null)
    {
        $request = $this->createEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeOpeningBalancesAsync
     * Creates opening balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalance[] $employee_opening_balance (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeOpeningBalancesAsync($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key = null)
    {
        return $this->createEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeOpeningBalancesAsyncWithHttpInfo
     * Creates opening balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalance[] $employee_opening_balance (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject';
        $request = $this->createEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeOpeningBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalance[] $employee_opening_balance (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balance, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_opening_balance' is set
        if ($employee_opening_balance === null || (is_array($employee_opening_balance) && count($employee_opening_balance) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_opening_balance when calling createEmployeeOpeningBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/OpeningBalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_opening_balance)) {
            $_tempBody = $employee_opening_balance;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeePaymentMethod
     * Creates a payment method for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethod $payment_method payment_method (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeePaymentMethod($xero_tenant_id, $employee_id, $payment_method, $idempotency_key = null)
    {
        list($response) = $this->createEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id, $payment_method, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeePaymentMethodWithHttpInfo
     * Creates a payment method for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethod $payment_method (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id, $payment_method, $idempotency_key = null)
    {
        $request = $this->createEmployeePaymentMethodRequest($xero_tenant_id, $employee_id, $payment_method, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeePaymentMethodAsync
     * Creates a payment method for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethod $payment_method (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeePaymentMethodAsync($xero_tenant_id, $employee_id, $payment_method, $idempotency_key = null)
    {
        return $this->createEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id, $payment_method, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeePaymentMethodAsyncWithHttpInfo
     * Creates a payment method for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethod $payment_method (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id, $payment_method, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject';
        $request = $this->createEmployeePaymentMethodRequest($xero_tenant_id, $employee_id, $payment_method, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeePaymentMethod'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethod $payment_method (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeePaymentMethodRequest($xero_tenant_id, $employee_id, $payment_method, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeePaymentMethod'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeePaymentMethod'
            );
        }
        // verify the required parameter 'payment_method' is set
        if ($payment_method === null || (is_array($payment_method) && count($payment_method) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_method when calling createEmployeePaymentMethod'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PaymentMethods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($payment_method)) {
            $_tempBody = $payment_method;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeSalaryAndWage
     * Creates an employee salary and wage record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeSalaryAndWageWithHttpInfo
     * Creates an employee salary and wage record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key = null)
    {
        $request = $this->createEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeSalaryAndWageAsync
     * Creates an employee salary and wage record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key = null)
    {
        return $this->createEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeSalaryAndWageAsyncWithHttpInfo
     * Creates an employee salary and wage record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject';
        $request = $this->createEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wage, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wage' is set
        if ($salary_and_wage === null || (is_array($salary_and_wage) && count($salary_and_wage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wage when calling createEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($salary_and_wage)) {
            $_tempBody = $salary_and_wage;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeWorkingPattern
     * Creates an employee working pattern
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksRequest $employee_working_pattern_with_working_weeks_request employee_working_pattern_with_working_weeks_request (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployeeWorkingPattern($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key = null)
    {
        list($response) = $this->createEmployeeWorkingPatternWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmployeeWorkingPatternWithHttpInfo
     * Creates an employee working pattern
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksRequest $employee_working_pattern_with_working_weeks_request (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeWorkingPatternWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key = null)
    {
        $request = $this->createEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeWorkingPatternAsync
     * Creates an employee working pattern
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksRequest $employee_working_pattern_with_working_weeks_request (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeWorkingPatternAsync($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key = null)
    {
        return $this->createEmployeeWorkingPatternAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeWorkingPatternAsyncWithHttpInfo
     * Creates an employee working pattern
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksRequest $employee_working_pattern_with_working_weeks_request (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeWorkingPatternAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject';
        $request = $this->createEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeWorkingPattern'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksRequest $employee_working_pattern_with_working_weeks_request (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_with_working_weeks_request, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeWorkingPattern'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeWorkingPattern'
            );
        }
        // verify the required parameter 'employee_working_pattern_with_working_weeks_request' is set
        if ($employee_working_pattern_with_working_weeks_request === null || (is_array($employee_working_pattern_with_working_weeks_request) && count($employee_working_pattern_with_working_weeks_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_working_pattern_with_working_weeks_request when calling createEmployeeWorkingPattern'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Working-Patterns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_working_pattern_with_working_weeks_request)) {
            $_tempBody = $employee_working_pattern_with_working_weeks_request;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployment
     * Creates an employment detail for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employment $employment employment (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createEmployment($xero_tenant_id, $employee_id, $employment, $idempotency_key = null)
    {
        list($response) = $this->createEmploymentWithHttpInfo($xero_tenant_id, $employee_id, $employment, $idempotency_key);
        return $response;
    }
    /**
     * Operation createEmploymentWithHttpInfo
     * Creates an employment detail for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employment $employment (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmploymentWithHttpInfo($xero_tenant_id, $employee_id, $employment, $idempotency_key = null)
    {
        $request = $this->createEmploymentRequest($xero_tenant_id, $employee_id, $employment, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmploymentAsync
     * Creates an employment detail for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employment $employment (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmploymentAsync($xero_tenant_id, $employee_id, $employment, $idempotency_key = null)
    {
        return $this->createEmploymentAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employment, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmploymentAsyncWithHttpInfo
     * Creates an employment detail for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employment $employment (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmploymentAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employment, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmploymentObject';
        $request = $this->createEmploymentRequest($xero_tenant_id, $employee_id, $employment, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployment'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employment $employment (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmploymentRequest($xero_tenant_id, $employee_id, $employment, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployment'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployment'
            );
        }
        // verify the required parameter 'employment' is set
        if ($employment === null || (is_array($employment) && count($employment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employment when calling createEmployment'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Employment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employment)) {
            $_tempBody = $employment;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLeaveType
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\LeaveType $leave_type leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createLeaveType($xero_tenant_id, $leave_type, $idempotency_key = null)
    {
        list($response) = $this->createLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type, $idempotency_key);
        return $response;
    }
    /**
     * Operation createLeaveTypeWithHttpInfo
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\LeaveType $leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type, $idempotency_key = null)
    {
        $request = $this->createLeaveTypeRequest($xero_tenant_id, $leave_type, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createLeaveTypeAsync
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\LeaveType $leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLeaveTypeAsync($xero_tenant_id, $leave_type, $idempotency_key = null)
    {
        return $this->createLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createLeaveTypeAsyncWithHttpInfo
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\LeaveType $leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject';
        $request = $this->createLeaveTypeRequest($xero_tenant_id, $leave_type, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLeaveType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\LeaveType $leave_type (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createLeaveTypeRequest($xero_tenant_id, $leave_type, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createLeaveType'
            );
        }
        // verify the required parameter 'leave_type' is set
        if ($leave_type === null || (is_array($leave_type) && count($leave_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_type when calling createLeaveType'
            );
        }
        $resourcePath = '/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($leave_type)) {
            $_tempBody = $leave_type;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createMultipleEmployeeEarningsTemplate
     * Creates multiple employee earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate[] $earnings_template earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createMultipleEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        list($response) = $this->createMultipleEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key);
        return $response;
    }
    /**
     * Operation createMultipleEmployeeEarningsTemplateWithHttpInfo
     * Creates multiple employee earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate[] $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createMultipleEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        $request = $this->createMultipleEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createMultipleEmployeeEarningsTemplateAsync
     * Creates multiple employee earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate[] $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createMultipleEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        return $this->createMultipleEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createMultipleEmployeeEarningsTemplateAsyncWithHttpInfo
     * Creates multiple employee earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate[] $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createMultipleEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeEarningsTemplates';
        $request = $this->createMultipleEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createMultipleEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate[] $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createMultipleEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createMultipleEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createMultipleEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'earnings_template' is set
        if ($earnings_template === null || (is_array($earnings_template) && count($earnings_template) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_template when calling createMultipleEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplateEarnings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_template)) {
            $_tempBody = $earnings_template;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayRun
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createPayRun($xero_tenant_id, $pay_run, $idempotency_key = null)
    {
        list($response) = $this->createPayRunWithHttpInfo($xero_tenant_id, $pay_run, $idempotency_key);
        return $response;
    }
    /**
     * Operation createPayRunWithHttpInfo
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPayRunWithHttpInfo($xero_tenant_id, $pay_run, $idempotency_key = null)
    {
        $request = $this->createPayRunRequest($xero_tenant_id, $pay_run, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createPayRunAsync
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPayRunAsync($xero_tenant_id, $pay_run, $idempotency_key = null)
    {
        return $this->createPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createPayRunAsyncWithHttpInfo
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject';
        $request = $this->createPayRunRequest($xero_tenant_id, $pay_run, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createPayRunRequest($xero_tenant_id, $pay_run, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayRun'
            );
        }
        // verify the required parameter 'pay_run' is set
        if ($pay_run === null || (is_array($pay_run) && count($pay_run) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run when calling createPayRun'
            );
        }
        $resourcePath = '/PayRuns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run)) {
            $_tempBody = $pay_run;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayRunCalendar
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendar $pay_run_calendar pay_run_calendar (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createPayRunCalendar($xero_tenant_id, $pay_run_calendar, $idempotency_key = null)
    {
        list($response) = $this->createPayRunCalendarWithHttpInfo($xero_tenant_id, $pay_run_calendar, $idempotency_key);
        return $response;
    }
    /**
     * Operation createPayRunCalendarWithHttpInfo
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendar $pay_run_calendar (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPayRunCalendarWithHttpInfo($xero_tenant_id, $pay_run_calendar, $idempotency_key = null)
    {
        $request = $this->createPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createPayRunCalendarAsync
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendar $pay_run_calendar (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPayRunCalendarAsync($xero_tenant_id, $pay_run_calendar, $idempotency_key = null)
    {
        return $this->createPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $pay_run_calendar, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createPayRunCalendarAsyncWithHttpInfo
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendar $pay_run_calendar (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $pay_run_calendar, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject';
        $request = $this->createPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayRunCalendar'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendar $pay_run_calendar (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayRunCalendar'
            );
        }
        // verify the required parameter 'pay_run_calendar' is set
        if ($pay_run_calendar === null || (is_array($pay_run_calendar) && count($pay_run_calendar) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_calendar when calling createPayRunCalendar'
            );
        }
        $resourcePath = '/PayRunCalendars';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run_calendar)) {
            $_tempBody = $pay_run_calendar;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReimbursement
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursement $reimbursement reimbursement (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createReimbursement($xero_tenant_id, $reimbursement, $idempotency_key = null)
    {
        list($response) = $this->createReimbursementWithHttpInfo($xero_tenant_id, $reimbursement, $idempotency_key);
        return $response;
    }
    /**
     * Operation createReimbursementWithHttpInfo
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursement $reimbursement (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReimbursementWithHttpInfo($xero_tenant_id, $reimbursement, $idempotency_key = null)
    {
        $request = $this->createReimbursementRequest($xero_tenant_id, $reimbursement, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createReimbursementAsync
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursement $reimbursement (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReimbursementAsync($xero_tenant_id, $reimbursement, $idempotency_key = null)
    {
        return $this->createReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createReimbursementAsyncWithHttpInfo
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursement $reimbursement (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject';
        $request = $this->createReimbursementRequest($xero_tenant_id, $reimbursement, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReimbursement'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursement $reimbursement (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createReimbursementRequest($xero_tenant_id, $reimbursement, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReimbursement'
            );
        }
        // verify the required parameter 'reimbursement' is set
        if ($reimbursement === null || (is_array($reimbursement) && count($reimbursement) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reimbursement when calling createReimbursement'
            );
        }
        $resourcePath = '/Reimbursements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($reimbursement)) {
            $_tempBody = $reimbursement;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSuperannuation
     * Creates a new superannuation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Benefit $benefit benefit (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createSuperannuation($xero_tenant_id, $benefit, $idempotency_key = null)
    {
        list($response) = $this->createSuperannuationWithHttpInfo($xero_tenant_id, $benefit, $idempotency_key);
        return $response;
    }
    /**
     * Operation createSuperannuationWithHttpInfo
     * Creates a new superannuation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Benefit $benefit (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSuperannuationWithHttpInfo($xero_tenant_id, $benefit, $idempotency_key = null)
    {
        $request = $this->createSuperannuationRequest($xero_tenant_id, $benefit, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createSuperannuationAsync
     * Creates a new superannuation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Benefit $benefit (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSuperannuationAsync($xero_tenant_id, $benefit, $idempotency_key = null)
    {
        return $this->createSuperannuationAsyncWithHttpInfo($xero_tenant_id, $benefit, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createSuperannuationAsyncWithHttpInfo
     * Creates a new superannuation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Benefit $benefit (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createSuperannuationAsyncWithHttpInfo($xero_tenant_id, $benefit, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject';
        $request = $this->createSuperannuationRequest($xero_tenant_id, $benefit, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSuperannuation'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Benefit $benefit (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createSuperannuationRequest($xero_tenant_id, $benefit, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createSuperannuation'
            );
        }
        // verify the required parameter 'benefit' is set
        if ($benefit === null || (is_array($benefit) && count($benefit) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $benefit when calling createSuperannuation'
            );
        }
        $resourcePath = '/Superannuations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($benefit)) {
            $_tempBody = $benefit;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTimesheet
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Timesheet $timesheet timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createTimesheet($xero_tenant_id, $timesheet, $idempotency_key = null)
    {
        list($response) = $this->createTimesheetWithHttpInfo($xero_tenant_id, $timesheet, $idempotency_key);
        return $response;
    }
    /**
     * Operation createTimesheetWithHttpInfo
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Timesheet $timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTimesheetWithHttpInfo($xero_tenant_id, $timesheet, $idempotency_key = null)
    {
        $request = $this->createTimesheetRequest($xero_tenant_id, $timesheet, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createTimesheetAsync
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Timesheet $timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTimesheetAsync($xero_tenant_id, $timesheet, $idempotency_key = null)
    {
        return $this->createTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createTimesheetAsyncWithHttpInfo
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Timesheet $timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
        $request = $this->createTimesheetRequest($xero_tenant_id, $timesheet, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Timesheet $timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createTimesheetRequest($xero_tenant_id, $timesheet, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTimesheet'
            );
        }
        // verify the required parameter 'timesheet' is set
        if ($timesheet === null || (is_array($timesheet) && count($timesheet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet when calling createTimesheet'
            );
        }
        $resourcePath = '/Timesheets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet)) {
            $_tempBody = $timesheet;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTimesheetLine
     * Create a new timesheet line for a specific time sheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function createTimesheetLine($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key = null)
    {
        list($response) = $this->createTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key);
        return $response;
    }
    /**
     * Operation createTimesheetLineWithHttpInfo
     * Create a new timesheet line for a specific time sheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key = null)
    {
        $request = $this->createTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createTimesheetLineAsync
     * Create a new timesheet line for a specific time sheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTimesheetLineAsync($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key = null)
    {
        return $this->createTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createTimesheetLineAsyncWithHttpInfo
     * Create a new timesheet line for a specific time sheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject';
        $request = $this->createTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTimesheetLine'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling createTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line' is set
        if ($timesheet_line === null || (is_array($timesheet_line) && count($timesheet_line) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line when calling createTimesheetLine'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Lines';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet_line)) {
            $_tempBody = $timesheet_line;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeEarningsTemplate
     * Deletes an employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject
     */
    public function deleteEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        list($response) = $this->deleteEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id);
        return $response;
    }
    /**
     * Operation deleteEmployeeEarningsTemplateWithHttpInfo
     * Deletes an employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        $request = $this->deleteEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeEarningsTemplateAsync
     * Deletes an employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        return $this->deleteEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeEarningsTemplateAsyncWithHttpInfo
     * Deletes an employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject';
        $request = $this->deleteEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'pay_template_earning_id' is set
        if ($pay_template_earning_id === null || (is_array($pay_template_earning_id) && count($pay_template_earning_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_template_earning_id when calling deleteEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates/Earnings/{PayTemplateEarningID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($pay_template_earning_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayTemplateEarningID' . '}',
                PayrollNzObjectSerializer::toPathValue($pay_template_earning_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeLeave
     * Deletes a leave record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject
     */
    public function deleteEmployeeLeave($xero_tenant_id, $employee_id, $leave_id)
    {
        list($response) = $this->deleteEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id);
        return $response;
    }
    /**
     * Operation deleteEmployeeLeaveWithHttpInfo
     * Deletes a leave record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
    {
        $request = $this->deleteEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeLeaveAsync
     * Deletes a leave record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeLeaveAsync($xero_tenant_id, $employee_id, $leave_id)
    {
        return $this->deleteEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeLeaveAsyncWithHttpInfo
     * Deletes a leave record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
        $request = $this->deleteEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeLeave'
            );
        }
        // verify the required parameter 'leave_id' is set
        if ($leave_id === null || (is_array($leave_id) && count($leave_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_id when calling deleteEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave/{LeaveID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($leave_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveID' . '}',
                PayrollNzObjectSerializer::toPathValue($leave_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeSalaryAndWage
     * Deletes an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject
     */
    public function deleteEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        list($response) = $this->deleteEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $response;
    }
    /**
     * Operation deleteEmployeeSalaryAndWageWithHttpInfo
     * Deletes an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $request = $this->deleteEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeSalaryAndWageAsync
     * Deletes an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        return $this->deleteEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeSalaryAndWageAsyncWithHttpInfo
     * Deletes an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject';
        $request = $this->deleteEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wages_id' is set
        if ($salary_and_wages_id === null || (is_array($salary_and_wages_id) && count($salary_and_wages_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wages_id when calling deleteEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($salary_and_wages_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SalaryAndWagesID' . '}',
                PayrollNzObjectSerializer::toPathValue($salary_and_wages_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeWorkingPattern
     * deletes employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function deleteEmployeeWorkingPattern($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        list($response) = $this->deleteEmployeeWorkingPatternWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id);
        return $response;
    }
    /**
     * Operation deleteEmployeeWorkingPatternWithHttpInfo
     * deletes employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeWorkingPatternWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        $request = $this->deleteEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeWorkingPatternAsync
     * deletes employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeWorkingPatternAsync($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        return $this->deleteEmployeeWorkingPatternAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeWorkingPatternAsyncWithHttpInfo
     * deletes employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeWorkingPatternAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
        $request = $this->deleteEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeWorkingPattern'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeWorkingPattern'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeWorkingPattern'
            );
        }
        // verify the required parameter 'employee_working_pattern_id' is set
        if ($employee_working_pattern_id === null || (is_array($employee_working_pattern_id) && count($employee_working_pattern_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_working_pattern_id when calling deleteEmployeeWorkingPattern'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Working-Patterns/{EmployeeWorkingPatternID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($employee_working_pattern_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeWorkingPatternID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_working_pattern_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTimesheet
     * Deletes a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function deleteTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->deleteTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation deleteTimesheetWithHttpInfo
     * Deletes a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->deleteTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteTimesheetAsync
     * Deletes a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->deleteTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteTimesheetAsyncWithHttpInfo
     * Deletes a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine';
        $request = $this->deleteTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling deleteTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTimesheetLine
     * Deletes a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function deleteTimesheetLine($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        list($response) = $this->deleteTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id);
        return $response;
    }
    /**
     * Operation deleteTimesheetLineWithHttpInfo
     * Deletes a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        $request = $this->deleteTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteTimesheetLineAsync
     * Deletes a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTimesheetLineAsync($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        return $this->deleteTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteTimesheetLineAsyncWithHttpInfo
     * Deletes a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine';
        $request = $this->deleteTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTimesheetLine'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling deleteTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line_id' is set
        if ($timesheet_line_id === null || (is_array($timesheet_line_id) && count($timesheet_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line_id when calling deleteTimesheetLine'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // path params
        if ($timesheet_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetLineID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_line_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDeduction
     * Retrieves a single deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject
     */
    public function getDeduction($xero_tenant_id, $deduction_id)
    {
        list($response) = $this->getDeductionWithHttpInfo($xero_tenant_id, $deduction_id);
        return $response;
    }
    /**
     * Operation getDeductionWithHttpInfo
     * Retrieves a single deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDeductionWithHttpInfo($xero_tenant_id, $deduction_id)
    {
        $request = $this->getDeductionRequest($xero_tenant_id, $deduction_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getDeductionAsync
     * Retrieves a single deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDeductionAsync($xero_tenant_id, $deduction_id)
    {
        return $this->getDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getDeductionAsyncWithHttpInfo
     * Retrieves a single deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\DeductionObject';
        $request = $this->getDeductionRequest($xero_tenant_id, $deduction_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDeduction'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getDeductionRequest($xero_tenant_id, $deduction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getDeduction'
            );
        }
        // verify the required parameter 'deduction_id' is set
        if ($deduction_id === null || (is_array($deduction_id) && count($deduction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deduction_id when calling getDeduction'
            );
        }
        $resourcePath = '/Deductions/{deductionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($deduction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'deductionId' . '}',
                PayrollNzObjectSerializer::toPathValue($deduction_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDeductions
     * Retrieves deductions for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\Deductions
     */
    public function getDeductions($xero_tenant_id, $page = null)
    {
        list($response) = $this->getDeductionsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getDeductionsWithHttpInfo
     * Retrieves deductions for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\Deductions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDeductionsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getDeductionsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Deductions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Deductions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Deductions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Deductions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getDeductionsAsync
     * Retrieves deductions for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDeductionsAsync($xero_tenant_id, $page = null)
    {
        return $this->getDeductionsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getDeductionsAsyncWithHttpInfo
     * Retrieves deductions for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getDeductionsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Deductions';
        $request = $this->getDeductionsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDeductions'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getDeductionsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getDeductions'
            );
        }
        $resourcePath = '/Deductions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEarningsRate
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject
     */
    public function getEarningsRate($xero_tenant_id, $earnings_rate_id)
    {
        list($response) = $this->getEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate_id);
        return $response;
    }
    /**
     * Operation getEarningsRateWithHttpInfo
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate_id)
    {
        $request = $this->getEarningsRateRequest($xero_tenant_id, $earnings_rate_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEarningsRateAsync
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEarningsRateAsync($xero_tenant_id, $earnings_rate_id)
    {
        return $this->getEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEarningsRateAsyncWithHttpInfo
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRateObject';
        $request = $this->getEarningsRateRequest($xero_tenant_id, $earnings_rate_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEarningsRate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEarningsRateRequest($xero_tenant_id, $earnings_rate_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEarningsRate'
            );
        }
        // verify the required parameter 'earnings_rate_id' is set
        if ($earnings_rate_id === null || (is_array($earnings_rate_id) && count($earnings_rate_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_rate_id when calling getEarningsRate'
            );
        }
        $resourcePath = '/EarningsRates/{EarningsRateID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($earnings_rate_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EarningsRateID' . '}',
                PayrollNzObjectSerializer::toPathValue($earnings_rate_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEarningsRates
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates
     */
    public function getEarningsRates($xero_tenant_id, $page = null)
    {
        list($response) = $this->getEarningsRatesWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getEarningsRatesWithHttpInfo
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEarningsRatesWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getEarningsRatesRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEarningsRatesAsync
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEarningsRatesAsync($xero_tenant_id, $page = null)
    {
        return $this->getEarningsRatesAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEarningsRatesAsyncWithHttpInfo
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEarningsRatesAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsRates';
        $request = $this->getEarningsRatesRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEarningsRates'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEarningsRatesRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEarningsRates'
            );
        }
        $resourcePath = '/EarningsRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployee
     * Retrieves an employees using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject
     */
    public function getEmployee($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeWithHttpInfo
     * Retrieves an employees using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeAsync
     * Retrieves an employees using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeAsyncWithHttpInfo
     * Retrieves an employees using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject';
        $request = $this->getEmployeeRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployee'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployee'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeaveBalances
     * Retrieves leave balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances
     */
    public function getEmployeeLeaveBalances($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeLeaveBalancesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeaveBalancesWithHttpInfo
     * Retrieves leave balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeaveBalancesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeLeaveBalancesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeaveBalancesAsync
     * Retrieves leave balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeaveBalancesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeLeaveBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeaveBalancesAsyncWithHttpInfo
     * Retrieves leave balances for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeaveBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveBalances';
        $request = $this->getEmployeeLeaveBalancesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeaveBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeaveBalancesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeaveBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeaveBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveBalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeavePeriods
     * Retrieves leave periods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function getEmployeeLeavePeriods($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        list($response) = $this->getEmployeeLeavePeriodsWithHttpInfo($xero_tenant_id, $employee_id, $start_date, $end_date);
        return $response;
    }
    /**
     * Operation getEmployeeLeavePeriodsWithHttpInfo
     * Retrieves leave periods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeavePeriodsWithHttpInfo($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        $request = $this->getEmployeeLeavePeriodsRequest($xero_tenant_id, $employee_id, $start_date, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeavePeriodsAsync
     * Retrieves leave periods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeavePeriodsAsync($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        return $this->getEmployeeLeavePeriodsAsyncWithHttpInfo($xero_tenant_id, $employee_id, $start_date, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeavePeriodsAsyncWithHttpInfo
     * Retrieves leave periods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeavePeriodsAsyncWithHttpInfo($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeavePeriods';
        $request = $this->getEmployeeLeavePeriodsRequest($xero_tenant_id, $employee_id, $start_date, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeavePeriods'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeavePeriodsRequest($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeavePeriods'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeavePeriods'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeavePeriods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = PayrollNzObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = PayrollNzObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeaveTypes
     * Retrieves leave types for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function getEmployeeLeaveTypes($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeLeaveTypesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeaveTypesWithHttpInfo
     * Retrieves leave types for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeaveTypesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeLeaveTypesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeaveTypesAsync
     * Retrieves leave types for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeaveTypesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeaveTypesAsyncWithHttpInfo
     * Retrieves leave types for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveTypes';
        $request = $this->getEmployeeLeaveTypesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeaveTypes'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeaveTypesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeaveTypes'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeaveTypes'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeaves
     * Retrieves leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves
     */
    public function getEmployeeLeaves($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeLeavesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeavesWithHttpInfo
     * Retrieves leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeavesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeLeavesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeavesAsync
     * Retrieves leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeavesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeLeavesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeavesAsyncWithHttpInfo
     * Retrieves leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeavesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaves';
        $request = $this->getEmployeeLeavesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeaves'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeavesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeaves'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeaves'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeOpeningBalances
     * Retrieves the opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject
     */
    public function getEmployeeOpeningBalances($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeOpeningBalancesWithHttpInfo
     * Retrieves the opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeOpeningBalancesAsync
     * Retrieves the opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeOpeningBalancesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeOpeningBalancesAsyncWithHttpInfo
     * Retrieves the opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeOpeningBalancesObject';
        $request = $this->getEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeOpeningBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeOpeningBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/OpeningBalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeePayTemplates
     * Retrieves pay templates for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function getEmployeePayTemplates($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeePayTemplatesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeePayTemplatesWithHttpInfo
     * Retrieves pay templates for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeePayTemplatesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeePayTemplatesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeePayTemplatesAsync
     * Retrieves pay templates for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeePayTemplatesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeePayTemplatesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeePayTemplatesAsyncWithHttpInfo
     * Retrieves pay templates for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeePayTemplatesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeePayTemplates';
        $request = $this->getEmployeePayTemplatesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeePayTemplates'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeePayTemplatesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeePayTemplates'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeePayTemplates'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeePaymentMethod
     * Retrieves available payment methods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function getEmployeePaymentMethod($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeePaymentMethodWithHttpInfo
     * Retrieves available payment methods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeePaymentMethodRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeePaymentMethodAsync
     * Retrieves available payment methods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeePaymentMethodAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeePaymentMethodAsyncWithHttpInfo
     * Retrieves available payment methods for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaymentMethodObject';
        $request = $this->getEmployeePaymentMethodRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeePaymentMethod'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeePaymentMethodRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeePaymentMethod'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeePaymentMethod'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PaymentMethods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeSalaryAndWage
     * Retrieves an employee's salary and wages record by using a unique salary and wage ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages
     */
    public function getEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        list($response) = $this->getEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $response;
    }
    /**
     * Operation getEmployeeSalaryAndWageWithHttpInfo
     * Retrieves an employee's salary and wages record by using a unique salary and wage ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $request = $this->getEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeSalaryAndWageAsync
     * Retrieves an employee's salary and wages record by using a unique salary and wage ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        return $this->getEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeSalaryAndWageAsyncWithHttpInfo
     * Retrieves an employee's salary and wages record by using a unique salary and wage ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages';
        $request = $this->getEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wages_id' is set
        if ($salary_and_wages_id === null || (is_array($salary_and_wages_id) && count($salary_and_wages_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wages_id when calling getEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($salary_and_wages_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SalaryAndWagesID' . '}',
                PayrollNzObjectSerializer::toPathValue($salary_and_wages_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeSalaryAndWages
     * Retrieves an employee's salary and wages
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function getEmployeeSalaryAndWages($xero_tenant_id, $employee_id, $page = null)
    {
        list($response) = $this->getEmployeeSalaryAndWagesWithHttpInfo($xero_tenant_id, $employee_id, $page);
        return $response;
    }
    /**
     * Operation getEmployeeSalaryAndWagesWithHttpInfo
     * Retrieves an employee's salary and wages
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeSalaryAndWagesWithHttpInfo($xero_tenant_id, $employee_id, $page = null)
    {
        $request = $this->getEmployeeSalaryAndWagesRequest($xero_tenant_id, $employee_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeSalaryAndWagesAsync
     * Retrieves an employee's salary and wages
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeSalaryAndWagesAsync($xero_tenant_id, $employee_id, $page = null)
    {
        return $this->getEmployeeSalaryAndWagesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeSalaryAndWagesAsyncWithHttpInfo
     * Retrieves an employee's salary and wages
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeSalaryAndWagesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWages';
        $request = $this->getEmployeeSalaryAndWagesRequest($xero_tenant_id, $employee_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeSalaryAndWages'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeSalaryAndWagesRequest($xero_tenant_id, $employee_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeSalaryAndWages'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeSalaryAndWages'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeTax
     * Retrieves tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject
     */
    public function getEmployeeTax($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeTaxWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeTaxWithHttpInfo
     * Retrieves tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeTaxWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeTaxRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeTaxAsync
     * Retrieves tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeTaxAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeTaxAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeTaxAsyncWithHttpInfo
     * Retrieves tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeTaxAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject';
        $request = $this->getEmployeeTaxRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeTax'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeTaxRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeTax'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeTax'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Tax';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeWorkingPattern
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject
     */
    public function getEmployeeWorkingPattern($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        list($response) = $this->getEmployeeWorkingPatternWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id);
        return $response;
    }
    /**
     * Operation getEmployeeWorkingPatternWithHttpInfo
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeWorkingPatternWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        $request = $this->getEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeWorkingPatternAsync
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeWorkingPatternAsync($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        return $this->getEmployeeWorkingPatternAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeWorkingPatternAsyncWithHttpInfo
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeWorkingPatternAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternWithWorkingWeeksObject';
        $request = $this->getEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeWorkingPattern'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $employee_working_pattern_id Employee working pattern id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeWorkingPatternRequest($xero_tenant_id, $employee_id, $employee_working_pattern_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeWorkingPattern'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeWorkingPattern'
            );
        }
        // verify the required parameter 'employee_working_pattern_id' is set
        if ($employee_working_pattern_id === null || (is_array($employee_working_pattern_id) && count($employee_working_pattern_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_working_pattern_id when calling getEmployeeWorkingPattern'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Working-Patterns/{EmployeeWorkingPatternID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($employee_working_pattern_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeWorkingPatternID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_working_pattern_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeWorkingPatterns
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject
     */
    public function getEmployeeWorkingPatterns($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeWorkingPatternsWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeWorkingPatternsWithHttpInfo
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeWorkingPatternsWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeWorkingPatternsRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeWorkingPatternsAsync
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeWorkingPatternsAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeWorkingPatternsAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeWorkingPatternsAsyncWithHttpInfo
     * Retrieves employee's working patterns
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeWorkingPatternsAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeWorkingPatternsObject';
        $request = $this->getEmployeeWorkingPatternsRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeWorkingPatterns'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeWorkingPatternsRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeWorkingPatterns'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeWorkingPatterns'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Working-Patterns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployees
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\Employees|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function getEmployees($xero_tenant_id, $filter = null, $page = null)
    {
        list($response) = $this->getEmployeesWithHttpInfo($xero_tenant_id, $filter, $page);
        return $response;
    }
    /**
     * Operation getEmployeesWithHttpInfo
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\Employees|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeesWithHttpInfo($xero_tenant_id, $filter = null, $page = null)
    {
        $request = $this->getEmployeesRequest($xero_tenant_id, $filter, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeesAsync
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeesAsync($xero_tenant_id, $filter = null, $page = null)
    {
        return $this->getEmployeesAsyncWithHttpInfo($xero_tenant_id, $filter, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeesAsyncWithHttpInfo
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeesAsyncWithHttpInfo($xero_tenant_id, $filter = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Employees';
        $request = $this->getEmployeesRequest($xero_tenant_id, $filter, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployees'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeesRequest($xero_tenant_id, $filter = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployees'
            );
        }
        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($filter !== null) {
            $queryParams['filter'] = PayrollNzObjectSerializer::toQueryValue($filter);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLeaveType
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject
     */
    public function getLeaveType($xero_tenant_id, $leave_type_id)
    {
        list($response) = $this->getLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type_id);
        return $response;
    }
    /**
     * Operation getLeaveTypeWithHttpInfo
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type_id)
    {
        $request = $this->getLeaveTypeRequest($xero_tenant_id, $leave_type_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getLeaveTypeAsync
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLeaveTypeAsync($xero_tenant_id, $leave_type_id)
    {
        return $this->getLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getLeaveTypeAsyncWithHttpInfo
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypeObject';
        $request = $this->getLeaveTypeRequest($xero_tenant_id, $leave_type_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLeaveType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getLeaveTypeRequest($xero_tenant_id, $leave_type_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getLeaveType'
            );
        }
        // verify the required parameter 'leave_type_id' is set
        if ($leave_type_id === null || (is_array($leave_type_id) && count($leave_type_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_type_id when calling getLeaveType'
            );
        }
        $resourcePath = '/LeaveTypes/{LeaveTypeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($leave_type_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveTypeID' . '}',
                PayrollNzObjectSerializer::toPathValue($leave_type_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLeaveTypes
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes
     */
    public function getLeaveTypes($xero_tenant_id, $page = null, $active_only = null)
    {
        list($response) = $this->getLeaveTypesWithHttpInfo($xero_tenant_id, $page, $active_only);
        return $response;
    }
    /**
     * Operation getLeaveTypesWithHttpInfo
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLeaveTypesWithHttpInfo($xero_tenant_id, $page = null, $active_only = null)
    {
        $request = $this->getLeaveTypesRequest($xero_tenant_id, $page, $active_only);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getLeaveTypesAsync
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLeaveTypesAsync($xero_tenant_id, $page = null, $active_only = null)
    {
        return $this->getLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $page, $active_only)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getLeaveTypesAsyncWithHttpInfo
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $page = null, $active_only = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\LeaveTypes';
        $request = $this->getLeaveTypesRequest($xero_tenant_id, $page, $active_only);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLeaveTypes'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getLeaveTypesRequest($xero_tenant_id, $page = null, $active_only = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getLeaveTypes'
            );
        }
        $resourcePath = '/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($active_only !== null) {
            $queryParams['ActiveOnly'] = $active_only ? 'true' : 'false';
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRun
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject
     */
    public function getPayRun($xero_tenant_id, $pay_run_id)
    {
        list($response) = $this->getPayRunWithHttpInfo($xero_tenant_id, $pay_run_id);
        return $response;
    }
    /**
     * Operation getPayRunWithHttpInfo
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunWithHttpInfo($xero_tenant_id, $pay_run_id)
    {
        $request = $this->getPayRunRequest($xero_tenant_id, $pay_run_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunAsync
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunAsync($xero_tenant_id, $pay_run_id)
    {
        return $this->getPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunAsyncWithHttpInfo
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject';
        $request = $this->getPayRunRequest($xero_tenant_id, $pay_run_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunRequest($xero_tenant_id, $pay_run_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRun'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling getPayRun'
            );
        }
        $resourcePath = '/PayRuns/{PayRunID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunID' . '}',
                PayrollNzObjectSerializer::toPathValue($pay_run_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRunCalendar
     * Retrieves a specific payrun calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Identifier for the payrun calendars (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject
     */
    public function getPayRunCalendar($xero_tenant_id, $payroll_calendar_id)
    {
        list($response) = $this->getPayRunCalendarWithHttpInfo($xero_tenant_id, $payroll_calendar_id);
        return $response;
    }
    /**
     * Operation getPayRunCalendarWithHttpInfo
     * Retrieves a specific payrun calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Identifier for the payrun calendars (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunCalendarWithHttpInfo($xero_tenant_id, $payroll_calendar_id)
    {
        $request = $this->getPayRunCalendarRequest($xero_tenant_id, $payroll_calendar_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunCalendarAsync
     * Retrieves a specific payrun calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Identifier for the payrun calendars (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunCalendarAsync($xero_tenant_id, $payroll_calendar_id)
    {
        return $this->getPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $payroll_calendar_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunCalendarAsyncWithHttpInfo
     * Retrieves a specific payrun calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Identifier for the payrun calendars (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $payroll_calendar_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendarObject';
        $request = $this->getPayRunCalendarRequest($xero_tenant_id, $payroll_calendar_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRunCalendar'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Identifier for the payrun calendars (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunCalendarRequest($xero_tenant_id, $payroll_calendar_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRunCalendar'
            );
        }
        // verify the required parameter 'payroll_calendar_id' is set
        if ($payroll_calendar_id === null || (is_array($payroll_calendar_id) && count($payroll_calendar_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payroll_calendar_id when calling getPayRunCalendar'
            );
        }
        $resourcePath = '/PayRunCalendars/{PayrollCalendarID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($payroll_calendar_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayrollCalendarID' . '}',
                PayrollNzObjectSerializer::toPathValue($payroll_calendar_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRunCalendars
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars
     */
    public function getPayRunCalendars($xero_tenant_id, $page = null)
    {
        list($response) = $this->getPayRunCalendarsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getPayRunCalendarsWithHttpInfo
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunCalendarsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getPayRunCalendarsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunCalendarsAsync
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunCalendarsAsync($xero_tenant_id, $page = null)
    {
        return $this->getPayRunCalendarsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunCalendarsAsyncWithHttpInfo
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunCalendarsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunCalendars';
        $request = $this->getPayRunCalendarsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRunCalendars'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunCalendarsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRunCalendars'
            );
        }
        $resourcePath = '/PayRunCalendars';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRuns
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRuns
     */
    public function getPayRuns($xero_tenant_id, $page = null, $status = null)
    {
        list($response) = $this->getPayRunsWithHttpInfo($xero_tenant_id, $page, $status);
        return $response;
    }
    /**
     * Operation getPayRunsWithHttpInfo
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRuns, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunsWithHttpInfo($xero_tenant_id, $page = null, $status = null)
    {
        $request = $this->getPayRunsRequest($xero_tenant_id, $page, $status);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRuns' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRuns', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRuns';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRuns',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunsAsync
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunsAsync($xero_tenant_id, $page = null, $status = null)
    {
        return $this->getPayRunsAsyncWithHttpInfo($xero_tenant_id, $page, $status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunsAsyncWithHttpInfo
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunsAsyncWithHttpInfo($xero_tenant_id, $page = null, $status = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRuns';
        $request = $this->getPayRunsRequest($xero_tenant_id, $page, $status);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRuns'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunsRequest($xero_tenant_id, $page = null, $status = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRuns'
            );
        }
        $resourcePath = '/PayRuns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($status !== null) {
            $queryParams['status'] = PayrollNzObjectSerializer::toQueryValue($status);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaySlip
     * Retrieves a specific payslip by a unique pay slip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject
     */
    public function getPaySlip($xero_tenant_id, $pay_slip_id)
    {
        list($response) = $this->getPaySlipWithHttpInfo($xero_tenant_id, $pay_slip_id);
        return $response;
    }
    /**
     * Operation getPaySlipWithHttpInfo
     * Retrieves a specific payslip by a unique pay slip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaySlipWithHttpInfo($xero_tenant_id, $pay_slip_id)
    {
        $request = $this->getPaySlipRequest($xero_tenant_id, $pay_slip_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPaySlipAsync
     * Retrieves a specific payslip by a unique pay slip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaySlipAsync($xero_tenant_id, $pay_slip_id)
    {
        return $this->getPaySlipAsyncWithHttpInfo($xero_tenant_id, $pay_slip_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPaySlipAsyncWithHttpInfo
     * Retrieves a specific payslip by a unique pay slip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPaySlipAsyncWithHttpInfo($xero_tenant_id, $pay_slip_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject';
        $request = $this->getPaySlipRequest($xero_tenant_id, $pay_slip_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaySlip'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPaySlipRequest($xero_tenant_id, $pay_slip_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPaySlip'
            );
        }
        // verify the required parameter 'pay_slip_id' is set
        if ($pay_slip_id === null || (is_array($pay_slip_id) && count($pay_slip_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_slip_id when calling getPaySlip'
            );
        }
        $resourcePath = '/PaySlips/{PaySlipID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_slip_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PaySlipID' . '}',
                PayrollNzObjectSerializer::toPathValue($pay_slip_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaySlips
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PaySlips
     */
    public function getPaySlips($xero_tenant_id, $pay_run_id, $page = null)
    {
        list($response) = $this->getPaySlipsWithHttpInfo($xero_tenant_id, $pay_run_id, $page);
        return $response;
    }
    /**
     * Operation getPaySlipsWithHttpInfo
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PaySlips, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaySlipsWithHttpInfo($xero_tenant_id, $pay_run_id, $page = null)
    {
        $request = $this->getPaySlipsRequest($xero_tenant_id, $pay_run_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PaySlips' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlips', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlips';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlips',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPaySlipsAsync
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaySlipsAsync($xero_tenant_id, $pay_run_id, $page = null)
    {
        return $this->getPaySlipsAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPaySlipsAsyncWithHttpInfo
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPaySlipsAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlips';
        $request = $this->getPaySlipsRequest($xero_tenant_id, $pay_run_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaySlips'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPaySlipsRequest($xero_tenant_id, $pay_run_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPaySlips'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling getPaySlips'
            );
        }
        $resourcePath = '/PaySlips';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($pay_run_id !== null) {
            $queryParams['PayRunID'] = PayrollNzObjectSerializer::toQueryValue($pay_run_id);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReimbursement
     * Retrieves a specific reimbursement by using a unique reimbursement ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject
     */
    public function getReimbursement($xero_tenant_id, $reimbursement_id)
    {
        list($response) = $this->getReimbursementWithHttpInfo($xero_tenant_id, $reimbursement_id);
        return $response;
    }
    /**
     * Operation getReimbursementWithHttpInfo
     * Retrieves a specific reimbursement by using a unique reimbursement ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReimbursementWithHttpInfo($xero_tenant_id, $reimbursement_id)
    {
        $request = $this->getReimbursementRequest($xero_tenant_id, $reimbursement_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getReimbursementAsync
     * Retrieves a specific reimbursement by using a unique reimbursement ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReimbursementAsync($xero_tenant_id, $reimbursement_id)
    {
        return $this->getReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getReimbursementAsyncWithHttpInfo
     * Retrieves a specific reimbursement by using a unique reimbursement ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\ReimbursementObject';
        $request = $this->getReimbursementRequest($xero_tenant_id, $reimbursement_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReimbursement'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getReimbursementRequest($xero_tenant_id, $reimbursement_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getReimbursement'
            );
        }
        // verify the required parameter 'reimbursement_id' is set
        if ($reimbursement_id === null || (is_array($reimbursement_id) && count($reimbursement_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reimbursement_id when calling getReimbursement'
            );
        }
        $resourcePath = '/Reimbursements/{ReimbursementID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($reimbursement_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ReimbursementID' . '}',
                PayrollNzObjectSerializer::toPathValue($reimbursement_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReimbursements
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements
     */
    public function getReimbursements($xero_tenant_id, $page = null)
    {
        list($response) = $this->getReimbursementsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getReimbursementsWithHttpInfo
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReimbursementsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getReimbursementsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getReimbursementsAsync
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReimbursementsAsync($xero_tenant_id, $page = null)
    {
        return $this->getReimbursementsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getReimbursementsAsyncWithHttpInfo
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getReimbursementsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Reimbursements';
        $request = $this->getReimbursementsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReimbursements'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getReimbursementsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getReimbursements'
            );
        }
        $resourcePath = '/Reimbursements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSettings
     * Retrieves settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\Settings
     */
    public function getSettings($xero_tenant_id)
    {
        list($response) = $this->getSettingsWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getSettingsWithHttpInfo
     * Retrieves settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\Settings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingsWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getSettingsRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Settings' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Settings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Settings';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Settings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSettingsAsync
     * Retrieves settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsync($xero_tenant_id)
    {
        return $this->getSettingsAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSettingsAsyncWithHttpInfo
     * Retrieves settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSettingsAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Settings';
        $request = $this->getSettingsRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSettings'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSettingsRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSettings'
            );
        }
        $resourcePath = '/Settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStatutoryDeduction
     * Retrieves a specific statutory deduction by using a unique statutory deductions id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the statutory deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject
     */
    public function getStatutoryDeduction($xero_tenant_id, $id)
    {
        list($response) = $this->getStatutoryDeductionWithHttpInfo($xero_tenant_id, $id);
        return $response;
    }
    /**
     * Operation getStatutoryDeductionWithHttpInfo
     * Retrieves a specific statutory deduction by using a unique statutory deductions id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the statutory deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStatutoryDeductionWithHttpInfo($xero_tenant_id, $id)
    {
        $request = $this->getStatutoryDeductionRequest($xero_tenant_id, $id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getStatutoryDeductionAsync
     * Retrieves a specific statutory deduction by using a unique statutory deductions id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the statutory deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStatutoryDeductionAsync($xero_tenant_id, $id)
    {
        return $this->getStatutoryDeductionAsyncWithHttpInfo($xero_tenant_id, $id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getStatutoryDeductionAsyncWithHttpInfo
     * Retrieves a specific statutory deduction by using a unique statutory deductions id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the statutory deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getStatutoryDeductionAsyncWithHttpInfo($xero_tenant_id, $id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductionObject';
        $request = $this->getStatutoryDeductionRequest($xero_tenant_id, $id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStatutoryDeduction'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the statutory deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getStatutoryDeductionRequest($xero_tenant_id, $id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getStatutoryDeduction'
            );
        }
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getStatutoryDeduction'
            );
        }
        $resourcePath = '/StatutoryDeductions/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                PayrollNzObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStatutoryDeductions
     * Retrieves statutory deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions
     */
    public function getStatutoryDeductions($xero_tenant_id, $page = null)
    {
        list($response) = $this->getStatutoryDeductionsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getStatutoryDeductionsWithHttpInfo
     * Retrieves statutory deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStatutoryDeductionsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getStatutoryDeductionsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getStatutoryDeductionsAsync
     * Retrieves statutory deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStatutoryDeductionsAsync($xero_tenant_id, $page = null)
    {
        return $this->getStatutoryDeductionsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getStatutoryDeductionsAsyncWithHttpInfo
     * Retrieves statutory deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getStatutoryDeductionsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\StatutoryDeductions';
        $request = $this->getStatutoryDeductionsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStatutoryDeductions'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getStatutoryDeductionsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getStatutoryDeductions'
            );
        }
        $resourcePath = '/StatutoryDeductions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuperannuation
     * Retrieves a specific superannuation using a unique superannuation ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $superannuation_id Identifier for the superannuation (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject
     */
    public function getSuperannuation($xero_tenant_id, $superannuation_id)
    {
        list($response) = $this->getSuperannuationWithHttpInfo($xero_tenant_id, $superannuation_id);
        return $response;
    }
    /**
     * Operation getSuperannuationWithHttpInfo
     * Retrieves a specific superannuation using a unique superannuation ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $superannuation_id Identifier for the superannuation (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuperannuationWithHttpInfo($xero_tenant_id, $superannuation_id)
    {
        $request = $this->getSuperannuationRequest($xero_tenant_id, $superannuation_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSuperannuationAsync
     * Retrieves a specific superannuation using a unique superannuation ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $superannuation_id Identifier for the superannuation (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuperannuationAsync($xero_tenant_id, $superannuation_id)
    {
        return $this->getSuperannuationAsyncWithHttpInfo($xero_tenant_id, $superannuation_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSuperannuationAsyncWithHttpInfo
     * Retrieves a specific superannuation using a unique superannuation ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $superannuation_id Identifier for the superannuation (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSuperannuationAsyncWithHttpInfo($xero_tenant_id, $superannuation_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SuperannuationObject';
        $request = $this->getSuperannuationRequest($xero_tenant_id, $superannuation_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuperannuation'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $superannuation_id Identifier for the superannuation (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSuperannuationRequest($xero_tenant_id, $superannuation_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSuperannuation'
            );
        }
        // verify the required parameter 'superannuation_id' is set
        if ($superannuation_id === null || (is_array($superannuation_id) && count($superannuation_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $superannuation_id when calling getSuperannuation'
            );
        }
        $resourcePath = '/Superannuations/{SuperannuationID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($superannuation_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SuperannuationID' . '}',
                PayrollNzObjectSerializer::toPathValue($superannuation_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuperannuations
     * Retrieves superannuations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\Superannuations
     */
    public function getSuperannuations($xero_tenant_id, $page = null)
    {
        list($response) = $this->getSuperannuationsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getSuperannuationsWithHttpInfo
     * Retrieves superannuations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\Superannuations, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuperannuationsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getSuperannuationsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Superannuations' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Superannuations', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Superannuations';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Superannuations',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSuperannuationsAsync
     * Retrieves superannuations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuperannuationsAsync($xero_tenant_id, $page = null)
    {
        return $this->getSuperannuationsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSuperannuationsAsyncWithHttpInfo
     * Retrieves superannuations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSuperannuationsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Superannuations';
        $request = $this->getSuperannuationsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuperannuations'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSuperannuationsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSuperannuations'
            );
        }
        $resourcePath = '/Superannuations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTimesheet
     * Retrieves a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject
     */
    public function getTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->getTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation getTimesheetWithHttpInfo
     * Retrieves a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->getTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTimesheetAsync
     * Retrieves a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->getTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTimesheetAsyncWithHttpInfo
     * Retrieves a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
        $request = $this->getTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling getTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTimesheets
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by employeeId and/or payrollCalendarId (optional)
     * @param  string $status filter results by any timesheets with a matching timesheet status (optional)
     * @param  string $start_date filter results by any timesheets with a startDate on or after the provided date (optional)
     * @param  string $end_date filter results by any timesheets with a endDate on or before the provided date (optional)
     * @param  string $sort sort the order of timesheets returned. The default is based on the timesheets createdDate, sorted oldest to newest. Currently, the only other option is to reverse the order based on the timesheets startDate, sorted newest to oldest. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\Timesheets
     */
    public function getTimesheets($xero_tenant_id, $page = null, $filter = null, $status = null, $start_date = null, $end_date = null, $sort = null)
    {
        list($response) = $this->getTimesheetsWithHttpInfo($xero_tenant_id, $page, $filter, $status, $start_date, $end_date, $sort);
        return $response;
    }
    /**
     * Operation getTimesheetsWithHttpInfo
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by employeeId and/or payrollCalendarId (optional)
     * @param  string $status filter results by any timesheets with a matching timesheet status (optional)
     * @param  string $start_date filter results by any timesheets with a startDate on or after the provided date (optional)
     * @param  string $end_date filter results by any timesheets with a endDate on or before the provided date (optional)
     * @param  string $sort sort the order of timesheets returned. The default is based on the timesheets createdDate, sorted oldest to newest. Currently, the only other option is to reverse the order based on the timesheets startDate, sorted newest to oldest. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\Timesheets, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTimesheetsWithHttpInfo($xero_tenant_id, $page = null, $filter = null, $status = null, $start_date = null, $end_date = null, $sort = null)
    {
        $request = $this->getTimesheetsRequest($xero_tenant_id, $page, $filter, $status, $start_date, $end_date, $sort);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Timesheets' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Timesheets', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Timesheets';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Timesheets',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTimesheetsAsync
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by employeeId and/or payrollCalendarId (optional)
     * @param  string $status filter results by any timesheets with a matching timesheet status (optional)
     * @param  string $start_date filter results by any timesheets with a startDate on or after the provided date (optional)
     * @param  string $end_date filter results by any timesheets with a endDate on or before the provided date (optional)
     * @param  string $sort sort the order of timesheets returned. The default is based on the timesheets createdDate, sorted oldest to newest. Currently, the only other option is to reverse the order based on the timesheets startDate, sorted newest to oldest. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTimesheetsAsync($xero_tenant_id, $page = null, $filter = null, $status = null, $start_date = null, $end_date = null, $sort = null)
    {
        return $this->getTimesheetsAsyncWithHttpInfo($xero_tenant_id, $page, $filter, $status, $start_date, $end_date, $sort)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTimesheetsAsyncWithHttpInfo
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by employeeId and/or payrollCalendarId (optional)
     * @param  string $status filter results by any timesheets with a matching timesheet status (optional)
     * @param  string $start_date filter results by any timesheets with a startDate on or after the provided date (optional)
     * @param  string $end_date filter results by any timesheets with a endDate on or before the provided date (optional)
     * @param  string $sort sort the order of timesheets returned. The default is based on the timesheets createdDate, sorted oldest to newest. Currently, the only other option is to reverse the order based on the timesheets startDate, sorted newest to oldest. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTimesheetsAsyncWithHttpInfo($xero_tenant_id, $page = null, $filter = null, $status = null, $start_date = null, $end_date = null, $sort = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\Timesheets';
        $request = $this->getTimesheetsRequest($xero_tenant_id, $page, $filter, $status, $start_date, $end_date, $sort);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTimesheets'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by employeeId and/or payrollCalendarId (optional)
     * @param  string $status filter results by any timesheets with a matching timesheet status (optional)
     * @param  string $start_date filter results by any timesheets with a startDate on or after the provided date (optional)
     * @param  string $end_date filter results by any timesheets with a endDate on or before the provided date (optional)
     * @param  string $sort sort the order of timesheets returned. The default is based on the timesheets createdDate, sorted oldest to newest. Currently, the only other option is to reverse the order based on the timesheets startDate, sorted newest to oldest. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTimesheetsRequest($xero_tenant_id, $page = null, $filter = null, $status = null, $start_date = null, $end_date = null, $sort = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTimesheets'
            );
        }
        $resourcePath = '/Timesheets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollNzObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($filter !== null) {
            $queryParams['filter'] = PayrollNzObjectSerializer::toQueryValue($filter);
        }
        // query params
        if ($status !== null) {
            $queryParams['status'] = PayrollNzObjectSerializer::toQueryValue($status);
        }
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = PayrollNzObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = PayrollNzObjectSerializer::toQueryValue($end_date);
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = PayrollNzObjectSerializer::toQueryValue($sort);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTrackingCategories
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories
     */
    public function getTrackingCategories($xero_tenant_id)
    {
        list($response) = $this->getTrackingCategoriesWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getTrackingCategoriesWithHttpInfo
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTrackingCategoriesWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getTrackingCategoriesRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTrackingCategoriesAsync
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTrackingCategoriesAsync($xero_tenant_id)
    {
        return $this->getTrackingCategoriesAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTrackingCategoriesAsyncWithHttpInfo
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTrackingCategoriesAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TrackingCategories';
        $request = $this->getTrackingCategoriesRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTrackingCategories'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTrackingCategoriesRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTrackingCategories'
            );
        }
        $resourcePath = '/Settings/TrackingCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation revertTimesheet
     * Reverts a timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function revertTimesheet($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        list($response) = $this->revertTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key);
        return $response;
    }
    /**
     * Operation revertTimesheetWithHttpInfo
     * Reverts a timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function revertTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        $request = $this->revertTimesheetRequest($xero_tenant_id, $timesheet_id, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation revertTimesheetAsync
     * Reverts a timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function revertTimesheetAsync($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        return $this->revertTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation revertTimesheetAsyncWithHttpInfo
     * Reverts a timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function revertTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetObject';
        $request = $this->revertTimesheetRequest($xero_tenant_id, $timesheet_id, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'revertTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function revertTimesheetRequest($xero_tenant_id, $timesheet_id, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling revertTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling revertTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/RevertToDraft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployee
     * Updates an existing employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updateEmployee($xero_tenant_id, $employee_id, $employee, $idempotency_key = null)
    {
        list($response) = $this->updateEmployeeWithHttpInfo($xero_tenant_id, $employee_id, $employee, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateEmployeeWithHttpInfo
     * Updates an existing employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeWithHttpInfo($xero_tenant_id, $employee_id, $employee, $idempotency_key = null)
    {
        $request = $this->updateEmployeeRequest($xero_tenant_id, $employee_id, $employee, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeAsync
     * Updates an existing employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeAsync($xero_tenant_id, $employee_id, $employee, $idempotency_key = null)
    {
        return $this->updateEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeAsyncWithHttpInfo
     * Updates an existing employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeObject';
        $request = $this->updateEmployeeRequest($xero_tenant_id, $employee_id, $employee, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\Employee $employee (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeRequest($xero_tenant_id, $employee_id, $employee, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployee'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployee'
            );
        }
        // verify the required parameter 'employee' is set
        if ($employee === null || (is_array($employee) && count($employee) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee when calling updateEmployee'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeEarningsTemplate
     * Updates an earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updateEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key = null)
    {
        list($response) = $this->updateEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateEmployeeEarningsTemplateWithHttpInfo
     * Updates an earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key = null)
    {
        $request = $this->updateEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeEarningsTemplateAsync
     * Updates an earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key = null)
    {
        return $this->updateEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeEarningsTemplateAsyncWithHttpInfo
     * Updates an earnings template records for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplateObject';
        $request = $this->updateEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EarningsTemplate $earnings_template (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'pay_template_earning_id' is set
        if ($pay_template_earning_id === null || (is_array($pay_template_earning_id) && count($pay_template_earning_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_template_earning_id when calling updateEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'earnings_template' is set
        if ($earnings_template === null || (is_array($earnings_template) && count($earnings_template) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_template when calling updateEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates/Earnings/{PayTemplateEarningID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($pay_template_earning_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayTemplateEarningID' . '}',
                PayrollNzObjectSerializer::toPathValue($pay_template_earning_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_template)) {
            $_tempBody = $earnings_template;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeLeave
     * Updates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updateEmployeeLeave($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key = null)
    {
        list($response) = $this->updateEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateEmployeeLeaveWithHttpInfo
     * Updates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key = null)
    {
        $request = $this->updateEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeLeaveAsync
     * Updates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeLeaveAsync($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key = null)
    {
        return $this->updateEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeLeaveAsyncWithHttpInfo
     * Updates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeaveObject';
        $request = $this->updateEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeLeave $employee_leave (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id, $employee_leave, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeLeave'
            );
        }
        // verify the required parameter 'leave_id' is set
        if ($leave_id === null || (is_array($leave_id) && count($leave_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_id when calling updateEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_leave' is set
        if ($employee_leave === null || (is_array($employee_leave) && count($employee_leave) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave when calling updateEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave/{LeaveID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($leave_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveID' . '}',
                PayrollNzObjectSerializer::toPathValue($leave_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave)) {
            $_tempBody = $employee_leave;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeSalaryAndWage
     * Updates an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updateEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key = null)
    {
        list($response) = $this->updateEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateEmployeeSalaryAndWageWithHttpInfo
     * Updates an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key = null)
    {
        $request = $this->updateEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeSalaryAndWageAsync
     * Updates an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key = null)
    {
        return $this->updateEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeSalaryAndWageAsyncWithHttpInfo
     * Updates an employee's salary and wages record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWageObject';
        $request = $this->updateEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\SalaryAndWage $salary_and_wage (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wages_id' is set
        if ($salary_and_wages_id === null || (is_array($salary_and_wages_id) && count($salary_and_wages_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wages_id when calling updateEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wage' is set
        if ($salary_and_wage === null || (is_array($salary_and_wage) && count($salary_and_wage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wage when calling updateEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($salary_and_wages_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SalaryAndWagesID' . '}',
                PayrollNzObjectSerializer::toPathValue($salary_and_wages_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($salary_and_wage)) {
            $_tempBody = $salary_and_wage;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeTax
     * Updates the tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTax $employee_tax employee_tax (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject
     */
    public function updateEmployeeTax($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key = null)
    {
        list($response) = $this->updateEmployeeTaxWithHttpInfo($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateEmployeeTaxWithHttpInfo
     * Updates the tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTax $employee_tax (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeTaxWithHttpInfo($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key = null)
    {
        $request = $this->updateEmployeeTaxRequest($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeTaxAsync
     * Updates the tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTax $employee_tax (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeTaxAsync($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key = null)
    {
        return $this->updateEmployeeTaxAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeTaxAsyncWithHttpInfo
     * Updates the tax records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTax $employee_tax (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeTaxAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTaxObject';
        $request = $this->updateEmployeeTaxRequest($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeTax'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\EmployeeTax $employee_tax (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeTaxRequest($xero_tenant_id, $employee_id, $employee_tax, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeTax'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeTax'
            );
        }
        // verify the required parameter 'employee_tax' is set
        if ($employee_tax === null || (is_array($employee_tax) && count($employee_tax) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_tax when calling updateEmployeeTax'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Tax';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollNzObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_tax)) {
            $_tempBody = $employee_tax;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePayRun
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updatePayRun($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key = null)
    {
        list($response) = $this->updatePayRunWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key);
        return $response;
    }
    /**
     * Operation updatePayRunWithHttpInfo
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePayRunWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key = null)
    {
        $request = $this->updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updatePayRunAsync
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePayRunAsync($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key = null)
    {
        return $this->updatePayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updatePayRunAsyncWithHttpInfo
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updatePayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PayRunObject';
        $request = $this->updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PayRun $pay_run (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updatePayRun'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling updatePayRun'
            );
        }
        // verify the required parameter 'pay_run' is set
        if ($pay_run === null || (is_array($pay_run) && count($pay_run) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run when calling updatePayRun'
            );
        }
        $resourcePath = '/PayRuns/{PayRunID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($pay_run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunID' . '}',
                PayrollNzObjectSerializer::toPathValue($pay_run_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run)) {
            $_tempBody = $pay_run;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePaySlipLineItems
     * Creates an employee pay slip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaySlip $pay_slip pay_slip (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updatePaySlipLineItems($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key = null)
    {
        list($response) = $this->updatePaySlipLineItemsWithHttpInfo($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key);
        return $response;
    }
    /**
     * Operation updatePaySlipLineItemsWithHttpInfo
     * Creates an employee pay slip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaySlip $pay_slip (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePaySlipLineItemsWithHttpInfo($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key = null)
    {
        $request = $this->updatePaySlipLineItemsRequest($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updatePaySlipLineItemsAsync
     * Creates an employee pay slip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaySlip $pay_slip (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePaySlipLineItemsAsync($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key = null)
    {
        return $this->updatePaySlipLineItemsAsyncWithHttpInfo($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updatePaySlipLineItemsAsyncWithHttpInfo
     * Creates an employee pay slip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaySlip $pay_slip (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updatePaySlipLineItemsAsyncWithHttpInfo($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\PaySlipObject';
        $request = $this->updatePaySlipLineItemsRequest($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePaySlipLineItems'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_slip_id Identifier for the payslip (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\PaySlip $pay_slip (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updatePaySlipLineItemsRequest($xero_tenant_id, $pay_slip_id, $pay_slip, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updatePaySlipLineItems'
            );
        }
        // verify the required parameter 'pay_slip_id' is set
        if ($pay_slip_id === null || (is_array($pay_slip_id) && count($pay_slip_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_slip_id when calling updatePaySlipLineItems'
            );
        }
        // verify the required parameter 'pay_slip' is set
        if ($pay_slip === null || (is_array($pay_slip) && count($pay_slip) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_slip when calling updatePaySlipLineItems'
            );
        }
        $resourcePath = '/PaySlips/{PaySlipID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($pay_slip_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PaySlipID' . '}',
                PayrollNzObjectSerializer::toPathValue($pay_slip_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($pay_slip)) {
            $_tempBody = $pay_slip;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateTimesheetLine
     * Updates a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem
     */
    public function updateTimesheetLine($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key = null)
    {
        list($response) = $this->updateTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateTimesheetLineWithHttpInfo
     * Updates a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollNz\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key = null)
    {
        $request = $this->updateTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollNz\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollNz\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollNzObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollNz\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateTimesheetLineAsync
     * Updates a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTimesheetLineAsync($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key = null)
    {
        return $this->updateTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateTimesheetLineAsyncWithHttpInfo
     * Updates a timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLineObject';
        $request = $this->updateTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollNzObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateTimesheetLine'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollNz\TimesheetLine $timesheet_line (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling updateTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line_id' is set
        if ($timesheet_line_id === null || (is_array($timesheet_line_id) && count($timesheet_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line_id when calling updateTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line' is set
        if ($timesheet_line === null || (is_array($timesheet_line) && count($timesheet_line) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line when calling updateTimesheetLine'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollNzObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = PayrollNzObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // path params
        if ($timesheet_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetLineID' . '}',
                PayrollNzObjectSerializer::toPathValue($timesheet_line_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet_line)) {
            $_tempBody = $timesheet_line;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollNzObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollNz() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
