<?php
/**
 * TrialBalanceAccount
 *
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Finance API
 *
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Models\Finance;

use \ArrayAccess;
use \XeroAPI\XeroPHP\FinanceObjectSerializer;
use \XeroAPI\XeroPHP\StringUtil;
use ReturnTypeWillChange;

/**
 * TrialBalanceAccount Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TrialBalanceAccount implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TrialBalanceAccount';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'account_id' => 'string',
        'account_type' => 'string',
        'account_code' => 'string',
        'account_class' => 'string',
        'status' => 'string',
        'reporting_code' => 'string',
        'account_name' => 'string',
        'balance' => '\XeroAPI\XeroPHP\Models\Finance\TrialBalanceEntry',
        'signed_balance' => 'double',
        'account_movement' => '\XeroAPI\XeroPHP\Models\Finance\TrialBalanceMovement'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'account_id' => 'uuid',
        'account_type' => null,
        'account_code' => null,
        'account_class' => null,
        'status' => null,
        'reporting_code' => null,
        'account_name' => null,
        'balance' => null,
        'signed_balance' => 'double',
        'account_movement' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_id' => 'accountId',
        'account_type' => 'accountType',
        'account_code' => 'accountCode',
        'account_class' => 'accountClass',
        'status' => 'status',
        'reporting_code' => 'reportingCode',
        'account_name' => 'accountName',
        'balance' => 'balance',
        'signed_balance' => 'signedBalance',
        'account_movement' => 'accountMovement'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_id' => 'setAccountId',
        'account_type' => 'setAccountType',
        'account_code' => 'setAccountCode',
        'account_class' => 'setAccountClass',
        'status' => 'setStatus',
        'reporting_code' => 'setReportingCode',
        'account_name' => 'setAccountName',
        'balance' => 'setBalance',
        'signed_balance' => 'setSignedBalance',
        'account_movement' => 'setAccountMovement'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_id' => 'getAccountId',
        'account_type' => 'getAccountType',
        'account_code' => 'getAccountCode',
        'account_class' => 'getAccountClass',
        'status' => 'getStatus',
        'reporting_code' => 'getReportingCode',
        'account_name' => 'getAccountName',
        'balance' => 'getBalance',
        'signed_balance' => 'getSignedBalance',
        'account_movement' => 'getAccountMovement'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_id'] = isset($data['account_id']) ? $data['account_id'] : null;
        $this->container['account_type'] = isset($data['account_type']) ? $data['account_type'] : null;
        $this->container['account_code'] = isset($data['account_code']) ? $data['account_code'] : null;
        $this->container['account_class'] = isset($data['account_class']) ? $data['account_class'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['reporting_code'] = isset($data['reporting_code']) ? $data['reporting_code'] : null;
        $this->container['account_name'] = isset($data['account_name']) ? $data['account_name'] : null;
        $this->container['balance'] = isset($data['balance']) ? $data['balance'] : null;
        $this->container['signed_balance'] = isset($data['signed_balance']) ? $data['signed_balance'] : null;
        $this->container['account_movement'] = isset($data['account_movement']) ? $data['account_movement'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account_id
     *
     * @return string|null
     */
    public function getAccountId()
    {
        return $this->container['account_id'];
    }

    /**
     * Sets account_id
     *
     * @param string|null $account_id ID of the account
     *
     * @return $this
     */
    public function setAccountId($account_id)
    {

        $this->container['account_id'] = $account_id;

        return $this;
    }



    /**
     * Gets account_type
     *
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->container['account_type'];
    }

    /**
     * Sets account_type
     *
     * @param string|null $account_type The type of the account. See <a href='https://developer.xero.com/documentation/api/types#AccountTypes'>Account Types</a>
     *
     * @return $this
     */
    public function setAccountType($account_type)
    {

        $this->container['account_type'] = $account_type;

        return $this;
    }



    /**
     * Gets account_code
     *
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->container['account_code'];
    }

    /**
     * Sets account_code
     *
     * @param string|null $account_code Customer defined alpha numeric account code e.g 200 or SALES
     *
     * @return $this
     */
    public function setAccountCode($account_code)
    {

        $this->container['account_code'] = $account_code;

        return $this;
    }



    /**
     * Gets account_class
     *
     * @return string|null
     */
    public function getAccountClass()
    {
        return $this->container['account_class'];
    }

    /**
     * Sets account_class
     *
     * @param string|null $account_class The class of the account. See <a href='https://developer.xero.com/documentation/api/types#AccountClassTypes'>Account Class Types</a>
     *
     * @return $this
     */
    public function setAccountClass($account_class)
    {

        $this->container['account_class'] = $account_class;

        return $this;
    }



    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Accounts with a status of ACTIVE can be updated to ARCHIVED. See <a href='https://developer.xero.com/documentation/api/types#AccountStatusCodes'>Account Status Codes</a>
     *
     * @return $this
     */
    public function setStatus($status)
    {

        $this->container['status'] = $status;

        return $this;
    }



    /**
     * Gets reporting_code
     *
     * @return string|null
     */
    public function getReportingCode()
    {
        return $this->container['reporting_code'];
    }

    /**
     * Sets reporting_code
     *
     * @param string|null $reporting_code Reporting code (Shown if set)
     *
     * @return $this
     */
    public function setReportingCode($reporting_code)
    {

        $this->container['reporting_code'] = $reporting_code;

        return $this;
    }



    /**
     * Gets account_name
     *
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->container['account_name'];
    }

    /**
     * Sets account_name
     *
     * @param string|null $account_name Name of the account
     *
     * @return $this
     */
    public function setAccountName($account_name)
    {

        $this->container['account_name'] = $account_name;

        return $this;
    }



    /**
     * Gets balance
     *
     * @return \XeroAPI\XeroPHP\Models\Finance\TrialBalanceEntry|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param \XeroAPI\XeroPHP\Models\Finance\TrialBalanceEntry|null $balance balance
     *
     * @return $this
     */
    public function setBalance($balance)
    {

        $this->container['balance'] = $balance;

        return $this;
    }



    /**
     * Gets signed_balance
     *
     * @return double|null
     */
    public function getSignedBalance()
    {
        return $this->container['signed_balance'];
    }

    /**
     * Sets signed_balance
     *
     * @param double|null $signed_balance Value of balance. Expense and Asset accounts code debits as positive. Revenue, Liability, and Equity accounts code debits as negative
     *
     * @return $this
     */
    public function setSignedBalance($signed_balance)
    {

        $this->container['signed_balance'] = $signed_balance;

        return $this;
    }



    /**
     * Gets account_movement
     *
     * @return \XeroAPI\XeroPHP\Models\Finance\TrialBalanceMovement|null
     */
    public function getAccountMovement()
    {
        return $this->container['account_movement'];
    }

    /**
     * Sets account_movement
     *
     * @param \XeroAPI\XeroPHP\Models\Finance\TrialBalanceMovement|null $account_movement account_movement
     *
     * @return $this
     */
    public function setAccountMovement($account_movement)
    {

        $this->container['account_movement'] = $account_movement;

        return $this;
    }


    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            FinanceObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


