<?php
/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 */

$aConfig = array(
    /**
     * Main Section.
     */
    'title' => 'Xero',
    'version_from' => '13.0.2',
    'version_to' => '14.0.0',
    'vendor' => 'BoonEx',

    'compatible_with' => array(
        '14.0.0'
    ),

    /**
     * 'home_dir' and 'home_uri' - should be unique. Don't use spaces in 'home_uri' and the other special chars.
     */
    'home_dir' => 'boonex/xero/updates/update_13.0.2_14.0.0/',
    'home_uri' => 'xero_update_1302_1400',

    'module_dir' => 'boonex/xero/',
    'module_uri' => 'xero',

    'db_prefix' => 'bx_xero_',
    'class_prefix' => 'BxXero',

    /**
     * Installation/Uninstallation Section.
     */
    'install' => array(
        'execute_sql' => 0,
        'update_files' => 1,
        'update_languages' => 0,
        'clear_db_cache' => 0,
    ),

    /**
     * Category for language keys.
     */
    'language_category' => 'Xero',

    /**
     * Files Section
     */
    'delete_files' => array(
        'plugins/guzzlehttp/guzzle/vendor-bin/php-cs-fixer/composer.json',
        'plugins/guzzlehttp/guzzle/vendor-bin/phpstan/composer.json',
        'plugins/guzzlehttp/guzzle/vendor-bin/psalm/composer.json',
        'plugins/guzzlehttp/promises/src/functions.php',
        'plugins/guzzlehttp/promises/src/functions_include.php',
        'plugins/guzzlehttp/promises/Makefile',
        'plugins/guzzlehttp/psr7/vendor-bin/php-cs-fixer/composer.json',
        'plugins/guzzlehttp/psr7/vendor-bin/phpstan/composer.json',
        'plugins/guzzlehttp/psr7/vendor-bin/psalm/composer.json',
        'plugins/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php',
        'plugins/monolog/monolog/src/Monolog/Formatter/JsonFormatter.php',
        'plugins/monolog/monolog/src/Monolog/Formatter/LineFormatter.php',
        'plugins/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php',
        'plugins/monolog/monolog/src/Monolog/Handler/AbstractHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/BufferHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/GroupHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/HandlerInterface.php',
        'plugins/monolog/monolog/src/Monolog/Handler/MailHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/NullHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/StreamHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/SwiftMailerHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/SyslogHandler.php',
        'plugins/monolog/monolog/src/Monolog/Handler/TestHandler.php',
        'plugins/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php',
        'plugins/monolog/monolog/src/Monolog/Processor/WebProcessor.php',
        'plugins/monolog/monolog/src/Monolog/Logger.php',
        'plugins/monolog/monolog/tests/Monolog/Formatter/JsonFormatterTest.php',
        'plugins/monolog/monolog/tests/Monolog/Formatter/LineFormatterTest.php',
        'plugins/monolog/monolog/tests/Monolog/Formatter/WildfireFormatterTest.php',
        'plugins/monolog/monolog/tests/Monolog/Functional/Handler/FirePHPHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/Fixtures/.gitkeep',
        'plugins/monolog/monolog/tests/Monolog/Handler/AbstractHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/AbstractProcessingHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/BufferHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/FingersCrossedHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/FirePHPHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/GroupHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/MailHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/NullHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/RotatingFileHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/StreamHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/SyslogHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Handler/TestHandlerTest.php',
        'plugins/monolog/monolog/tests/Monolog/Processor/IntrospectionProcessorTest.php',
        'plugins/monolog/monolog/tests/Monolog/Processor/WebProcessorTest.php',
        'plugins/monolog/monolog/tests/Monolog/LoggerTest.php',
        'plugins/monolog/monolog/tests/Monolog/TestCase.php',
        'plugins/monolog/monolog/tests/bootstrap.php',
        'plugins/monolog/monolog/CHANGELOG.mdown',
        'plugins/monolog/monolog/composer.json',
        'plugins/monolog/monolog/LICENSE',
        'plugins/monolog/monolog/phpunit.xml.dist',
        'plugins/monolog/monolog/README.mdown',
        'plugins/paragonie/random_compat/dist/random_compat.phar.pubkey',
        'plugins/paragonie/random_compat/dist/random_compat.phar.pubkey.asc',
        'plugins/paragonie/random_compat/lib/random.php',
        'plugins/paragonie/random_compat/other/build_phar.php',
        'plugins/paragonie/random_compat/build-phar.sh',
        'plugins/paragonie/random_compat/composer.json',
        'plugins/paragonie/random_compat/LICENSE',
        'plugins/paragonie/random_compat/psalm-autoload.php',
        'plugins/paragonie/random_compat/psalm.xml',
        'plugins/psr/http-factory/.pullapprove.yml',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Api/AccountingApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Account.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Accounts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/AccountsPayable.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/AccountsReceivable.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/AccountType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Action.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Actions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Address.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/AddressForOrganisation.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Allocation.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Allocations.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Attachment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Attachments.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BalanceDetails.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Balances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BankTransaction.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BankTransactions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BankTransfer.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BankTransfers.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BatchPayment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BatchPaymentDetails.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BatchPayments.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Bill.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BrandingTheme.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/BrandingThemes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CISOrgSetting.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CISOrgSettings.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CISSetting.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CISSettings.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Contact.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ContactGroup.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ContactGroups.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ContactPerson.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Contacts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ConversionBalances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ConversionDate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CountryCode.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CreditNote.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CreditNotes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Currencies.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Currency.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/CurrencyCode.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Element.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Employee.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Employees.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Error.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ExpenseClaim.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ExpenseClaims.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ExternalLink.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/HistoryRecord.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/HistoryRecords.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ImportSummary.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ImportSummaryAccounts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ImportSummaryObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ImportSummaryOrganisation.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Invoice.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/InvoiceReminder.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/InvoiceReminders.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Invoices.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Item.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Items.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Journal.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/JournalLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Journals.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/LineAmountTypes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/LineItem.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/LineItemTracking.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/LinkedTransaction.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/LinkedTransactions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ManualJournal.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ManualJournalLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ManualJournals.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/OnlineInvoice.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/OnlineInvoices.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Organisation.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Organisations.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Overpayment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Overpayments.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Payment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PaymentDelete.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Payments.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PaymentService.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PaymentServices.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PaymentTerm.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PaymentTermType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Phone.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Prepayment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Prepayments.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Purchase.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PurchaseOrder.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/PurchaseOrders.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Quote.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/QuoteLineAmountTypes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Quotes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/QuoteStatusCodes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Receipt.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Receipts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/RepeatingInvoice.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/RepeatingInvoices.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Report.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportAttribute.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportCell.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportFields.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportRow.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportRows.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Reports.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportWithRow.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ReportWithRows.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/RequestEmpty.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/RowType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/SalesTrackingCategory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Schedule.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Setup.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/SetupBalanceDetails.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/SetupConversionBalances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/SetupConversionDate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TaxComponent.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TaxRate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TaxRates.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TaxType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TenNinetyNineContact.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TimeZone.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TrackingCategories.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TrackingCategory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TrackingOption.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/TrackingOptions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/User.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/Users.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/Model/ValidationError.md',
        'plugins/xeroapi/xero-php-oauth2/doc/accounting/README.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Api/AssetApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/Asset.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/Assets.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/AssetStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/AssetStatusQueryParam.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/AssetType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/BookDepreciationDetail.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/BookDepreciationSetting.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/Error.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/FieldValidationErrorsElement.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/Pagination.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/ResourceValidationErrorsElement.md',
        'plugins/xeroapi/xero-php-oauth2/doc/assets/Model/Setting.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Api/FilesApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/Association.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/FileObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/FileResponse204.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/Files.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/Folder.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/Folders.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/InlineObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/ObjectGroup.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/ObjectType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/UploadObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/Model/User.md',
        'plugins/xeroapi/xero-php-oauth2/doc/file/README.md',
        'plugins/xeroapi/xero-php-oauth2/doc/identity/Api/IdentityApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/identity/Model/AccessToken.md',
        'plugins/xeroapi/xero-php-oauth2/doc/identity/Model/Connection.md',
        'plugins/xeroapi/xero-php-oauth2/doc/identity/Model/RefreshToken.md',
        'plugins/xeroapi/xero-php-oauth2/doc/identity/README.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Api/PayrollAUApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Account.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/AccountType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/AllowanceType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/APIException.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/BankAccount.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/CalendarType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/DeductionLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/DeductionType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/DeductionTypeCalculationType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EarningsRate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EarningsRateCalculationType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EarningsType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Employee.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Employees.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EmployeeStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EmploymentBasis.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EmploymentTerminationPaymentType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/EntitlementFinalPayPayoutType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/HomeAddress.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveAccrualLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveApplication.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveApplications.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveBalance.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveEarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveLineCalculationType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveLines.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeavePeriod.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeavePeriodStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/LeaveTypeContributionType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/ManualTaxType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/OpeningBalances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayItem.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayItems.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PaymentFrequencyType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayrollCalendar.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayrollCalendars.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayRun.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayRuns.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayRunStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Payslip.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayslipLines.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayslipObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Payslips.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayslipSummary.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/PayTemplate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/RateType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/ReimbursementLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/ReimbursementLines.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/ReimbursementType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/ResidencyStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Settings.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SettingsObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SettingsTrackingCategories.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SettingsTrackingCategoriesEmployeeGroups.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SettingsTrackingCategoriesTimesheetCategories.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/State.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperannuationCalculationType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperannuationContributionType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperannuationLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperFund.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperFundProduct.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperFundProducts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperFunds.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperFundType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/SuperMembership.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/TaxDeclaration.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/TaxLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/TFNExemptionType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Timesheet.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/TimesheetLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/TimesheetObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/Timesheets.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/TimesheetStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/Model/ValidationError.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollau/README.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Api/PayrollNzApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Account.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Accounts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Address.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/BankAccount.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Benefit.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/CalendarType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Deduction.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/DeductionLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/DeductionObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Deductions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsOrder.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsOrderObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsOrders.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsRate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsRateObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsRates.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsTemplate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EarningsTemplateObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Employee.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeEarningsTemplates.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeave.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveBalance.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveBalances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaves.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveSetup.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveSetupObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveTypeObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeLeaveTypes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeOpeningBalance.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeOpeningBalancesObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeePayTemplate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeePayTemplateObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeePayTemplates.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Employees.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutoryLeaveBalance.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutoryLeaveBalanceObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutoryLeavesSummaries.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutoryLeaveSummary.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutorySickLeave.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutorySickLeaveObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeStatutorySickLeaves.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeTax.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmployeeTaxObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Employment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/EmploymentObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/GrossEarningsHistory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/InvalidField.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeaveAccrualLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeaveEarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeavePeriod.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeavePeriods.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeaveType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeaveTypeObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/LeaveTypes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Pagination.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PaymentLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PaymentMethod.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PaymentMethodObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PayRun.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PayRunCalendar.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PayRunCalendarObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PayRunCalendars.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PayRunObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PayRuns.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PaySlip.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PaySlipObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/PaySlips.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Problem.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Reimbursement.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/ReimbursementLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/ReimbursementObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Reimbursements.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/SalaryAndWage.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/SalaryAndWageObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/SalaryAndWages.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Settings.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/StatutoryDeduction.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/StatutoryDeductionCategory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/StatutoryDeductionLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/StatutoryDeductionObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/StatutoryDeductions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/SuperannuationLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/SuperannuationObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Superannuations.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TaxCode.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TaxLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TaxSettings.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Timesheet.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TimesheetEarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TimesheetLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TimesheetLineObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TimesheetObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/Timesheets.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TrackingCategories.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/Model/TrackingCategory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrollnz/README.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Api/PayrollUkApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Account.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Accounts.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Address.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/BankAccount.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Benefit.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/BenefitLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/BenefitObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Benefits.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/CourtOrderLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Deduction.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/DeductionLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/DeductionObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Deductions.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsOrder.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsOrderObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsOrders.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsRate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsRateObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsRates.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsTemplate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EarningsTemplateObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Employee.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeave.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaveBalance.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaveBalances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaveObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaves.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaveType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaveTypeObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeLeaveTypes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeOpeningBalances.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeOpeningBalancesObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeePayTemplate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeePayTemplateObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeePayTemplates.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Employees.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutoryLeaveBalance.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutoryLeaveBalanceObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutoryLeavesSummaries.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutoryLeaveSummary.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutorySickLeave.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutorySickLeaveObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeStatutorySickLeaves.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeTax.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmployeeTaxObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Employment.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/EmploymentObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/InvalidField.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeaveAccrualLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeaveEarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeavePeriod.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeavePeriods.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeaveType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeaveTypeObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/LeaveTypes.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Pagination.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PaymentLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PaymentMethod.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PaymentMethodObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayRun.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayRunCalendar.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayRunCalendarObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayRunCalendars.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayRunObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayRuns.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Payslip.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/PayslipObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Payslips.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Problem.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Reimbursement.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/ReimbursementLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/ReimbursementObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Reimbursements.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/SalaryAndWage.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/SalaryAndWageObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/SalaryAndWages.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Settings.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/StatutoryDeduction.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/StatutoryDeductionCategory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TaxLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Timesheet.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TimesheetEarningsLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TimesheetLine.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TimesheetLineObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TimesheetObject.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/Timesheets.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TrackingCategories.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/Model/TrackingCategory.md',
        'plugins/xeroapi/xero-php-oauth2/doc/payrolluk/README.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Api/ProjectApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Api/ProjectsApi.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Amount.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/ChargeType.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/CurrencyCode.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Error.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Pagination.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Project.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/ProjectCreateOrUpdate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/ProjectPatch.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Projects.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/ProjectStatus.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/ProjectUser.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/ProjectUsers.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Task.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/TaskCreateOrUpdate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/Tasks.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/TimeEntries.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/TimeEntry.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/Model/TimeEntryCreateOrUpdate.md',
        'plugins/xeroapi/xero-php-oauth2/doc/project/README.md',
    ),
);
