<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Iam
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Iam\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class NewApiKeyList extends ListResource
    {
    /**
     * Construct the NewApiKeyList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Keys';
    }

    /**
     * Helper function for Create
     *
     * @param string $accountSid The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Payments resource.
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(string $accountSid, array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'AccountSid' =>
                $accountSid,
            'FriendlyName' =>
                $options['friendlyName'],
            'KeyType' =>
                $options['keyType'],
            'Policy' =>
                Serialize::jsonObject($options['policy']),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the NewApiKeyInstance
     *
     * @param string $accountSid The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Payments resource.
     * @param array|Options $options Optional Arguments
     * @return NewApiKeyInstance Created NewApiKeyInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $accountSid, array $options = []): NewApiKeyInstance
    {
        $response = $this->_create( $accountSid, $options);
        return new NewApiKeyInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the NewApiKeyInstance with Metadata
     *
     * @param string $accountSid The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Payments resource.
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(string $accountSid, array $options = []): ResourceMetadata
    {
        $response = $this->_create( $accountSid, $options);
        $resource = new NewApiKeyInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Iam.V1.NewApiKeyList]';
    }
}
