<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Marketplace
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Marketplace\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class ReferralConversionList extends ListResource
    {
    /**
     * Construct the ReferralConversionList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/ReferralConversion';
    }

    /**
     * Helper function for Create
     *
     * @param CreateReferralConversionRequest $createReferralConversionRequest
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(CreateReferralConversionRequest $createReferralConversionRequest): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $createReferralConversionRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the ReferralConversionInstance
     *
     * @param CreateReferralConversionRequest $createReferralConversionRequest
     * @return ReferralConversionInstance Created ReferralConversionInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(CreateReferralConversionRequest $createReferralConversionRequest): ReferralConversionInstance
    {
        $response = $this->_create( $createReferralConversionRequest);
        return new ReferralConversionInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the ReferralConversionInstance with Metadata
     *
     * @param CreateReferralConversionRequest $createReferralConversionRequest
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(CreateReferralConversionRequest $createReferralConversionRequest): ResourceMetadata
    {
        $response = $this->_create( $createReferralConversionRequest);
        $resource = new ReferralConversionInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Marketplace.V1.ReferralConversionList]';
    }
}
