<?php defined('BX_DOL') or die('hack attempt');
/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 *
 * @defgroup    MediaManager MediaManager
 * @ingroup     UnaModules
 *
 * @{
 */

class BxMediaInstaller extends BxBaseModTextInstaller
{
    protected $_oModule;
    
    function __construct($aConfig)
    {
        parent::__construct($aConfig);   
    }
    
    public function enable($aParams)
    {
        $aResult = parent::enable($aParams);
        if($aResult['result'])
            $this->_saveSettings();
        return $aResult;
    }
    
    public function disable($aParams)
    {
        $aResult = parent::disable($aParams);
        if($aResult['result'])
            $this->_restoreSettings();
        return $aResult;
    }
    
    private function _saveSettings()
    {
		$sObjectUploaderNameDef = 'bx_media_uploader';
		$sObjectUploaderNameAtt = 'bx_media_uploader_attachments';
		
    	$this->oDb->query("INSERT INTO `bx_media_input_settings`(`input_id`, `value`, `values`) SELECT `id`, `value`, `values` FROM `sys_form_inputs` WHERE `type` = 'files'");
        $aInputs = $this->oDb->getAll("SELECT `name`, `id`, `value`, `values`, `module` FROM `sys_form_inputs` WHERE `type` = 'files'");
        foreach($aInputs as $aInput){
			
			$sObjectUploaderName = $sObjectUploaderNameDef;
			// need to fix in future after AL change munu behavour
			if ($aInput['name'] == 'pictures' && $aInput['module'] == 'bx_posts')
				$sObjectUploaderName = $sObjectUploaderNameAtt;
			
			$aValue = $aInput['value'];
			if (substr_count($aInput['value'], 'html5') >0){
				 $aValue = serialize(array($sObjectUploaderName));
			}
			
            $aValues = unserialize($aInput['values']);
            $aValues[$sObjectUploaderName] = _t('_bx_media_uploader_title');
            $aBindings = array(
                'id' => $aInput['id'],
                'values' => serialize($aValues)
            );
            $sQuery = "UPDATE `sys_form_inputs` SET `values`  = :values WHERE `id` = :id";
            $this->oDb->query($sQuery, $aBindings);
        }
		
		$aMenuSets = $this->oDb->getAll("SELECT * FROM `sys_objects_menu` WHERE `override_class_name` like '%MenuAttachment%'");
		foreach($aMenuSets as $aMenuSet){
			
			$aBindings = array(
                'set_name' => $aMenuSet['set_name']
            );
			
			$aMenus = $this->oDb->getAll("SELECT * FROM `sys_menu_items` WHERE `set_name` = :set_name AND name like '%html5'", $aBindings);
			foreach($aMenus as $aMenu){
				$sQuery = "INSERT INTO `sys_menu_items`(`set_name`, `module`, `name`, `title_system`, `title`, `link`, `onclick`, `target`, `icon`, `visible_for_levels`, `active`, `copyable`, `editable`, `order`) VALUES (:set_name, :module, :name, :title_system, :title, :link, :onclick, :target, :icon, :visible_for_levels, :active, :copyable, :editable, :order)";
				$aBindings = array(
					'set_name' => $aMenu['set_name'],
					'module' => 'bx_media',
					'name' => str_replace('html5', 'media manager', $aMenu['name']),
					'title_system' => str_replace('html5', 'Media manager', _t($aMenu['title_system'])),
					'title' => $aMenu['title'],
					'link' => $aMenu['link'],
					'target' => $aMenu['target'],
					'onclick' => 'javascript:{js_object_bx_media_uploader_attachments}.showUploaderForm();',
					'icon' => 'photo-video',
					'visible_for_levels' => $aMenu['visible_for_levels'],
					'active' => 0,
					'copyable' => $aMenu['copyable'],
					'editable' => $aMenu['editable'],
					'order' => $aMenu['order'],
				);
				$this->oDb->query($sQuery, $aBindings);
				
				/*$sQuery = "UPDATE `sys_menu_items` SET active = 0 WHERE id = :id";
				$aBindings = array(
					'id' => $aMenu['id']
				);
				$this->oDb->query($sQuery, $aBindings);*/
			}
		}
    }
    
    private function _restoreSettings()
    {
        $aInputs = $this->oDb->getAll("SELECT `id`, `input_id`, `value`, `values` FROM `bx_media_input_settings`");
        foreach($aInputs as $aInput){
            $aBindings = array(
                'id' => $aInput['input_id'],
                'value' => $aInput['value'],
                'values' => $aInput['values']
            );
            $sQuery = "UPDATE `sys_form_inputs` SET `value` = :value, `values` = :values WHERE `id` = :id";
            $this->oDb->query($sQuery, $aBindings);
            
            $sQuery = "DELETE FROM `bx_media_input_settings` WHERE `id` = :id";
            $aBindings = array(
                'id' => $aInput['id'],
            );
            $this->oDb->query($sQuery, $aBindings);
        }
		
		$aMenuSets = $this->oDb->getAll("SELECT * FROM `sys_objects_menu` WHERE `override_class_name` like '%MenuAttachment%'");
		foreach($aMenuSets as $aMenuSet){
			$aBindings = array(
                'set_name' => $aMenuSet['set_name']
            );
			//$this->oDb->query("UPDATE `sys_menu_items` SET `active` = 1 WHERE `set_name` = :set_name AND `name` like '%html5'", $aBindings);
			$this->oDb->query("DELETE FROM `sys_menu_items` WHERE `set_name` = :set_name AND `module` = 'bx_media'", $aBindings);
		}
    }
}

/** @} */
