<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Lookups\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class LookupOverrideContext extends InstanceContext
    {
    /**
     * Initialize the LookupOverrideContext
     *
     * @param Version $version Version that contains the resource
     * @param string $field
     * @param string $phoneNumber
     */
    public function __construct(
        Version $version,
        $field,
        $phoneNumber
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'field' =>
            $field,
        'phoneNumber' =>
            $phoneNumber,
        ];

        $this->uri = '/PhoneNumbers/' . \rawurlencode($phoneNumber)
        .'/Overrides/' . \rawurlencode($field)
        .'';
    }

    /**
     * Helper function for Create
     *
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $overridesRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the LookupOverrideInstance
     *
     * @return LookupOverrideInstance Created LookupOverrideInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(): LookupOverrideInstance
    {
        $response = $this->_create();
        return new LookupOverrideInstance(
            $this->version,
            $response->getContent(),
            $this->solution['field'],
            $this->solution['phoneNumber']
        );
        
    }

    /**
     * Create the LookupOverrideInstance with Metadata
     *
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(): ResourceMetadata
    {
        $response = $this->_create();
        $resource = new LookupOverrideInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['field'],
                        $this->solution['phoneNumber']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Delete
     *
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the LookupOverrideInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {
        $response = $this->_delete();
        
        return true;
    }

    /**
     * Delete the LookupOverrideInstance with Metadata
     *
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(): ResourceMetadata
    {
        $response = $this->_delete();
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the LookupOverrideInstance
     *
     * @return LookupOverrideInstance Fetched LookupOverrideInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): LookupOverrideInstance
    {
        $response = $this->_fetch();
        return new LookupOverrideInstance(
            $this->version,
            $response->getContent(),
            $this->solution['field'],
            $this->solution['phoneNumber']
        );
        
    }

    /**
     * Fetch the LookupOverrideInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new LookupOverrideInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['field'],
                        $this->solution['phoneNumber']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $overridesRequest->toArray();
        return $this->version->handleRequest('PUT', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the LookupOverrideInstance
     *
     * @return LookupOverrideInstance Updated LookupOverrideInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): LookupOverrideInstance
    {
        $response = $this->_update();
        return new LookupOverrideInstance(
            $this->version,
            $response->getContent(),
            $this->solution['field'],
            $this->solution['phoneNumber']
        );
        
    }

    /**
     * Update the LookupOverrideInstance with Metadata
     *
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(): ResourceMetadata
    {
        $response = $this->_update();
        $resource = new LookupOverrideInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['field'],
                        $this->solution['phoneNumber']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Lookups.V2.LookupOverrideContext ' . \implode(' ', $context) . ']';
    }
}
