<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Video
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Video\V1\Room;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class RecordingRulesList extends ListResource
    {
    /**
     * Construct the RecordingRulesList
     *
     * @param Version $version Version that contains the resource
     * @param string $roomSid The SID of the Room resource where the recording rules to fetch apply.
     */
    public function __construct(
        Version $version,
        string $roomSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'roomSid' =>
            $roomSid,
        
        ];

        $this->uri = '/Rooms/' . \rawurlencode($roomSid)
        .'/RecordingRules';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the RecordingRulesInstance
     *
     * @return RecordingRulesInstance Fetched RecordingRulesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): RecordingRulesInstance
    {
        $response = $this->_fetch();
        return new RecordingRulesInstance(
            $this->version,
            $response->getContent(),
            $this->solution['roomSid']
        );
        
    }

    /**
     * Fetch the RecordingRulesInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new RecordingRulesInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['roomSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'Rules' =>
                Serialize::jsonObject($options['rules']),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the RecordingRulesInstance
     *
     * @param array|Options $options Optional Arguments
     * @return RecordingRulesInstance Updated RecordingRulesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): RecordingRulesInstance
    {
        $response = $this->_update($options);
        return new RecordingRulesInstance(
            $this->version,
            $response->getContent(),
            $this->solution['roomSid']
        );
        
    }

    /**
     * Update the RecordingRulesInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new RecordingRulesInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['roomSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Video.V1.RecordingRulesList]';
    }
}
