<?php
/**
 * FinanceApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP Finance
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Finance API
 *
 * The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.
 *
 * OpenAPI spec version: 9.0.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\FinanceObjectSerializer;

/**
 * FinanceApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FinanceApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getAccountingActivityAccountUsage
     * Get account usage
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_month date, yyyy-MM                 If no parameter is provided, the month 12 months prior to the end month will be used.                Account usage for up to 12 months from this date will be returned. (optional)
     * @param  string $end_month date, yyyy-MM                 If no parameter is provided, the current month will be used.                Account usage for up to 12 months prior to this date will be returned. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getAccountingActivityAccountUsage($xero_tenant_id, $start_month = null, $end_month = null)
    {
        list($response) = $this->getAccountingActivityAccountUsageWithHttpInfo($xero_tenant_id, $start_month, $end_month);
        return $response;
    }
    /**
     * Operation getAccountingActivityAccountUsageWithHttpInfo
     * Get account usage
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_month date, yyyy-MM                 If no parameter is provided, the month 12 months prior to the end month will be used.                Account usage for up to 12 months from this date will be returned. (optional)
     * @param  string $end_month date, yyyy-MM                 If no parameter is provided, the current month will be used.                Account usage for up to 12 months prior to this date will be returned. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountingActivityAccountUsageWithHttpInfo($xero_tenant_id, $start_month = null, $end_month = null)
    {
        $request = $this->getAccountingActivityAccountUsageRequest($xero_tenant_id, $start_month, $end_month);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAccountingActivityAccountUsageAsync
     * Get account usage
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_month date, yyyy-MM                 If no parameter is provided, the month 12 months prior to the end month will be used.                Account usage for up to 12 months from this date will be returned. (optional)
     * @param  string $end_month date, yyyy-MM                 If no parameter is provided, the current month will be used.                Account usage for up to 12 months prior to this date will be returned. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountingActivityAccountUsageAsync($xero_tenant_id, $start_month = null, $end_month = null)
    {
        return $this->getAccountingActivityAccountUsageAsyncWithHttpInfo($xero_tenant_id, $start_month, $end_month)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAccountingActivityAccountUsageAsyncWithHttpInfo
     * Get account usage
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_month date, yyyy-MM                 If no parameter is provided, the month 12 months prior to the end month will be used.                Account usage for up to 12 months from this date will be returned. (optional)
     * @param  string $end_month date, yyyy-MM                 If no parameter is provided, the current month will be used.                Account usage for up to 12 months prior to this date will be returned. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAccountingActivityAccountUsageAsyncWithHttpInfo($xero_tenant_id, $start_month = null, $end_month = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\AccountUsageResponse';
        $request = $this->getAccountingActivityAccountUsageRequest($xero_tenant_id, $start_month, $end_month);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountingActivityAccountUsage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_month date, yyyy-MM                 If no parameter is provided, the month 12 months prior to the end month will be used.                Account usage for up to 12 months from this date will be returned. (optional)
     * @param  string $end_month date, yyyy-MM                 If no parameter is provided, the current month will be used.                Account usage for up to 12 months prior to this date will be returned. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAccountingActivityAccountUsageRequest($xero_tenant_id, $start_month = null, $end_month = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountingActivityAccountUsage'
            );
        }
        $resourcePath = '/AccountingActivities/AccountUsage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($start_month !== null) {
            $queryParams['startMonth'] = FinanceObjectSerializer::toQueryValue($start_month);
        }
        // query params
        if ($end_month !== null) {
            $queryParams['endMonth'] = FinanceObjectSerializer::toQueryValue($end_month);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountingActivityLockHistory
     * Get lock history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any changes to hard or soft lock dates that were made within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a change is visible from this API. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getAccountingActivityLockHistory($xero_tenant_id, $end_date = null)
    {
        list($response) = $this->getAccountingActivityLockHistoryWithHttpInfo($xero_tenant_id, $end_date);
        return $response;
    }
    /**
     * Operation getAccountingActivityLockHistoryWithHttpInfo
     * Get lock history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any changes to hard or soft lock dates that were made within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a change is visible from this API. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountingActivityLockHistoryWithHttpInfo($xero_tenant_id, $end_date = null)
    {
        $request = $this->getAccountingActivityLockHistoryRequest($xero_tenant_id, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAccountingActivityLockHistoryAsync
     * Get lock history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any changes to hard or soft lock dates that were made within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a change is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountingActivityLockHistoryAsync($xero_tenant_id, $end_date = null)
    {
        return $this->getAccountingActivityLockHistoryAsyncWithHttpInfo($xero_tenant_id, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAccountingActivityLockHistoryAsyncWithHttpInfo
     * Get lock history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any changes to hard or soft lock dates that were made within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a change is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAccountingActivityLockHistoryAsyncWithHttpInfo($xero_tenant_id, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\LockHistoryResponse';
        $request = $this->getAccountingActivityLockHistoryRequest($xero_tenant_id, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountingActivityLockHistory'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any changes to hard or soft lock dates that were made within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a change is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAccountingActivityLockHistoryRequest($xero_tenant_id, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountingActivityLockHistory'
            );
        }
        $resourcePath = '/AccountingActivities/LockHistory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountingActivityReportHistory
     * Get report history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any reports that were published within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a published report is visible from this API. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getAccountingActivityReportHistory($xero_tenant_id, $end_date = null)
    {
        list($response) = $this->getAccountingActivityReportHistoryWithHttpInfo($xero_tenant_id, $end_date);
        return $response;
    }
    /**
     * Operation getAccountingActivityReportHistoryWithHttpInfo
     * Get report history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any reports that were published within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a published report is visible from this API. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountingActivityReportHistoryWithHttpInfo($xero_tenant_id, $end_date = null)
    {
        $request = $this->getAccountingActivityReportHistoryRequest($xero_tenant_id, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAccountingActivityReportHistoryAsync
     * Get report history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any reports that were published within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a published report is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountingActivityReportHistoryAsync($xero_tenant_id, $end_date = null)
    {
        return $this->getAccountingActivityReportHistoryAsyncWithHttpInfo($xero_tenant_id, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAccountingActivityReportHistoryAsyncWithHttpInfo
     * Get report history
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any reports that were published within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a published report is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAccountingActivityReportHistoryAsyncWithHttpInfo($xero_tenant_id, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\ReportHistoryResponse';
        $request = $this->getAccountingActivityReportHistoryRequest($xero_tenant_id, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountingActivityReportHistory'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date date, yyyy-MM-dd                 If no parameter is provided, the current date will be used.                Any reports that were published within the period up to 12 months before this date will be returned.                Please be aware that there may be a delay of up to 3 days before a published report is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAccountingActivityReportHistoryRequest($xero_tenant_id, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountingActivityReportHistory'
            );
        }
        $resourcePath = '/AccountingActivities/ReportHistory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAccountingActivityUserActivities
     * Get user activities
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $data_month date, yyyy-MM                 The specified month must be complete (in the past); The current month cannot be specified since it is not complete.                If no parameter is provided, the month immediately previous to the current month will be used.                Any user activities occurring within the specified month will be returned.                Please be aware that there may be a delay of up to 3 days before a user activity is visible from this API. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getAccountingActivityUserActivities($xero_tenant_id, $data_month = null)
    {
        list($response) = $this->getAccountingActivityUserActivitiesWithHttpInfo($xero_tenant_id, $data_month);
        return $response;
    }
    /**
     * Operation getAccountingActivityUserActivitiesWithHttpInfo
     * Get user activities
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $data_month date, yyyy-MM                 The specified month must be complete (in the past); The current month cannot be specified since it is not complete.                If no parameter is provided, the month immediately previous to the current month will be used.                Any user activities occurring within the specified month will be returned.                Please be aware that there may be a delay of up to 3 days before a user activity is visible from this API. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountingActivityUserActivitiesWithHttpInfo($xero_tenant_id, $data_month = null)
    {
        $request = $this->getAccountingActivityUserActivitiesRequest($xero_tenant_id, $data_month);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAccountingActivityUserActivitiesAsync
     * Get user activities
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $data_month date, yyyy-MM                 The specified month must be complete (in the past); The current month cannot be specified since it is not complete.                If no parameter is provided, the month immediately previous to the current month will be used.                Any user activities occurring within the specified month will be returned.                Please be aware that there may be a delay of up to 3 days before a user activity is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAccountingActivityUserActivitiesAsync($xero_tenant_id, $data_month = null)
    {
        return $this->getAccountingActivityUserActivitiesAsyncWithHttpInfo($xero_tenant_id, $data_month)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAccountingActivityUserActivitiesAsyncWithHttpInfo
     * Get user activities
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $data_month date, yyyy-MM                 The specified month must be complete (in the past); The current month cannot be specified since it is not complete.                If no parameter is provided, the month immediately previous to the current month will be used.                Any user activities occurring within the specified month will be returned.                Please be aware that there may be a delay of up to 3 days before a user activity is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAccountingActivityUserActivitiesAsyncWithHttpInfo($xero_tenant_id, $data_month = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\UserActivitiesResponse';
        $request = $this->getAccountingActivityUserActivitiesRequest($xero_tenant_id, $data_month);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAccountingActivityUserActivities'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $data_month date, yyyy-MM                 The specified month must be complete (in the past); The current month cannot be specified since it is not complete.                If no parameter is provided, the month immediately previous to the current month will be used.                Any user activities occurring within the specified month will be returned.                Please be aware that there may be a delay of up to 3 days before a user activity is visible from this API. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAccountingActivityUserActivitiesRequest($xero_tenant_id, $data_month = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAccountingActivityUserActivities'
            );
        }
        $resourcePath = '/AccountingActivities/UserActivities';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($data_month !== null) {
            $queryParams['dataMonth'] = FinanceObjectSerializer::toQueryValue($data_month);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBankStatementAccounting
     * Get Bank Statement Accounting
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_account_id string, GUID    Bank account Id (required)
     * @param  string $from_date date, yyyy-MM-dd     Specifies the start date of the query period.   The maximum range of the query period is 12 months. If the specified query period is more than 12 months the request will be rejected. (required)
     * @param  string $to_date date, yyyy-MM-dd     Specifies the end date of the query period.   If the end date is a future date, the request will be rejected. (required)
     * @param  bool $summary_only boolean, true/false    The default value is true if no parameter is provided.    In summary mode, the response will exclude the computation-heavy LineItems fields from bank transaction, invoice, credit note, prepayment and overpayment data, making the API calls quicker and more efficient. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getBankStatementAccounting($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only = null)
    {
        list($response) = $this->getBankStatementAccountingWithHttpInfo($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only);
        return $response;
    }
    /**
     * Operation getBankStatementAccountingWithHttpInfo
     * Get Bank Statement Accounting
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_account_id string, GUID    Bank account Id (required)
     * @param  string $from_date date, yyyy-MM-dd     Specifies the start date of the query period.   The maximum range of the query period is 12 months. If the specified query period is more than 12 months the request will be rejected. (required)
     * @param  string $to_date date, yyyy-MM-dd     Specifies the end date of the query period.   If the end date is a future date, the request will be rejected. (required)
     * @param  bool $summary_only boolean, true/false    The default value is true if no parameter is provided.    In summary mode, the response will exclude the computation-heavy LineItems fields from bank transaction, invoice, credit note, prepayment and overpayment data, making the API calls quicker and more efficient. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBankStatementAccountingWithHttpInfo($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only = null)
    {
        $request = $this->getBankStatementAccountingRequest($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getBankStatementAccountingAsync
     * Get Bank Statement Accounting
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_account_id string, GUID    Bank account Id (required)
     * @param  string $from_date date, yyyy-MM-dd     Specifies the start date of the query period.   The maximum range of the query period is 12 months. If the specified query period is more than 12 months the request will be rejected. (required)
     * @param  string $to_date date, yyyy-MM-dd     Specifies the end date of the query period.   If the end date is a future date, the request will be rejected. (required)
     * @param  bool $summary_only boolean, true/false    The default value is true if no parameter is provided.    In summary mode, the response will exclude the computation-heavy LineItems fields from bank transaction, invoice, credit note, prepayment and overpayment data, making the API calls quicker and more efficient. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBankStatementAccountingAsync($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only = null)
    {
        return $this->getBankStatementAccountingAsyncWithHttpInfo($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getBankStatementAccountingAsyncWithHttpInfo
     * Get Bank Statement Accounting
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_account_id string, GUID    Bank account Id (required)
     * @param  string $from_date date, yyyy-MM-dd     Specifies the start date of the query period.   The maximum range of the query period is 12 months. If the specified query period is more than 12 months the request will be rejected. (required)
     * @param  string $to_date date, yyyy-MM-dd     Specifies the end date of the query period.   If the end date is a future date, the request will be rejected. (required)
     * @param  bool $summary_only boolean, true/false    The default value is true if no parameter is provided.    In summary mode, the response will exclude the computation-heavy LineItems fields from bank transaction, invoice, credit note, prepayment and overpayment data, making the API calls quicker and more efficient. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getBankStatementAccountingAsyncWithHttpInfo($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\BankStatementAccountingResponse';
        $request = $this->getBankStatementAccountingRequest($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBankStatementAccounting'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $bank_account_id string, GUID    Bank account Id (required)
     * @param  string $from_date date, yyyy-MM-dd     Specifies the start date of the query period.   The maximum range of the query period is 12 months. If the specified query period is more than 12 months the request will be rejected. (required)
     * @param  string $to_date date, yyyy-MM-dd     Specifies the end date of the query period.   If the end date is a future date, the request will be rejected. (required)
     * @param  bool $summary_only boolean, true/false    The default value is true if no parameter is provided.    In summary mode, the response will exclude the computation-heavy LineItems fields from bank transaction, invoice, credit note, prepayment and overpayment data, making the API calls quicker and more efficient. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getBankStatementAccountingRequest($xero_tenant_id, $bank_account_id, $from_date, $to_date, $summary_only = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBankStatementAccounting'
            );
        }
        // verify the required parameter 'bank_account_id' is set
        if ($bank_account_id === null || (is_array($bank_account_id) && count($bank_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bank_account_id when calling getBankStatementAccounting'
            );
        }
        // verify the required parameter 'from_date' is set
        if ($from_date === null || (is_array($from_date) && count($from_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $from_date when calling getBankStatementAccounting'
            );
        }
        // verify the required parameter 'to_date' is set
        if ($to_date === null || (is_array($to_date) && count($to_date) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $to_date when calling getBankStatementAccounting'
            );
        }
        $resourcePath = '/BankStatementsPlus/statements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($bank_account_id !== null) {
            $queryParams['BankAccountID'] = FinanceObjectSerializer::toQueryValue($bank_account_id);
        }
        // query params
        if ($from_date !== null) {
            $queryParams['FromDate'] = FinanceObjectSerializer::toQueryValue($from_date);
        }
        // query params
        if ($to_date !== null) {
            $queryParams['ToDate'] = FinanceObjectSerializer::toQueryValue($to_date);
        }
        // query params
        if ($summary_only !== null) {
            $queryParams['SummaryOnly'] = $summary_only ? 'true' : 'false';
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCashValidation
     * Get cash validation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘balance date’ will return transactions based on the accounting date entered by the user.  Transactions before the balanceDate will be included.  The user has discretion as to which accounting period the transaction relates to.    The ‘balance date’  will control the latest maximum date of transactions included in the aggregate numbers.  Balance date does not affect the CurrentStatement object, as this will always return the most recent statement before asAtSystemDate (if specified) (optional)
     * @param  string $as_at_system_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘as at’ date will return transactions based on the  creation date.  It reflects the date the transactions were entered into Xero, not the accounting date.  The ‘as at’ date can not be overridden by the user.  This can be used to estimate a ‘historical frequency of reconciliation’.    The ‘as at’ date will affect the current statement in the response, as any candidate statements created after this date will be filtered out.  Thus the current statement returned will be the most recent statement prior to the specified ‘as at’ date.  Be aware that neither the begin date, nor the balance date, will affect the current statement.    Note;  information is only presented when system architecture allows, meaning historical cash validation information will be an estimate. In addition, delete events are not aware of the ‘as at’ functionality in this endpoint, meaning that transactions deleted at the time the API is accessed will be considered to always have been deleted. (optional)
     * @param  string $begin_date date, yyyy-MM-dd     If no parameter is provided, the aggregate results will be drawn from the user’s total history.    The ‘begin date’ will return transactions based on the accounting date entered by the user. Transactions after the beginDate will be included.  The user has discretion as to which accounting period the transaction relates to. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getCashValidation($xero_tenant_id, $balance_date = null, $as_at_system_date = null, $begin_date = null)
    {
        list($response) = $this->getCashValidationWithHttpInfo($xero_tenant_id, $balance_date, $as_at_system_date, $begin_date);
        return $response;
    }
    /**
     * Operation getCashValidationWithHttpInfo
     * Get cash validation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘balance date’ will return transactions based on the accounting date entered by the user.  Transactions before the balanceDate will be included.  The user has discretion as to which accounting period the transaction relates to.    The ‘balance date’  will control the latest maximum date of transactions included in the aggregate numbers.  Balance date does not affect the CurrentStatement object, as this will always return the most recent statement before asAtSystemDate (if specified) (optional)
     * @param  string $as_at_system_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘as at’ date will return transactions based on the  creation date.  It reflects the date the transactions were entered into Xero, not the accounting date.  The ‘as at’ date can not be overridden by the user.  This can be used to estimate a ‘historical frequency of reconciliation’.    The ‘as at’ date will affect the current statement in the response, as any candidate statements created after this date will be filtered out.  Thus the current statement returned will be the most recent statement prior to the specified ‘as at’ date.  Be aware that neither the begin date, nor the balance date, will affect the current statement.    Note;  information is only presented when system architecture allows, meaning historical cash validation information will be an estimate. In addition, delete events are not aware of the ‘as at’ functionality in this endpoint, meaning that transactions deleted at the time the API is accessed will be considered to always have been deleted. (optional)
     * @param  string $begin_date date, yyyy-MM-dd     If no parameter is provided, the aggregate results will be drawn from the user’s total history.    The ‘begin date’ will return transactions based on the accounting date entered by the user. Transactions after the beginDate will be included.  The user has discretion as to which accounting period the transaction relates to. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCashValidationWithHttpInfo($xero_tenant_id, $balance_date = null, $as_at_system_date = null, $begin_date = null)
    {
        $request = $this->getCashValidationRequest($xero_tenant_id, $balance_date, $as_at_system_date, $begin_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getCashValidationAsync
     * Get cash validation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘balance date’ will return transactions based on the accounting date entered by the user.  Transactions before the balanceDate will be included.  The user has discretion as to which accounting period the transaction relates to.    The ‘balance date’  will control the latest maximum date of transactions included in the aggregate numbers.  Balance date does not affect the CurrentStatement object, as this will always return the most recent statement before asAtSystemDate (if specified) (optional)
     * @param  string $as_at_system_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘as at’ date will return transactions based on the  creation date.  It reflects the date the transactions were entered into Xero, not the accounting date.  The ‘as at’ date can not be overridden by the user.  This can be used to estimate a ‘historical frequency of reconciliation’.    The ‘as at’ date will affect the current statement in the response, as any candidate statements created after this date will be filtered out.  Thus the current statement returned will be the most recent statement prior to the specified ‘as at’ date.  Be aware that neither the begin date, nor the balance date, will affect the current statement.    Note;  information is only presented when system architecture allows, meaning historical cash validation information will be an estimate. In addition, delete events are not aware of the ‘as at’ functionality in this endpoint, meaning that transactions deleted at the time the API is accessed will be considered to always have been deleted. (optional)
     * @param  string $begin_date date, yyyy-MM-dd     If no parameter is provided, the aggregate results will be drawn from the user’s total history.    The ‘begin date’ will return transactions based on the accounting date entered by the user. Transactions after the beginDate will be included.  The user has discretion as to which accounting period the transaction relates to. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCashValidationAsync($xero_tenant_id, $balance_date = null, $as_at_system_date = null, $begin_date = null)
    {
        return $this->getCashValidationAsyncWithHttpInfo($xero_tenant_id, $balance_date, $as_at_system_date, $begin_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getCashValidationAsyncWithHttpInfo
     * Get cash validation
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘balance date’ will return transactions based on the accounting date entered by the user.  Transactions before the balanceDate will be included.  The user has discretion as to which accounting period the transaction relates to.    The ‘balance date’  will control the latest maximum date of transactions included in the aggregate numbers.  Balance date does not affect the CurrentStatement object, as this will always return the most recent statement before asAtSystemDate (if specified) (optional)
     * @param  string $as_at_system_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘as at’ date will return transactions based on the  creation date.  It reflects the date the transactions were entered into Xero, not the accounting date.  The ‘as at’ date can not be overridden by the user.  This can be used to estimate a ‘historical frequency of reconciliation’.    The ‘as at’ date will affect the current statement in the response, as any candidate statements created after this date will be filtered out.  Thus the current statement returned will be the most recent statement prior to the specified ‘as at’ date.  Be aware that neither the begin date, nor the balance date, will affect the current statement.    Note;  information is only presented when system architecture allows, meaning historical cash validation information will be an estimate. In addition, delete events are not aware of the ‘as at’ functionality in this endpoint, meaning that transactions deleted at the time the API is accessed will be considered to always have been deleted. (optional)
     * @param  string $begin_date date, yyyy-MM-dd     If no parameter is provided, the aggregate results will be drawn from the user’s total history.    The ‘begin date’ will return transactions based on the accounting date entered by the user. Transactions after the beginDate will be included.  The user has discretion as to which accounting period the transaction relates to. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getCashValidationAsyncWithHttpInfo($xero_tenant_id, $balance_date = null, $as_at_system_date = null, $begin_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\CashValidationResponse[]';
        $request = $this->getCashValidationRequest($xero_tenant_id, $balance_date, $as_at_system_date, $begin_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCashValidation'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘balance date’ will return transactions based on the accounting date entered by the user.  Transactions before the balanceDate will be included.  The user has discretion as to which accounting period the transaction relates to.    The ‘balance date’  will control the latest maximum date of transactions included in the aggregate numbers.  Balance date does not affect the CurrentStatement object, as this will always return the most recent statement before asAtSystemDate (if specified) (optional)
     * @param  string $as_at_system_date date, yyyy-MM-dd     If no parameter is provided, the current date will be used.    The ‘as at’ date will return transactions based on the  creation date.  It reflects the date the transactions were entered into Xero, not the accounting date.  The ‘as at’ date can not be overridden by the user.  This can be used to estimate a ‘historical frequency of reconciliation’.    The ‘as at’ date will affect the current statement in the response, as any candidate statements created after this date will be filtered out.  Thus the current statement returned will be the most recent statement prior to the specified ‘as at’ date.  Be aware that neither the begin date, nor the balance date, will affect the current statement.    Note;  information is only presented when system architecture allows, meaning historical cash validation information will be an estimate. In addition, delete events are not aware of the ‘as at’ functionality in this endpoint, meaning that transactions deleted at the time the API is accessed will be considered to always have been deleted. (optional)
     * @param  string $begin_date date, yyyy-MM-dd     If no parameter is provided, the aggregate results will be drawn from the user’s total history.    The ‘begin date’ will return transactions based on the accounting date entered by the user. Transactions after the beginDate will be included.  The user has discretion as to which accounting period the transaction relates to. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getCashValidationRequest($xero_tenant_id, $balance_date = null, $as_at_system_date = null, $begin_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getCashValidation'
            );
        }
        $resourcePath = '/CashValidation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($balance_date !== null) {
            $queryParams['balanceDate'] = FinanceObjectSerializer::toQueryValue($balance_date);
        }
        // query params
        if ($as_at_system_date !== null) {
            $queryParams['asAtSystemDate'] = FinanceObjectSerializer::toQueryValue($as_at_system_date);
        }
        // query params
        if ($begin_date !== null) {
            $queryParams['beginDate'] = FinanceObjectSerializer::toQueryValue($begin_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFinancialStatementBalanceSheet
     * Get Balance Sheet report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date Specifies the date for balance sheet report.    Format yyyy-MM-dd. If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse|\XeroAPI\XeroPHP\Models\Finance\Problem|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getFinancialStatementBalanceSheet($xero_tenant_id, $balance_date = null)
    {
        list($response) = $this->getFinancialStatementBalanceSheetWithHttpInfo($xero_tenant_id, $balance_date);
        return $response;
    }
    /**
     * Operation getFinancialStatementBalanceSheetWithHttpInfo
     * Get Balance Sheet report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date Specifies the date for balance sheet report.    Format yyyy-MM-dd. If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse|\XeroAPI\XeroPHP\Models\Finance\Problem|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFinancialStatementBalanceSheetWithHttpInfo($xero_tenant_id, $balance_date = null)
    {
        $request = $this->getFinancialStatementBalanceSheetRequest($xero_tenant_id, $balance_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFinancialStatementBalanceSheetAsync
     * Get Balance Sheet report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date Specifies the date for balance sheet report.    Format yyyy-MM-dd. If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFinancialStatementBalanceSheetAsync($xero_tenant_id, $balance_date = null)
    {
        return $this->getFinancialStatementBalanceSheetAsyncWithHttpInfo($xero_tenant_id, $balance_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFinancialStatementBalanceSheetAsyncWithHttpInfo
     * Get Balance Sheet report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date Specifies the date for balance sheet report.    Format yyyy-MM-dd. If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFinancialStatementBalanceSheetAsyncWithHttpInfo($xero_tenant_id, $balance_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\BalanceSheetResponse';
        $request = $this->getFinancialStatementBalanceSheetRequest($xero_tenant_id, $balance_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFinancialStatementBalanceSheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $balance_date Specifies the date for balance sheet report.    Format yyyy-MM-dd. If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFinancialStatementBalanceSheetRequest($xero_tenant_id, $balance_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFinancialStatementBalanceSheet'
            );
        }
        $resourcePath = '/FinancialStatements/BalanceSheet';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($balance_date !== null) {
            $queryParams['balanceDate'] = FinanceObjectSerializer::toQueryValue($balance_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFinancialStatementCashflow
     * Get Cash flow report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for cash flow report.    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for cash flow report.    If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\CashflowResponse|\XeroAPI\XeroPHP\Models\Finance\Problem|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getFinancialStatementCashflow($xero_tenant_id, $start_date = null, $end_date = null)
    {
        list($response) = $this->getFinancialStatementCashflowWithHttpInfo($xero_tenant_id, $start_date, $end_date);
        return $response;
    }
    /**
     * Operation getFinancialStatementCashflowWithHttpInfo
     * Get Cash flow report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for cash flow report.    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for cash flow report.    If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\CashflowResponse|\XeroAPI\XeroPHP\Models\Finance\Problem|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFinancialStatementCashflowWithHttpInfo($xero_tenant_id, $start_date = null, $end_date = null)
    {
        $request = $this->getFinancialStatementCashflowRequest($xero_tenant_id, $start_date, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\CashflowResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\CashflowResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 503:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\CashflowResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\CashflowResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFinancialStatementCashflowAsync
     * Get Cash flow report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for cash flow report.    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for cash flow report.    If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFinancialStatementCashflowAsync($xero_tenant_id, $start_date = null, $end_date = null)
    {
        return $this->getFinancialStatementCashflowAsyncWithHttpInfo($xero_tenant_id, $start_date, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFinancialStatementCashflowAsyncWithHttpInfo
     * Get Cash flow report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for cash flow report.    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for cash flow report.    If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFinancialStatementCashflowAsyncWithHttpInfo($xero_tenant_id, $start_date = null, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\CashflowResponse';
        $request = $this->getFinancialStatementCashflowRequest($xero_tenant_id, $start_date, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFinancialStatementCashflow'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for cash flow report.    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for cash flow report.    If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFinancialStatementCashflowRequest($xero_tenant_id, $start_date = null, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFinancialStatementCashflow'
            );
        }
        $resourcePath = '/FinancialStatements/Cashflow';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = FinanceObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFinancialStatementContactsExpense
     * Get expense by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getFinancialStatementContactsExpense($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        list($response) = $this->getFinancialStatementContactsExpenseWithHttpInfo($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date);
        return $response;
    }
    /**
     * Operation getFinancialStatementContactsExpenseWithHttpInfo
     * Get expense by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFinancialStatementContactsExpenseWithHttpInfo($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        $request = $this->getFinancialStatementContactsExpenseRequest($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFinancialStatementContactsExpenseAsync
     * Get expense by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFinancialStatementContactsExpenseAsync($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        return $this->getFinancialStatementContactsExpenseAsyncWithHttpInfo($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFinancialStatementContactsExpenseAsyncWithHttpInfo
     * Get expense by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFinancialStatementContactsExpenseAsyncWithHttpInfo($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse';
        $request = $this->getFinancialStatementContactsExpenseRequest($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFinancialStatementContactsExpense'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFinancialStatementContactsExpenseRequest($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFinancialStatementContactsExpense'
            );
        }
        $resourcePath = '/FinancialStatements/contacts/expense';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if (is_array($contact_ids)) {
            $contact_ids = FinanceObjectSerializer::serializeCollection($contact_ids, 'multi', true);
        }
        if ($contact_ids !== null) {
            $queryParams['contactIds'] = FinanceObjectSerializer::toQueryValue($contact_ids);
        }
        // query params
        if ($include_manual_journals !== null) {
            $queryParams['includeManualJournals'] = $include_manual_journals ? 'true' : 'false';
        }
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = FinanceObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFinancialStatementContactsRevenue
     * Get revenue by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getFinancialStatementContactsRevenue($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        list($response) = $this->getFinancialStatementContactsRevenueWithHttpInfo($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date);
        return $response;
    }
    /**
     * Operation getFinancialStatementContactsRevenueWithHttpInfo
     * Get revenue by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFinancialStatementContactsRevenueWithHttpInfo($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        $request = $this->getFinancialStatementContactsRevenueRequest($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFinancialStatementContactsRevenueAsync
     * Get revenue by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFinancialStatementContactsRevenueAsync($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        return $this->getFinancialStatementContactsRevenueAsyncWithHttpInfo($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFinancialStatementContactsRevenueAsyncWithHttpInfo
     * Get revenue by contacts report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFinancialStatementContactsRevenueAsyncWithHttpInfo($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\IncomeByContactResponse';
        $request = $this->getFinancialStatementContactsRevenueRequest($xero_tenant_id, $contact_ids, $include_manual_journals, $start_date, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFinancialStatementContactsRevenue'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $contact_ids Specifies the customer contacts to be included in the report.    If no parameter is provided, all customer contacts will be included (optional)
     * @param  bool $include_manual_journals Specifies whether to include the manual journals in the report.                If no parameter is provided, manual journals will not be included. (optional)
     * @param  string $start_date Date yyyy-MM-dd    Specifies the start date for the report.                If no parameter is provided, the date of 12 months before the end date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @param  string $end_date Date yyyy-MM-dd    Specifies the end date for the report.    If no parameter is provided, the current date will be used.                It is recommended to always specify both a start date and end date; While the initial range may be set to 12 months, this may need to be reduced for high volume organisations in order to improve latency. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFinancialStatementContactsRevenueRequest($xero_tenant_id, $contact_ids = null, $include_manual_journals = null, $start_date = null, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFinancialStatementContactsRevenue'
            );
        }
        $resourcePath = '/FinancialStatements/contacts/revenue';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if (is_array($contact_ids)) {
            $contact_ids = FinanceObjectSerializer::serializeCollection($contact_ids, 'multi', true);
        }
        if ($contact_ids !== null) {
            $queryParams['contactIds'] = FinanceObjectSerializer::toQueryValue($contact_ids);
        }
        // query params
        if ($include_manual_journals !== null) {
            $queryParams['includeManualJournals'] = $include_manual_journals ? 'true' : 'false';
        }
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = FinanceObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFinancialStatementProfitAndLoss
     * Get Profit & Loss report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for profit and loss report    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for profit and loss report     If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getFinancialStatementProfitAndLoss($xero_tenant_id, $start_date = null, $end_date = null)
    {
        list($response) = $this->getFinancialStatementProfitAndLossWithHttpInfo($xero_tenant_id, $start_date, $end_date);
        return $response;
    }
    /**
     * Operation getFinancialStatementProfitAndLossWithHttpInfo
     * Get Profit & Loss report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for profit and loss report    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for profit and loss report     If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFinancialStatementProfitAndLossWithHttpInfo($xero_tenant_id, $start_date = null, $end_date = null)
    {
        $request = $this->getFinancialStatementProfitAndLossRequest($xero_tenant_id, $start_date, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFinancialStatementProfitAndLossAsync
     * Get Profit & Loss report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for profit and loss report    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for profit and loss report     If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFinancialStatementProfitAndLossAsync($xero_tenant_id, $start_date = null, $end_date = null)
    {
        return $this->getFinancialStatementProfitAndLossAsyncWithHttpInfo($xero_tenant_id, $start_date, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFinancialStatementProfitAndLossAsyncWithHttpInfo
     * Get Profit & Loss report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for profit and loss report    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for profit and loss report     If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFinancialStatementProfitAndLossAsyncWithHttpInfo($xero_tenant_id, $start_date = null, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\ProfitAndLossResponse';
        $request = $this->getFinancialStatementProfitAndLossRequest($xero_tenant_id, $start_date, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFinancialStatementProfitAndLoss'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $start_date Date e.g. yyyy-MM-dd    Specifies the start date for profit and loss report    If no parameter is provided, the date of 12 months before the end date will be used. (optional)
     * @param  string $end_date Date e.g. yyyy-MM-dd    Specifies the end date for profit and loss report     If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFinancialStatementProfitAndLossRequest($xero_tenant_id, $start_date = null, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFinancialStatementProfitAndLoss'
            );
        }
        $resourcePath = '/FinancialStatements/ProfitAndLoss';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = FinanceObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFinancialStatementTrialBalance
     * Get Trial Balance report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date Date e.g. yyyy-MM-dd     Specifies the end date for trial balance report     If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse|\XeroAPI\XeroPHP\Models\Finance\Problem
     */
    public function getFinancialStatementTrialBalance($xero_tenant_id, $end_date = null)
    {
        list($response) = $this->getFinancialStatementTrialBalanceWithHttpInfo($xero_tenant_id, $end_date);
        return $response;
    }
    /**
     * Operation getFinancialStatementTrialBalanceWithHttpInfo
     * Get Trial Balance report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date Date e.g. yyyy-MM-dd     Specifies the end date for trial balance report     If no parameter is provided, the current date will be used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse|\XeroAPI\XeroPHP\Models\Finance\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFinancialStatementTrialBalanceWithHttpInfo($xero_tenant_id, $end_date = null)
    {
        $request = $this->getFinancialStatementTrialBalanceRequest($xero_tenant_id, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\Finance\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\Finance\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FinanceObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = FinanceObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\Finance\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFinancialStatementTrialBalanceAsync
     * Get Trial Balance report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date Date e.g. yyyy-MM-dd     Specifies the end date for trial balance report     If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFinancialStatementTrialBalanceAsync($xero_tenant_id, $end_date = null)
    {
        return $this->getFinancialStatementTrialBalanceAsyncWithHttpInfo($xero_tenant_id, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFinancialStatementTrialBalanceAsyncWithHttpInfo
     * Get Trial Balance report
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date Date e.g. yyyy-MM-dd     Specifies the end date for trial balance report     If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFinancialStatementTrialBalanceAsyncWithHttpInfo($xero_tenant_id, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\Finance\TrialBalanceResponse';
        $request = $this->getFinancialStatementTrialBalanceRequest($xero_tenant_id, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FinanceObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFinancialStatementTrialBalance'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $end_date Date e.g. yyyy-MM-dd     Specifies the end date for trial balance report     If no parameter is provided, the current date will be used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFinancialStatementTrialBalanceRequest($xero_tenant_id, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFinancialStatementTrialBalance'
            );
        }
        $resourcePath = '/FinancialStatements/TrialBalance';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = FinanceObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FinanceObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FinanceObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFinance() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
