<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Content
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Content\V1\Content;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class ApprovalCreateList extends ListResource
    {
    /**
     * Construct the ApprovalCreateList
     *
     * @param Version $version Version that contains the resource
     * @param string $contentSid 
     */
    public function __construct(
        Version $version,
        string $contentSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'contentSid' =>
            $contentSid,
        
        ];

        $this->uri = '/Content/' . \rawurlencode($contentSid)
        .'/ApprovalRequests/whatsapp';
    }

    /**
     * Helper function for Create
     *
     * @param ContentApprovalRequest $contentApprovalRequest
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(ContentApprovalRequest $contentApprovalRequest): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $contentApprovalRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the ApprovalCreateInstance
     *
     * @param ContentApprovalRequest $contentApprovalRequest
     * @return ApprovalCreateInstance Created ApprovalCreateInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(ContentApprovalRequest $contentApprovalRequest): ApprovalCreateInstance
    {
        $response = $this->_create( $contentApprovalRequest);
        return new ApprovalCreateInstance(
            $this->version,
            $response->getContent(),
            $this->solution['contentSid']
        );
        
    }

    /**
     * Create the ApprovalCreateInstance with Metadata
     *
     * @param ContentApprovalRequest $contentApprovalRequest
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(ContentApprovalRequest $contentApprovalRequest): ResourceMetadata
    {
        $response = $this->_create( $contentApprovalRequest);
        $resource = new ApprovalCreateInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['contentSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Content.V1.ApprovalCreateList]';
    }
}
