<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Taskrouter
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Taskrouter\V1\Workspace;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class ActivityContext extends InstanceContext
    {
    /**
     * Initialize the ActivityContext
     *
     * @param Version $version Version that contains the resource
     * @param string $workspaceSid The SID of the Workspace that the new Activity belongs to.
     * @param string $sid The SID of the Activity resource to delete.
     */
    public function __construct(
        Version $version,
        $workspaceSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'workspaceSid' =>
            $workspaceSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/Workspaces/' . \rawurlencode($workspaceSid)
        .'/Activities/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Helper function for Delete
     *
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the ActivityInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {
        $response = $this->_delete();
        
        return true;
    }

    /**
     * Delete the ActivityInstance with Metadata
     *
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(): ResourceMetadata
    {
        $response = $this->_delete();
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the ActivityInstance
     *
     * @return ActivityInstance Fetched ActivityInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ActivityInstance
    {
        $response = $this->_fetch();
        return new ActivityInstance(
            $this->version,
            $response->getContent(),
            $this->solution['workspaceSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Fetch the ActivityInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new ActivityInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['workspaceSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'FriendlyName' =>
                $options['friendlyName'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the ActivityInstance
     *
     * @param array|Options $options Optional Arguments
     * @return ActivityInstance Updated ActivityInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): ActivityInstance
    {
        $response = $this->_update($options);
        return new ActivityInstance(
            $this->version,
            $response->getContent(),
            $this->solution['workspaceSid'],
            $this->solution['sid']
        );
        
    }

    /**
     * Update the ActivityInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new ActivityInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['workspaceSid'],
                        $this->solution['sid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Taskrouter.V1.ActivityContext ' . \implode(' ', $context) . ']';
    }
}
