/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 *
 * @defgroup	Messenger Messenger
 * @ingroup	UnaModules
 * @{
 */
 
/**
 * Primus class to work with the server and main messenger class
 */ 
;window.oRTWSF = (function(){
	let _oPrimus = null,
		_oData = Object.create(null),
		_sIP = '0.0.0.0';
	
	return {
			/**
			* Init Primus with provided settings and attaches listeners on event emitters from the server
			*@param object oOptions options
			*/
			init:function(oOptions){
				const _this = this;
					_this._sIP = oOptions.ip || _this._sIP;
				
				if (!oOptions.server.length)
					return;
				
				if (_oPrimus === null)
						_oPrimus = new Primus(oOptions.server);

				// on data received from the server
				_oPrimus.on('data', function(oData) {					
						if (typeof oData.action !== "undefined" && !_oPrimus.emit(oData.action, oData))
							console.log('Unknown server response', oData);						
								
						}).on('error', function error(oError) {
							console.log('Primus Error', oError);					
						}).on('reconnect scheduled', function (oOptions) {
							console.log('Reconnecting in %d ms', oOptions.scheduled);
							console.log('This is attempt %d out of %d', oOptions.attempt, oOptions.retries);
							_this.onReconnecting(oOptions);
						}).on('reconnected', function (oOptions) {
							_this.onReconnected(oOptions);
						}).on('reconnect failed', function (oOptions) {
							_this.onReconnectFailed(oOptions);
						}).on('open', function () {
							var oSettings = _this.getSettings();				
							if (typeof oSettings !== 'undefined' && typeof oSettings.user_id !== 'undefined' && typeof oSettings.status !== 'undefined'){
								this.write({
									 action:'init', 
									 ip:_this._sIP,
									 user_id: oSettings.user_id,
									 status: oSettings.status 
								});
							}
						}).on('typing', function (oData) {
							_this.onTyping(oData);
						}).on('msg', function (oData){
							_this.onMessage(oData);
						}).on('update_status', function (oData) {
							_this.onStatusUpdate(oData);
						}).on('check_sent', function (oData) {
							_this.onServerResponse(oData);
						}).on('denied', function (oData) {
							console.log('Access Denied for your IP');
						})
				
			},
			isInitialized:function(){
				return _oPrimus != undefined;
			},
			/* 
			*Methods occur when received data from the server or on primus events 
			*BEGIN 
			*/
			onTyping:function(){
				console.log('overwrite it in the main messenger class');
			},		
			onMessage:function(){
				console.log('overwrite it in the main messenger class');
			},
			onStatusUpdate:function(){
				console.log('overwrite it in the main messenger class');
			},
			getSettings:function(){
				console.log('overwrite it in the main messenger class');
			},
			onServerResponse:function(){
				console.log('overwrite it in the main messenger class');
			},
			onReconnecting:function(){
				console.log('overwrite it in the main messenger class');
			},
			onReconnected:function(){
				console.log('overwrite it in the main messenger class');
			},
			onReconnectFailed:function(){
				console.log('overwrite it in the main messenger class');
			},
			/** End **/

		 	/*
			*Methods are called on members' activities in chat window and send data to the server 
			*BEGIN
			*/
			initSettings:function(oData){							
				this.exec('init', oData);
			},
			message:function(oData){
				this.exec('msg', oData);
			},
			typing:function(oData){
				this.exec('typing', oData);
			},
			end:function(oData){
				this.exec('before_delete', oData);
				_oPrimus.end();
			},
			updateStatus:function(oData){
				this.exec('update_status', oData);
			},
			exec:function(sParam, oData){
				if (!this.isInitialized())
					return;
				
				if (!_oPrimus.writable)
					_oPrimus.open();				
			
				_oPrimus.write($.extend(oData, {action:sParam, ip:this._sIP}));
			}
			/** END **/
		}	
})();

/** @} */
