<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Organization Public API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\PreviewIam\Versionless\Organization;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class UserContext extends InstanceContext
    {
    /**
     * Initialize the UserContext
     *
     * @param Version $version Version that contains the resource
     * @param string $organizationSid
     * @param string $id
     */
    public function __construct(
        Version $version,
        $organizationSid,
        $id
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'organizationSid' =>
            $organizationSid,
        'id' =>
            $id,
        ];

        $this->uri = '/' . \rawurlencode($organizationSid)
        .'/scim/Users/' . \rawurlencode($id)
        .'';
    }

    /**
     * Helper function for Delete
     *
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the UserInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {
        $response = $this->_delete();
        
        return true;
    }

    /**
     * Delete the UserInstance with Metadata
     *
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(): ResourceMetadata
    {
        $response = $this->_delete();
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/scim+json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the UserInstance
     *
     * @return UserInstance Fetched UserInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): UserInstance
    {
        $response = $this->_fetch();
        return new UserInstance(
            $this->version,
            $response->getContent(),
            $this->solution['organizationSid'],
            $this->solution['id']
        );
        
    }

    /**
     * Fetch the UserInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new UserInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['organizationSid'],
                        $this->solution['id']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param ScimUser $scimUser
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(ScimUser $scimUser, array $options = []): Response
    {
        $options = new Values($options);

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/scim+json' , 'If-Match' => $options['ifMatch']]);
        $data = $scimUser->toArray();
        return $this->version->handleRequest('PUT', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the UserInstance
     *
     * @param ScimUser $scimUser
     * @param array|Options $options Optional Arguments
     * @return UserInstance Updated UserInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(ScimUser $scimUser, array $options = []): UserInstance
    {
        $response = $this->_update( $scimUser, $options);
        return new UserInstance(
            $this->version,
            $response->getContent(),
            $this->solution['organizationSid'],
            $this->solution['id']
        );
        
    }

    /**
     * Update the UserInstance with Metadata
     *
     * @param ScimUser $scimUser
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(ScimUser $scimUser, array $options = []): ResourceMetadata
    {
        $response = $this->_update( $scimUser, $options);
        $resource = new UserInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['organizationSid'],
                        $this->solution['id']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.PreviewIam.Versionless.UserContext ' . \implode(' ', $context) . ']';
    }
}
