<?php
/**
 * FilesApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP File
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Files API
 *
 * These endpoints are specific to Xero Files API
 *
 * OpenAPI spec version: 7.0.0
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\FileObjectSerializer;

/**
 * FilesApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FilesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createFileAssociation
     * Creates a new file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Association $association association (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Association
     */
    public function createFileAssociation($xero_tenant_id, $file_id, $association, $idempotency_key = null)
    {
        list($response) = $this->createFileAssociationWithHttpInfo($xero_tenant_id, $file_id, $association, $idempotency_key);
        return $response;
    }
    /**
     * Operation createFileAssociationWithHttpInfo
     * Creates a new file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Association $association (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Association, HTTP status code, HTTP response headers (array of strings)
     */
    public function createFileAssociationWithHttpInfo($xero_tenant_id, $file_id, $association, $idempotency_key = null)
    {
        $request = $this->createFileAssociationRequest($xero_tenant_id, $file_id, $association, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\XeroAPI\XeroPHP\Models\File\Association' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Association', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Association';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Association',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createFileAssociationAsync
     * Creates a new file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Association $association (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createFileAssociationAsync($xero_tenant_id, $file_id, $association, $idempotency_key = null)
    {
        return $this->createFileAssociationAsyncWithHttpInfo($xero_tenant_id, $file_id, $association, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createFileAssociationAsyncWithHttpInfo
     * Creates a new file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Association $association (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createFileAssociationAsyncWithHttpInfo($xero_tenant_id, $file_id, $association, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Association';
        $request = $this->createFileAssociationRequest($xero_tenant_id, $file_id, $association, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createFileAssociation'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Association $association (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createFileAssociationRequest($xero_tenant_id, $file_id, $association, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createFileAssociation'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling createFileAssociation'
            );
        }
        // verify the required parameter 'association' is set
        if ($association === null || (is_array($association) && count($association) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $association when calling createFileAssociation'
            );
        }
        $resourcePath = '/Files/{FileId}/Associations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = FileObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($association)) {
            $_tempBody = $association;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createFolder
     * Creates a new folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Folder
     */
    public function createFolder($xero_tenant_id, $folder, $idempotency_key = null)
    {
        list($response) = $this->createFolderWithHttpInfo($xero_tenant_id, $folder, $idempotency_key);
        return $response;
    }
    /**
     * Operation createFolderWithHttpInfo
     * Creates a new folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Folder, HTTP status code, HTTP response headers (array of strings)
     */
    public function createFolderWithHttpInfo($xero_tenant_id, $folder, $idempotency_key = null)
    {
        $request = $this->createFolderRequest($xero_tenant_id, $folder, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Folder' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Folder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Folder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createFolderAsync
     * Creates a new folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createFolderAsync($xero_tenant_id, $folder, $idempotency_key = null)
    {
        return $this->createFolderAsyncWithHttpInfo($xero_tenant_id, $folder, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createFolderAsyncWithHttpInfo
     * Creates a new folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createFolderAsyncWithHttpInfo($xero_tenant_id, $folder, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
        $request = $this->createFolderRequest($xero_tenant_id, $folder, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createFolder'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createFolderRequest($xero_tenant_id, $folder, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createFolder'
            );
        }
        // verify the required parameter 'folder' is set
        if ($folder === null || (is_array($folder) && count($folder) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $folder when calling createFolder'
            );
        }
        $resourcePath = '/Folders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = FileObjectSerializer::toHeaderValue($idempotency_key);
        }
        // body params
        $_tempBody = null;
        if (isset($folder)) {
            $_tempBody = $folder;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteFile
     * Deletes a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteFile($xero_tenant_id, $file_id)
    {
        $this->deleteFileWithHttpInfo($xero_tenant_id, $file_id);
    }
    /**
     * Operation deleteFileWithHttpInfo
     * Deletes a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteFileWithHttpInfo($xero_tenant_id, $file_id)
    {
        $request = $this->deleteFileRequest($xero_tenant_id, $file_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }
    /**
     * Operation deleteFileAsync
     * Deletes a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteFileAsync($xero_tenant_id, $file_id)
    {
        return $this->deleteFileAsyncWithHttpInfo($xero_tenant_id, $file_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteFileAsyncWithHttpInfo
     * Deletes a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteFileAsyncWithHttpInfo($xero_tenant_id, $file_id)
    {
        $returnType = '';
        $request = $this->deleteFileRequest($xero_tenant_id, $file_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteFile'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteFileRequest($xero_tenant_id, $file_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteFile'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling deleteFile'
            );
        }
        $resourcePath = '/Files/{FileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteFileAssociation
     * Deletes an existing file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  string $object_id Object id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteFileAssociation($xero_tenant_id, $file_id, $object_id)
    {
        $this->deleteFileAssociationWithHttpInfo($xero_tenant_id, $file_id, $object_id);
    }
    /**
     * Operation deleteFileAssociationWithHttpInfo
     * Deletes an existing file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  string $object_id Object id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteFileAssociationWithHttpInfo($xero_tenant_id, $file_id, $object_id)
    {
        $request = $this->deleteFileAssociationRequest($xero_tenant_id, $file_id, $object_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }
    /**
     * Operation deleteFileAssociationAsync
     * Deletes an existing file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  string $object_id Object id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteFileAssociationAsync($xero_tenant_id, $file_id, $object_id)
    {
        return $this->deleteFileAssociationAsyncWithHttpInfo($xero_tenant_id, $file_id, $object_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteFileAssociationAsyncWithHttpInfo
     * Deletes an existing file association
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  string $object_id Object id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteFileAssociationAsyncWithHttpInfo($xero_tenant_id, $file_id, $object_id)
    {
        $returnType = '';
        $request = $this->deleteFileAssociationRequest($xero_tenant_id, $file_id, $object_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteFileAssociation'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  string $object_id Object id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteFileAssociationRequest($xero_tenant_id, $file_id, $object_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteFileAssociation'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling deleteFileAssociation'
            );
        }
        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling deleteFileAssociation'
            );
        }
        $resourcePath = '/Files/{FileId}/Associations/{ObjectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ObjectId' . '}',
                FileObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteFolder
     * Deletes a folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteFolder($xero_tenant_id, $folder_id)
    {
        $this->deleteFolderWithHttpInfo($xero_tenant_id, $folder_id);
    }
    /**
     * Operation deleteFolderWithHttpInfo
     * Deletes a folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteFolderWithHttpInfo($xero_tenant_id, $folder_id)
    {
        $request = $this->deleteFolderRequest($xero_tenant_id, $folder_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }
    /**
     * Operation deleteFolderAsync
     * Deletes a folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteFolderAsync($xero_tenant_id, $folder_id)
    {
        return $this->deleteFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteFolderAsyncWithHttpInfo
     * Deletes a folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id)
    {
        $returnType = '';
        $request = $this->deleteFolderRequest($xero_tenant_id, $folder_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteFolder'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteFolderRequest($xero_tenant_id, $folder_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteFolder'
            );
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null || (is_array($folder_id) && count($folder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $folder_id when calling deleteFolder'
            );
        }
        $resourcePath = '/Folders/{FolderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FolderId' . '}',
                FileObjectSerializer::toPathValue($folder_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssociationsByObject
     * Retrieves an association object using a unique object ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $object_id Object id for single object (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @param  string $direction direction to sort by (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Association[]
     */
    public function getAssociationsByObject($xero_tenant_id, $object_id, $pagesize = null, $page = null, $sort = null, $direction = null)
    {
        list($response) = $this->getAssociationsByObjectWithHttpInfo($xero_tenant_id, $object_id, $pagesize, $page, $sort, $direction);
        return $response;
    }
    /**
     * Operation getAssociationsByObjectWithHttpInfo
     * Retrieves an association object using a unique object ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $object_id Object id for single object (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @param  string $direction direction to sort by (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Association[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssociationsByObjectWithHttpInfo($xero_tenant_id, $object_id, $pagesize = null, $page = null, $sort = null, $direction = null)
    {
        $request = $this->getAssociationsByObjectRequest($xero_tenant_id, $object_id, $pagesize, $page, $sort, $direction);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Association[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Association[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Association[]';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Association[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAssociationsByObjectAsync
     * Retrieves an association object using a unique object ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $object_id Object id for single object (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @param  string $direction direction to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssociationsByObjectAsync($xero_tenant_id, $object_id, $pagesize = null, $page = null, $sort = null, $direction = null)
    {
        return $this->getAssociationsByObjectAsyncWithHttpInfo($xero_tenant_id, $object_id, $pagesize, $page, $sort, $direction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAssociationsByObjectAsyncWithHttpInfo
     * Retrieves an association object using a unique object ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $object_id Object id for single object (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @param  string $direction direction to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAssociationsByObjectAsyncWithHttpInfo($xero_tenant_id, $object_id, $pagesize = null, $page = null, $sort = null, $direction = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Association[]';
        $request = $this->getAssociationsByObjectRequest($xero_tenant_id, $object_id, $pagesize, $page, $sort, $direction);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssociationsByObject'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $object_id Object id for single object (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @param  string $direction direction to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAssociationsByObjectRequest($xero_tenant_id, $object_id, $pagesize = null, $page = null, $sort = null, $direction = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAssociationsByObject'
            );
        }
        // verify the required parameter 'object_id' is set
        if ($object_id === null || (is_array($object_id) && count($object_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_id when calling getAssociationsByObject'
            );
        }
        if ($pagesize !== null && $pagesize > 100) {
            throw new \InvalidArgumentException('invalid value for "$pagesize" when calling FilesApi.getAssociationsByObject, must be smaller than or equal to 100.');
        }

        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling FilesApi.getAssociationsByObject, must be bigger than or equal to 1.');
        }

        $resourcePath = '/Associations/{ObjectId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($pagesize !== null) {
            $queryParams['pagesize'] = FileObjectSerializer::toQueryValue($pagesize);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = FileObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = FileObjectSerializer::toQueryValue($sort);
        }
        // query params
        if ($direction !== null) {
            $queryParams['direction'] = FileObjectSerializer::toQueryValue($direction);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($object_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ObjectId' . '}',
                FileObjectSerializer::toPathValue($object_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAssociationsCount
     * Retrieves a count of associations for a list of objects.
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $object_ids A comma-separated list of object ids (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getAssociationsCount($xero_tenant_id, $object_ids)
    {
        list($response) = $this->getAssociationsCountWithHttpInfo($xero_tenant_id, $object_ids);
        return $response;
    }
    /**
     * Operation getAssociationsCountWithHttpInfo
     * Retrieves a count of associations for a list of objects.
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $object_ids A comma-separated list of object ids (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAssociationsCountWithHttpInfo($xero_tenant_id, $object_ids)
    {
        $request = $this->getAssociationsCountRequest($xero_tenant_id, $object_ids);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = 'object';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAssociationsCountAsync
     * Retrieves a count of associations for a list of objects.
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $object_ids A comma-separated list of object ids (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAssociationsCountAsync($xero_tenant_id, $object_ids)
    {
        return $this->getAssociationsCountAsyncWithHttpInfo($xero_tenant_id, $object_ids)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getAssociationsCountAsyncWithHttpInfo
     * Retrieves a count of associations for a list of objects.
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $object_ids A comma-separated list of object ids (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getAssociationsCountAsyncWithHttpInfo($xero_tenant_id, $object_ids)
    {
        $returnType = 'object';
        $request = $this->getAssociationsCountRequest($xero_tenant_id, $object_ids);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAssociationsCount'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string[] $object_ids A comma-separated list of object ids (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getAssociationsCountRequest($xero_tenant_id, $object_ids)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getAssociationsCount'
            );
        }
        // verify the required parameter 'object_ids' is set
        if ($object_ids === null || (is_array($object_ids) && count($object_ids) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $object_ids when calling getAssociationsCount'
            );
        }
        $resourcePath = '/Associations/Count';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if (is_array($object_ids)) {
            $object_ids = FileObjectSerializer::serializeCollection($object_ids, 'multi', true);
        }
        if ($object_ids !== null) {
            $queryParams['ObjectIds'] = FileObjectSerializer::toQueryValue($object_ids);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFile
     * Retrieves a file by a unique file ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\FileObject
     */
    public function getFile($xero_tenant_id, $file_id)
    {
        list($response) = $this->getFileWithHttpInfo($xero_tenant_id, $file_id);
        return $response;
    }
    /**
     * Operation getFileWithHttpInfo
     * Retrieves a file by a unique file ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\FileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFileWithHttpInfo($xero_tenant_id, $file_id)
    {
        $request = $this->getFileRequest($xero_tenant_id, $file_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\FileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\FileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\FileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFileAsync
     * Retrieves a file by a unique file ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFileAsync($xero_tenant_id, $file_id)
    {
        return $this->getFileAsyncWithHttpInfo($xero_tenant_id, $file_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFileAsyncWithHttpInfo
     * Retrieves a file by a unique file ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFileAsyncWithHttpInfo($xero_tenant_id, $file_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
        $request = $this->getFileRequest($xero_tenant_id, $file_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFile'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFileRequest($xero_tenant_id, $file_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFile'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling getFile'
            );
        }
        $resourcePath = '/Files/{FileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFileAssociations
     * Retrieves a specific file associations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Association[]
     */
    public function getFileAssociations($xero_tenant_id, $file_id)
    {
        list($response) = $this->getFileAssociationsWithHttpInfo($xero_tenant_id, $file_id);
        return $response;
    }
    /**
     * Operation getFileAssociationsWithHttpInfo
     * Retrieves a specific file associations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Association[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getFileAssociationsWithHttpInfo($xero_tenant_id, $file_id)
    {
        $request = $this->getFileAssociationsRequest($xero_tenant_id, $file_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Association[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Association[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Association[]';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Association[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFileAssociationsAsync
     * Retrieves a specific file associations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFileAssociationsAsync($xero_tenant_id, $file_id)
    {
        return $this->getFileAssociationsAsyncWithHttpInfo($xero_tenant_id, $file_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFileAssociationsAsyncWithHttpInfo
     * Retrieves a specific file associations
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFileAssociationsAsyncWithHttpInfo($xero_tenant_id, $file_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Association[]';
        $request = $this->getFileAssociationsRequest($xero_tenant_id, $file_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFileAssociations'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFileAssociationsRequest($xero_tenant_id, $file_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFileAssociations'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling getFileAssociations'
            );
        }
        $resourcePath = '/Files/{FileId}/Associations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFileContent
     * Retrieves the content of a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getFileContent($xero_tenant_id, $file_id)
    {
        list($response) = $this->getFileContentWithHttpInfo($xero_tenant_id, $file_id);
        return $response;
    }
    /**
     * Operation getFileContentWithHttpInfo
     * Retrieves the content of a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFileContentWithHttpInfo($xero_tenant_id, $file_id)
    {
        $request = $this->getFileContentRequest($xero_tenant_id, $file_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\SplFileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFileContentAsync
     * Retrieves the content of a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFileContentAsync($xero_tenant_id, $file_id)
    {
        return $this->getFileContentAsyncWithHttpInfo($xero_tenant_id, $file_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFileContentAsyncWithHttpInfo
     * Retrieves the content of a specific file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFileContentAsyncWithHttpInfo($xero_tenant_id, $file_id)
    {
        $returnType = '\SplFileObject';
        $request = $this->getFileContentRequest($xero_tenant_id, $file_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFileContent'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFileContentRequest($xero_tenant_id, $file_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFileContent'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling getFileContent'
            );
        }
        $resourcePath = '/Files/{FileId}/Content';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/octet-stream']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/octet-stream'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFiles
     * Retrieves files
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Files
     */
    public function getFiles($xero_tenant_id, $pagesize = null, $page = null, $sort = null)
    {
        list($response) = $this->getFilesWithHttpInfo($xero_tenant_id, $pagesize, $page, $sort);
        return $response;
    }
    /**
     * Operation getFilesWithHttpInfo
     * Retrieves files
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Files, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFilesWithHttpInfo($xero_tenant_id, $pagesize = null, $page = null, $sort = null)
    {
        $request = $this->getFilesRequest($xero_tenant_id, $pagesize, $page, $sort);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Files' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Files', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Files';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Files',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFilesAsync
     * Retrieves files
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFilesAsync($xero_tenant_id, $pagesize = null, $page = null, $sort = null)
    {
        return $this->getFilesAsyncWithHttpInfo($xero_tenant_id, $pagesize, $page, $sort)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFilesAsyncWithHttpInfo
     * Retrieves files
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFilesAsyncWithHttpInfo($xero_tenant_id, $pagesize = null, $page = null, $sort = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Files';
        $request = $this->getFilesRequest($xero_tenant_id, $pagesize, $page, $sort);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFiles'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $pagesize pass an optional page size value (optional)
     * @param  int $page number of records to skip for pagination (optional)
     * @param  string $sort values to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFilesRequest($xero_tenant_id, $pagesize = null, $page = null, $sort = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFiles'
            );
        }
        if ($pagesize !== null && $pagesize > 100) {
            throw new \InvalidArgumentException('invalid value for "$pagesize" when calling FilesApi.getFiles, must be smaller than or equal to 100.');
        }

        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling FilesApi.getFiles, must be bigger than or equal to 1.');
        }

        $resourcePath = '/Files';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($pagesize !== null) {
            $queryParams['pagesize'] = FileObjectSerializer::toQueryValue($pagesize);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = FileObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = FileObjectSerializer::toQueryValue($sort);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFolder
     * Retrieves specific folder by using a unique folder ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Folder
     */
    public function getFolder($xero_tenant_id, $folder_id)
    {
        list($response) = $this->getFolderWithHttpInfo($xero_tenant_id, $folder_id);
        return $response;
    }
    /**
     * Operation getFolderWithHttpInfo
     * Retrieves specific folder by using a unique folder ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Folder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFolderWithHttpInfo($xero_tenant_id, $folder_id)
    {
        $request = $this->getFolderRequest($xero_tenant_id, $folder_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Folder' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Folder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Folder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFolderAsync
     * Retrieves specific folder by using a unique folder ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFolderAsync($xero_tenant_id, $folder_id)
    {
        return $this->getFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFolderAsyncWithHttpInfo
     * Retrieves specific folder by using a unique folder ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
        $request = $this->getFolderRequest($xero_tenant_id, $folder_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFolder'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFolderRequest($xero_tenant_id, $folder_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFolder'
            );
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null || (is_array($folder_id) && count($folder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $folder_id when calling getFolder'
            );
        }
        $resourcePath = '/Folders/{FolderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FolderId' . '}',
                FileObjectSerializer::toPathValue($folder_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getFolders
     * Retrieves folders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $sort values to sort by (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Folder[]
     */
    public function getFolders($xero_tenant_id, $sort = null)
    {
        list($response) = $this->getFoldersWithHttpInfo($xero_tenant_id, $sort);
        return $response;
    }
    /**
     * Operation getFoldersWithHttpInfo
     * Retrieves folders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $sort values to sort by (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Folder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getFoldersWithHttpInfo($xero_tenant_id, $sort = null)
    {
        $request = $this->getFoldersRequest($xero_tenant_id, $sort);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Folder[]' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Folder[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Folder[]';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Folder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getFoldersAsync
     * Retrieves folders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $sort values to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getFoldersAsync($xero_tenant_id, $sort = null)
    {
        return $this->getFoldersAsyncWithHttpInfo($xero_tenant_id, $sort)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getFoldersAsyncWithHttpInfo
     * Retrieves folders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $sort values to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getFoldersAsyncWithHttpInfo($xero_tenant_id, $sort = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Folder[]';
        $request = $this->getFoldersRequest($xero_tenant_id, $sort);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getFolders'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $sort values to sort by (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getFoldersRequest($xero_tenant_id, $sort = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getFolders'
            );
        }
        $resourcePath = '/Folders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = FileObjectSerializer::toQueryValue($sort);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInbox
     * Retrieves inbox folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Folder
     */
    public function getInbox($xero_tenant_id)
    {
        list($response) = $this->getInboxWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getInboxWithHttpInfo
     * Retrieves inbox folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Folder, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInboxWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getInboxRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Folder' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Folder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Folder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getInboxAsync
     * Retrieves inbox folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInboxAsync($xero_tenant_id)
    {
        return $this->getInboxAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getInboxAsyncWithHttpInfo
     * Retrieves inbox folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getInboxAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
        $request = $this->getInboxRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInbox'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getInboxRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getInbox'
            );
        }
        $resourcePath = '/Inbox';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateFile
     * Update a file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\FileObject $file_object file_object (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\FileObject
     */
    public function updateFile($xero_tenant_id, $file_id, $file_object, $idempotency_key = null)
    {
        list($response) = $this->updateFileWithHttpInfo($xero_tenant_id, $file_id, $file_object, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateFileWithHttpInfo
     * Update a file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\FileObject $file_object (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\FileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateFileWithHttpInfo($xero_tenant_id, $file_id, $file_object, $idempotency_key = null)
    {
        $request = $this->updateFileRequest($xero_tenant_id, $file_id, $file_object, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\FileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\FileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\FileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateFileAsync
     * Update a file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\FileObject $file_object (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateFileAsync($xero_tenant_id, $file_id, $file_object, $idempotency_key = null)
    {
        return $this->updateFileAsyncWithHttpInfo($xero_tenant_id, $file_id, $file_object, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateFileAsyncWithHttpInfo
     * Update a file
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\FileObject $file_object (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateFileAsyncWithHttpInfo($xero_tenant_id, $file_id, $file_object, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
        $request = $this->updateFileRequest($xero_tenant_id, $file_id, $file_object, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateFile'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $file_id File id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\FileObject $file_object (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateFileRequest($xero_tenant_id, $file_id, $file_object, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateFile'
            );
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null || (is_array($file_id) && count($file_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_id when calling updateFile'
            );
        }
        // verify the required parameter 'file_object' is set
        if ($file_object === null || (is_array($file_object) && count($file_object) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $file_object when calling updateFile'
            );
        }
        $resourcePath = '/Files/{FileId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = FileObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FileId' . '}',
                FileObjectSerializer::toPathValue($file_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($file_object)) {
            $_tempBody = $file_object;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateFolder
     * Updates an existing folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\Folder
     */
    public function updateFolder($xero_tenant_id, $folder_id, $folder, $idempotency_key = null)
    {
        list($response) = $this->updateFolderWithHttpInfo($xero_tenant_id, $folder_id, $folder, $idempotency_key);
        return $response;
    }
    /**
     * Operation updateFolderWithHttpInfo
     * Updates an existing folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\Folder, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateFolderWithHttpInfo($xero_tenant_id, $folder_id, $folder, $idempotency_key = null)
    {
        $request = $this->updateFolderRequest($xero_tenant_id, $folder_id, $folder, $idempotency_key);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\File\Folder' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\Folder', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\Folder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateFolderAsync
     * Updates an existing folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateFolderAsync($xero_tenant_id, $folder_id, $folder, $idempotency_key = null)
    {
        return $this->updateFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id, $folder, $idempotency_key)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateFolderAsyncWithHttpInfo
     * Updates an existing folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id, $folder, $idempotency_key = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\Folder';
        $request = $this->updateFolderRequest($xero_tenant_id, $folder_id, $folder, $idempotency_key);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateFolder'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id Folder id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\File\Folder $folder (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateFolderRequest($xero_tenant_id, $folder_id, $folder, $idempotency_key = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateFolder'
            );
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null || (is_array($folder_id) && count($folder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $folder_id when calling updateFolder'
            );
        }
        // verify the required parameter 'folder' is set
        if ($folder === null || (is_array($folder) && count($folder) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $folder when calling updateFolder'
            );
        }
        $resourcePath = '/Folders/{FolderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = FileObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FolderId' . '}',
                FileObjectSerializer::toPathValue($folder_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($folder)) {
            $_tempBody = $folder;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadFile
     * Uploads a File to the inbox
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $body body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type mime_type (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\FileObject
     */
    public function uploadFile($xero_tenant_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        list($response) = $this->uploadFileWithHttpInfo($xero_tenant_id, $body, $name, $filename, $idempotency_key, $mime_type);
        return $response;
    }
    /**
     * Operation uploadFileWithHttpInfo
     * Uploads a File to the inbox
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\FileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileWithHttpInfo($xero_tenant_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        $request = $this->uploadFileRequest($xero_tenant_id, $body, $name, $filename, $idempotency_key, $mime_type);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\XeroAPI\XeroPHP\Models\File\FileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\FileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\FileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation uploadFileAsync
     * Uploads a File to the inbox
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadFileAsync($xero_tenant_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        return $this->uploadFileAsyncWithHttpInfo($xero_tenant_id, $body, $name, $filename, $idempotency_key, $mime_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation uploadFileAsyncWithHttpInfo
     * Uploads a File to the inbox
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function uploadFileAsyncWithHttpInfo($xero_tenant_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
        $request = $this->uploadFileRequest($xero_tenant_id, $body, $name, $filename, $idempotency_key, $mime_type);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFile'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function uploadFileRequest($xero_tenant_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling uploadFile'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling uploadFile'
            );
        }
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling uploadFile'
            );
        }
        // verify the required parameter 'filename' is set
        if ($filename === null || (is_array($filename) && count($filename) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $filename when calling uploadFile'
            );
        }
        $resourcePath = '/Files';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = FileObjectSerializer::toHeaderValue($idempotency_key);
        }
        // form params
        if ($body !== null) {
            $multipart = true;
            
            $formParams['body'] = FileObjectSerializer::toFormValue($body);
        }
        // form params
        if ($name !== null) {
            
            $formParams['name'] = FileObjectSerializer::toFormValue($name);
        }
        // form params
        if ($filename !== null) {
            
            $formParams['filename'] = FileObjectSerializer::toFormValue($filename);
        }
        // form params
        if ($mime_type !== null) {
            
            $formParams['mimeType'] = FileObjectSerializer::toFormValue($mime_type);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['multipart/form-data']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                        'contents' => $body,
                        'name' => $name,
                        'filename' => $filename,
                        'mimeType' => $mime_type
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadFileToFolder
     * Uploads a File to a specific folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id pass required folder id to save file to specific folder (required)
     * @param  string $body body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type mime_type (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\File\FileObject
     */
    public function uploadFileToFolder($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        list($response) = $this->uploadFileToFolderWithHttpInfo($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key, $mime_type);
        return $response;
    }
    /**
     * Operation uploadFileToFolderWithHttpInfo
     * Uploads a File to a specific folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id pass required folder id to save file to specific folder (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\File\FileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadFileToFolderWithHttpInfo($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        $request = $this->uploadFileToFolderRequest($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key, $mime_type);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\XeroAPI\XeroPHP\Models\File\FileObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\File\FileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                FileObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = FileObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\File\FileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation uploadFileToFolderAsync
     * Uploads a File to a specific folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id pass required folder id to save file to specific folder (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadFileToFolderAsync($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        return $this->uploadFileToFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key, $mime_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation uploadFileToFolderAsyncWithHttpInfo
     * Uploads a File to a specific folder
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id pass required folder id to save file to specific folder (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function uploadFileToFolderAsyncWithHttpInfo($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\File\FileObject';
        $request = $this->uploadFileToFolderRequest($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key, $mime_type);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        FileObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadFileToFolder'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $folder_id pass required folder id to save file to specific folder (required)
     * @param  string $body (required)
     * @param  string $name exact name of the file you are uploading (required)
     * @param  string $filename (required)
     * @param  string $idempotency_key This allows you to safely retry requests without the risk of duplicate processing. 128 character max. (optional)
     * @param  string $mime_type (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function uploadFileToFolderRequest($xero_tenant_id, $folder_id, $body, $name, $filename, $idempotency_key = null, $mime_type = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling uploadFileToFolder'
            );
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null || (is_array($folder_id) && count($folder_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $folder_id when calling uploadFileToFolder'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling uploadFileToFolder'
            );
        }
        // verify the required parameter 'name' is set
        if ($name === null || (is_array($name) && count($name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $name when calling uploadFileToFolder'
            );
        }
        // verify the required parameter 'filename' is set
        if ($filename === null || (is_array($filename) && count($filename) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $filename when calling uploadFileToFolder'
            );
        }
        $resourcePath = '/Files/{FolderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['xero-tenant-id'] = FileObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($idempotency_key !== null) {
            $headerParams['Idempotency-Key'] = FileObjectSerializer::toHeaderValue($idempotency_key);
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                '{' . 'FolderId' . '}',
                FileObjectSerializer::toPathValue($folder_id),
                $resourcePath
            );
        }
        // form params
        if ($body !== null) {
            $multipart = true;
            
            $formParams['body'] = FileObjectSerializer::toFormValue($body);
        }
        // form params
        if ($name !== null) {
            
            $formParams['name'] = FileObjectSerializer::toFormValue($name);
        }
        // form params
        if ($filename !== null) {
            
            $formParams['filename'] = FileObjectSerializer::toFormValue($filename);
        }
        // form params
        if ($mime_type !== null) {
            
            $formParams['mimeType'] = FileObjectSerializer::toFormValue($mime_type);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['multipart/form-data']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(FileObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                        'contents' => $body,
                        'name' => $name,
                        'filename' => $filename,
                        'mimeType' => $mime_type
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHostFile() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
