<?php
/**
 * Invoice
 *
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Models\Accounting;

use \ArrayAccess;
use \XeroAPI\XeroPHP\AccountingObjectSerializer;
use \XeroAPI\XeroPHP\StringUtil;
use ReturnTypeWillChange;

/**
 * Invoice Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Invoice implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Invoice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'type' => 'string',
        'contact' => '\XeroAPI\XeroPHP\Models\Accounting\Contact',
        'line_items' => '\XeroAPI\XeroPHP\Models\Accounting\LineItem[]',
        'date' => 'string',
        'due_date' => 'string',
        'line_amount_types' => '\XeroAPI\XeroPHP\Models\Accounting\LineAmountTypes',
        'invoice_number' => 'string',
        'reference' => 'string',
        'branding_theme_id' => 'string',
        'url' => 'string',
        'currency_code' => '\XeroAPI\XeroPHP\Models\Accounting\CurrencyCode',
        'currency_rate' => 'double',
        'status' => 'string',
        'sent_to_contact' => 'bool',
        'expected_payment_date' => 'string',
        'planned_payment_date' => 'string',
        'cis_deduction' => 'double',
        'cis_rate' => 'double',
        'sub_total' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'total_discount' => 'double',
        'invoice_id' => 'string',
        'repeating_invoice_id' => 'string',
        'has_attachments' => 'bool',
        'is_discounted' => 'bool',
        'payments' => '\XeroAPI\XeroPHP\Models\Accounting\Payment[]',
        'prepayments' => '\XeroAPI\XeroPHP\Models\Accounting\Prepayment[]',
        'overpayments' => '\XeroAPI\XeroPHP\Models\Accounting\Overpayment[]',
        'amount_due' => 'double',
        'amount_paid' => 'double',
        'fully_paid_on_date' => 'string',
        'amount_credited' => 'double',
        'updated_date_utc' => 'string',
        'credit_notes' => '\XeroAPI\XeroPHP\Models\Accounting\CreditNote[]',
        'attachments' => '\XeroAPI\XeroPHP\Models\Accounting\Attachment[]',
        'has_errors' => 'bool',
        'status_attribute_string' => 'string',
        'validation_errors' => '\XeroAPI\XeroPHP\Models\Accounting\ValidationError[]',
        'warnings' => '\XeroAPI\XeroPHP\Models\Accounting\ValidationError[]',
        'invoice_addresses' => '\XeroAPI\XeroPHP\Models\Accounting\InvoiceAddress[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'type' => null,
        'contact' => null,
        'line_items' => null,
        'date' => null,
        'due_date' => null,
        'line_amount_types' => null,
        'invoice_number' => null,
        'reference' => null,
        'branding_theme_id' => 'uuid',
        'url' => null,
        'currency_code' => null,
        'currency_rate' => 'double',
        'status' => null,
        'sent_to_contact' => null,
        'expected_payment_date' => null,
        'planned_payment_date' => null,
        'cis_deduction' => 'double',
        'cis_rate' => 'double',
        'sub_total' => 'double',
        'total_tax' => 'double',
        'total' => 'double',
        'total_discount' => 'double',
        'invoice_id' => 'uuid',
        'repeating_invoice_id' => 'uuid',
        'has_attachments' => null,
        'is_discounted' => null,
        'payments' => null,
        'prepayments' => null,
        'overpayments' => null,
        'amount_due' => 'double',
        'amount_paid' => 'double',
        'fully_paid_on_date' => null,
        'amount_credited' => 'double',
        'updated_date_utc' => null,
        'credit_notes' => null,
        'attachments' => null,
        'has_errors' => null,
        'status_attribute_string' => null,
        'validation_errors' => null,
        'warnings' => null,
        'invoice_addresses' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'type' => 'Type',
        'contact' => 'Contact',
        'line_items' => 'LineItems',
        'date' => 'Date',
        'due_date' => 'DueDate',
        'line_amount_types' => 'LineAmountTypes',
        'invoice_number' => 'InvoiceNumber',
        'reference' => 'Reference',
        'branding_theme_id' => 'BrandingThemeID',
        'url' => 'Url',
        'currency_code' => 'CurrencyCode',
        'currency_rate' => 'CurrencyRate',
        'status' => 'Status',
        'sent_to_contact' => 'SentToContact',
        'expected_payment_date' => 'ExpectedPaymentDate',
        'planned_payment_date' => 'PlannedPaymentDate',
        'cis_deduction' => 'CISDeduction',
        'cis_rate' => 'CISRate',
        'sub_total' => 'SubTotal',
        'total_tax' => 'TotalTax',
        'total' => 'Total',
        'total_discount' => 'TotalDiscount',
        'invoice_id' => 'InvoiceID',
        'repeating_invoice_id' => 'RepeatingInvoiceID',
        'has_attachments' => 'HasAttachments',
        'is_discounted' => 'IsDiscounted',
        'payments' => 'Payments',
        'prepayments' => 'Prepayments',
        'overpayments' => 'Overpayments',
        'amount_due' => 'AmountDue',
        'amount_paid' => 'AmountPaid',
        'fully_paid_on_date' => 'FullyPaidOnDate',
        'amount_credited' => 'AmountCredited',
        'updated_date_utc' => 'UpdatedDateUTC',
        'credit_notes' => 'CreditNotes',
        'attachments' => 'Attachments',
        'has_errors' => 'HasErrors',
        'status_attribute_string' => 'StatusAttributeString',
        'validation_errors' => 'ValidationErrors',
        'warnings' => 'Warnings',
        'invoice_addresses' => 'InvoiceAddresses'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'type' => 'setType',
        'contact' => 'setContact',
        'line_items' => 'setLineItems',
        'date' => 'setDate',
        'due_date' => 'setDueDate',
        'line_amount_types' => 'setLineAmountTypes',
        'invoice_number' => 'setInvoiceNumber',
        'reference' => 'setReference',
        'branding_theme_id' => 'setBrandingThemeId',
        'url' => 'setUrl',
        'currency_code' => 'setCurrencyCode',
        'currency_rate' => 'setCurrencyRate',
        'status' => 'setStatus',
        'sent_to_contact' => 'setSentToContact',
        'expected_payment_date' => 'setExpectedPaymentDate',
        'planned_payment_date' => 'setPlannedPaymentDate',
        'cis_deduction' => 'setCisDeduction',
        'cis_rate' => 'setCisRate',
        'sub_total' => 'setSubTotal',
        'total_tax' => 'setTotalTax',
        'total' => 'setTotal',
        'total_discount' => 'setTotalDiscount',
        'invoice_id' => 'setInvoiceId',
        'repeating_invoice_id' => 'setRepeatingInvoiceId',
        'has_attachments' => 'setHasAttachments',
        'is_discounted' => 'setIsDiscounted',
        'payments' => 'setPayments',
        'prepayments' => 'setPrepayments',
        'overpayments' => 'setOverpayments',
        'amount_due' => 'setAmountDue',
        'amount_paid' => 'setAmountPaid',
        'fully_paid_on_date' => 'setFullyPaidOnDate',
        'amount_credited' => 'setAmountCredited',
        'updated_date_utc' => 'setUpdatedDateUtc',
        'credit_notes' => 'setCreditNotes',
        'attachments' => 'setAttachments',
        'has_errors' => 'setHasErrors',
        'status_attribute_string' => 'setStatusAttributeString',
        'validation_errors' => 'setValidationErrors',
        'warnings' => 'setWarnings',
        'invoice_addresses' => 'setInvoiceAddresses'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'type' => 'getType',
        'contact' => 'getContact',
        'line_items' => 'getLineItems',
        'date' => 'getDate',
        'due_date' => 'getDueDate',
        'line_amount_types' => 'getLineAmountTypes',
        'invoice_number' => 'getInvoiceNumber',
        'reference' => 'getReference',
        'branding_theme_id' => 'getBrandingThemeId',
        'url' => 'getUrl',
        'currency_code' => 'getCurrencyCode',
        'currency_rate' => 'getCurrencyRate',
        'status' => 'getStatus',
        'sent_to_contact' => 'getSentToContact',
        'expected_payment_date' => 'getExpectedPaymentDate',
        'planned_payment_date' => 'getPlannedPaymentDate',
        'cis_deduction' => 'getCisDeduction',
        'cis_rate' => 'getCisRate',
        'sub_total' => 'getSubTotal',
        'total_tax' => 'getTotalTax',
        'total' => 'getTotal',
        'total_discount' => 'getTotalDiscount',
        'invoice_id' => 'getInvoiceId',
        'repeating_invoice_id' => 'getRepeatingInvoiceId',
        'has_attachments' => 'getHasAttachments',
        'is_discounted' => 'getIsDiscounted',
        'payments' => 'getPayments',
        'prepayments' => 'getPrepayments',
        'overpayments' => 'getOverpayments',
        'amount_due' => 'getAmountDue',
        'amount_paid' => 'getAmountPaid',
        'fully_paid_on_date' => 'getFullyPaidOnDate',
        'amount_credited' => 'getAmountCredited',
        'updated_date_utc' => 'getUpdatedDateUtc',
        'credit_notes' => 'getCreditNotes',
        'attachments' => 'getAttachments',
        'has_errors' => 'getHasErrors',
        'status_attribute_string' => 'getStatusAttributeString',
        'validation_errors' => 'getValidationErrors',
        'warnings' => 'getWarnings',
        'invoice_addresses' => 'getInvoiceAddresses'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const TYPE_ACCPAY = 'ACCPAY';
    const TYPE_ACCPAYCREDIT = 'ACCPAYCREDIT';
    const TYPE_APOVERPAYMENT = 'APOVERPAYMENT';
    const TYPE_APPREPAYMENT = 'APPREPAYMENT';
    const TYPE_ACCREC = 'ACCREC';
    const TYPE_ACCRECCREDIT = 'ACCRECCREDIT';
    const TYPE_AROVERPAYMENT = 'AROVERPAYMENT';
    const TYPE_ARPREPAYMENT = 'ARPREPAYMENT';
    const STATUS_DRAFT = 'DRAFT';
    const STATUS_SUBMITTED = 'SUBMITTED';
    const STATUS_DELETED = 'DELETED';
    const STATUS_AUTHORISED = 'AUTHORISED';
    const STATUS_PAID = 'PAID';
    const STATUS_VOIDED = 'VOIDED';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ACCPAY,
            self::TYPE_ACCPAYCREDIT,
            self::TYPE_APOVERPAYMENT,
            self::TYPE_APPREPAYMENT,
            self::TYPE_ACCREC,
            self::TYPE_ACCRECCREDIT,
            self::TYPE_AROVERPAYMENT,
            self::TYPE_ARPREPAYMENT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_DRAFT,
            self::STATUS_SUBMITTED,
            self::STATUS_DELETED,
            self::STATUS_AUTHORISED,
            self::STATUS_PAID,
            self::STATUS_VOIDED,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['contact'] = isset($data['contact']) ? $data['contact'] : null;
        $this->container['line_items'] = isset($data['line_items']) ? $data['line_items'] : null;
        $this->container['date'] = isset($data['date']) ? $data['date'] : null;
        $this->container['due_date'] = isset($data['due_date']) ? $data['due_date'] : null;
        $this->container['line_amount_types'] = isset($data['line_amount_types']) ? $data['line_amount_types'] : null;
        $this->container['invoice_number'] = isset($data['invoice_number']) ? $data['invoice_number'] : null;
        $this->container['reference'] = isset($data['reference']) ? $data['reference'] : null;
        $this->container['branding_theme_id'] = isset($data['branding_theme_id']) ? $data['branding_theme_id'] : null;
        $this->container['url'] = isset($data['url']) ? $data['url'] : null;
        $this->container['currency_code'] = isset($data['currency_code']) ? $data['currency_code'] : null;
        $this->container['currency_rate'] = isset($data['currency_rate']) ? $data['currency_rate'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['sent_to_contact'] = isset($data['sent_to_contact']) ? $data['sent_to_contact'] : null;
        $this->container['expected_payment_date'] = isset($data['expected_payment_date']) ? $data['expected_payment_date'] : null;
        $this->container['planned_payment_date'] = isset($data['planned_payment_date']) ? $data['planned_payment_date'] : null;
        $this->container['cis_deduction'] = isset($data['cis_deduction']) ? $data['cis_deduction'] : null;
        $this->container['cis_rate'] = isset($data['cis_rate']) ? $data['cis_rate'] : null;
        $this->container['sub_total'] = isset($data['sub_total']) ? $data['sub_total'] : null;
        $this->container['total_tax'] = isset($data['total_tax']) ? $data['total_tax'] : null;
        $this->container['total'] = isset($data['total']) ? $data['total'] : null;
        $this->container['total_discount'] = isset($data['total_discount']) ? $data['total_discount'] : null;
        $this->container['invoice_id'] = isset($data['invoice_id']) ? $data['invoice_id'] : null;
        $this->container['repeating_invoice_id'] = isset($data['repeating_invoice_id']) ? $data['repeating_invoice_id'] : null;
        $this->container['has_attachments'] = isset($data['has_attachments']) ? $data['has_attachments'] : false;
        $this->container['is_discounted'] = isset($data['is_discounted']) ? $data['is_discounted'] : null;
        $this->container['payments'] = isset($data['payments']) ? $data['payments'] : null;
        $this->container['prepayments'] = isset($data['prepayments']) ? $data['prepayments'] : null;
        $this->container['overpayments'] = isset($data['overpayments']) ? $data['overpayments'] : null;
        $this->container['amount_due'] = isset($data['amount_due']) ? $data['amount_due'] : null;
        $this->container['amount_paid'] = isset($data['amount_paid']) ? $data['amount_paid'] : null;
        $this->container['fully_paid_on_date'] = isset($data['fully_paid_on_date']) ? $data['fully_paid_on_date'] : null;
        $this->container['amount_credited'] = isset($data['amount_credited']) ? $data['amount_credited'] : null;
        $this->container['updated_date_utc'] = isset($data['updated_date_utc']) ? $data['updated_date_utc'] : null;
        $this->container['credit_notes'] = isset($data['credit_notes']) ? $data['credit_notes'] : null;
        $this->container['attachments'] = isset($data['attachments']) ? $data['attachments'] : null;
        $this->container['has_errors'] = isset($data['has_errors']) ? $data['has_errors'] : false;
        $this->container['status_attribute_string'] = isset($data['status_attribute_string']) ? $data['status_attribute_string'] : null;
        $this->container['validation_errors'] = isset($data['validation_errors']) ? $data['validation_errors'] : null;
        $this->container['warnings'] = isset($data['warnings']) ? $data['warnings'] : null;
        $this->container['invoice_addresses'] = isset($data['invoice_addresses']) ? $data['invoice_addresses'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        if (!is_null($this->container['invoice_number']) && (mb_strlen($this->container['invoice_number']) > 255)) {
            $invalidProperties[] = "invalid value for 'invoice_number', the character length must be smaller than or equal to 255.";
        }

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'status', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type See Invoice Types
     *
     * @return $this
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($type) && !in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }

        $this->container['type'] = $type;

        return $this;
    }



    /**
     * Gets contact
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Contact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Contact|null $contact contact
     *
     * @return $this
     */
    public function setContact($contact)
    {

        $this->container['contact'] = $contact;

        return $this;
    }



    /**
     * Gets line_items
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\LineItem[]|null
     */
    public function getLineItems()
    {
        return $this->container['line_items'];
    }

    /**
     * Sets line_items
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\LineItem[]|null $line_items See LineItems
     *
     * @return $this
     */
    public function setLineItems($line_items)
    {

        $this->container['line_items'] = $line_items;

        return $this;
    }



    /**
     * Gets date
     *
     * @return string|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }
    public function getDateAsDate()
    {
      if ($this->getDate() != null) {
        return StringUtil::convertStringToDate($this->getDate());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets date
     *
     * @param string|null $date Date invoice was issued – YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation
     *
     * @return $this
     */
    public function setDate($date)
    {

        $this->container['date'] = $date;

        return $this;
    }
    /**
     * Sets date
     *
     * @param \DateTime |null $date Date invoice was issued – YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation
     *
     * @return $this
     */
    public function setDateAsDate($date)
    {
      //CONVERT Date into MS DateFromat String 
      if (StringUtil::checkThisDate($date->format('Y-m-d')) )
      {        
        $timeInMillis = strtotime($date->format('Y-m-d')." UTC") * 1000;
        $date = "/Date(" . $timeInMillis. "+0000)/";
      }  
      $this->container['date'] = $date;
      return $this;
    }



    /**
     * Gets due_date
     *
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->container['due_date'];
    }
    public function getDueDateAsDate()
    {
      if ($this->getDueDate() != null) {
        return StringUtil::convertStringToDate($this->getDueDate());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets due_date
     *
     * @param string|null $due_date Date invoice is due – YYYY-MM-DD
     *
     * @return $this
     */
    public function setDueDate($due_date)
    {

        $this->container['due_date'] = $due_date;

        return $this;
    }
    /**
     * Sets due_date
     *
     * @param \DateTime |null $due_date Date invoice is due – YYYY-MM-DD
     *
     * @return $this
     */
    public function setDueDateAsDate($due_date)
    {
      //CONVERT Date into MS DateFromat String 
      if (StringUtil::checkThisDate($due_date->format('Y-m-d')) )
      {        
        $timeInMillis = strtotime($due_date->format('Y-m-d')." UTC") * 1000;
        $due_date = "/Date(" . $timeInMillis. "+0000)/";
      }  
      $this->container['due_date'] = $due_date;
      return $this;
    }



    /**
     * Gets line_amount_types
     *
     * @return string|null
     */
    public function getLineAmountTypes()
    {
        return $this->container['line_amount_types'];
    }

    /**
     * Sets line_amount_types
     *
     * @param string|null $line_amount_types line_amount_types
     *
     * @return $this
     */
    public function setLineAmountTypes($line_amount_types)
    {

        $this->container['line_amount_types'] = $line_amount_types;

        return $this;
    }



    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number ACCREC – Unique alpha numeric code identifying invoice (when missing will auto-generate from your Organisation Invoice Settings) (max length = 255)
     *
     * @return $this
     */
    public function setInvoiceNumber($invoice_number)
    {
        if (!is_null($invoice_number) && (mb_strlen($invoice_number) > 255)) {
            throw new \InvalidArgumentException('invalid length for $invoice_number when calling Invoice., must be smaller than or equal to 255.');
        }


        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }



    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference ACCREC only – additional reference number
     *
     * @return $this
     */
    public function setReference($reference)
    {

        $this->container['reference'] = $reference;

        return $this;
    }



    /**
     * Gets branding_theme_id
     *
     * @return string|null
     */
    public function getBrandingThemeId()
    {
        return $this->container['branding_theme_id'];
    }

    /**
     * Sets branding_theme_id
     *
     * @param string|null $branding_theme_id See BrandingThemes
     *
     * @return $this
     */
    public function setBrandingThemeId($branding_theme_id)
    {

        $this->container['branding_theme_id'] = $branding_theme_id;

        return $this;
    }



    /**
     * Gets url
     *
     * @return string|null
     */
    public function getUrl()
    {
        return $this->container['url'];
    }

    /**
     * Sets url
     *
     * @param string|null $url URL link to a source document – shown as “Go to [appName]” in the Xero app
     *
     * @return $this
     */
    public function setUrl($url)
    {

        $this->container['url'] = $url;

        return $this;
    }



    /**
     * Gets currency_code
     *
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->container['currency_code'];
    }

    /**
     * Sets currency_code
     *
     * @param string|null $currency_code currency_code
     *
     * @return $this
     */
    public function setCurrencyCode($currency_code)
    {

        $this->container['currency_code'] = $currency_code;

        return $this;
    }



    /**
     * Gets currency_rate
     *
     * @return double|null
     */
    public function getCurrencyRate()
    {
        return $this->container['currency_rate'];
    }

    /**
     * Sets currency_rate
     *
     * @param double|null $currency_rate The currency rate for a multicurrency invoice. If no rate is specified, the XE.com day rate is used. (max length = [18].[6])
     *
     * @return $this
     */
    public function setCurrencyRate($currency_rate)
    {

        $this->container['currency_rate'] = $currency_rate;

        return $this;
    }



    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status See Invoice Status Codes
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'status', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }

        $this->container['status'] = $status;

        return $this;
    }



    /**
     * Gets sent_to_contact
     *
     * @return bool|null
     */
    public function getSentToContact()
    {
        return $this->container['sent_to_contact'];
    }

    /**
     * Sets sent_to_contact
     *
     * @param bool|null $sent_to_contact Boolean to set whether the invoice in the Xero app should be marked as “sent”. This can be set only on invoices that have been approved
     *
     * @return $this
     */
    public function setSentToContact($sent_to_contact)
    {

        $this->container['sent_to_contact'] = $sent_to_contact;

        return $this;
    }



    /**
     * Gets expected_payment_date
     *
     * @return string|null
     */
    public function getExpectedPaymentDate()
    {
        return $this->container['expected_payment_date'];
    }
    public function getExpectedPaymentDateAsDate()
    {
      if ($this->getExpectedPaymentDate() != null) {
        return StringUtil::convertStringToDate($this->getExpectedPaymentDate());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets expected_payment_date
     *
     * @param string|null $expected_payment_date Shown on sales invoices (Accounts Receivable) when this has been set
     *
     * @return $this
     */
    public function setExpectedPaymentDate($expected_payment_date)
    {

        $this->container['expected_payment_date'] = $expected_payment_date;

        return $this;
    }
    /**
     * Sets expected_payment_date
     *
     * @param \DateTime |null $expected_payment_date Shown on sales invoices (Accounts Receivable) when this has been set
     *
     * @return $this
     */
    public function setExpectedPaymentDateAsDate($expected_payment_date)
    {
      //CONVERT Date into MS DateFromat String 
      if (StringUtil::checkThisDate($expected_payment_date->format('Y-m-d')) )
      {        
        $timeInMillis = strtotime($expected_payment_date->format('Y-m-d')." UTC") * 1000;
        $expected_payment_date = "/Date(" . $timeInMillis. "+0000)/";
      }  
      $this->container['expected_payment_date'] = $expected_payment_date;
      return $this;
    }



    /**
     * Gets planned_payment_date
     *
     * @return string|null
     */
    public function getPlannedPaymentDate()
    {
        return $this->container['planned_payment_date'];
    }
    public function getPlannedPaymentDateAsDate()
    {
      if ($this->getPlannedPaymentDate() != null) {
        return StringUtil::convertStringToDate($this->getPlannedPaymentDate());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets planned_payment_date
     *
     * @param string|null $planned_payment_date Shown on bills (Accounts Payable) when this has been set
     *
     * @return $this
     */
    public function setPlannedPaymentDate($planned_payment_date)
    {

        $this->container['planned_payment_date'] = $planned_payment_date;

        return $this;
    }
    /**
     * Sets planned_payment_date
     *
     * @param \DateTime |null $planned_payment_date Shown on bills (Accounts Payable) when this has been set
     *
     * @return $this
     */
    public function setPlannedPaymentDateAsDate($planned_payment_date)
    {
      //CONVERT Date into MS DateFromat String 
      if (StringUtil::checkThisDate($planned_payment_date->format('Y-m-d')) )
      {        
        $timeInMillis = strtotime($planned_payment_date->format('Y-m-d')." UTC") * 1000;
        $planned_payment_date = "/Date(" . $timeInMillis. "+0000)/";
      }  
      $this->container['planned_payment_date'] = $planned_payment_date;
      return $this;
    }



    /**
     * Gets cis_deduction
     *
     * @return double|null
     */
    public function getCisDeduction()
    {
        return $this->container['cis_deduction'];
    }

    /**
     * Sets cis_deduction
     *
     * @param double|null $cis_deduction CIS deduction for UK contractors
     *
     * @return $this
     */
    public function setCisDeduction($cis_deduction)
    {

        $this->container['cis_deduction'] = $cis_deduction;

        return $this;
    }


    /**
     * Gets cis_rate
     *
     * @return double|null
     */
    public function getCisRate()
    {
        return $this->container['cis_rate'];
    }

    /**
     * Sets cis_rate
     *
     * @param double|null $cis_rate CIS Deduction rate for the organisation
     *
     * @return $this
     */
    public function setCisRate($cis_rate)
    {

        $this->container['cis_rate'] = $cis_rate;

        return $this;
    }


    /**
     * Gets sub_total
     *
     * @return double|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param double|null $sub_total Total of invoice excluding taxes
     *
     * @return $this
     */
    public function setSubTotal($sub_total)
    {

        $this->container['sub_total'] = $sub_total;

        return $this;
    }


    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax Total tax on invoice
     *
     * @return $this
     */
    public function setTotalTax($total_tax)
    {

        $this->container['total_tax'] = $total_tax;

        return $this;
    }


    /**
     * Gets total
     *
     * @return double|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param double|null $total Total of Invoice tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn’t equal the sum of the LineAmounts
     *
     * @return $this
     */
    public function setTotal($total)
    {

        $this->container['total'] = $total;

        return $this;
    }


    /**
     * Gets total_discount
     *
     * @return double|null
     */
    public function getTotalDiscount()
    {
        return $this->container['total_discount'];
    }

    /**
     * Sets total_discount
     *
     * @param double|null $total_discount Total of discounts applied on the invoice line items
     *
     * @return $this
     */
    public function setTotalDiscount($total_discount)
    {

        $this->container['total_discount'] = $total_discount;

        return $this;
    }


    /**
     * Gets invoice_id
     *
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->container['invoice_id'];
    }

    /**
     * Sets invoice_id
     *
     * @param string|null $invoice_id Xero generated unique identifier for invoice
     *
     * @return $this
     */
    public function setInvoiceId($invoice_id)
    {

        $this->container['invoice_id'] = $invoice_id;

        return $this;
    }



    /**
     * Gets repeating_invoice_id
     *
     * @return string|null
     */
    public function getRepeatingInvoiceId()
    {
        return $this->container['repeating_invoice_id'];
    }

    /**
     * Sets repeating_invoice_id
     *
     * @param string|null $repeating_invoice_id Xero generated unique identifier for repeating invoices
     *
     * @return $this
     */
    public function setRepeatingInvoiceId($repeating_invoice_id)
    {

        $this->container['repeating_invoice_id'] = $repeating_invoice_id;

        return $this;
    }



    /**
     * Gets has_attachments
     *
     * @return bool|null
     */
    public function getHasAttachments()
    {
        return $this->container['has_attachments'];
    }

    /**
     * Sets has_attachments
     *
     * @param bool|null $has_attachments boolean to indicate if an invoice has an attachment
     *
     * @return $this
     */
    public function setHasAttachments($has_attachments)
    {

        $this->container['has_attachments'] = $has_attachments;

        return $this;
    }


    /**
     * Gets is_discounted
     *
     * @return bool|null
     */
    public function getIsDiscounted()
    {
        return $this->container['is_discounted'];
    }

    /**
     * Sets is_discounted
     *
     * @param bool|null $is_discounted boolean to indicate if an invoice has a discount
     *
     * @return $this
     */
    public function setIsDiscounted($is_discounted)
    {

        $this->container['is_discounted'] = $is_discounted;

        return $this;
    }


    /**
     * Gets payments
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Payment[]|null
     */
    public function getPayments()
    {
        return $this->container['payments'];
    }

    /**
     * Sets payments
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Payment[]|null $payments See Payments
     *
     * @return $this
     */
    public function setPayments($payments)
    {

        $this->container['payments'] = $payments;

        return $this;
    }


    /**
     * Gets prepayments
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Prepayment[]|null
     */
    public function getPrepayments()
    {
        return $this->container['prepayments'];
    }

    /**
     * Sets prepayments
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Prepayment[]|null $prepayments See Prepayments
     *
     * @return $this
     */
    public function setPrepayments($prepayments)
    {

        $this->container['prepayments'] = $prepayments;

        return $this;
    }


    /**
     * Gets overpayments
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Overpayment[]|null
     */
    public function getOverpayments()
    {
        return $this->container['overpayments'];
    }

    /**
     * Sets overpayments
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Overpayment[]|null $overpayments See Overpayments
     *
     * @return $this
     */
    public function setOverpayments($overpayments)
    {

        $this->container['overpayments'] = $overpayments;

        return $this;
    }


    /**
     * Gets amount_due
     *
     * @return double|null
     */
    public function getAmountDue()
    {
        return $this->container['amount_due'];
    }

    /**
     * Sets amount_due
     *
     * @param double|null $amount_due Amount remaining to be paid on invoice
     *
     * @return $this
     */
    public function setAmountDue($amount_due)
    {

        $this->container['amount_due'] = $amount_due;

        return $this;
    }


    /**
     * Gets amount_paid
     *
     * @return double|null
     */
    public function getAmountPaid()
    {
        return $this->container['amount_paid'];
    }

    /**
     * Sets amount_paid
     *
     * @param double|null $amount_paid Sum of payments received for invoice
     *
     * @return $this
     */
    public function setAmountPaid($amount_paid)
    {

        $this->container['amount_paid'] = $amount_paid;

        return $this;
    }


    /**
     * Gets fully_paid_on_date
     *
     * @return string|null
     */
    public function getFullyPaidOnDate()
    {
        return $this->container['fully_paid_on_date'];
    }
    public function getFullyPaidOnDateAsDate()
    {
      if ($this->getFullyPaidOnDate() != null) {
        return StringUtil::convertStringToDate($this->getFullyPaidOnDate());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets fully_paid_on_date
     *
     * @param string|null $fully_paid_on_date The date the invoice was fully paid. Only returned on fully paid invoices
     *
     * @return $this
     */
    public function setFullyPaidOnDate($fully_paid_on_date)
    {

        $this->container['fully_paid_on_date'] = $fully_paid_on_date;

        return $this;
    }


    /**
     * Gets amount_credited
     *
     * @return double|null
     */
    public function getAmountCredited()
    {
        return $this->container['amount_credited'];
    }

    /**
     * Sets amount_credited
     *
     * @param double|null $amount_credited Sum of all credit notes, over-payments and pre-payments applied to invoice
     *
     * @return $this
     */
    public function setAmountCredited($amount_credited)
    {

        $this->container['amount_credited'] = $amount_credited;

        return $this;
    }


    /**
     * Gets updated_date_utc
     *
     * @return string|null
     */
    public function getUpdatedDateUtc()
    {
        return $this->container['updated_date_utc'];
    }
    public function getUpdatedDateUtcAsDate()
    {
      if ($this->getUpdatedDateUtc() != null) {
        return StringUtil::convertStringToDateTime($this->getUpdatedDateUtc());
      } else {
        throw new \Exception('can not convert null string to date');
      } 
    }

    /**
     * Sets updated_date_utc
     *
     * @param string|null $updated_date_utc Last modified date UTC format
     *
     * @return $this
     */
    public function setUpdatedDateUtc($updated_date_utc)
    {

        $this->container['updated_date_utc'] = $updated_date_utc;

        return $this;
    }


    /**
     * Gets credit_notes
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\CreditNote[]|null
     */
    public function getCreditNotes()
    {
        return $this->container['credit_notes'];
    }

    /**
     * Sets credit_notes
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\CreditNote[]|null $credit_notes Details of credit notes that have been applied to an invoice
     *
     * @return $this
     */
    public function setCreditNotes($credit_notes)
    {

        $this->container['credit_notes'] = $credit_notes;

        return $this;
    }


    /**
     * Gets attachments
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\Attachment[]|null
     */
    public function getAttachments()
    {
        return $this->container['attachments'];
    }

    /**
     * Sets attachments
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\Attachment[]|null $attachments Displays array of attachments from the API
     *
     * @return $this
     */
    public function setAttachments($attachments)
    {

        $this->container['attachments'] = $attachments;

        return $this;
    }



    /**
     * Gets has_errors
     *
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->container['has_errors'];
    }

    /**
     * Sets has_errors
     *
     * @param bool|null $has_errors A boolean to indicate if a invoice has an validation errors
     *
     * @return $this
     */
    public function setHasErrors($has_errors)
    {

        $this->container['has_errors'] = $has_errors;

        return $this;
    }



    /**
     * Gets status_attribute_string
     *
     * @return string|null
     */
    public function getStatusAttributeString()
    {
        return $this->container['status_attribute_string'];
    }

    /**
     * Sets status_attribute_string
     *
     * @param string|null $status_attribute_string A string to indicate if a invoice status
     *
     * @return $this
     */
    public function setStatusAttributeString($status_attribute_string)
    {

        $this->container['status_attribute_string'] = $status_attribute_string;

        return $this;
    }



    /**
     * Gets validation_errors
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\ValidationError[]|null
     */
    public function getValidationErrors()
    {
        return $this->container['validation_errors'];
    }

    /**
     * Sets validation_errors
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\ValidationError[]|null $validation_errors Displays array of validation error messages from the API
     *
     * @return $this
     */
    public function setValidationErrors($validation_errors)
    {

        $this->container['validation_errors'] = $validation_errors;

        return $this;
    }



    /**
     * Gets warnings
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\ValidationError[]|null
     */
    public function getWarnings()
    {
        return $this->container['warnings'];
    }

    /**
     * Sets warnings
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\ValidationError[]|null $warnings Displays array of warning messages from the API
     *
     * @return $this
     */
    public function setWarnings($warnings)
    {

        $this->container['warnings'] = $warnings;

        return $this;
    }



    /**
     * Gets invoice_addresses
     *
     * @return \XeroAPI\XeroPHP\Models\Accounting\InvoiceAddress[]|null
     */
    public function getInvoiceAddresses()
    {
        return $this->container['invoice_addresses'];
    }

    /**
     * Sets invoice_addresses
     *
     * @param \XeroAPI\XeroPHP\Models\Accounting\InvoiceAddress[]|null $invoice_addresses An array of addresses used to auto calculate sales tax
     *
     * @return $this
     */
    public function setInvoiceAddresses($invoice_addresses)
    {

        $this->container['invoice_addresses'] = $invoice_addresses;

        return $this;
    }


    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            AccountingObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


