<?php
/**
 * TaxBreakdownComponent
 *
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Accounting API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.4.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Models\Accounting;

use \ArrayAccess;
use \XeroAPI\XeroPHP\AccountingObjectSerializer;
use \XeroAPI\XeroPHP\StringUtil;
use ReturnTypeWillChange;

/**
 * TaxBreakdownComponent Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TaxBreakdownComponent implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TaxBreakdownComponent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tax_component_id' => 'string',
        'type' => 'string',
        'name' => 'string',
        'tax_percentage' => 'float',
        'tax_amount' => 'float',
        'taxable_amount' => 'float',
        'non_taxable_amount' => 'float',
        'exempt_amount' => 'float',
        'state_assigned_no' => 'string',
        'jurisdiction_region' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'tax_component_id' => 'uuid',
        'type' => null,
        'name' => null,
        'tax_percentage' => null,
        'tax_amount' => null,
        'taxable_amount' => null,
        'non_taxable_amount' => null,
        'exempt_amount' => null,
        'state_assigned_no' => null,
        'jurisdiction_region' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tax_component_id' => 'TaxComponentId',
        'type' => 'Type',
        'name' => 'Name',
        'tax_percentage' => 'TaxPercentage',
        'tax_amount' => 'TaxAmount',
        'taxable_amount' => 'TaxableAmount',
        'non_taxable_amount' => 'NonTaxableAmount',
        'exempt_amount' => 'ExemptAmount',
        'state_assigned_no' => 'StateAssignedNo',
        'jurisdiction_region' => 'JurisdictionRegion'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tax_component_id' => 'setTaxComponentId',
        'type' => 'setType',
        'name' => 'setName',
        'tax_percentage' => 'setTaxPercentage',
        'tax_amount' => 'setTaxAmount',
        'taxable_amount' => 'setTaxableAmount',
        'non_taxable_amount' => 'setNonTaxableAmount',
        'exempt_amount' => 'setExemptAmount',
        'state_assigned_no' => 'setStateAssignedNo',
        'jurisdiction_region' => 'setJurisdictionRegion'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tax_component_id' => 'getTaxComponentId',
        'type' => 'getType',
        'name' => 'getName',
        'tax_percentage' => 'getTaxPercentage',
        'tax_amount' => 'getTaxAmount',
        'taxable_amount' => 'getTaxableAmount',
        'non_taxable_amount' => 'getNonTaxableAmount',
        'exempt_amount' => 'getExemptAmount',
        'state_assigned_no' => 'getStateAssignedNo',
        'jurisdiction_region' => 'getJurisdictionRegion'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const TYPE_USCOUNTRY = 'SYSGST/USCOUNTRY';
    const TYPE_USSTATE = 'SYSGST/USSTATE';
    const TYPE_USCOUNTY = 'SYSGST/USCOUNTY';
    const TYPE_USCITY = 'SYSGST/USCITY';
    const TYPE_USSPECIAL = 'SYSGST/USSPECIAL';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_USCOUNTRY,
            self::TYPE_USSTATE,
            self::TYPE_USCOUNTY,
            self::TYPE_USCITY,
            self::TYPE_USSPECIAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tax_component_id'] = isset($data['tax_component_id']) ? $data['tax_component_id'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['tax_percentage'] = isset($data['tax_percentage']) ? $data['tax_percentage'] : null;
        $this->container['tax_amount'] = isset($data['tax_amount']) ? $data['tax_amount'] : null;
        $this->container['taxable_amount'] = isset($data['taxable_amount']) ? $data['taxable_amount'] : null;
        $this->container['non_taxable_amount'] = isset($data['non_taxable_amount']) ? $data['non_taxable_amount'] : null;
        $this->container['exempt_amount'] = isset($data['exempt_amount']) ? $data['exempt_amount'] : null;
        $this->container['state_assigned_no'] = isset($data['state_assigned_no']) ? $data['state_assigned_no'] : null;
        $this->container['jurisdiction_region'] = isset($data['jurisdiction_region']) ? $data['jurisdiction_region'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets tax_component_id
     *
     * @return string|null
     */
    public function getTaxComponentId()
    {
        return $this->container['tax_component_id'];
    }

    /**
     * Sets tax_component_id
     *
     * @param string|null $tax_component_id The unique ID number of this component
     *
     * @return $this
     */
    public function setTaxComponentId($tax_component_id)
    {

        $this->container['tax_component_id'] = $tax_component_id;

        return $this;
    }



    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The type of the jurisdiction
     *
     * @return $this
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($type) && !in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }

        $this->container['type'] = $type;

        return $this;
    }



    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the jurisdiction
     *
     * @return $this
     */
    public function setName($name)
    {

        $this->container['name'] = $name;

        return $this;
    }



    /**
     * Gets tax_percentage
     *
     * @return float|null
     */
    public function getTaxPercentage()
    {
        return $this->container['tax_percentage'];
    }

    /**
     * Sets tax_percentage
     *
     * @param float|null $tax_percentage The percentage of the tax
     *
     * @return $this
     */
    public function setTaxPercentage($tax_percentage)
    {

        $this->container['tax_percentage'] = $tax_percentage;

        return $this;
    }



    /**
     * Gets tax_amount
     *
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param float|null $tax_amount The amount of the tax
     *
     * @return $this
     */
    public function setTaxAmount($tax_amount)
    {

        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }



    /**
     * Gets taxable_amount
     *
     * @return float|null
     */
    public function getTaxableAmount()
    {
        return $this->container['taxable_amount'];
    }

    /**
     * Sets taxable_amount
     *
     * @param float|null $taxable_amount The amount that is taxable
     *
     * @return $this
     */
    public function setTaxableAmount($taxable_amount)
    {

        $this->container['taxable_amount'] = $taxable_amount;

        return $this;
    }



    /**
     * Gets non_taxable_amount
     *
     * @return float|null
     */
    public function getNonTaxableAmount()
    {
        return $this->container['non_taxable_amount'];
    }

    /**
     * Sets non_taxable_amount
     *
     * @param float|null $non_taxable_amount The amount that is not taxable
     *
     * @return $this
     */
    public function setNonTaxableAmount($non_taxable_amount)
    {

        $this->container['non_taxable_amount'] = $non_taxable_amount;

        return $this;
    }



    /**
     * Gets exempt_amount
     *
     * @return float|null
     */
    public function getExemptAmount()
    {
        return $this->container['exempt_amount'];
    }

    /**
     * Sets exempt_amount
     *
     * @param float|null $exempt_amount The amount that is exempt
     *
     * @return $this
     */
    public function setExemptAmount($exempt_amount)
    {

        $this->container['exempt_amount'] = $exempt_amount;

        return $this;
    }



    /**
     * Gets state_assigned_no
     *
     * @return string|null
     */
    public function getStateAssignedNo()
    {
        return $this->container['state_assigned_no'];
    }

    /**
     * Sets state_assigned_no
     *
     * @param string|null $state_assigned_no The state assigned number of the jurisdiction
     *
     * @return $this
     */
    public function setStateAssignedNo($state_assigned_no)
    {

        $this->container['state_assigned_no'] = $state_assigned_no;

        return $this;
    }



    /**
     * Gets jurisdiction_region
     *
     * @return string|null
     */
    public function getJurisdictionRegion()
    {
        return $this->container['jurisdiction_region'];
    }

    /**
     * Sets jurisdiction_region
     *
     * @param string|null $jurisdiction_region Name identifying the region within the country
     *
     * @return $this
     */
    public function setJurisdictionRegion($jurisdiction_region)
    {

        $this->container['jurisdiction_region'] = $jurisdiction_region;

        return $this;
    }


    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            AccountingObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


