<?php
// This file was auto-generated from sdk-root/src/data/wickr/2024-02-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2024-02-01', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'admin.wickr', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'AWS Wickr Admin API', 'serviceId' => 'Wickr', 'signatureVersion' => 'v4', 'signingName' => 'wickr', 'uid' => 'wickr-2024-02-01', ], 'operations' => [ 'BatchCreateUser' => [ 'name' => 'BatchCreateUser', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/users', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchCreateUserRequest', ], 'output' => [ 'shape' => 'BatchCreateUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'BatchDeleteUser' => [ 'name' => 'BatchDeleteUser', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/users/batch-delete', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchDeleteUserRequest', ], 'output' => [ 'shape' => 'BatchDeleteUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'BatchLookupUserUname' => [ 'name' => 'BatchLookupUserUname', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/users/uname-lookup', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchLookupUserUnameRequest', ], 'output' => [ 'shape' => 'BatchLookupUserUnameResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'BatchReinviteUser' => [ 'name' => 'BatchReinviteUser', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/users/re-invite', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchReinviteUserRequest', ], 'output' => [ 'shape' => 'BatchReinviteUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'BatchResetDevicesForUser' => [ 'name' => 'BatchResetDevicesForUser', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/users/{userId}/devices', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchResetDevicesForUserRequest', ], 'output' => [ 'shape' => 'BatchResetDevicesForUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'BatchToggleUserSuspendStatus' => [ 'name' => 'BatchToggleUserSuspendStatus', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/users/toggleSuspend', 'responseCode' => 200, ], 'input' => [ 'shape' => 'BatchToggleUserSuspendStatusRequest', ], 'output' => [ 'shape' => 'BatchToggleUserSuspendStatusResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'CreateBot' => [ 'name' => 'CreateBot', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/bots', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateBotRequest', ], 'output' => [ 'shape' => 'CreateBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'CreateDataRetentionBot' => [ 'name' => 'CreateDataRetentionBot', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/data-retention-bots', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDataRetentionBotRequest', ], 'output' => [ 'shape' => 'CreateDataRetentionBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'CreateDataRetentionBotChallenge' => [ 'name' => 'CreateDataRetentionBotChallenge', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/data-retention-bots/challenge', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateDataRetentionBotChallengeRequest', ], 'output' => [ 'shape' => 'CreateDataRetentionBotChallengeResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'CreateNetwork' => [ 'name' => 'CreateNetwork', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateNetworkRequest', ], 'output' => [ 'shape' => 'CreateNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'CreateSecurityGroup' => [ 'name' => 'CreateSecurityGroup', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/security-groups', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSecurityGroupRequest', ], 'output' => [ 'shape' => 'CreateSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'DeleteBot' => [ 'name' => 'DeleteBot', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/networks/{networkId}/bots/{botId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteBotRequest', ], 'output' => [ 'shape' => 'DeleteBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'DeleteDataRetentionBot' => [ 'name' => 'DeleteDataRetentionBot', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/networks/{networkId}/data-retention-bots', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDataRetentionBotRequest', ], 'output' => [ 'shape' => 'DeleteDataRetentionBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'DeleteNetwork' => [ 'name' => 'DeleteNetwork', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/networks/{networkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteNetworkRequest', ], 'output' => [ 'shape' => 'DeleteNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'DeleteSecurityGroup' => [ 'name' => 'DeleteSecurityGroup', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/networks/{networkId}/security-groups/{groupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSecurityGroupRequest', ], 'output' => [ 'shape' => 'DeleteSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'GetBot' => [ 'name' => 'GetBot', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/bots/{botId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBotRequest', ], 'output' => [ 'shape' => 'GetBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetBotsCount' => [ 'name' => 'GetBotsCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/bots/count', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBotsCountRequest', ], 'output' => [ 'shape' => 'GetBotsCountResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetDataRetentionBot' => [ 'name' => 'GetDataRetentionBot', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/data-retention-bots', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataRetentionBotRequest', ], 'output' => [ 'shape' => 'GetDataRetentionBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetGuestUserHistoryCount' => [ 'name' => 'GetGuestUserHistoryCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/guest-users/count', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetGuestUserHistoryCountRequest', ], 'output' => [ 'shape' => 'GetGuestUserHistoryCountResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetNetwork' => [ 'name' => 'GetNetwork', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetNetworkRequest', ], 'output' => [ 'shape' => 'GetNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetNetworkSettings' => [ 'name' => 'GetNetworkSettings', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/settings', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetNetworkSettingsRequest', ], 'output' => [ 'shape' => 'GetNetworkSettingsResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetOidcInfo' => [ 'name' => 'GetOidcInfo', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/oidc', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOidcInfoRequest', ], 'output' => [ 'shape' => 'GetOidcInfoResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetOpentdfConfig' => [ 'name' => 'GetOpentdfConfig', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/tdf', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOpentdfConfigRequest', ], 'output' => [ 'shape' => 'GetOpentdfConfigResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetSecurityGroup' => [ 'name' => 'GetSecurityGroup', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/security-groups/{groupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSecurityGroupRequest', ], 'output' => [ 'shape' => 'GetSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetUser' => [ 'name' => 'GetUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/users/{userId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetUserRequest', ], 'output' => [ 'shape' => 'GetUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'GetUsersCount' => [ 'name' => 'GetUsersCount', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/users/count', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetUsersCountRequest', ], 'output' => [ 'shape' => 'GetUsersCountResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListBlockedGuestUsers' => [ 'name' => 'ListBlockedGuestUsers', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/guest-users/blocklist', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListBlockedGuestUsersRequest', ], 'output' => [ 'shape' => 'ListBlockedGuestUsersResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListBots' => [ 'name' => 'ListBots', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/bots', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListBotsRequest', ], 'output' => [ 'shape' => 'ListBotsResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListDevicesForUser' => [ 'name' => 'ListDevicesForUser', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/users/{userId}/devices', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDevicesForUserRequest', ], 'output' => [ 'shape' => 'ListDevicesForUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListGuestUsers' => [ 'name' => 'ListGuestUsers', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/guest-users', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListGuestUsersRequest', ], 'output' => [ 'shape' => 'ListGuestUsersResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListNetworks' => [ 'name' => 'ListNetworks', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListNetworksRequest', ], 'output' => [ 'shape' => 'ListNetworksResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListSecurityGroupUsers' => [ 'name' => 'ListSecurityGroupUsers', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/security-groups/{groupId}/users', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSecurityGroupUsersRequest', ], 'output' => [ 'shape' => 'ListSecurityGroupUsersResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListSecurityGroups' => [ 'name' => 'ListSecurityGroups', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/security-groups', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSecurityGroupsRequest', ], 'output' => [ 'shape' => 'ListSecurityGroupsResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'ListUsers' => [ 'name' => 'ListUsers', 'http' => [ 'method' => 'GET', 'requestUri' => '/networks/{networkId}/users', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListUsersRequest', ], 'output' => [ 'shape' => 'ListUsersResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'readonly' => true, ], 'RegisterOidcConfig' => [ 'name' => 'RegisterOidcConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/oidc/save', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RegisterOidcConfigRequest', ], 'output' => [ 'shape' => 'RegisterOidcConfigResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'RegisterOidcConfigTest' => [ 'name' => 'RegisterOidcConfigTest', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/oidc/test', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RegisterOidcConfigTestRequest', ], 'output' => [ 'shape' => 'RegisterOidcConfigTestResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'RegisterOpentdfConfig' => [ 'name' => 'RegisterOpentdfConfig', 'http' => [ 'method' => 'POST', 'requestUri' => '/networks/{networkId}/tdf', 'responseCode' => 200, ], 'input' => [ 'shape' => 'RegisterOpentdfConfigRequest', ], 'output' => [ 'shape' => 'RegisterOpentdfConfigResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'UpdateBot' => [ 'name' => 'UpdateBot', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/bots/{botId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateBotRequest', ], 'output' => [ 'shape' => 'UpdateBotResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'UpdateDataRetention' => [ 'name' => 'UpdateDataRetention', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/data-retention-bots', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDataRetentionRequest', ], 'output' => [ 'shape' => 'UpdateDataRetentionResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'UpdateGuestUser' => [ 'name' => 'UpdateGuestUser', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/guest-users/{usernameHash}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateGuestUserRequest', ], 'output' => [ 'shape' => 'UpdateGuestUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], ], 'UpdateNetwork' => [ 'name' => 'UpdateNetwork', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateNetworkRequest', ], 'output' => [ 'shape' => 'UpdateNetworkResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'UpdateNetworkSettings' => [ 'name' => 'UpdateNetworkSettings', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/settings', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateNetworkSettingsRequest', ], 'output' => [ 'shape' => 'UpdateNetworkSettingsResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'UpdateSecurityGroup' => [ 'name' => 'UpdateSecurityGroup', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/security-groups/{groupId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateSecurityGroupRequest', ], 'output' => [ 'shape' => 'UpdateSecurityGroupResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], 'UpdateUser' => [ 'name' => 'UpdateUser', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/networks/{networkId}/users', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateUserRequest', ], 'output' => [ 'shape' => 'UpdateUserResponse', ], 'errors' => [ [ 'shape' => 'ValidationError', ], [ 'shape' => 'BadRequestError', ], [ 'shape' => 'ResourceNotFoundError', ], [ 'shape' => 'ForbiddenError', ], [ 'shape' => 'UnauthorizedError', ], [ 'shape' => 'InternalServerError', ], [ 'shape' => 'RateLimitError', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessLevel' => [ 'type' => 'string', 'enum' => [ 'STANDARD', 'PREMIUM', ], ], 'AppIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'GenericString', ], ], 'BadRequestError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'BasicDeviceObject' => [ 'type' => 'structure', 'members' => [ 'appId' => [ 'shape' => 'GenericString', ], 'created' => [ 'shape' => 'GenericString', ], 'lastLogin' => [ 'shape' => 'GenericString', ], 'statusText' => [ 'shape' => 'GenericString', ], 'suspend' => [ 'shape' => 'Boolean', ], 'type' => [ 'shape' => 'GenericString', ], ], ], 'BatchCreateUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'users', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'users' => [ 'shape' => 'BatchCreateUserRequestItems', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'BatchCreateUserRequestItem' => [ 'type' => 'structure', 'required' => [ 'securityGroupIds', 'username', ], 'members' => [ 'firstName' => [ 'shape' => 'SensitiveString', ], 'lastName' => [ 'shape' => 'SensitiveString', ], 'securityGroupIds' => [ 'shape' => 'SecurityGroupIdList', ], 'username' => [ 'shape' => 'GenericString', ], 'inviteCode' => [ 'shape' => 'GenericString', ], 'inviteCodeTtl' => [ 'shape' => 'Integer', ], 'codeValidation' => [ 'shape' => 'Boolean', ], ], ], 'BatchCreateUserRequestItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchCreateUserRequestItem', ], ], 'BatchCreateUserResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'successful' => [ 'shape' => 'Users', ], 'failed' => [ 'shape' => 'BatchUserErrorResponseItems', ], ], ], 'BatchDeleteUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'userIds', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'userIds' => [ 'shape' => 'UserIds', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'BatchDeleteUserResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'successful' => [ 'shape' => 'BatchUserSuccessResponseItems', ], 'failed' => [ 'shape' => 'BatchUserErrorResponseItems', ], ], ], 'BatchDeviceErrorResponseItem' => [ 'type' => 'structure', 'required' => [ 'appId', ], 'members' => [ 'field' => [ 'shape' => 'GenericString', ], 'reason' => [ 'shape' => 'GenericString', ], 'appId' => [ 'shape' => 'GenericString', ], ], ], 'BatchDeviceErrorResponseItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchDeviceErrorResponseItem', ], ], 'BatchDeviceSuccessResponseItem' => [ 'type' => 'structure', 'required' => [ 'appId', ], 'members' => [ 'appId' => [ 'shape' => 'GenericString', ], ], ], 'BatchDeviceSuccessResponseItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchDeviceSuccessResponseItem', ], ], 'BatchLookupUserUnameRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'unames', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'unames' => [ 'shape' => 'Unames', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'BatchLookupUserUnameResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'successful' => [ 'shape' => 'BatchUnameSuccessResponseItems', ], 'failed' => [ 'shape' => 'BatchUnameErrorResponseItems', ], ], ], 'BatchReinviteUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'userIds', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'userIds' => [ 'shape' => 'UserIds', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'BatchReinviteUserResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'successful' => [ 'shape' => 'BatchUserSuccessResponseItems', ], 'failed' => [ 'shape' => 'BatchUserErrorResponseItems', ], ], ], 'BatchResetDevicesForUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'userId', 'appIds', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'userId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'userId', ], 'appIds' => [ 'shape' => 'AppIds', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'BatchResetDevicesForUserResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'successful' => [ 'shape' => 'BatchDeviceSuccessResponseItems', ], 'failed' => [ 'shape' => 'BatchDeviceErrorResponseItems', ], ], ], 'BatchToggleUserSuspendStatusRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'suspend', 'userIds', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'suspend' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'suspend', ], 'userIds' => [ 'shape' => 'UserIds', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'BatchToggleUserSuspendStatusResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'successful' => [ 'shape' => 'BatchUserSuccessResponseItems', ], 'failed' => [ 'shape' => 'BatchUserErrorResponseItems', ], ], ], 'BatchUnameErrorResponseItem' => [ 'type' => 'structure', 'required' => [ 'uname', ], 'members' => [ 'field' => [ 'shape' => 'GenericString', ], 'reason' => [ 'shape' => 'GenericString', ], 'uname' => [ 'shape' => 'Uname', ], ], ], 'BatchUnameErrorResponseItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchUnameErrorResponseItem', ], ], 'BatchUnameSuccessResponseItem' => [ 'type' => 'structure', 'required' => [ 'uname', 'username', ], 'members' => [ 'uname' => [ 'shape' => 'Uname', ], 'username' => [ 'shape' => 'GenericString', ], ], ], 'BatchUnameSuccessResponseItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchUnameSuccessResponseItem', ], ], 'BatchUserErrorResponseItem' => [ 'type' => 'structure', 'required' => [ 'userId', ], 'members' => [ 'field' => [ 'shape' => 'GenericString', ], 'reason' => [ 'shape' => 'GenericString', ], 'userId' => [ 'shape' => 'UserId', ], ], ], 'BatchUserErrorResponseItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchUserErrorResponseItem', ], ], 'BatchUserSuccessResponseItem' => [ 'type' => 'structure', 'required' => [ 'userId', ], 'members' => [ 'userId' => [ 'shape' => 'UserId', ], ], ], 'BatchUserSuccessResponseItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchUserSuccessResponseItem', ], ], 'BlockedGuestUser' => [ 'type' => 'structure', 'required' => [ 'username', 'admin', 'modified', 'usernameHash', ], 'members' => [ 'username' => [ 'shape' => 'GenericString', ], 'admin' => [ 'shape' => 'GenericString', ], 'modified' => [ 'shape' => 'GenericString', ], 'usernameHash' => [ 'shape' => 'GenericString', ], ], ], 'BlockedGuestUserList' => [ 'type' => 'list', 'member' => [ 'shape' => 'BlockedGuestUser', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'Bot' => [ 'type' => 'structure', 'members' => [ 'botId' => [ 'shape' => 'GenericString', ], 'displayName' => [ 'shape' => 'GenericString', ], 'username' => [ 'shape' => 'GenericString', ], 'uname' => [ 'shape' => 'GenericString', ], 'pubkey' => [ 'shape' => 'GenericString', ], 'status' => [ 'shape' => 'BotStatus', ], 'groupId' => [ 'shape' => 'GenericString', ], 'hasChallenge' => [ 'shape' => 'Boolean', ], 'suspended' => [ 'shape' => 'Boolean', ], 'lastLogin' => [ 'shape' => 'GenericString', ], ], ], 'BotId' => [ 'type' => 'string', 'max' => 10, 'min' => 1, 'pattern' => '[0-9]+', ], 'BotStatus' => [ 'type' => 'integer', 'box' => true, ], 'Bots' => [ 'type' => 'list', 'member' => [ 'shape' => 'Bot', ], ], 'CallingSettings' => [ 'type' => 'structure', 'members' => [ 'canStart11Call' => [ 'shape' => 'Boolean', ], 'canVideoCall' => [ 'shape' => 'Boolean', ], 'forceTcpCall' => [ 'shape' => 'Boolean', ], ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9-_:]+', ], 'CreateBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'username', 'groupId', 'challenge', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'username' => [ 'shape' => 'GenericString', ], 'displayName' => [ 'shape' => 'GenericString', ], 'groupId' => [ 'shape' => 'GenericString', ], 'challenge' => [ 'shape' => 'SensitiveString', ], ], ], 'CreateBotResponse' => [ 'type' => 'structure', 'required' => [ 'botId', ], 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'botId' => [ 'shape' => 'BotId', ], 'networkId' => [ 'shape' => 'NetworkId', ], 'username' => [ 'shape' => 'GenericString', ], 'displayName' => [ 'shape' => 'GenericString', ], 'groupId' => [ 'shape' => 'GenericString', ], ], ], 'CreateDataRetentionBotChallengeRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'CreateDataRetentionBotChallengeResponse' => [ 'type' => 'structure', 'required' => [ 'challenge', ], 'members' => [ 'challenge' => [ 'shape' => 'SensitiveString', ], ], ], 'CreateDataRetentionBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'CreateDataRetentionBotResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'CreateNetworkRequest' => [ 'type' => 'structure', 'required' => [ 'networkName', 'accessLevel', ], 'members' => [ 'networkName' => [ 'shape' => 'GenericString', ], 'accessLevel' => [ 'shape' => 'AccessLevel', ], 'enablePremiumFreeTrial' => [ 'shape' => 'Boolean', ], 'encryptionKeyArn' => [ 'shape' => 'GenericString', ], ], ], 'CreateNetworkResponse' => [ 'type' => 'structure', 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', ], 'networkName' => [ 'shape' => 'GenericString', ], 'encryptionKeyArn' => [ 'shape' => 'GenericString', ], ], ], 'CreateSecurityGroupRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'name', 'securityGroupSettings', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'name' => [ 'shape' => 'GenericString', ], 'securityGroupSettings' => [ 'shape' => 'SecurityGroupSettingsRequest', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'CreateSecurityGroupResponse' => [ 'type' => 'structure', 'required' => [ 'securityGroup', ], 'members' => [ 'securityGroup' => [ 'shape' => 'SecurityGroup', ], ], ], 'DataRetentionActionType' => [ 'type' => 'string', 'enum' => [ 'ENABLE', 'DISABLE', 'PUBKEY_MSG_ACK', ], ], 'DeleteBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'botId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'botId' => [ 'shape' => 'BotId', 'location' => 'uri', 'locationName' => 'botId', ], ], ], 'DeleteBotResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'DeleteDataRetentionBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'DeleteDataRetentionBotResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'DeleteNetworkRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], ], ], 'DeleteNetworkResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'DeleteSecurityGroupRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'groupId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'groupId' => [ 'shape' => 'GenericString', 'location' => 'uri', 'locationName' => 'groupId', ], ], ], 'DeleteSecurityGroupResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], 'networkId' => [ 'shape' => 'NetworkId', ], 'groupId' => [ 'shape' => 'GenericString', ], ], ], 'Devices' => [ 'type' => 'list', 'member' => [ 'shape' => 'BasicDeviceObject', ], ], 'ErrorDetail' => [ 'type' => 'structure', 'members' => [ 'field' => [ 'shape' => 'GenericString', ], 'reason' => [ 'shape' => 'GenericString', ], ], ], 'ErrorDetailList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ErrorDetail', ], ], 'ForbiddenError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'GenericString' => [ 'type' => 'string', 'pattern' => '[\\S\\s]*', ], 'GetBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'botId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'botId' => [ 'shape' => 'BotId', 'location' => 'uri', 'locationName' => 'botId', ], ], ], 'GetBotResponse' => [ 'type' => 'structure', 'members' => [ 'botId' => [ 'shape' => 'GenericString', ], 'displayName' => [ 'shape' => 'GenericString', ], 'username' => [ 'shape' => 'GenericString', ], 'uname' => [ 'shape' => 'GenericString', ], 'pubkey' => [ 'shape' => 'GenericString', ], 'status' => [ 'shape' => 'BotStatus', ], 'groupId' => [ 'shape' => 'GenericString', ], 'hasChallenge' => [ 'shape' => 'Boolean', ], 'suspended' => [ 'shape' => 'Boolean', ], 'lastLogin' => [ 'shape' => 'GenericString', ], ], ], 'GetBotsCountRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetBotsCountResponse' => [ 'type' => 'structure', 'required' => [ 'pending', 'active', 'total', ], 'members' => [ 'pending' => [ 'shape' => 'Integer', ], 'active' => [ 'shape' => 'Integer', ], 'total' => [ 'shape' => 'Integer', ], ], ], 'GetDataRetentionBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetDataRetentionBotResponse' => [ 'type' => 'structure', 'members' => [ 'botName' => [ 'shape' => 'GenericString', ], 'botExists' => [ 'shape' => 'Boolean', ], 'isBotActive' => [ 'shape' => 'Boolean', ], 'isDataRetentionBotRegistered' => [ 'shape' => 'Boolean', ], 'isDataRetentionServiceEnabled' => [ 'shape' => 'Boolean', ], 'isPubkeyMsgAcked' => [ 'shape' => 'Boolean', ], ], ], 'GetGuestUserHistoryCountRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetGuestUserHistoryCountResponse' => [ 'type' => 'structure', 'required' => [ 'history', ], 'members' => [ 'history' => [ 'shape' => 'GuestUserHistoryCountList', ], ], ], 'GetNetworkRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetNetworkResponse' => [ 'type' => 'structure', 'required' => [ 'networkId', 'networkName', 'accessLevel', 'awsAccountId', 'networkArn', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', ], 'networkName' => [ 'shape' => 'GenericString', ], 'accessLevel' => [ 'shape' => 'AccessLevel', ], 'awsAccountId' => [ 'shape' => 'GenericString', ], 'networkArn' => [ 'shape' => 'GenericString', ], 'standing' => [ 'shape' => 'Integer', ], 'freeTrialExpiration' => [ 'shape' => 'GenericString', ], 'migrationState' => [ 'shape' => 'Integer', ], 'encryptionKeyArn' => [ 'shape' => 'GenericString', ], ], ], 'GetNetworkSettingsRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetNetworkSettingsResponse' => [ 'type' => 'structure', 'required' => [ 'settings', ], 'members' => [ 'settings' => [ 'shape' => 'SettingsList', ], ], ], 'GetOidcInfoRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'clientId' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'clientId', ], 'code' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'code', ], 'grantType' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'grantType', ], 'redirectUri' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'redirectUri', ], 'url' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'url', ], 'clientSecret' => [ 'shape' => 'SensitiveString', 'location' => 'querystring', 'locationName' => 'clientSecret', ], 'codeVerifier' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'codeVerifier', ], 'certificate' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'certificate', ], ], ], 'GetOidcInfoResponse' => [ 'type' => 'structure', 'members' => [ 'openidConnectInfo' => [ 'shape' => 'OidcConfigInfo', ], 'tokenInfo' => [ 'shape' => 'OidcTokenInfo', ], ], ], 'GetOpentdfConfigRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetOpentdfConfigResponse' => [ 'type' => 'structure', 'required' => [ 'clientId', 'domain', 'clientSecret', 'provider', ], 'members' => [ 'clientId' => [ 'shape' => 'GenericString', ], 'domain' => [ 'shape' => 'GenericString', ], 'clientSecret' => [ 'shape' => 'SensitiveString', ], 'provider' => [ 'shape' => 'GenericString', ], ], ], 'GetSecurityGroupRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'groupId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'groupId' => [ 'shape' => 'GenericString', 'location' => 'uri', 'locationName' => 'groupId', ], ], ], 'GetSecurityGroupResponse' => [ 'type' => 'structure', 'required' => [ 'securityGroup', ], 'members' => [ 'securityGroup' => [ 'shape' => 'SecurityGroup', ], ], ], 'GetUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'userId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'userId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'userId', ], 'startTime' => [ 'shape' => 'SyntheticTimestamp_epoch_seconds', 'location' => 'querystring', 'locationName' => 'startTime', ], 'endTime' => [ 'shape' => 'SyntheticTimestamp_epoch_seconds', 'location' => 'querystring', 'locationName' => 'endTime', ], ], ], 'GetUserResponse' => [ 'type' => 'structure', 'required' => [ 'userId', ], 'members' => [ 'userId' => [ 'shape' => 'UserId', ], 'firstName' => [ 'shape' => 'SensitiveString', ], 'lastName' => [ 'shape' => 'SensitiveString', ], 'username' => [ 'shape' => 'GenericString', ], 'isAdmin' => [ 'shape' => 'Boolean', ], 'suspended' => [ 'shape' => 'Boolean', ], 'status' => [ 'shape' => 'Integer', ], 'lastActivity' => [ 'shape' => 'Integer', ], 'lastLogin' => [ 'shape' => 'Integer', ], 'securityGroupIds' => [ 'shape' => 'SecurityGroupIdList', ], ], ], 'GetUsersCountRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], ], ], 'GetUsersCountResponse' => [ 'type' => 'structure', 'required' => [ 'pending', 'active', 'rejected', 'remaining', 'total', ], 'members' => [ 'pending' => [ 'shape' => 'Integer', ], 'active' => [ 'shape' => 'Integer', ], 'rejected' => [ 'shape' => 'Integer', ], 'remaining' => [ 'shape' => 'Integer', ], 'total' => [ 'shape' => 'Integer', ], ], ], 'GuestUser' => [ 'type' => 'structure', 'required' => [ 'billingPeriod', 'username', 'usernameHash', ], 'members' => [ 'billingPeriod' => [ 'shape' => 'GenericString', ], 'username' => [ 'shape' => 'GenericString', ], 'usernameHash' => [ 'shape' => 'GenericString', ], ], ], 'GuestUserHistoryCount' => [ 'type' => 'structure', 'required' => [ 'month', 'count', ], 'members' => [ 'month' => [ 'shape' => 'GenericString', ], 'count' => [ 'shape' => 'GenericString', ], ], ], 'GuestUserHistoryCountList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuestUserHistoryCount', ], ], 'GuestUserList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GuestUser', ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServerError' => [ 'type' => 'structure', 'required' => [ 'message', ], 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'ListBlockedGuestUsersRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'username' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'username', ], 'admin' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'admin', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListBlockedGuestUsersResponse' => [ 'type' => 'structure', 'required' => [ 'blocklist', ], 'members' => [ 'nextToken' => [ 'shape' => 'GenericString', ], 'blocklist' => [ 'shape' => 'BlockedGuestUserList', ], ], ], 'ListBotsRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], 'displayName' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'displayName', ], 'username' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'username', ], 'status' => [ 'shape' => 'BotStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'groupId' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'groupId', ], ], ], 'ListBotsResponse' => [ 'type' => 'structure', 'required' => [ 'bots', ], 'members' => [ 'bots' => [ 'shape' => 'Bots', ], 'nextToken' => [ 'shape' => 'GenericString', ], ], ], 'ListDevicesForUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'userId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'userId' => [ 'shape' => 'UserId', 'location' => 'uri', 'locationName' => 'userId', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], ], ], 'ListDevicesForUserResponse' => [ 'type' => 'structure', 'required' => [ 'devices', ], 'members' => [ 'nextToken' => [ 'shape' => 'GenericString', ], 'devices' => [ 'shape' => 'Devices', ], ], ], 'ListGuestUsersRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'username' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'username', ], 'billingPeriod' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'billingPeriod', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListGuestUsersResponse' => [ 'type' => 'structure', 'required' => [ 'guestlist', ], 'members' => [ 'nextToken' => [ 'shape' => 'GenericString', ], 'guestlist' => [ 'shape' => 'GuestUserList', ], ], ], 'ListNetworksRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListNetworksResponse' => [ 'type' => 'structure', 'required' => [ 'networks', ], 'members' => [ 'networks' => [ 'shape' => 'NetworkList', ], 'nextToken' => [ 'shape' => 'GenericString', ], ], ], 'ListSecurityGroupUsersRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'groupId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'groupId' => [ 'shape' => 'GenericString', 'location' => 'uri', 'locationName' => 'groupId', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], ], ], 'ListSecurityGroupUsersResponse' => [ 'type' => 'structure', 'required' => [ 'users', ], 'members' => [ 'users' => [ 'shape' => 'Users', ], 'nextToken' => [ 'shape' => 'GenericString', ], ], ], 'ListSecurityGroupsRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], ], ], 'ListSecurityGroupsResponse' => [ 'type' => 'structure', 'members' => [ 'securityGroups' => [ 'shape' => 'SecurityGroupList', ], 'nextToken' => [ 'shape' => 'GenericString', ], ], ], 'ListUsersRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'nextToken' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'Integer', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'sortFields' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'sortFields', ], 'sortDirection' => [ 'shape' => 'SortDirection', 'location' => 'querystring', 'locationName' => 'sortDirection', ], 'firstName' => [ 'shape' => 'SensitiveString', 'location' => 'querystring', 'locationName' => 'firstName', ], 'lastName' => [ 'shape' => 'SensitiveString', 'location' => 'querystring', 'locationName' => 'lastName', ], 'username' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'username', ], 'status' => [ 'shape' => 'UserStatus', 'location' => 'querystring', 'locationName' => 'status', ], 'groupId' => [ 'shape' => 'GenericString', 'location' => 'querystring', 'locationName' => 'groupId', ], ], ], 'ListUsersResponse' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'GenericString', ], 'users' => [ 'shape' => 'Users', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'Network' => [ 'type' => 'structure', 'required' => [ 'networkId', 'networkName', 'accessLevel', 'awsAccountId', 'networkArn', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', ], 'networkName' => [ 'shape' => 'GenericString', ], 'accessLevel' => [ 'shape' => 'AccessLevel', ], 'awsAccountId' => [ 'shape' => 'GenericString', ], 'networkArn' => [ 'shape' => 'GenericString', ], 'standing' => [ 'shape' => 'Integer', ], 'freeTrialExpiration' => [ 'shape' => 'GenericString', ], 'migrationState' => [ 'shape' => 'Integer', ], 'encryptionKeyArn' => [ 'shape' => 'GenericString', ], ], ], 'NetworkId' => [ 'type' => 'string', 'max' => 8, 'min' => 8, 'pattern' => '[0-9]{8}', ], 'NetworkList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Network', ], ], 'NetworkSettings' => [ 'type' => 'structure', 'members' => [ 'enableClientMetrics' => [ 'shape' => 'Boolean', ], 'readReceiptConfig' => [ 'shape' => 'ReadReceiptConfig', ], 'dataRetention' => [ 'shape' => 'Boolean', ], 'enableTrustedDataFormat' => [ 'shape' => 'Boolean', ], ], ], 'OidcConfigInfo' => [ 'type' => 'structure', 'required' => [ 'companyId', 'scopes', 'issuer', ], 'members' => [ 'applicationName' => [ 'shape' => 'GenericString', ], 'clientId' => [ 'shape' => 'GenericString', ], 'companyId' => [ 'shape' => 'GenericString', ], 'scopes' => [ 'shape' => 'GenericString', ], 'issuer' => [ 'shape' => 'GenericString', ], 'clientSecret' => [ 'shape' => 'SensitiveString', ], 'secret' => [ 'shape' => 'SensitiveString', ], 'redirectUrl' => [ 'shape' => 'GenericString', ], 'userId' => [ 'shape' => 'GenericString', ], 'customUsername' => [ 'shape' => 'GenericString', ], 'caCertificate' => [ 'shape' => 'GenericString', ], 'applicationId' => [ 'shape' => 'OidcConfigInfoApplicationIdInteger', ], 'ssoTokenBufferMinutes' => [ 'shape' => 'Integer', ], 'extraAuthParams' => [ 'shape' => 'GenericString', ], ], ], 'OidcConfigInfoApplicationIdInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 1, ], 'OidcTokenInfo' => [ 'type' => 'structure', 'members' => [ 'codeVerifier' => [ 'shape' => 'GenericString', ], 'codeChallenge' => [ 'shape' => 'GenericString', ], 'accessToken' => [ 'shape' => 'GenericString', ], 'idToken' => [ 'shape' => 'GenericString', ], 'refreshToken' => [ 'shape' => 'GenericString', ], 'tokenType' => [ 'shape' => 'GenericString', ], 'expiresIn' => [ 'shape' => 'Long', ], ], ], 'PasswordRequirements' => [ 'type' => 'structure', 'members' => [ 'lowercase' => [ 'shape' => 'Integer', ], 'minLength' => [ 'shape' => 'Integer', ], 'numbers' => [ 'shape' => 'Integer', ], 'symbols' => [ 'shape' => 'Integer', ], 'uppercase' => [ 'shape' => 'Integer', ], ], ], 'PermittedNetworksList' => [ 'type' => 'list', 'member' => [ 'shape' => 'NetworkId', ], ], 'PermittedWickrEnterpriseNetwork' => [ 'type' => 'structure', 'required' => [ 'domain', 'networkId', ], 'members' => [ 'domain' => [ 'shape' => 'GenericString', ], 'networkId' => [ 'shape' => 'NetworkId', ], ], ], 'PermittedWickrEnterpriseNetworksList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PermittedWickrEnterpriseNetwork', ], ], 'RateLimitError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'ReadReceiptConfig' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'Status', ], ], ], 'RegisterOidcConfigRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'companyId', 'issuer', 'scopes', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'companyId' => [ 'shape' => 'GenericString', ], 'customUsername' => [ 'shape' => 'GenericString', ], 'extraAuthParams' => [ 'shape' => 'GenericString', ], 'issuer' => [ 'shape' => 'GenericString', ], 'scopes' => [ 'shape' => 'GenericString', ], 'secret' => [ 'shape' => 'SensitiveString', ], 'ssoTokenBufferMinutes' => [ 'shape' => 'Integer', ], 'userId' => [ 'shape' => 'GenericString', ], ], ], 'RegisterOidcConfigResponse' => [ 'type' => 'structure', 'required' => [ 'companyId', 'scopes', 'issuer', ], 'members' => [ 'applicationName' => [ 'shape' => 'GenericString', ], 'clientId' => [ 'shape' => 'GenericString', ], 'companyId' => [ 'shape' => 'GenericString', ], 'scopes' => [ 'shape' => 'GenericString', ], 'issuer' => [ 'shape' => 'GenericString', ], 'clientSecret' => [ 'shape' => 'SensitiveString', ], 'secret' => [ 'shape' => 'SensitiveString', ], 'redirectUrl' => [ 'shape' => 'GenericString', ], 'userId' => [ 'shape' => 'GenericString', ], 'customUsername' => [ 'shape' => 'GenericString', ], 'caCertificate' => [ 'shape' => 'GenericString', ], 'applicationId' => [ 'shape' => 'RegisterOidcConfigResponseApplicationIdInteger', ], 'ssoTokenBufferMinutes' => [ 'shape' => 'Integer', ], 'extraAuthParams' => [ 'shape' => 'GenericString', ], ], ], 'RegisterOidcConfigResponseApplicationIdInteger' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 1, ], 'RegisterOidcConfigTestRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'issuer', 'scopes', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'extraAuthParams' => [ 'shape' => 'GenericString', ], 'issuer' => [ 'shape' => 'GenericString', ], 'scopes' => [ 'shape' => 'GenericString', ], 'certificate' => [ 'shape' => 'GenericString', ], ], ], 'RegisterOidcConfigTestResponse' => [ 'type' => 'structure', 'members' => [ 'tokenEndpoint' => [ 'shape' => 'GenericString', ], 'userinfoEndpoint' => [ 'shape' => 'GenericString', ], 'responseTypesSupported' => [ 'shape' => 'StringList', ], 'scopesSupported' => [ 'shape' => 'StringList', ], 'issuer' => [ 'shape' => 'GenericString', ], 'authorizationEndpoint' => [ 'shape' => 'GenericString', ], 'endSessionEndpoint' => [ 'shape' => 'GenericString', ], 'logoutEndpoint' => [ 'shape' => 'GenericString', ], 'grantTypesSupported' => [ 'shape' => 'StringList', ], 'revocationEndpoint' => [ 'shape' => 'GenericString', ], 'tokenEndpointAuthMethodsSupported' => [ 'shape' => 'StringList', ], 'microsoftMultiRefreshToken' => [ 'shape' => 'Boolean', ], ], ], 'RegisterOpentdfConfigRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'clientId', 'clientSecret', 'domain', 'provider', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'clientId' => [ 'shape' => 'GenericString', ], 'clientSecret' => [ 'shape' => 'SensitiveString', ], 'domain' => [ 'shape' => 'GenericString', ], 'provider' => [ 'shape' => 'GenericString', ], 'dryRun' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'dryRun', ], ], ], 'RegisterOpentdfConfigResponse' => [ 'type' => 'structure', 'required' => [ 'clientId', 'domain', 'clientSecret', 'provider', ], 'members' => [ 'clientId' => [ 'shape' => 'GenericString', ], 'domain' => [ 'shape' => 'GenericString', ], 'clientSecret' => [ 'shape' => 'SensitiveString', ], 'provider' => [ 'shape' => 'GenericString', ], ], ], 'ResourceNotFoundError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'SecurityGroup' => [ 'type' => 'structure', 'required' => [ 'activeMembers', 'botMembers', 'id', 'isDefault', 'name', 'modified', 'securityGroupSettings', ], 'members' => [ 'activeMembers' => [ 'shape' => 'Integer', ], 'botMembers' => [ 'shape' => 'Integer', ], 'activeDirectoryGuid' => [ 'shape' => 'GenericString', ], 'id' => [ 'shape' => 'GenericString', ], 'isDefault' => [ 'shape' => 'Boolean', ], 'name' => [ 'shape' => 'GenericString', ], 'modified' => [ 'shape' => 'Integer', ], 'securityGroupSettings' => [ 'shape' => 'SecurityGroupSettings', ], ], ], 'SecurityGroupId' => [ 'type' => 'string', 'pattern' => '[\\S]+', ], 'SecurityGroupIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], ], 'SecurityGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroup', ], ], 'SecurityGroupSettings' => [ 'type' => 'structure', 'members' => [ 'alwaysReauthenticate' => [ 'shape' => 'Boolean', ], 'atakPackageValues' => [ 'shape' => 'SecurityGroupStringList', ], 'calling' => [ 'shape' => 'CallingSettings', ], 'checkForUpdates' => [ 'shape' => 'Boolean', ], 'enableAtak' => [ 'shape' => 'Boolean', ], 'enableCrashReports' => [ 'shape' => 'Boolean', ], 'enableFileDownload' => [ 'shape' => 'Boolean', ], 'enableGuestFederation' => [ 'shape' => 'Boolean', ], 'enableNotificationPreview' => [ 'shape' => 'Boolean', ], 'enableOpenAccessOption' => [ 'shape' => 'Boolean', ], 'enableRestrictedGlobalFederation' => [ 'shape' => 'Boolean', ], 'filesEnabled' => [ 'shape' => 'Boolean', ], 'forceDeviceLockout' => [ 'shape' => 'Integer', ], 'forceOpenAccess' => [ 'shape' => 'Boolean', ], 'forceReadReceipts' => [ 'shape' => 'Boolean', ], 'globalFederation' => [ 'shape' => 'Boolean', ], 'isAtoEnabled' => [ 'shape' => 'Boolean', ], 'isLinkPreviewEnabled' => [ 'shape' => 'Boolean', ], 'locationAllowMaps' => [ 'shape' => 'Boolean', ], 'locationEnabled' => [ 'shape' => 'Boolean', ], 'maxAutoDownloadSize' => [ 'shape' => 'Long', ], 'maxBor' => [ 'shape' => 'Integer', ], 'maxTtl' => [ 'shape' => 'Long', ], 'messageForwardingEnabled' => [ 'shape' => 'Boolean', ], 'passwordRequirements' => [ 'shape' => 'PasswordRequirements', ], 'presenceEnabled' => [ 'shape' => 'Boolean', ], 'quickResponses' => [ 'shape' => 'SecurityGroupStringList', ], 'showMasterRecoveryKey' => [ 'shape' => 'Boolean', ], 'shredder' => [ 'shape' => 'ShredderSettings', ], 'ssoMaxIdleMinutes' => [ 'shape' => 'Integer', ], 'federationMode' => [ 'shape' => 'Integer', ], 'lockoutThreshold' => [ 'shape' => 'Integer', ], 'permittedNetworks' => [ 'shape' => 'PermittedNetworksList', ], 'permittedWickrAwsNetworks' => [ 'shape' => 'WickrAwsNetworksList', ], 'permittedWickrEnterpriseNetworks' => [ 'shape' => 'PermittedWickrEnterpriseNetworksList', ], ], ], 'SecurityGroupSettingsRequest' => [ 'type' => 'structure', 'members' => [ 'lockoutThreshold' => [ 'shape' => 'Integer', ], 'permittedNetworks' => [ 'shape' => 'PermittedNetworksList', ], 'enableGuestFederation' => [ 'shape' => 'Boolean', ], 'globalFederation' => [ 'shape' => 'Boolean', ], 'federationMode' => [ 'shape' => 'Integer', ], 'enableRestrictedGlobalFederation' => [ 'shape' => 'Boolean', ], 'permittedWickrAwsNetworks' => [ 'shape' => 'WickrAwsNetworksList', ], 'permittedWickrEnterpriseNetworks' => [ 'shape' => 'PermittedWickrEnterpriseNetworksList', ], ], ], 'SecurityGroupStringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GenericString', ], ], 'SensitiveString' => [ 'type' => 'string', 'pattern' => '[\\S\\s]*', 'sensitive' => true, ], 'Setting' => [ 'type' => 'structure', 'required' => [ 'optionName', 'value', 'type', ], 'members' => [ 'optionName' => [ 'shape' => 'GenericString', ], 'value' => [ 'shape' => 'GenericString', ], 'type' => [ 'shape' => 'GenericString', ], ], ], 'SettingsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Setting', ], ], 'ShredderSettings' => [ 'type' => 'structure', 'members' => [ 'canProcessManually' => [ 'shape' => 'Boolean', ], 'intensity' => [ 'shape' => 'Integer', ], ], ], 'SortDirection' => [ 'type' => 'string', 'enum' => [ 'ASC', 'DESC', ], ], 'Status' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'ENABLED', 'FORCE_ENABLED', ], ], 'StringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GenericString', ], ], 'SyntheticTimestamp_epoch_seconds' => [ 'type' => 'timestamp', 'timestampFormat' => 'unixTimestamp', ], 'Uname' => [ 'type' => 'string', ], 'Unames' => [ 'type' => 'list', 'member' => [ 'shape' => 'GenericString', ], ], 'UnauthorizedError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 401, 'senderFault' => true, ], 'exception' => true, ], 'UpdateBotRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'botId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'botId' => [ 'shape' => 'BotId', 'location' => 'uri', 'locationName' => 'botId', ], 'displayName' => [ 'shape' => 'GenericString', ], 'groupId' => [ 'shape' => 'GenericString', ], 'challenge' => [ 'shape' => 'SensitiveString', ], 'suspend' => [ 'shape' => 'Boolean', ], ], ], 'UpdateBotResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'UpdateDataRetentionRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'actionType', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'actionType' => [ 'shape' => 'DataRetentionActionType', ], ], ], 'UpdateDataRetentionResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'UpdateGuestUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'usernameHash', 'block', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'usernameHash' => [ 'shape' => 'GenericString', 'location' => 'uri', 'locationName' => 'usernameHash', ], 'block' => [ 'shape' => 'Boolean', ], ], ], 'UpdateGuestUserResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'UpdateNetworkRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'networkName', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'networkName' => [ 'shape' => 'GenericString', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, 'location' => 'header', 'locationName' => 'X-Client-Token', ], 'encryptionKeyArn' => [ 'shape' => 'GenericString', ], ], ], 'UpdateNetworkResponse' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'GenericString', ], ], ], 'UpdateNetworkSettingsRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'settings', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'settings' => [ 'shape' => 'NetworkSettings', ], ], ], 'UpdateNetworkSettingsResponse' => [ 'type' => 'structure', 'required' => [ 'settings', ], 'members' => [ 'settings' => [ 'shape' => 'SettingsList', ], ], ], 'UpdateSecurityGroupRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'groupId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'groupId' => [ 'shape' => 'GenericString', 'location' => 'uri', 'locationName' => 'groupId', ], 'name' => [ 'shape' => 'GenericString', ], 'securityGroupSettings' => [ 'shape' => 'SecurityGroupSettings', ], ], ], 'UpdateSecurityGroupResponse' => [ 'type' => 'structure', 'required' => [ 'securityGroup', ], 'members' => [ 'securityGroup' => [ 'shape' => 'SecurityGroup', ], ], ], 'UpdateUserDetails' => [ 'type' => 'structure', 'members' => [ 'firstName' => [ 'shape' => 'SensitiveString', ], 'lastName' => [ 'shape' => 'SensitiveString', ], 'username' => [ 'shape' => 'GenericString', ], 'securityGroupIds' => [ 'shape' => 'SecurityGroupIdList', ], 'inviteCode' => [ 'shape' => 'GenericString', ], 'inviteCodeTtl' => [ 'shape' => 'Integer', ], 'codeValidation' => [ 'shape' => 'Boolean', ], ], ], 'UpdateUserRequest' => [ 'type' => 'structure', 'required' => [ 'networkId', 'userId', ], 'members' => [ 'networkId' => [ 'shape' => 'NetworkId', 'location' => 'uri', 'locationName' => 'networkId', ], 'userId' => [ 'shape' => 'UserId', ], 'userDetails' => [ 'shape' => 'UpdateUserDetails', ], ], ], 'UpdateUserResponse' => [ 'type' => 'structure', 'required' => [ 'userId', 'networkId', 'suspended', ], 'members' => [ 'userId' => [ 'shape' => 'UserId', ], 'networkId' => [ 'shape' => 'NetworkId', ], 'securityGroupIds' => [ 'shape' => 'SecurityGroupIdList', ], 'firstName' => [ 'shape' => 'SensitiveString', ], 'lastName' => [ 'shape' => 'SensitiveString', ], 'middleName' => [ 'shape' => 'GenericString', ], 'suspended' => [ 'shape' => 'Boolean', ], 'modified' => [ 'shape' => 'Integer', ], 'status' => [ 'shape' => 'Integer', ], 'inviteCode' => [ 'shape' => 'GenericString', ], 'inviteExpiration' => [ 'shape' => 'Integer', ], 'codeValidation' => [ 'shape' => 'Boolean', ], ], ], 'User' => [ 'type' => 'structure', 'members' => [ 'userId' => [ 'shape' => 'UserId', ], 'firstName' => [ 'shape' => 'SensitiveString', ], 'lastName' => [ 'shape' => 'SensitiveString', ], 'username' => [ 'shape' => 'GenericString', ], 'securityGroups' => [ 'shape' => 'SecurityGroupIdList', ], 'isAdmin' => [ 'shape' => 'Boolean', ], 'suspended' => [ 'shape' => 'Boolean', ], 'status' => [ 'shape' => 'Integer', ], 'otpEnabled' => [ 'shape' => 'Boolean', ], 'scimId' => [ 'shape' => 'GenericString', ], 'type' => [ 'shape' => 'GenericString', ], 'cell' => [ 'shape' => 'GenericString', ], 'countryCode' => [ 'shape' => 'GenericString', ], 'challengeFailures' => [ 'shape' => 'Integer', ], 'isInviteExpired' => [ 'shape' => 'Boolean', ], 'isUser' => [ 'shape' => 'Boolean', ], 'inviteCode' => [ 'shape' => 'GenericString', ], 'codeValidation' => [ 'shape' => 'Boolean', ], 'uname' => [ 'shape' => 'GenericString', ], ], ], 'UserId' => [ 'type' => 'string', 'max' => 10, 'min' => 1, 'pattern' => '[0-9]+', ], 'UserIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'UserId', ], ], 'UserStatus' => [ 'type' => 'integer', 'box' => true, ], 'Users' => [ 'type' => 'list', 'member' => [ 'shape' => 'User', ], ], 'ValidationError' => [ 'type' => 'structure', 'members' => [ 'reasons' => [ 'shape' => 'ErrorDetailList', ], 'message' => [ 'shape' => 'GenericString', ], ], 'error' => [ 'httpStatusCode' => 422, 'senderFault' => true, ], 'exception' => true, ], 'WickrAwsNetworks' => [ 'type' => 'structure', 'required' => [ 'region', 'networkId', ], 'members' => [ 'region' => [ 'shape' => 'GenericString', ], 'networkId' => [ 'shape' => 'NetworkId', ], ], ], 'WickrAwsNetworksList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WickrAwsNetworks', ], ], ],];
