<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Api
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Api\V2010\Account\Call;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class UserDefinedMessageList extends ListResource
    {
    /**
     * Construct the UserDefinedMessageList
     *
     * @param Version $version Version that contains the resource
     * @param string $accountSid The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created User Defined Message.
     * @param string $callSid The SID of the [Call](https://www.twilio.com/docs/voice/api/call-resource) the User Defined Message is associated with.
     */
    public function __construct(
        Version $version,
        string $accountSid,
        string $callSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'accountSid' =>
            $accountSid,
        
        'callSid' =>
            $callSid,
        
        ];

        $this->uri = '/Accounts/' . \rawurlencode($accountSid)
        .'/Calls/' . \rawurlencode($callSid)
        .'/UserDefinedMessages.json';
    }

    /**
     * Helper function for Create
     *
     * @param string $content The User Defined Message in the form of URL-encoded JSON string.
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(string $content, array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'Content' =>
                $content,
            'IdempotencyKey' =>
                $options['idempotencyKey'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the UserDefinedMessageInstance
     *
     * @param string $content The User Defined Message in the form of URL-encoded JSON string.
     * @param array|Options $options Optional Arguments
     * @return UserDefinedMessageInstance Created UserDefinedMessageInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $content, array $options = []): UserDefinedMessageInstance
    {
        $response = $this->_create( $content, $options);
        return new UserDefinedMessageInstance(
            $this->version,
            $response->getContent(),
            $this->solution['accountSid'],
            $this->solution['callSid']
        );
        
    }

    /**
     * Create the UserDefinedMessageInstance with Metadata
     *
     * @param string $content The User Defined Message in the form of URL-encoded JSON string.
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(string $content, array $options = []): ResourceMetadata
    {
        $response = $this->_create( $content, $options);
        $resource = new UserDefinedMessageInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['accountSid'],
                        $this->solution['callSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Api.V2010.UserDefinedMessageList]';
    }
}
