<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Events
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Events\V1\Subscription;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class SubscribedEventContext extends InstanceContext
    {
    /**
     * Initialize the SubscribedEventContext
     *
     * @param Version $version Version that contains the resource
     * @param string $subscriptionSid The unique SID identifier of the Subscription.
     * @param string $type Type of event being subscribed to.
     */
    public function __construct(
        Version $version,
        $subscriptionSid,
        $type
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'subscriptionSid' =>
            $subscriptionSid,
        'type' =>
            $type,
        ];

        $this->uri = '/Subscriptions/' . \rawurlencode($subscriptionSid)
        .'/SubscribedEvents/' . \rawurlencode($type)
        .'';
    }

    /**
     * Helper function for Delete
     *
     * @return Response Deleted Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _delete(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->handleRequest('DELETE', $this->uri, [], [], $headers, "delete");
    }

    /**
     * Delete the SubscribedEventInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {
        $response = $this->_delete();
        
        return true;
    }

    /**
     * Delete the SubscribedEventInstance with Metadata
     *
     * @return ResourceMetadata The Deleted Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function deleteWithMetadata(): ResourceMetadata
    {
        $response = $this->_delete();
        
        return new ResourceMetadata(
            null,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the SubscribedEventInstance
     *
     * @return SubscribedEventInstance Fetched SubscribedEventInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): SubscribedEventInstance
    {
        $response = $this->_fetch();
        return new SubscribedEventInstance(
            $this->version,
            $response->getContent(),
            $this->solution['subscriptionSid'],
            $this->solution['type']
        );
        
    }

    /**
     * Fetch the SubscribedEventInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new SubscribedEventInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['subscriptionSid'],
                        $this->solution['type']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'SchemaVersion' =>
                $options['schemaVersion'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the SubscribedEventInstance
     *
     * @param array|Options $options Optional Arguments
     * @return SubscribedEventInstance Updated SubscribedEventInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): SubscribedEventInstance
    {
        $response = $this->_update($options);
        return new SubscribedEventInstance(
            $this->version,
            $response->getContent(),
            $this->solution['subscriptionSid'],
            $this->solution['type']
        );
        
    }

    /**
     * Update the SubscribedEventInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new SubscribedEventInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['subscriptionSid'],
                        $this->solution['type']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Events.V1.SubscribedEventContext ' . \implode(' ', $context) . ']';
    }
}
