<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class InteractionList extends ListResource
    {
    /**
     * Construct the InteractionList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Interactions';
    }

    /**
     * Helper function for Create
     *
     * @param array $channel The Interaction's channel.
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(array $channel, array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'Channel' =>
                Serialize::jsonObject($channel),
            'Routing' =>
                Serialize::jsonObject($options['routing']),
            'InteractionContextSid' =>
                $options['interactionContextSid'],
            'WebhookTtid' =>
                $options['webhookTtid'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the InteractionInstance
     *
     * @param array $channel The Interaction's channel.
     * @param array|Options $options Optional Arguments
     * @return InteractionInstance Created InteractionInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(array $channel, array $options = []): InteractionInstance
    {
        $response = $this->_create( $channel, $options);
        return new InteractionInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the InteractionInstance with Metadata
     *
     * @param array $channel The Interaction's channel.
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(array $channel, array $options = []): ResourceMetadata
    {
        $response = $this->_create( $channel, $options);
        $resource = new InteractionInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Constructs a InteractionContext
     *
     * @param string $sid The SID of the Interaction resource to fetch.
     */
    public function getContext(
        string $sid
        
    ): InteractionContext
    {
        return new InteractionContext(
            $this->version,
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.FlexApi.V1.InteractionList]';
    }
}
