<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Insights
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Insights\V1\Call;

use Twilio\Exceptions\TwilioException;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class AnnotationContext extends InstanceContext
    {
    /**
     * Initialize the AnnotationContext
     *
     * @param Version $version Version that contains the resource
     * @param string $callSid The unique SID identifier of the Call.
     */
    public function __construct(
        Version $version,
        $callSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'callSid' =>
            $callSid,
        ];

        $this->uri = '/Voice/' . \rawurlencode($callSid)
        .'/Annotation';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the AnnotationInstance
     *
     * @return AnnotationInstance Fetched AnnotationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): AnnotationInstance
    {
        $response = $this->_fetch();
        return new AnnotationInstance(
            $this->version,
            $response->getContent(),
            $this->solution['callSid']
        );
        
    }

    /**
     * Fetch the AnnotationInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new AnnotationInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['callSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Helper function for Update
     *
     * @param array|Options $options Optional Arguments
     * @return Response Updated Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _update(array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'AnsweredBy' =>
                $options['answeredBy'],
            'ConnectivityIssue' =>
                $options['connectivityIssue'],
            'QualityIssues' =>
                $options['qualityIssues'],
            'Spam' =>
                Serialize::booleanToString($options['spam']),
            'CallScore' =>
                $options['callScore'],
            'Comment' =>
                $options['comment'],
            'Incident' =>
                $options['incident'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "update");
    }

    /**
     * Update the AnnotationInstance
     *
     * @param array|Options $options Optional Arguments
     * @return AnnotationInstance Updated AnnotationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): AnnotationInstance
    {
        $response = $this->_update($options);
        return new AnnotationInstance(
            $this->version,
            $response->getContent(),
            $this->solution['callSid']
        );
        
    }

    /**
     * Update the AnnotationInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Updated Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function updateWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_update($options);
        $resource = new AnnotationInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['callSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Insights.V1.AnnotationContext ' . \implode(' ', $context) . ']';
    }
}
