<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Lookups
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Lookups\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Serialize;


class RateLimitList extends ListResource
    {
    /**
     * Construct the RateLimitList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/RateLimits';
    }

    /**
     * Helper function for Fetch
     *
     * @param array|Options $options Optional Arguments
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(array $options = []): Response
    {
        $options = new Values($options);

        $params = Values::of([
            'Fields' =>
                Serialize::map($options['fields'], function ($e) { return $e; }),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, $params, [], $headers, "fetch");
    }

    /**
     * Fetch the RateLimitInstance
     *
     * @param array|Options $options Optional Arguments
     * @return RateLimitInstance Fetched RateLimitInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): RateLimitInstance
    {
        $response = $this->_fetch($options);
        return new RateLimitInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Fetch the RateLimitInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_fetch($options);
        $resource = new RateLimitInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Lookups.V2.RateLimitList]';
    }
}
