<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Messaging\V1\BrandRegistration;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class BrandVettingContext extends InstanceContext
    {
    /**
     * Initialize the BrandVettingContext
     *
     * @param Version $version Version that contains the resource
     * @param string $brandSid The SID of the Brand Registration resource of the vettings to create .
     * @param string $brandVettingSid The Twilio SID of the third-party vetting record.
     */
    public function __construct(
        Version $version,
        $brandSid,
        $brandVettingSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'brandSid' =>
            $brandSid,
        'brandVettingSid' =>
            $brandVettingSid,
        ];

        $this->uri = '/a2p/BrandRegistrations/' . \rawurlencode($brandSid)
        .'/Vettings/' . \rawurlencode($brandVettingSid)
        .'';
    }

    /**
     * Helper function for Fetch
     *
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(): Response
    {
        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, [], [], $headers, "fetch");
    }

    /**
     * Fetch the BrandVettingInstance
     *
     * @return BrandVettingInstance Fetched BrandVettingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): BrandVettingInstance
    {
        $response = $this->_fetch();
        return new BrandVettingInstance(
            $this->version,
            $response->getContent(),
            $this->solution['brandSid'],
            $this->solution['brandVettingSid']
        );
        
    }

    /**
     * Fetch the BrandVettingInstance with Metadata
     *
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(): ResourceMetadata
    {
        $response = $this->_fetch();
        $resource = new BrandVettingInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['brandSid'],
                        $this->solution['brandVettingSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.BrandVettingContext ' . \implode(' ', $context) . ']';
    }
}
