<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Messaging\V1\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class UsAppToPersonUsecaseList extends ListResource
    {
    /**
     * Construct the UsAppToPersonUsecaseList
     *
     * @param Version $version Version that contains the resource
     * @param string $messagingServiceSid The SID of the [Messaging Service](https://www.twilio.com/docs/messaging/api/service-resource) to fetch the resource from.
     */
    public function __construct(
        Version $version,
        string $messagingServiceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'messagingServiceSid' =>
            $messagingServiceSid,
        
        ];

        $this->uri = '/Services/' . \rawurlencode($messagingServiceSid)
        .'/Compliance/Usa2p/Usecases';
    }

    /**
     * Helper function for Fetch
     *
     * @param array|Options $options Optional Arguments
     * @return Response Fetched Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _fetch(array $options = []): Response
    {
        $options = new Values($options);

        $params = Values::of([
            'BrandRegistrationSid' =>
                $options['brandRegistrationSid'],
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('GET', $this->uri, $params, [], $headers, "fetch");
    }

    /**
     * Fetch the UsAppToPersonUsecaseInstance
     *
     * @param array|Options $options Optional Arguments
     * @return UsAppToPersonUsecaseInstance Fetched UsAppToPersonUsecaseInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): UsAppToPersonUsecaseInstance
    {
        $response = $this->_fetch($options);
        return new UsAppToPersonUsecaseInstance(
            $this->version,
            $response->getContent(),
            $this->solution['messagingServiceSid']
        );
        
    }

    /**
     * Fetch the UsAppToPersonUsecaseInstance with Metadata
     *
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Fetched Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetchWithMetadata(array $options = []): ResourceMetadata
    {
        $response = $this->_fetch($options);
        $resource = new UsAppToPersonUsecaseInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['messagingServiceSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Messaging.V1.UsAppToPersonUsecaseList]';
    }
}
