<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Numbers\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class PortingPortInList extends ListResource
    {
    /**
     * Construct the PortingPortInList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Porting/PortIn';
    }

    /**
     * Helper function for Create
     *
     * @param NumbersV1PortingPortInCreate $numbersV1PortingPortInCreate
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(NumbersV1PortingPortInCreate $numbersV1PortingPortInCreate): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $numbersV1PortingPortInCreate->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the PortingPortInInstance
     *
     * @param NumbersV1PortingPortInCreate $numbersV1PortingPortInCreate
     * @return PortingPortInInstance Created PortingPortInInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(NumbersV1PortingPortInCreate $numbersV1PortingPortInCreate): PortingPortInInstance
    {
        $response = $this->_create( $numbersV1PortingPortInCreate);
        return new PortingPortInInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the PortingPortInInstance with Metadata
     *
     * @param NumbersV1PortingPortInCreate $numbersV1PortingPortInCreate
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(NumbersV1PortingPortInCreate $numbersV1PortingPortInCreate): ResourceMetadata
    {
        $response = $this->_create( $numbersV1PortingPortInCreate);
        $resource = new PortingPortInInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Constructs a PortingPortInContext
     *
     * @param string $portInRequestSid The SID of the Port In request. This is a unique identifier of the port in request.
     */
    public function getContext(
        string $portInRequestSid
        
    ): PortingPortInContext
    {
        return new PortingPortInContext(
            $this->version,
            $portInRequestSid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Numbers.V1.PortingPortInList]';
    }
}
