<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Verify
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;
use Twilio\Http\Response;
use Twilio\Metadata\ResourceMetadata;


class NewChallengeContext extends InstanceContext
    {
    /**
     * Initialize the NewChallengeContext
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The unique SID identifier of the Service.
     */
    public function __construct(
        Version $version,
        $serviceSid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'serviceSid' =>
            $serviceSid,
        ];

        $this->uri = '/Services/' . \rawurlencode($serviceSid)
        .'/Passkeys/Challenges';
    }

    /**
     * Helper function for Create
     *
     * @param CreatePasskeysChallengeRequest $createPasskeysChallengeRequest
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(CreatePasskeysChallengeRequest $createPasskeysChallengeRequest): Response
    {
        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $createPasskeysChallengeRequest->toArray();
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the NewChallengeInstance
     *
     * @param CreatePasskeysChallengeRequest $createPasskeysChallengeRequest
     * @return NewChallengeInstance Created NewChallengeInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(CreatePasskeysChallengeRequest $createPasskeysChallengeRequest): NewChallengeInstance
    {
        $response = $this->_create( $createPasskeysChallengeRequest);
        return new NewChallengeInstance(
            $this->version,
            $response->getContent(),
            $this->solution['serviceSid']
        );
        
    }

    /**
     * Create the NewChallengeInstance with Metadata
     *
     * @param CreatePasskeysChallengeRequest $createPasskeysChallengeRequest
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(CreatePasskeysChallengeRequest $createPasskeysChallengeRequest): ResourceMetadata
    {
        $response = $this->_create( $createPasskeysChallengeRequest);
        $resource = new NewChallengeInstance(
                        $this->version,
                        $response->getContent(),
                        $this->solution['serviceSid']
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Verify.V2.NewChallengeContext ' . \implode(' ', $context) . ']';
    }
}
