<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\TwiML\Voice;

use Twilio\TwiML\TwiML;

class SipUri extends TwiML {
    /**
     * SipUri constructor.
     *
     * @param string $sipUrl The SIP URI
     * @param array $attributes Optional attributes
     */
    public function __construct($sipUrl = null, $attributes = []) {
        parent::__construct('Uri', $sipUrl, $attributes);
    }

    /**
     * Add Priority attribute.
     *
     * @param string $priority The priority of this SIP URI
     */
    public function setPriority($priority): self {
        return $this->setAttribute('priority', $priority);
    }

    /**
     * Add Weight attribute.
     *
     * @param string $weight The weight of this SIP URI
     */
    public function setWeight($weight): self {
        return $this->setAttribute('weight', $weight);
    }

    /**
     * Add Username attribute.
     *
     * @param string $username The username for authentication
     */
    public function setUsername($username): self {
        return $this->setAttribute('username', $username);
    }

    /**
     * Add Password attribute.
     *
     * @param string $password The password for authentication
     */
    public function setPassword($password): self {
        return $this->setAttribute('password', $password);
    }
}