import type { IStripeConnectInitParams, StripeConnectInstance, ConnectElementTagName } from "../types";
export type LoadConnectAndInitialize = (initParams: IStripeConnectInitParams) => StripeConnectInstance;
type ConnectElementHTMLName = "stripe-connect-account-onboarding" | "stripe-connect-disputes-list" | "stripe-connect-payments" | "stripe-connect-payment-details" | "stripe-connect-payment-disputes" | "stripe-connect-account-management" | "stripe-connect-notification-banner" | "stripe-connect-instant-payouts-promotion" | "stripe-connect-issuing-card" | "stripe-connect-issuing-cards-list" | "stripe-connect-financial-account" | "stripe-connect-financial-account-transactions" | "stripe-connect-payouts" | "stripe-connect-payouts-list" | "stripe-connect-payout-details" | "stripe-connect-balances" | "stripe-connect-documents" | "stripe-connect-tax-registrations" | "stripe-connect-tax-settings";
export declare const componentNameMapping: Record<ConnectElementTagName, ConnectElementHTMLName>;
type StripeConnectInstanceExtended = StripeConnectInstance & {
    debugInstance: () => Promise<StripeConnectInstance>;
};
interface StripeConnectWrapper {
    initialize: (params: IStripeConnectInitParams) => StripeConnectInstance;
}
export declare const findScript: () => HTMLScriptElement | null;
export declare const isWindowStripeConnectDefined: (stripeConnect: unknown) => boolean;
export declare const loadScript: () => Promise<StripeConnectWrapper>;
export declare const initStripeConnect: (stripePromise: Promise<StripeConnectWrapper>, initParams: IStripeConnectInitParams) => StripeConnectInstanceExtended;
export {};
