<a href="https://unacms.com"><img width="300" alt="UNA Platform" src="https://github.com/user-attachments/assets/ef5c2250-e172-4b12-8948-f1084643bc55"></a>

## Unified Networking Applications

[![Official Website](https://img.shields.io/badge/website-una.io-blue.svg?style=for-the-badge)](https://unacms.com)
[![GitHub license](https://img.shields.io/github/license/unaio/una?style=for-the-badge)](https://github.com/unacms/una/blob/master/license.txt)
[![Releases](https://img.shields.io/github/downloads/unaio/una/total.svg?style=for-the-badge)](https://github.com/unacms/una)
[![GitHub forks](https://img.shields.io/github/forks/unaio/una?style=for-the-badge)](https://github.com/unacms/una/network)

UNA is a **Community** Management System. The core platform is a full-stack framework for independent community websites and apps. With UNA content management, collaboration, e-commerce, learning management, and social networking, you can build any online project you have in mind.

![screenshot](https://user-images.githubusercontent.com/22210428/186073113-8f82f8f2-fd5a-4dbb-8328-e0ca847809b9.png)

## Table of Contents

- [Key Features](#key-features)
- [Documentation](#documentation)
- [Download](#download)
- [Support & Development](#support--development)
- [License](#license)

## Key Features

- **Unlimited Scalability**: Hundreds, thousands, or millions - get as many users as your hosting can handle. UNA won't limit you.
- **Absolute Control**: You own the data, you set the rules, you lead the community. We give you the tools and support.
- **Permissive License**: MIT - the license allowing unrestricted commercial and private use, distribution, and modification.
- **Continuous Improvement**: Regular security, performance, and feature updates for the core platform, apps, and integrations.
- **Collective Innovation**: Improvements and revisions initiated and co-funded by the platform users community.
- **Integrations-Friendly**: Integrate 3rd-party services as UNA apps or use UNA REST API to talk to your external apps.
- **Secure-By-Design**: Full-site SSL encryption, SPD development, regular service updates, and vulnerability audits.
- **Compliance Readiness**: We offer HIPAA, GDPR, CCPA (and any other regulations) compliance preparation service.

## Documentation

To install and run the UNA platform, you'll need a web-hosting server or you can use [UNA Cloud hosting](https://una.io/start) for an instant launch.

- [UNACMS.COM - Official Website](https://unacms.com)
- [Documentation](https://unacms.com/wiki/Introduction)
- [Discussions](https://unacms.com/page/discussions-home)
- [Contact Team](https://unacms.com/page/contact)
- [Installation](https://unacms.com/wiki/Installation)

## Download

You can [download](https://github.com/unaio/una/archive/refs/heads/master.zip) the latest installable version of UNA Core and install it on your server. You will need to [create an UNACMS.COM account](https://unacms.com) to access all features.

## Support & Development

UNA is managed by [Yasko.Studio](https://yasko.studio) team and developed with the help of [UNA Community](https://una.io).

- Free community support - [Discussions](https://unacms.com/page/discussions-home)
- Direct support and professional services - [UNA Pro](https://unacms.com/start)

## Setup Development Environment

Clone UNA repository to current folder:
```bash
git clone https://github.com/unacms/UNA.git una
```

Switch current directory to newly created `una` folder:
```bash
cd una
```

Install JavaScript depenences:
```bash
yarn
```

Install PHP dependences:
```bash
docker run --rm -it -v "$(pwd):/app" composer/composer installdocker run --rm -it -v "$(pwd):/app" composer/composer install --ignore-platform-reqs
```

Run UNA and related services:
```bash
docker compose up -d
```

Open UNA using the URL below in browser and proceed with the UNA installation:
```
http://localhost.una.io
```
Use the following default credentials for DB configuration during UNA install:  
    Database host name: `mysql`   
    Database name: `una`   
    Database user: `una`   
    Database password: `una`   

Use phpMyAdmin to manage UNA database:
```
http://localhost.una.io:8080
```
MySQL `root` user password: `root`

Use Mailpit to inspect all emails coming from UNA:
```
http://localhost.una.io:8025
```

If you use Visual Studio Code, then there is already ready launch configuration for debugging via XDebug.

## License

MIT

---

> UNACMS on X [@unacms](https://twitter.com/unacms)

---

This project is tested with BrowserStack.
