<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Messaging
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Messaging\V2;

use Twilio\Exceptions\TwilioException;
use Twilio\Values;
use Twilio\Version;
use Twilio\InstanceContext;


class ChannelsSenderContext extends InstanceContext
    {
    /**
     * Initialize the ChannelsSenderContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The SID of the sender.
     */
    public function __construct(
        Version $version,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'sid' =>
            $sid,
        ];

        $this->uri = '/Channels/Senders/' . \rawurlencode($sid)
        .'';
    }

    /**
     * Delete the ChannelsSenderInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' ]);
        return $this->version->delete('DELETE', $this->uri, [], [], $headers);
    }


    /**
     * Fetch the ChannelsSenderInstance
     *
     * @return ChannelsSenderInstance Fetched ChannelsSenderInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): ChannelsSenderInstance
    {

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        $payload = $this->version->fetch('GET', $this->uri, [], [], $headers);

        return new ChannelsSenderInstance(
            $this->version,
            $payload,
            $this->solution['sid']
        );
    }


    /**
     * Update the ChannelsSenderInstance
     *
     * @return ChannelsSenderInstance Updated ChannelsSenderInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(): ChannelsSenderInstance
    {

        $headers = Values::of(['Content-Type' => 'application/json', 'Accept' => 'application/json' ]);
        $data = $messagingV2ChannelsSenderRequestsUpdate->toArray();
        $payload = $this->version->update('POST', $this->uri, [], $data, $headers);

        return new ChannelsSenderInstance(
            $this->version,
            $payload,
            $this->solution['sid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V2.ChannelsSenderContext ' . \implode(' ', $context) . ']';
    }
}
